#   include	"docBufConfig.h"

#   include	"docBuf.h"
#   include	<stdio.h>
#   include	<appDebugon.h>
#   include	<uniUtf8.h>

#   define	LIST_LINE_PARTICULES	0

void docListParticule(	int			indent,
			const char *		label,
			int			n,
			const BufferItem *	bi,
			const TextParticule *	tp )
    {
    appDebug( "%*s%s %3d: [S %4d..%4d] A=%-3d %s %s",
		    indent, "", label, n,
		    tp->tpStroff, tp->tpStroff+ tp->tpStrlen,
		    tp->tpTextAttrNr,
		    docParticuleFlagsStr( tp->tpFlags ),
		    docKindStr( tp->tpKind ) );

    if  ( tp->tpStrlen > 0 )
	{
	appDebug( " \"%.*s\"",
		    (int)tp->tpStrlen,
		    docParaString( bi, tp->tpStroff ) );
	}

    if  ( tp->tpKind == DOCkindOBJECT		||
	  tp->tpKind == DOCkindFIELDSTART	||
	  tp->tpKind == DOCkindFIELDEND		||
	  tp->tpObjectNumber >= 0		)
	{ appDebug( " OBNR=%d", tp->tpObjectNumber );	}

    appDebug( "\n" );

    return;
    }

void docListTextLine(	int			indent,
			const char *		label,
			int			n,
			const BufferItem *	paraBi,
			const TextLine *	tl )
    {
#   if LIST_LINE_PARTICULES
    TextParticule *	tp;
    int			part;
#   endif

    char		flags[100];
    const char *	sep= " ";

    flags[0]= '\0';
    if  ( tl->tlFlags & TLflagPAGEBREAK )
	{
	strcat( flags, sep ); sep= "|";
	strcat( flags, "PAGEBREAK" );
	}
    if  ( tl->tlFlags & TLflagINLINECONTENT )
	{
	strcat( flags, sep ); sep= "|";
	strcat( flags, "INLINECONTENT" );
	}
    if  ( tl->tlFlags & TLflagSHADING )
	{
	strcat( flags, sep ); sep= "|";
	strcat( flags, "SHADING" );
	}
    if  ( tl->tlFlags & TLflagBORDER )
	{
	strcat( flags, sep ); sep= "|";
	strcat( flags, "BORDER" );
	}

    if  ( ! tl )
	{ LDEB(tl); return;	}

    appDebug( "%*s%s %3d: PG=%2d:%d Y=%d H=%d S:[%4d..%4d] P:[%3d..%3d]%s ",
	    indent, "", label, n,
	    tl->tlTopPosition.lpPage,tl->tlTopPosition.lpColumn,
	    tl->tlTopPosition.lpPageYTwips, tl->tlLineStride,
	    tl->tlStroff, tl->tlStroff+ tl->tlStrlen,
	    tl->tlFirstParticule, tl->tlFirstParticule+ tl->tlParticuleCount,
	    flags );

    appDebug( "\"%.*s\"\n",
		    (int)tl->tlStrlen,
		    docParaString( paraBi, tl->tlStroff ) );

#   if LIST_LINE_PARTICULES

    tp= paraBi->biParaParticules+ tl->tlFirstParticule;
    for ( part= tl->tlFirstParticule;
          part < tl->tlFirstParticule+ tl->tlParticuleCount;
	  tp++, part++ )
	{ docListParticule( indent+ 4, "PART", part, paraBi, tp ); }

#   endif

    return;
    }

void docListNotes(	const BufferDocument *	bd )
    {
    int				i;
    const DocumentNote *	dn;

    dn= bd->bdNotesList.nlNotes;
    for ( i= 0; i < bd->bdNotesList.nlNoteCount; dn++, i++ )
	{
	if  ( NOTE_IS_DELETED( dn ) )
	    {
	    appDebug( "%4d DELETED\n", i );
	    continue;
	    }

	appDebug(
	    "%4d %-8s %3d: NR=%3d PG=%3d:%d\n",
	    i, docExternalKindStr( dn->dnNoteProperties.npExternalItemKind ),
	    i, dn->dnNoteNumber,
	    dn->dnReferringPage,
	    dn->dnReferringColumn );
	}

    return;
    }

void docListListNumberNode(	int				indent,
				const ListNumberTreeNode *	lntn )
    {
    int		i;

    appDebug( "%*s PARA=%d %s\n",
	indent, "",
	lntn->lntnParaNr,
	lntn->lntnIsLeaf?"LEAF":"TREE" );

    for ( i= 0; i < lntn->lntnChildCount; i++ )
	{ docListListNumberNode( indent+ 1, &(lntn->lntnChildren[i]) );	}
    }

void docListFontList( const DocumentFontList *	dfl )
    {
    int		i;

    appDebug( "FONTLIST: %d fonts\n", dfl->dflFontCount );
    for ( i= 0; i < dfl->dflFontCount; i++ )
	{
	const DocumentFont *	df= docFontListGetFontByNumber( dfl, i );

	if  ( ! df )
	    { continue;	}

	appDebug( "FONT %6d: \"%s\"\n", df->dfDocFontNumber, df->dfName );
	}
    }

static int docListDocumentListLevelConst(
				int *				pLevel,
				const DocumentListLevel *	dll,
				int				field )
    {
    int			constOff;
    int			constLen;
    int			constChars;
    int			level;

    int			chars= 0;

    if  ( docListLevelGetField( &constOff, &constLen, &constChars, &level,
								dll, field ) )
	{ LDEB(field); return -1;	}

    if  ( constLen > 0 )
	{
	const char *	from= dll->dllFormatString+ constOff;
	int		todo= constLen;

	appDebug( "%.*s", constLen, from );

	while( todo > 0 )
	    {
	    unsigned short	symbol;
	    int			step;

	    step= uniGetUtf8( &symbol, (unsigned char *)from );
	    if  ( step < 1 )
		{ SLDEB("###",step); break;	}

	    chars++; from += step; todo -= step;
	    }
	}

    if  ( chars != constChars )
	{ SLLLDEB("###",field,chars,constChars);	}

    *pLevel= level;
    return 0;
    }

void docListDocumentListLevel(	int				n,
				const DocumentListLevel *	dll )
    {
    int			field;
    int			level;

    appDebug( "\t%d: format: \"%s\"\n", n, dll->dllFormatString );
    appDebug( "\t%d: %d fields: \"", n, dll->dllLevelNumberCount );

    for ( field= 0; field < dll->dllLevelNumberCount; field++ )
	{
	if  ( docListDocumentListLevelConst( &level, dll, field ) )
	    { SDEB("###"); break;	}

	appDebug( "<%d>", level );
	if  ( level < 0 || level >= DLmaxLEVELS ||
	      ( n >= 0 && level > n )		)
	    { appDebug( "###" );	}
	}

    if  ( docListDocumentListLevelConst( &level, dll, field ) )
	{ SDEB("###");	}
    else{
	if  ( level != -1 )
	    {
	    appDebug( "<%d>", level );
	    appDebug( "###" );
	    }
	}

    appDebug( "\"\n" );
    }

void docListDocumentList(	int			n,
				const DocumentList *	dl )
    {
    int		l;

    appDebug( "LIST %3d:\n", n );

    for ( l= 0; l < dl->dlLevelCount; l++ )
	{
	docListDocumentListLevel( l, dl->dlLevels+ l );
	}
    }

void docListListOverrideLevel(	int				n,
				const ListOverrideLevel *	lol )
    {
    docListDocumentListLevel( n, &(lol->lolListLevel) );
    }

void docListListOverride(	int				n,
				const ListOverride *		lo )
    {
    int		l;

    for ( l= 0; l < lo->loLevelCount; l++ )
	{
	docListListOverrideLevel( l, lo->loLevels+ l );
	}
    }

void docListListOverrideTable(	int				n,
				const ListOverrideTable *	lot )
    {
    int		o;

    for ( o= 0; o < lot->lotOverrideCount; o++ )
	{
	docListListOverride( o, lot->lotOverrides+ o );
	}
    }

void docListDocumentListTable( const DocumentListTable *	dlt )
    {
    int		n;

    for ( n= 0; n < dlt->dltListCount; n++ )
	{
	docListDocumentList( n, dlt->dltLists+ n );
	}
    }
