/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<utilBase26.h>
#   include	<utilRoman.h>
#   include	"docBuf.h"
#   include	"docEvalField.h"
#   include	"docEdit.h"

/************************************************************************/
/*									*/
/*  Format the value of a 'chftn' field.				*/
/*									*/
/*  I.E. the text of the reference to the note in the body of the text,	*/
/*	or the identical sign at the begnning of the note.		*/
/*									*/
/************************************************************************/

int docFormatChftnField(	MemoryBuffer *			mbResult,
				const DocumentProperties *	dp,
				const NoteProperties *		np,
				int				noteNumber )
    {
    char			scratch[100+1];
    const NotesProperties *	nsp;

    utilEmptyMemoryBuffer( mbResult );

    if  ( ! np->npAutoNumber )
	{
	if  ( utilCopyMemoryBuffer( mbResult, &(np->npFixedText) ) )
	    { LDEB(1); return -1;	}
	return 0;
	}

    switch( np->npExternalItemKind )
	{
	case DOCinFOOTNOTE:
	    nsp= &(dp->dpFootnoteProperties);
	    break;

	case DOCinENDNOTE:
	    nsp= &(dp->dpEndnoteProperties);
	    break;

	default:
	    SDEB(docExternalKindStr(np->npExternalItemKind)); return -1;
	}

    if  ( nsp->npRestart == FTN_RST_CONTINUOUS )
	{ noteNumber += nsp->npStartNumber- 1;	}

    switch( nsp->npNumberStyle )
	{
	case FTNstyleNAR:
	    sprintf( scratch, "%d", noteNumber+ 1 );
	    utilAddToMemoryBuffer( mbResult,
				(unsigned char *)scratch, strlen( scratch ) );
	    break;

	case FTNstyleNALC:
	    if  ( utilBase26String( scratch, sizeof(scratch)-1,
							noteNumber+ 1, 0 ) )
		{ LDEB(noteNumber); return -1;	}
	    utilAddToMemoryBuffer( mbResult,
				(unsigned char *)scratch, strlen( scratch ) );
	    break;

	case FTNstyleNAUC:
	    if  ( utilBase26String( scratch, sizeof(scratch)-1,
							noteNumber+ 1, 1 ) )
		{ LDEB(noteNumber); return -1;	}
	    utilAddToMemoryBuffer( mbResult,
				(unsigned char *)scratch, strlen( scratch ) );
	    break;

	case FTNstyleNRLC:
	    if  ( utilRomanString( scratch, sizeof(scratch)-1,
							noteNumber+ 1, 0 ) )
		{ sprintf( scratch, "NRLC:%d", noteNumber+ 1 );	}
	    utilAddToMemoryBuffer( mbResult,
				(unsigned char *)scratch, strlen( scratch ) );
	    break;

	case FTNstyleNRUC:
	    if  ( utilRomanString( scratch, sizeof(scratch)-1,
							noteNumber+ 1, 1 ) )
		{ sprintf( scratch, "NRUC:%d", noteNumber+ 1 );	}
	    utilAddToMemoryBuffer( mbResult,
				(unsigned char *)scratch, strlen( scratch ) );
	    break;

	case FTNstyleNCHI:
	default:
	    LDEB(nsp->npNumberStyle);
	    sprintf( scratch, "(%d)", noteNumber+ 1 );
	    utilAddToMemoryBuffer( mbResult,
				(unsigned char *)scratch, strlen( scratch ) );
	    break;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Evaluate Footnote number fields.					*/
/*									*/
/************************************************************************/

int docCalculateChftnFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		dfChftn,
				const RecalculateFields *	rf )
    {
    const BufferDocument *	bd= rf->rfBd;
    DocumentNote *		dn;

    dn= docGetNoteOfField( dfChftn, bd );
    if  ( dn )
	{
	if  ( docFormatChftnField( mbResult,
					    &(bd->bdProperties),
					    &(dn->dnNoteProperties),
					    dn->dnNoteNumber ) )
	    { LDEB(dn->dnNoteNumber); *pCalculated= 0; return 0; }

	*pCalculated= 1;
	return 0;
	}

    XDEB(dn);
    *pCalculated= 0; return 0;
    }

/************************************************************************/
/*									*/
/*  Evaluate Footnote number fields.					*/
/*									*/
/************************************************************************/

int docRecalculateParaChftnTextParticules(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf )
    {
    int			ret;

    TextAttribute	taSet;
    PropertyMask	taSetMask;
    PropertyMask	taDoneMask;


    ret= docRecalculateParaStringTextParticules( pCalculated,
			    pPartShift, pStroffShift, paraBi, part, partCount,
			    df, rf );

    if  ( ret )
	{ LDEB(ret); return ret;	}

    docPlainTextAttribute( &taSet, rf->rfBd );
    utilPropMaskClear( &taSetMask );
    utilPropMaskClear( &taDoneMask );

    taSet.taSuperSub= DOCfontSUPERSCRIPT;
    PROPmaskADD( &taSetMask, TApropSUPERSUB );

    if  ( docChangeParticuleAttributes( &taDoneMask, rf->rfBd,
					paraBi, part+ 1,
					part+ 1+ partCount+ *pPartShift,
					&taSet, &taSetMask ) )
	{ LDEB(1);	}

    if  ( ! utilPropMaskIsEmpty( &taDoneMask ) )
	{ *pCalculated= 1;	}

    return ret;
    }
