/************************************************************************/
/*									*/
/*  Cell Properties.							*/
/*									*/
/************************************************************************/

#   ifndef	DOC_CELL_PROPS_H
#   define	DOC_CELL_PROPS_H

#   include	"docPropVal.h"
#   include	"docItemShading.h"
#   include	"docBorderProperties.h"
#   include	"docDocumentAttributeMap.h"

/************************************************************************/
/*									*/
/*  Cell Properties.							*/
/*									*/
/************************************************************************/

typedef struct CellProperties
    {
    int			cpRightBoundaryTwips;

    /**/
    int			cpTopBorderNumber;
    int			cpBottomBorderNumber;
    int			cpLeftBorderNumber;
    int			cpRightBorderNumber;

    int			cpShadingNumber;

    int			cpPreferredWidth;

    short int		cpTopPadding;
    short int		cpBottomPadding;
    short int		cpLeftPadding;
    short int		cpRightPadding;

			/* TableAutoFormatUnit */
    unsigned char	cpPreferredWidthUnit;

    unsigned char	cpTopPaddingUnit;
    unsigned char	cpBottomPaddingUnit;
    unsigned char	cpLeftPaddingUnit;
    unsigned char	cpRightPaddingUnit;

    unsigned char	cpLeftInMergedRow;
    unsigned char	cpMergedWithLeft;
    unsigned char	cpTopInMergedColumn;
    unsigned char	cpMergedWithAbove;
    unsigned char	cpNoWrap;

    unsigned char	cpNoShading; /* clshdrawnil */

    unsigned char	cpValign;			/*  (enum)	*/
    unsigned char	cpTextFlow;			/*  (enum)	*/
    } CellProperties;

#   define CELL_MERGED( cp ) \
		( (cp)->cpMergedWithLeft || (cp)->cpMergedWithAbove )

#   define	docCleanCellProperties( cp ) ( ( *(cp)= *(cp) ), 0 )

typedef enum CellProperty
    {
    CLprop_NONE= -1,

    CLpropCELLX= 0,

    CLpropTOP_BORDER,
    CLpropBOTTOM_BORDER,
    CLpropLEFT_BORDER,
    CLpropRIGHT_BORDER,

    CLpropSHADING,
    CLpropCLW_WIDTH,
    CLpropCLFTS_WIDTH,

    CLpropLEFT_IN_MERGED,
    CLpropMERGED_WITH_LEFT,
    CLpropTOP_IN_MERGED,
    CLpropMERGED_WITH_ABOVE,
    CLpropNO_WRAP,

    CLpropVALIGN,
    CLpropTEXT_FLOW,

    CLpropTOP_PADDING,
    CLpropBOTTOM_PADDING,
    CLpropLEFT_PADDING,
    CLpropRIGHT_PADDING,

    CLpropTOP_PADDING_UNIT,
    CLpropBOTTOM_PADDING_UNIT,
    CLpropLEFT_PADDING_UNIT,
    CLpropRIGHT_PADDING_UNIT,

    CLpropNO_SHADING,

    CLprop_COUNT,

    CLprop_ROWSPAN,			/*  9  */
    CLprop_COLSPAN,			/*  9  */

    CLprop_FULL_COUNT
    } CellProperty;

/************************************************************************/
/*									*/
/*  Application of table styles.					*/
/*									*/
/************************************************************************/

typedef enum CellInstanceProperty
    {
    CIpropYTS= 0,

    CIpropFIRST_ROW,
    CIpropLAST_ROW,

    CIpropFIRST_COLUMN,
    CIpropLAST_COLUMN,

    CIpropODD_ROW_BAND,
    CIpropEVEN_ROW_BAND,

    CIpropODD_COLUMN_BAND,
    CIpropEVEN_COLUMN_BAND,

    CIpropNW_CELL,
    CIpropNE_CELL,
    CIpropSW_CELL,
    CIpropSE_CELL,

    CIprop_COUNT
    } CellInstanceProperty;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitCellProperties(	CellProperties *	cp );

extern int docUpdCellProperties(PropertyMask *			pCpChgPask,
				CellProperties *		cp,
				const PropertyMask *		cpUpdMask,
				const CellProperties *		cpNew,
				const DocumentAttributeMap *	dam );

extern void docCellPropertyDifference(	
				PropertyMask *			pChgMask,
				const CellProperties *		cp1,
				const CellProperties *		cp2,
				const PropertyMask *		updMask,
				const DocumentAttributeMap *	dam );

extern void docCopyCellProperties(	
				CellProperties *		cpTo,
				const CellProperties *		cpFrom,
				const DocumentAttributeMap *	dam );

extern int docSetCellProperty(		CellProperties *	cp,
					int			prop,
					int			arg );

extern int docGetCellProperty(		const CellProperties *	cp,
					int			prop );

#   endif	/*  DOC_CELL_PROPS_H  */
