#   include	"bitmapConfig.h"

#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<string.h>

#   include	"bitmap.h"

#   include	<appDebugon.h>

int bmSelect(	BitmapDescription *		bdOut,
		unsigned char **		pBuffer,
		const BitmapDescription *	bdIn,
		const unsigned char *		bufIn,
		const DocumentRectangle *	drSel )
    {
    BitmapDescription	bd;
    int			originBit;
    int			originByte;
    unsigned char *	buffer;
    int			row;

    if  ( drSel->drX0 < 0			||
	  drSel->drY0 < 0			||
	  drSel->drX1 >= bdIn->bdPixelsWide	||
	  drSel->drY1 >= bdIn->bdPixelsHigh	)
	{
	RECTDEB(drSel);
	LLDEB(bdIn->bdPixelsWide,bdIn->bdPixelsHigh);
	return -1;
	}

    /************************************************************/
    /*  Derive properties of output bitmap from input.		*/
    /************************************************************/
    bmCopyDescription( &bd, bdIn );
    bd.bdPixelsWide= drSel->drX1- drSel->drX0+ 1;
    bd.bdPixelsHigh= drSel->drY1- drSel->drY0+ 1;

    bmCalculateSizes( &bd );

    /************************************************************/
    /*  How many bits to shift?					*/
    /************************************************************/
    originBit=  ( drSel->drX0* bdIn->bdBitsPerPixel )% 8;
    originByte= ( drSel->drX0* bdIn->bdBitsPerPixel )/ 8;

    /************************************************************/
    /*  Allocate new buffer.					*/
    /************************************************************/
    buffer= (unsigned char *)malloc( bd.bdBufferLength );
    if  ( ! buffer )
	{ LLDEB(bd.bdBufferLength,buffer); return -1;	}

    if  ( originBit == 0 )
	{
	for ( row= 0; row < bd.bdPixelsHigh; row++ )
	    {
	    memcpy( buffer+ row* bd.bdBytesPerRow, bufIn+
			( row+ drSel->drX0 )* bdIn->bdBytesPerRow+ originByte,
			bd.bdBytesPerRow );
	    }
	}
    else{
	int	rightShift= 8- originBit;

	for ( row= 0; row < bd.bdPixelsHigh; row++ )
	    {
	    int				byte;
	    unsigned char *		to;
	    const unsigned char *	from;
	    int				col;

	    to= buffer+ row* bd.bdBytesPerRow;
	    from= bufIn+ ( row+ drSel->drY0 )* bdIn->bdBytesPerRow+ originByte;

	    col= 0;
	    *to=   *from << originBit; from++;

	    for ( byte= 1; byte < bd.bdBytesPerRow; byte++ )
		{
		*to |= *from >> rightShift; to++;
		*to=   *from << originBit; from++;
		}

	    /*
	    *to |= *from >> rightShift;
	    */
	    }
	}

    *pBuffer= buffer;
    *bdOut= bd;

    return 0;
    }

# if 0

/* To be run through valgrind */
extern void bmSelectTest( void );

void bmSelectTest( void )
    {
    BitmapDescription	bdIn;
    unsigned char *	bufIn= (unsigned char *)0;
    const int		IN_SZ= 25;
    const int		OUT_SZ= 8;
    int			i;

    int			format;
    char		fileName[30];

    bmInitDescription( &bdIn );
    bdIn.bdPixelsWide= IN_SZ;
    bdIn.bdPixelsHigh= IN_SZ;
    bdIn.bdColorEncoding= BMcoBLACKWHITE;
    bdIn.bdBitsPerPixel= 1;
    bdIn.bdBitsPerSample= 1;
    bdIn.bdUnit= BMunPIXEL;
    bdIn.bdXResolution= 1;
    bdIn.bdYResolution= 1;
    bdIn.bdHasAlpha= 0;

    bmCalculateSizes( &bdIn );
    bufIn= malloc( bdIn.bdBufferLength );
    memset( bufIn, 0x55, bdIn.bdBufferLength );

    sprintf( fileName, "/tmp/bsin.png" );
    format= bmSuggestFormat( fileName, -1, &bdIn );
    SDEB(fileName);
    bmWrite( fileName, bufIn, &bdIn, format );

    for ( i= IN_SZ- OUT_SZ- 6; i <= IN_SZ- OUT_SZ; i++ )
	{
	BitmapDescription	bdOut;
	unsigned char *		bufOut= (unsigned char *)0;
	DocumentRectangle	drSel;

	drSel.drX0= i;
	drSel.drY0= i;
	drSel.drX1= i+ OUT_SZ- 1;
	drSel.drY1= i+ OUT_SZ- 1;

	LDEB(i);
	bmInitDescription( &bdOut );
	bmSelect( &bdOut, &bufOut, &bdIn, bufIn, &drSel );

	sprintf( fileName, "/tmp/bsin-%d.png", i );
	format= bmSuggestFormat( fileName, -1, &bdOut );
	SDEB(fileName);
	bmWrite( fileName, bufOut, &bdOut, format );

	bmCleanDescription( &bdOut );
	free( bufOut );
	}

    bmCleanDescription( &bdIn );
    free( bufIn );
    }
# endif

/************************************************************************/
/*									*/
/*  Copy parts of an image into another one.				*/
/*									*/
/************************************************************************/

int bmCopyArea(			int				x0,
				int				y0,
				unsigned char *			buffer1,
				const unsigned char *		buffer2,
				const BitmapDescription *	bd1,
				const BitmapDescription *	bd2 )
    {
    int			x1;
    int			y1;

    int			y;

    int			targetBit;
    int			targetByte;
    int			copyBits;
    int			copyBytes;
    int			tailBits;

    /************************************************************/
    /*  Same kind of image?					*/
    /************************************************************/
    if  ( bd1->bdBitsPerSample != bd2->bdBitsPerSample )
	{ LLDEB(bd1->bdBitsPerSample,bd2->bdBitsPerSample); return -1;	}
    if  ( bd1->bdSamplesPerPixel != bd2->bdSamplesPerPixel )
	{ LLDEB(bd1->bdSamplesPerPixel,bd2->bdSamplesPerPixel); return -1; }
    if  ( bd1->bdBitsPerPixel != bd2->bdBitsPerPixel )
	{ LLDEB(bd1->bdBitsPerPixel,bd2->bdBitsPerPixel); return -1;	}
    if  ( bd1->bdColorEncoding != bd2->bdColorEncoding )
	{ LLDEB(bd1->bdColorEncoding,bd2->bdColorEncoding); return -1; }

    /************************************************************/
    /*  Origin inside target?					*/
    /************************************************************/
    if  ( x0 < 0 || y0 < 0 )
	{ LLDEB(x0,y0); return -1;	}
    if  ( x0 >= bd1->bdPixelsWide || y0 >= bd1->bdPixelsHigh )
	{ LLLLDEB(x0,y0,bd1->bdPixelsWide,bd1->bdPixelsHigh); return -1; }

    x1= x0+ bd2->bdPixelsWide;
    if  ( x1 > bd1->bdPixelsWide )
	{ x1=  bd1->bdPixelsWide;	}

    y1= y0+ bd2->bdPixelsHigh;
    if  ( y1 > bd1->bdPixelsHigh )
	{ y1=  bd1->bdPixelsHigh;	}

    /************************************************************/
    /*  How many bits to copy/shift?				*/
    /************************************************************/
    targetBit=  ( x0* bd1->bdBitsPerPixel )% 8;
    targetByte= ( x0* bd1->bdBitsPerPixel )/ 8;

    copyBits= ( x1- x0 )* bd1->bdBitsPerPixel;
    if  ( targetBit != 0 )
	{ copyBits -= 8- targetBit;	}
    copyBytes= copyBits/ 8;
    tailBits=  copyBits% 8;

    if  ( targetBit == 0 )
	{
	unsigned char	t1Mask= 0xff >> tailBits;
	unsigned char	t2Mask= 0xff << ( 8- tailBits );

	for ( y= y0; y < y1; y++ )
	    {
	    unsigned char *		r1;
	    const unsigned char *	r2;

	    r1= buffer1+ ( y-  0 )* bd1->bdBytesPerRow;
	    r2= buffer2+ ( y- y0 )* bd2->bdBytesPerRow;

	    r1 += targetByte;

	    memcpy( r1, r2, copyBytes );

	    if  ( tailBits > 0 )
		{
		r1 += copyBytes;
		r2 += copyBytes;

		*r1 &= t1Mask;
		*r1 |= *r2 & t2Mask;
		}
	    }

	return 0;
	}
    else{
	unsigned char	h1Mask= ~( 0xff >> targetBit );

	unsigned char	t1Mask= 0xff >> tailBits;
	unsigned char	t2Mask= 0xff << ( 8- tailBits );

	for ( y= y0; y < y1; y++ )
	    {
	    unsigned char *		r1;
	    const unsigned char *	r2;
	    int				i;
	    unsigned char		c;


	    r1= buffer1+ ( y-  0 )* bd1->bdBytesPerRow;
	    r2= buffer2+ ( y- y0 )* bd2->bdBytesPerRow;

	    r1 += targetByte;

	    c= ( *r1 & h1Mask ) | ( *r2 >> targetBit );
	    *(r1++)= c;

	    for ( i= 0; i < copyBytes; i++ )
		{
		c= *(r2++) << ( 8- targetBit );
		c |= *r2 >> targetBit;
		*(r1++)= c;
		}

	    if  ( tailBits > 0 )
		{
		c= *(r2++) << ( 8- targetBit );
		c |= *r2 >> targetBit;

		*r1 &= t1Mask;
		*r1 |= c & t2Mask;
		}
	    }

	return 0;
	}
    }

/************************************************************************/
/*									*/
/*  Transfer parts of an image into another one: Only locations that	*/
/*  are not transparent are affected.					*/
/*									*/
/************************************************************************/

static int bmPaintArea8(	int				x0,
				int				x1,
				int				y0,
				int				y1,
				unsigned char *			buffer1,
				const unsigned char *		buffer2,
				const BitmapDescription *	bd1,
				const BitmapDescription *	bd2 )
    {
    int		yf;
    int		yt;
    const int	spp1= bd1->bdSamplesPerPixel;
    const int	spp2= bd2->bdSamplesPerPixel;

    yf= 0;
    for ( yt= y0; yt < y1; yf++, yt++ )
	{
	int			x;
	unsigned char *		to= buffer1+ yt* bd1->bdBytesPerRow+ x0* spp1;
	const unsigned char *	fr= buffer2+ yf* bd2->bdBytesPerRow;

	for ( x= x0; x < x1; x++ )
	    {
	    if  ( fr[spp2- 1] )
		{ memcpy( to, fr, spp1 );	}

	    to += spp1; fr += spp2;
	    }
	}

    return 0;
    }

int bmPaintArea(		int				x0,
				int				y0,
				unsigned char *			buffer1,
				const unsigned char *		buffer2,
				const BitmapDescription *	bd1,
				const BitmapDescription *	bd2 )
    {
    int			x1;
    int			y1;

    if  ( ! bd2->bdHasAlpha )
	{ return bmCopyArea( x0, y0, buffer1, buffer2, bd1, bd2 );	}

    /************************************************************/
    /*  Same kind of image?					*/
    /************************************************************/
    if  ( bd1->bdBitsPerSample != bd2->bdBitsPerSample )
	{ LLDEB(bd1->bdBitsPerSample,bd2->bdBitsPerSample); return -1;	}
    if  ( bd1->bdColorEncoding != bd2->bdColorEncoding )
	{ LLDEB(bd1->bdColorEncoding,bd2->bdColorEncoding); return -1; }

    if  ( bd1->bdSamplesPerPixel+ !bd1->bdHasAlpha != bd2->bdSamplesPerPixel )
	{
	LLLDEB(bd1->bdSamplesPerPixel,bd1->bdHasAlpha,bd2->bdSamplesPerPixel);
	return -1;
	}

    /************************************************************/
    /*  Origin inside target?					*/
    /************************************************************/
    if  ( x0 < 0 || y0 < 0 )
	{ LLDEB(x0,y0); return -1;	}
    if  ( x0 >= bd1->bdPixelsWide || y0 >= bd1->bdPixelsHigh )
	{ LLLLDEB(x0,y0,bd1->bdPixelsWide,bd1->bdPixelsHigh); return -1; }

    x1= x0+ bd2->bdPixelsWide;
    if  ( x1 > bd1->bdPixelsWide )
	{ x1=  bd1->bdPixelsWide;	}

    y1= y0+ bd2->bdPixelsHigh;
    if  ( y1 > bd1->bdPixelsHigh )
	{ y1=  bd1->bdPixelsHigh;	}

    switch( bd1->bdBitsPerSample )
	{
	case 8:
	    return bmPaintArea8( x0, x1, y0, y1, buffer1, buffer2, bd1, bd2 );

	default:
	    LDEB(bd1->bdBitsPerSample); return -1;
	}
    }

