/************************************************************************/
/*									*/
/*  Keep a collection TextAttributes by number.				*/
/*									*/
/************************************************************************/

#   include	"appUtilConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   include	<appDebugon.h>

#   include	"utilTextAttributeAdmin.h"

/************************************************************************/
/*									*/
/*  Initialize/Clean attribute administration.				*/
/*									*/
/************************************************************************/

void utilInitTextAttributeList(	NumberedPropertiesList *	tal )
    {
    int			num;
    TextAttribute	ta;

    utilInitNumberedPropertiesList( tal );

    utilStartNumberedPropertyList( tal,

		    TAprop_COUNT,
		    (NumberedPropertiesGetProperty)utilGetTextProperty,

		    sizeof(TextAttribute),
		    (InitPagedListItem)utilInitTextAttribute,
		    (CleanPagedListItem)0 );

    utilInitTextAttribute( &ta );
    ta.taFontNumber= 0;

    num= utilTextAttributeNumber( tal, &ta );
    if  ( num != 0 )
	{ LDEB(num);	}

    return;
    }

/************************************************************************/
/*									*/
/*  Translate a text attribute number to a struct value.		*/
/*									*/
/************************************************************************/

void utilGetTextAttributeByNumber(	TextAttribute *			ta,
					const NumberedPropertiesList *	tal,
					int				n )
    {
    void *	vta= utilPagedListGetItemByNumber( &(tal->nplPagedList), n );

    if  ( ! vta )
	{ LXDEB(n,vta); utilInitTextAttribute( ta ); return; }

    *ta= *((TextAttribute *)vta);
    return;
    }

/************************************************************************/
/*									*/
/*  Call a function for all TextAttributes in the list.			*/
/*									*/
/************************************************************************/

void utilForAllTextAttributes(	const NumberedPropertiesList *	tal,
				TextAttributeFunction		f,
				void *				through )
    {
    int			n;

    for ( n= 0; n < tal->nplPagedList.plItemCount; n++ )
	{
	void *      vta= utilPagedListGetItemByNumber(
						&(tal->nplPagedList), n );

	(*f)( (TextAttribute *)vta, n, through );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Translate a text attribute to its number.				*/
/*									*/
/************************************************************************/

int utilTextAttributeNumber(	NumberedPropertiesList *	tal,
				const TextAttribute *		ta )
    {
    const int	make= 1;

    return utilGetPropertyNumber( tal, make, (void *)ta );
    }
