/************************************************************************/
/*									*/
/*  Attributes of text.							*/
/*									*/
/************************************************************************/

#   ifndef	UTIL_TEXT_ATTRIBUTE_H
#   define	UTIL_TEXT_ATTRIBUTE_H

#   include	<utilPropMask.h>

typedef struct TextAttribute
    {
    short int		taFontNumber;
    short int		taFontSizeHalfPoints;
    short int		taTextColorNumber;
    short int		taTextStyleNumber;

    short int		taBorderNumber;
    short int		taShadingNumber;

    unsigned char	taFontIsBold;
    unsigned char	taFontIsSlanted;
    unsigned char	taTextIsUnderlined;
#   define			DOCunderlineNONE	0
#   define			DOCunderlineSINGLE	1
#   define			DOCunderlineDOUBLE	2

    unsigned char	taSmallCaps;
    unsigned char	taHasStrikethrough;
    unsigned char	taCapitals;

    unsigned char	taSuperSub;
#   define			DOCfontREGULAR		0
#   define			DOCfontSUPERSCRIPT	1
#   define			DOCfontSUBSCRIPT	2
    } TextAttribute;

typedef enum TextProperty
    {
    TAprop_NONE= -1,

    TApropDOC_FONT_NUMBER= 0,
    TApropFONTSIZE,
    TApropFONTBOLD,
    TApropFONTSLANTED,
    TApropTEXTUNDERLINED,
    TApropSUPERSUB,
    TApropSMALLCAPS,
    TApropCAPITALS,
    TApropSTRIKETHROUGH,
    TApropTEXT_COLOR,
    TApropTEXT_STYLE,

    TApropBORDER,
    TApropSHADING,

    TAprop_COUNT
    } TextProperty;

#   define	docEqualFontAttributes(ta1,ta2) ( \
		(ta1)->taFontIsBold == (ta2)->taFontIsBold && \
		(ta1)->taFontIsSlanted == (ta2)->taFontIsSlanted )

#   define	docEqualFont(ta1,ta2) ( \
		(ta1)->taFontNumber == (ta2)->taFontNumber && \
		(ta1)->taFontSizeHalfPoints == (ta2)->taFontSizeHalfPoints && \
		(ta1)->taSuperSub == (ta2)->taSuperSub && \
		(ta1)->taSmallCaps == (ta2)->taSmallCaps && \
		docEqualFontAttributes( (ta1), (ta2) ) )

#   define	docEqualTextAttributes(ta1,ta2) ( \
		docEqualFont((ta1),(ta2)) && \
		(ta1)->taTextIsUnderlined == (ta2)->taTextIsUnderlined && \
		(ta1)->taHasStrikethrough == (ta2)->taHasStrikethrough && \
		(ta1)->taCapitals == (ta2)->taCapitals && \
		(ta1)->taTextColorNumber == (ta2)->taTextColorNumber && \
		(ta1)->taBorderNumber == (ta2)->taBorderNumber && \
		(ta1)->taShadingNumber == (ta2)->taShadingNumber )

#define FACE_INDEX( isS, isB ) ( 2*( (isS) != 0 )+ ( (isB) != 0 ) )
#define FACE_BOLD( idx ) ( (idx) % 2 != 0 )
#define FACE_SLANTED( idx ) ( ((idx)/2) % 2 != 0 )

/************************************************************************/
/*									*/
/*  Default attributes.							*/
/*									*/
/************************************************************************/

extern TextAttribute   DocDefaultAttributes;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void utilInitTextAttribute(	TextAttribute *		ta );

extern void utilAttributeDifference(	PropertyMask *		pChangeMask,
					const TextAttribute *	taTo,
					const TextAttribute *	taFrom,
					const PropertyMask *	updMask );

extern void utilUpdateTextAttribute(	PropertyMask *		pChangeMask,
					TextAttribute *		taTo,
					const TextAttribute *	taFrom,
					const PropertyMask *	updMask );

extern int utilSetTextProperty(		TextAttribute *		ta,
					int			prop,
					int			arg );

extern int utilGetTextProperty(		const TextAttribute *	ta,
					int			prop );

#   endif	/*  UTIL_TEXT_ATTRIBUTE_H	*/
