/************************************************************************/
/*									*/
/*  sioPipe.[ch]:	sio equivalents to popen/pclose.		*/
/*									*/
/************************************************************************/

#   include	"appUtilConfig.h"

#   include	<sioPipe.h>

#   include	<stdlib.h>
#   include	<stdarg.h>
#   include	<stdio.h>
#   include	<string.h>
#   include	<signal.h>

#   include	<errno.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Simple io streams from and to commands using popen().		*/
/*									*/
/************************************************************************/

static int sioPipeClose(	void *	voidf )
    {
    int		rval;
    void	(*prevSigPipeHandler)( int );

    prevSigPipeHandler= signal( SIGPIPE, SIG_IGN );

    rval= pclose( (FILE *)voidf );

    signal( SIGPIPE, prevSigPipeHandler );

    return rval;
    }

/************************************************************************/
/*									*/
/*  Open an input stream from a command using popen().			*/
/*									*/
/************************************************************************/

static int sioInPipeReadBytes(		void *			voidf,
					unsigned char *		buffer,
					unsigned int		count )
    {
    int		rval;

    rval= fread( buffer, 1, count, (FILE *)voidf );

    return rval;
    }

SimpleInputStream * sioInPipeOpen(	const char *	command )
    {
    SimpleInputStream *		sis= (SimpleInputStream *)0;
    FILE *			f;

    f= popen( command, "r" );
    if  ( ! f )
	{ SXDEB(command,f); goto ready;	}

    sis= sioInOpen( (void *)f, sioInPipeReadBytes, sioPipeClose );

    if  ( ! sis )
	{ SXDEB(command,sis); pclose( f ); goto ready;	}

  ready:

    return sis;
    }


/************************************************************************/
/*									*/
/*  Open an output stream to a command using popen().			*/
/*									*/
/************************************************************************/

static int sioOutPipeWriteBytes(	void *			voidf,
					const unsigned char *	buffer,
					int			count )
    {
    int		rval;
    void	(*prevSigPipeHandler)( int );

    prevSigPipeHandler= signal( SIGPIPE, SIG_IGN );

    rval= fwrite( buffer, 1, count, (FILE *)voidf );

    signal( SIGPIPE, prevSigPipeHandler );

    return rval;
    }

SimpleOutputStream * sioOutPipeOpen(	const char *	command )
    {
    SimpleOutputStream *	sos= (SimpleOutputStream *)0;
    FILE *			f;

    void			(*prevSigPipeHandler)( int );

    prevSigPipeHandler= signal( SIGPIPE, SIG_IGN );

    f= popen( command, "w" );
    if  ( ! f )
	{ SXDEB(command,f); goto ready;	}

    sos= sioOutOpen( (void *)f, sioOutPipeWriteBytes, sioPipeClose );

    if  ( ! sos )
	{ SXDEB(command,sos); pclose( f ); goto ready;	}

  ready:

    signal( SIGPIPE, prevSigPipeHandler );

    return sos;
    }

