/************************************************************************/
/*									*/
/*  A pixmap in the screen GUI. (Implementation)			*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<guiWidgetPixmap.h>
#   include	"guiPixmapImpl.h"
#   include	"guiWidgetImpl.h"
#   include	"drawUtilImpl.h"
#   include	<appDebugon.h>

#   ifdef 		USE_MOTIF

ScreenPixmap guiMakePixmapForWidget(	ScreenWidget	sw,
					int		wide,
					int		high )
    {
    int			depth;
    ScreenPixmap	sp= malloc(sizeof(struct ScreenPixmap));
    APP_WIDGET		w= sw->swNativeWidget;

    if  ( ! sp )
	{ PDEB(sp); return sp;	}

    sp->spDisplay= XtDisplay( w );
    sp->spScreen= DefaultScreen( sp->spDisplay );
    sp->spColors= sw->swColors;
    sp->spBitmapImage= None;
    sp->spGc= None;

    depth= DefaultDepth( sp->spDisplay, sp->spScreen );

    sp->spBitmapImage=
	    XCreatePixmap( sp->spDisplay, XtWindow(w), wide, high, depth );
    if  ( ! sp->spBitmapImage )
	{
	XDEB(sp->spBitmapImage);
	guiFreeScreenPixmap( sp );
	return (ScreenPixmap)0;
	}

    sp->spGc= XCreateGC( sp->spDisplay, sp->spBitmapImage, 0L, (XGCValues *)0 );
    if  ( ! sp->spGc )
	{
	XDEB(sp->spGc);
	guiFreeScreenPixmap( sp );
	return (ScreenPixmap)0;
	}

    return sp;
    }

void guiFreeScreenPixmap(	ScreenPixmap	sp )
    {
    if  ( sp->spGc )
	{ XFreeGC( sp->spDisplay, sp->spGc );	}

    XFreePixmap( sp->spDisplay, sp->spBitmapImage );

    /* spColors is owned by the widget */
    /* spDisplay is owned by the widget */
    /* spScreen is owned by the widget */

    free( sp );
    }

ScreenPixmap guiMakePixmapForImageAndWidget(
				ScreenWidget			sw,
				const AppBitmapImage *		abi,
				const DocumentRectangle *	drSrc,
				int				wide,
				int				high )
    {
    ScreenPixmap	sp= guiMakePixmapForWidget( sw, wide, high );
    XImage *		xim= (XImage *)0;

    if  ( ! sp )
	{ PDEB(sp); return sp;	}

    if  ( drawUtilMotifMakeImage( sp->spDisplay, sp->spScreen,
				&xim, wide, high, sp->spColors, abi, drSrc ) )
	{ guiFreeScreenPixmap( sp ); return (ScreenPixmap)0;	}

    XPutImage( sp->spDisplay, sp->spBitmapImage, sp->spGc, xim,
						    0, 0, 0, 0, wide, high );

    XDestroyImage( xim );

    return sp;
    }

#   endif	/*	USE_MOTIF	*/
