/************************************************************************/
/*									*/
/*  A pixmap in the screen GUI. (Implementation)			*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<guiWidgetPixmap.h>
#   include	"guiPixmapImpl.h"
#   include	"guiWidgetImpl.h"
#   include	"drawUtilImpl.h"
#   include	<appDebugon.h>

#   ifdef 		USE_GTK

ScreenPixmap guiMakePixmapForWidget(	ScreenWidget	sw,
					int		wide,
					int		high )
    {
    int			depth= gdk_visual_get_system()->depth;
    ScreenPixmap	sp= malloc(sizeof(struct ScreenPixmap));
    APP_WIDGET		w= sw->swNativeWidget;

    if  ( ! sp )
	{ PDEB(sp); return sp;	}

    sp->spColors= sw->swColors;
    sp->spBitmapImage= (APP_BITMAP_IMAGE)0;
    sp->spGc= (GdkGC *)0;

    sp->spBitmapImage= gdk_pixmap_new( w->window, wide, high, depth );
    if  ( ! sp->spBitmapImage )
	{
	XDEB(sp->spBitmapImage);
	guiFreeScreenPixmap( sp );
	return (ScreenPixmap)0;
	}

    sp->spGc= gdk_gc_new( sp->spBitmapImage );
    if  ( ! sp->spGc )
	{
	XDEB(sp->spGc);
	guiFreeScreenPixmap( sp );
	return (ScreenPixmap)0;
	}

    return sp;
    }

void guiFreeScreenPixmap(	ScreenPixmap	sp )
    {
    if  ( sp->spGc )
	{ gdk_gc_unref( sp->spGc );	}

    gdk_pixmap_unref( sp->spBitmapImage );

    /* spColors is owned by the widget */

    free( sp );
    }

ScreenPixmap guiMakePixmapForImageAndWidget(
				ScreenWidget			sw,
				const AppBitmapImage *		abi,
				const DocumentRectangle *	drSrc,
				int				wide,
				int				high )
    {
    ScreenPixmap	sp= guiMakePixmapForWidget( sw, wide, high );
    APP_IMAGE *		xim= (APP_IMAGE *)0;

    if  ( ! sp )
	{ PDEB(sp); return sp;	}

    if  ( drawUtilGtkMakeImage( &xim, wide, high, sp->spColors, abi, drSrc ) )
	{ guiFreeScreenPixmap( sp ); return (ScreenPixmap)0;	}

    gdk_draw_image( sp->spBitmapImage, sp->spGc, xim, 0, 0, 0, 0, wide, high );

    gdk_image_destroy( xim );

    return sp;
    }

#   endif	/*	USE_GTK	*/
