/************************************************************************/
/*									*/
/*  Keep a collection TextAttributes by number.				*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   include	<appDebugon.h>

#   include	"drawScreenFontAdmin.h"

/************************************************************************/
/*									*/
/*  Initialize/Clean border administration.				*/
/*									*/
/************************************************************************/

void drawStartScreenFontList(	NumberedPropertiesList *	sfl )
    {
    utilInitNumberedPropertiesList( sfl );

    utilStartNumberedPropertyList( sfl,

		    DSFkey_COUNT,
		    (NumberedPropertiesGetProperty)drawGetScreenFontKey,

		    sizeof(DrawScreenFont),
		    (InitPagedListItem)drawInitScreenFont,
		    (CleanPagedListItem)drawCleanScreenFont );

    return;
    }

/************************************************************************/
/*									*/
/*  Translate a border properties number to a struct value.		*/
/*									*/
/************************************************************************/

DrawScreenFont * drawGetScreenFontByNumber(
					const NumberedPropertiesList *	sfl,
					int				n )
    {
    void *	vdsf= utilPagedListGetItemByNumber( &(sfl->nplPagedList), n );

    return (DrawScreenFont *)vdsf;
    }

/************************************************************************/
/*									*/
/*  Call a function for all ScreenFont in the list.		*/
/*									*/
/************************************************************************/

void drawForAllScreenFonts(	const NumberedPropertiesList *	sfl,
				ScreenFontFunction	f,
				void *				through )
    {
    int			n;
    const PagedList *	pl= &(sfl->nplPagedList);

    for ( n= 0; n < pl->plItemCount; n++ )
	{
	void *      vdsf= utilPagedListGetItemByNumber( pl, n );

	(*f)( (DrawScreenFont *)vdsf, n, through );
	}

    return;
    }

