/************************************************************************/
/*									*/
/*  Drawing surface implementation implementation.			*/
/*									*/
/************************************************************************/

#   include <appFrameConfig.h>

#   include <guiWidgetDrawingSurface.h>
#   include <drawDrawingSurfaceImpl.h>
#   include <guiWidgetImpl.h>
#   include <appDraw.h>
#   include <appDebugon.h>

/************************************************************************/
/*									*/
/*  Explicitly set the coordinate transform.				*/
/*									*/
/************************************************************************/

void drawSetTransform(	DrawingSurface			ds,
			const AffineTransform2D *	at2 )
    {
    if  ( geoInvertAffineTransform2D( &(ds->dsReverseTransform), at2 ) )
	{ AFF2DEB(at2); return;	}

    ds->dsTransform= *at2;
    }

/************************************************************************/
/*									*/
/*  Transform physical coordinates to logical ones. This is needed to	*/
/*  translate from physical coordinates in an event to logical ones in	*/
/*  the application.							*/
/*									*/
/*  If the transformation has a rotation or a skew, we calculate the	*/
/*  smallest possible rectangle around the transformed rectangle.	*/
/*									*/
/************************************************************************/

void drawTransformRectangleBackward(
				DocumentRectangle *		drLogical,
				DrawingSurface			ds,
				const DocumentRectangle *	drPhysical )
    {
    int			x;
    int			y;

    x= AT2_X( drPhysical->drX0, drPhysical->drY0, &(ds->dsReverseTransform) );
    y= AT2_Y( drPhysical->drX0, drPhysical->drY0, &(ds->dsReverseTransform) );

    drLogical->drX0= drLogical->drX1= x;
    drLogical->drY0= drLogical->drY1= y;

    x= AT2_X( drPhysical->drX1, drPhysical->drY0, &(ds->dsReverseTransform) );
    y= AT2_Y( drPhysical->drX1, drPhysical->drY0, &(ds->dsReverseTransform) );
    geo2DIBoxAroundXY( x, y, drLogical );

    x= AT2_X( drPhysical->drX0, drPhysical->drY1, &(ds->dsReverseTransform) );
    y= AT2_Y( drPhysical->drX0, drPhysical->drY1, &(ds->dsReverseTransform) );
    geo2DIBoxAroundXY( x, y, drLogical );

    x= AT2_X( drPhysical->drX1, drPhysical->drY1, &(ds->dsReverseTransform) );
    y= AT2_Y( drPhysical->drX1, drPhysical->drY1, &(ds->dsReverseTransform) );
    geo2DIBoxAroundXY( x, y, drLogical );

    return;
    }

void drawSetRectanglePoints(	APP_POINT			points[5],
				DrawingSurface			ds,
				const DocumentRectangle *	drLogical )
    {
    /*  Counter clockwise */
    points[0].x= AT2_X( drLogical->drX0, drLogical->drY0, &(ds->dsTransform) );
    points[0].y= AT2_Y( drLogical->drX0, drLogical->drY0, &(ds->dsTransform) );

    points[1].x= AT2_X( drLogical->drX0, drLogical->drY1, &(ds->dsTransform) );
    points[1].y= AT2_Y( drLogical->drX0, drLogical->drY1, &(ds->dsTransform) );

    points[2].x= AT2_X( drLogical->drX1, drLogical->drY1, &(ds->dsTransform) );
    points[2].y= AT2_Y( drLogical->drX1, drLogical->drY1, &(ds->dsTransform) );

    points[3].x= AT2_X( drLogical->drX1, drLogical->drY0, &(ds->dsTransform) );
    points[3].y= AT2_Y( drLogical->drX1, drLogical->drY0, &(ds->dsTransform) );

    points[4]= points[0];

    return;
    }
