#   ifndef	APP_XFT_COLOR_LIST_H
#   define	APP_XFT_COLOR_LIST_H

#   include	<appGuiBase.h>
#   include	<utilIntegerValueNode.h>
#   include	<utilNumberedPropertiesAdmin.h>
#   include	<bmcolor.h>

#   ifdef USE_XFT

#   include	<X11/Xft/Xft.h>
#   include	<X11/extensions/Xrender.h>

struct AppXftColorList;

typedef struct AppXftColor
    {
    XRenderColor		axcXRenderColor;
    unsigned char		axcXftColorAllocated;
    XftColor			axcXftColor;

    struct AppXftColorList *	axcList;
    } AppXftColor;

typedef struct AppXftColorList
    {
    Display *			axclDisplay;
    Visual *			axclVisual;
    Colormap			axclColormap;

    NumberedPropertiesList	axclPropertiesList;
    } AppXftColorList;

typedef void (*AppXftColorFunction)(	AppXftColor *		axc,
					int			n,
					void *			through );

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void appInitAppXftColor(		AppXftColor *		axc );

extern void appSolidXftColor(		AppXftColor *		to,
					const APP_COLOR_RGB *	from );

extern int appXftAllocateColor(		AppXftColor *		axc,
					AppXftColorList *	axcl );

extern void appInitAppXftColorList(	AppXftColorList *	axcl );

extern void appCleanAppXftColorList(	AppXftColorList *	axcl );

extern int appAppXftColorNumber(	AppXftColorList *	axcl,
					const AppXftColor *	axc );

extern void appGetAppXftColorByNumber(	AppXftColor *		axc,
					const AppXftColorList *	axcl,
					int			n );

#   endif
#   endif	/* APP_XFT_COLOR_LIST_H */
