#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>

#   include	<appWinMetaImpl.h>
#   include	<appMacPictImpl.h>
#   include	"guiPixmapImpl.h"
#   include	<psPrint.h>
#   include	<bmWmfIo.h>
#   include	<bmEmfIo.h>

#   include	<math.h>

#   include	<appDebugon.h>

# if 0
#    define	WMFDEB(x)	(x)
# else
#    define	WMFDEB(x)	/*nothing*/
# endif

static int appMetaCleanObjectX11(	DeviceContext *		dc,
					void *			through,
					MetaFileObject *	mfo )
    {
    AppDrawingData *	add= &(dc->dcDrawingData);
    PatternBrush *	pb;
    LogicalBrush *	lb;

    switch( mfo->mfoType )
	{
	case MFtypePATTERNBRUSH:
	    pb= &(mfo->mfoPatternBrush);
	    if  ( pb->pbTilePixmap )
		{
		appDrawFreePixmap( add, pb->pbTilePixmap );
		pb->pbTilePixmap= (APP_BITMAP_IMAGE)0;
		}
	    break;

	case MFtypeBRUSH:
	    lb= &(mfo->mfoLogicalBrush);
	    if  ( lb->lbTilePixmap )
		{
		appDrawFreePixmap( add, lb->lbTilePixmap );
		lb->lbTilePixmap= (APP_BITMAP_IMAGE)0;
		}
	    break;

	default:
	    break;
	}

    return 0;
    }

static int appMetaInitDeviceContextX11(
				DeviceContextX11 *		dcx,
				const PostScriptFontList *	psfl,
				int				objectCount,
				const DocumentRectangle *	drLogical,
				int				mapMode,
				int				twipsWide,
				int				twipsHigh,
				int				pixelsWide,
				int				pixelsHigh )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);

    if  ( appMetaInitDeviceContext( dc, psfl, objectCount, drLogical, mapMode,
						    pixelsWide, pixelsHigh,
						    twipsWide, twipsHigh ) )
	{ LDEB(objectCount); return -1;	}

    dcx->dcxScreenFont= -1;

    dcx->dcxPixelsWide= pixelsWide;
    dcx->dcxPixelsHigh= pixelsHigh;

    return 0;
    }

static int appMetaSetDeviceDefaultsX11(	DeviceContextX11 *	dcx,
					AppColors *		ac )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);
    AppDrawingData *	add= &(dc->dcDrawingData);

    dcx->dcxColors= ac;

    appDrawSetForegroundBlack( add );

    if  ( appColorRgb( &dcx->dcxPenColor, ac,
		    dc->dcPen.lpColor.rgb8Red,
		    dc->dcPen.lpColor.rgb8Green,
		    dc->dcPen.lpColor.rgb8Blue ) )
	{ LDEB(1); return -1;	}

    if  ( appColorRgb( &dcx->dcxBrushColor, ac,
		    dc->dcBrush.lbColor.rgb8Red,
		    dc->dcBrush.lbColor.rgb8Green,
		    dc->dcBrush.lbColor.rgb8Blue ) )
	{ LDEB(1); return -1;	}

    if  ( appColorRgb( &dcx->dcxBkColor, ac,
		    dc->dcBkColor.rgb8Red,
		    dc->dcBkColor.rgb8Green,
		    dc->dcBkColor.rgb8Blue ) )
	{ LDEB(1); return -1;	}

    if  ( appColorRgb( &dcx->dcxTextColor, ac,
		    dc->dcTextColor.rgb8Red,
		    dc->dcTextColor.rgb8Green,
		    dc->dcTextColor.rgb8Blue ) )
	{ LDEB(1); return -1;	}


    return 0;
    }

static int appMetaSelectBrushObjectX11(	DeviceContext *		dc,
					void *			through,
					LogicalBrush *		lb )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);
    AppColors *		ac= dcx->dcxColors;

    switch( lb->lbStyle )
	{
	case BS_SOLID:
	    dcx->dcxDeviceContext.dcFillInsides= 1;

	    if  ( appColorRgb( &dcx->dcxBrushColor, ac,
					    lb->lbColor.rgb8Red,
					    lb->lbColor.rgb8Green,
					    lb->lbColor.rgb8Blue ) )
		{ LDEB(1);  return -1;	}

#	    ifdef USE_MOTIF
	    XSetFillStyle( add->addDisplay, add->addGc, FillSolid );
#	    endif
#	    ifdef USE_GTK
	    gdk_gc_set_fill( add->addGc, GDK_SOLID );
#	    endif

	    dcx->dcxFillTiled= 0;
	    dcx->dcxFillHatched= 0;
	    appDrawSetForegroundColor( add, &(dcx->dcxBrushColor) );
	    break;

	case BS_HOLLOW:
#	    ifdef USE_MOTIF
	    XSetFillStyle( add->addDisplay, add->addGc, FillSolid );
#	    endif
#	    ifdef USE_GTK
	    gdk_gc_set_fill( add->addGc, GDK_SOLID );
#	    endif

	    dcx->dcxFillTiled= 0;
	    dcx->dcxFillHatched= 0;
	    dcx->dcxDeviceContext.dcFillInsides= 0;

	    break;

	case BS_HATCHED:
	case BS_PATTERN:
	    if  ( ! lb->lbTilePixmap )
		{
		int		wide= 8;
		int		high= 8;

		AppDrawingData	addPat;

		appInitDrawingData( &addPat );

		if  ( appColorRgb( &(dcx->dcxBrushColor), ac,
						lb->lbColor.rgb8Red,
						lb->lbColor.rgb8Green,
						lb->lbColor.rgb8Blue ) )
		    { LDEB(1);  return -1;	}

		lb->lbTilePixmap= appMakePixmap( add, wide, high );

		appCloneDrawingEnvironment( &addPat,
					add, 1.0, 0.05, lb->lbTilePixmap );

		appDrawSetForegroundWhite( &addPat );
		appDrawFillRectangle( &addPat, 0, 0, wide, high );

		appDrawSetForegroundColor( &addPat, &(dcx->dcxBrushColor) );

		switch( lb->lbHatch )
		    {
		    case HS_HORIZONTAL:
			appDrawDrawLine( &addPat, 0, 1, wide- 1, 1 );
			break;

		    case HS_VERTICAL:
			appDrawDrawLine( &addPat, 1, 0, 1, high- 1 );
			break;

		    case HS_FDIAGONAL:
			appDrawDrawLine( &addPat, 0, 0, wide- 1, high- 1 );
			break;

		    case HS_BDIAGONAL:
			appDrawDrawLine( &addPat, 0, high- 1, wide- 1, 0 );
			break;

		    case HS_CROSS:
			appDrawDrawLine( &addPat, 0, 1, wide- 1, 1 );
			appDrawDrawLine( &addPat, 1, 0, 1, high- 1 );
			break;

		    case HS_DIAGCROSS:
			appDrawDrawLine( &addPat, 0, 0, wide- 1, high- 1 );
			appDrawDrawLine( &addPat, 0, high- 1, wide- 1, 0 );
			break;

		    default:
			LDEB(lb->lbHatch);
			break;
		    }

		appCleanDrawingData( &addPat );
		}

#	    ifdef USE_MOTIF
	    XSetTile( add->addDisplay, add->addGc, lb->lbTilePixmap );
#	    endif
#	    ifdef USE_GTK
	    gdk_gc_set_tile( add->addGc, lb->lbTilePixmap );
#	    endif

	    dcx->dcxDeviceContext.dcFillInsides= 1;
	    dcx->dcxFillTiled= 1;
	    dcx->dcxFillHatched= 1;
	    break;

	default:
	    LDEB(lb->lbStyle); 
	    dcx->dcxDeviceContext.dcFillInsides= 0;
	    break;
	}

    dcx->dcxDeviceContext.dcBrush= *lb;

    return 0;
    }

static int appMetaSelectPatternBrushObjectX11(	DeviceContext *		dc,
						void *			through,
						PatternBrush *		pb )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);
    AppBitmapImage *	abi= pb->pbAbi;
    AppColors *		ac= dcx->dcxColors;

    if  ( ! pb->pbTilePixmap )
	{
	const int		dstXExt= abi->abiBitmap.bdPixelsWide;
	const int		dstYExt= abi->abiBitmap.bdPixelsHigh;

	if  ( appImgMakePixmap( add, &(pb->pbTilePixmap),
					    dstXExt, dstYExt, ac,
					    abi, (DocumentRectangle *)0 ) )
	    { LDEB(1); return -1;	}
	}

#   ifdef USE_MOTIF
    XSetTile( add->addDisplay, add->addGc, pb->pbTilePixmap );
#   endif
#   ifdef USE_GTK
    gdk_gc_set_tile( add->addGc, pb->pbTilePixmap );
#   endif

    dc->dcFillInsides= 1;
    dcx->dcxFillTiled= 1;
    dcx->dcxFillHatched= 0;

    return 0;
    }

static int appMetaSelectFontObjectX11(	DeviceContext *		dc,
					void *			through,
					LogicalFont *		lf )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);

    if  ( lf->lfPrivateFont < 0 )
	{
	int	pixelSize= appWinMetaOutputSize( dc, lf->lfHeight );

	lf->lfPrivateFont= appOpenScreenFont( add, &(dc->dcFontList),
					&(lf->lfTextAttribute), pixelSize );

	if  ( lf->lfPrivateFont < 0 )
	    { SLDEB(lf->lfFaceNameUtf8,lf->lfPrivateFont); return 0;	}
	}

    if  ( lf->lfPrivateFont >= 0 )
	{
	dcx->dcxScreenFont= lf->lfPrivateFont;

	appDrawSetFont( add, dcx->dcxScreenFont );
	}
    else{ dcx->dcxScreenFont= -1;	}

    return 0;
    }

void appMetaX11SetWindowsLineStyle(	AppDrawingData *	add,
					int *			pDraw,
					int			ps,
					int			lpW,
					int			width )
    {
    int		drawBorders= 0;

    static unsigned char	dash[]= { 3, 2 };
    static unsigned char	dot[]= { 1, 2 };
    static unsigned char	dashdot[]= { 2, 2, 1, 2 };
    static unsigned char	dashdotdot[]= { 2, 2, 1, 2, 1, 2 };

    switch( ps & 0xff )
	{
	case PS_SOLID:
	  solid:
	    drawBorders= 1;

	    appDrawSetLineAttributes( add,
			width, LINEstyleSOLID, LINEcapBUTT, LINEjoinMITER,
			(const unsigned char *)0, 0 );
	    break;

	case PS_INSIDEFRAME:
	    drawBorders= 1;

	    appDrawSetLineAttributes( add,
			width, LINEstyleSOLID, LINEcapBUTT, LINEjoinMITER,
			(const unsigned char *)0, 0 );
	    break;

	case PS_DASH:
	    if  ( lpW > 1 )
		{ goto solid;	}

	    drawBorders= 1;

	    appDrawSetLineAttributes( add,
			1, LINEstyleON_OFF_DASH, LINEcapBUTT, LINEjoinMITER,
			dash, sizeof( dash ) );
	    break;

	case PS_DOT:
	    if  ( lpW > 1 )
		{ goto solid;	}

	    drawBorders= 1;

	    appDrawSetLineAttributes( add,
			1, LINEstyleON_OFF_DASH, LINEcapBUTT, LINEjoinMITER,
			dot, sizeof( dot ) );
	    break;

	case PS_DASHDOT:
	    if  ( lpW > 1 )
		{ goto solid;	}

	    drawBorders= 1;

	    appDrawSetLineAttributes( add,
			1, LINEstyleON_OFF_DASH, LINEcapBUTT, LINEjoinMITER,
			dashdot, sizeof( dashdot ) );
	    break;

	case PS_DASHDOTDOT:
	    if  ( lpW > 1 )
		{ goto solid;	}

	    drawBorders= 1;

	    appDrawSetLineAttributes( add,
			1, LINEstyleON_OFF_DASH, LINEcapBUTT, LINEjoinMITER,
			dashdotdot, sizeof( dashdotdot ) );
	    break;

	case PS_NULL:
	    drawBorders= 0;
	    break;

	default:
	    drawBorders= 0;
	    break;
	}


    *pDraw= drawBorders;
    return;
    }

static int appMetaSelectPenObjectX11(	DeviceContext *		dc,
					void *			through,
					LogicalPen *		lp )
    {
    DeviceContextX11 *		dcx= (DeviceContextX11 *)through;
    AppDrawingData *		add= &(dc->dcDrawingData);
    AppColors *			ac= dcx->dcxColors;
    int				outputWidth;

    outputWidth= appWinMetaOutputSize( dc, lp->lpWidth );

    appMetaX11SetWindowsLineStyle( add,
			&(dcx->dcxDeviceContext.dcDrawBorders),
			lp->lpStyle, lp->lpWidth, outputWidth );

    if  ( dcx->dcxDeviceContext.dcDrawBorders )
	{
	if  ( appColorRgb( &dcx->dcxPenColor, ac,
					    lp->lpColor.rgb8Red,
					    lp->lpColor.rgb8Green,
					    lp->lpColor.rgb8Blue ) )
		{ LDEB(1);  return -1;	}

	appDrawSetForegroundColor( add, &(dcx->dcxPenColor) );
	}

    dcx->dcxDeviceContext.dcPen= *lp;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw a raster image on the window.					*/
/*									*/
/************************************************************************/

static int appDrawMetaBitmapImageX11(	DeviceContext *			dc,
					void *				through,
					const AppBitmapImage *		abi,
					const DocumentRectangle *	drSrc,
					const DocumentRectangle *	drDest )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);
    AppColors *		ac= dcx->dcxColors;

    APP_IMAGE *		xim= (APP_IMAGE *)0;

    int			pixelsWide= drDest->drX1- drDest->drX0+ 1;
    int			pixelsHigh= drDest->drY1- drDest->drY0+ 1;

    if  ( appImgMakeImage( add, &xim, pixelsWide, pixelsHigh, ac, abi, drSrc ) )
	{ LDEB(1); return -1; }

#   ifdef USE_MOTIF
    XPutImage( add->addDisplay, add->addDrawable, add->addGc,
					xim, 0, 0, drDest->drX0, drDest->drY0,
					pixelsWide, pixelsHigh );
    XDestroyImage( xim );
#   endif

#   ifdef USE_GTK
    gdk_draw_image( add->addDrawable, add->addGc,
					xim, 0, 0, drDest->drX0, drDest->drY0,
					pixelsWide, pixelsHigh );
    gdk_image_destroy( xim );
#   endif

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw a rounded rectangle.						*/
/*									*/
/************************************************************************/

static int appMetaDrawRoundedRectangleX11(
				DeviceContext *			dc,
				void *				through,
				const DocumentRectangle *	dr,
				int				wide,
				int				high,
				int				fillInside,
				int				drawBorder )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);

    APP_ARC		arcs[4];
    APP_SEGMENT		segments[4];
    APP_POINT		points[12];

    appDrawPrepareRoundRect( arcs, segments, points, dr, wide, high );

    if  ( fillInside )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxBrushColor) );

	appDrawFillArcs( add, arcs, 4 );
	appDrawFillPolygon( add, points, 12 );
	}

    if  ( drawBorder )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxPenColor) );

	appDrawDrawArcs( add, arcs, 4 );
	appDrawDrawSegments( add, segments, 4 );
	}

    return 0;
    }

static void appMetaGetArcX11(	DeviceContextX11 *		dcx,
				DocumentRectangle *		drFixed,
				int *				pa1,
				int *				pa2,
				const DocumentRectangle *	dr,
				int				xs,
				int				ys,
				int				xe,
				int				ye )

    {
    int		ym;
    int		xm;
    int		h;
    int		w;

    double	as;
    double	ae;

    ym= ( dr->drY1+ dr->drY0 )/2;
    xm= ( dr->drX1+ dr->drX0 )/2;
    *drFixed= *dr;

    if  ( dr->drX1 < dr->drX0 )
	{
	xs= 2* xm- xs;
	xe= 2* xm- xe;
	drFixed->drX1= dr->drX0;
	drFixed->drX0= dr->drX1;
	}
    if  ( dr->drY1 < dr->drY0 )
	{
	ys= 2* ym- ys;
	ye= 2* ym- ye;
	drFixed->drY1= dr->drY0;
	drFixed->drY0= dr->drY1;
	}

    h= drFixed->drY1- drFixed->drY0;
    w= drFixed->drY1- drFixed->drY0;

    as= -atan2(	(double) w* ( ys- ym ), (double) h* ( xs- xm ) );
    ae= -atan2(	(double) w* ( ye- ym ), (double) h* ( xe- xm ) );

    as= ( 180* as )/ M_PI;
    ae= ( 180* ae )/ M_PI;

    if  ( ae < as )
	{ ae += 360;	}

    as= 64* as;
    ae= 64* ae;

    ae -= as;

    *pa1= (int)as;
    *pa2= (int)ae;

    return;
    }

static int appMetaDrawArcX11(	DeviceContext *			dc,
				void *				through,
				const DocumentRectangle *	dr,
				int				xs,
				int				ys,
				int				xe,
				int				ye,
				int				fillInside,
				int				drawBorder )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);

    int			a1;
    int			a2;
    DocumentRectangle	drFixed;

    appMetaGetArcX11( dcx, &drFixed, &a1, &a2, dr, xs, ys, xe, ye );

    if  ( drawBorder )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxPenColor) );

	appDrawDrawArc( add, drFixed.drX0, drFixed.drY0,
				    drFixed.drX1- drFixed.drX0,
				    drFixed.drY1- drFixed.drY0, a1, a2 );
	}

    return 0;
    }

static int appMetaDrawChordX11(	DeviceContext *			dc,
				void *				through,
				const DocumentRectangle *	dr,
				int				xs,
				int				ys,
				int				xe,
				int				ye,
				int				fillInside,
				int				drawBorder )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);

    int			a1;
    int			a2;
    DocumentRectangle	drFixed;

    appMetaGetArcX11( dcx, &drFixed, &a1, &a2, dr, xs, ys, xe, ye );

    if  ( drawBorder )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxPenColor) );

	/* WRONG */
	appDrawDrawArc( add, drFixed.drX0, drFixed.drY0,
				    drFixed.drX1- drFixed.drX0,
				    drFixed.drY1- drFixed.drY0, a1, a2 );
	}

    return 0;
    }

static int appMetaDrawPieX11(	DeviceContext *			dc,
				void *				through,
				const DocumentRectangle *	dr,
				int				xs,
				int				ys,
				int				xe,
				int				ye,
				int				fillInside,
				int				drawBorder )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);

    int			a1;
    int			a2;
    DocumentRectangle	drFixed;

    appMetaGetArcX11( dcx, &drFixed, &a1, &a2, dr, xs, ys, xe, ye );

    if  ( fillInside )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxBrushColor) );

	appDrawFillArc( add, drFixed.drX0, drFixed.drY0,
				    drFixed.drX1- drFixed.drX0,
				    drFixed.drY1- drFixed.drY0, a1, a2 );
	}

    if  ( drawBorder )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxPenColor) );

	appDrawDrawArc( add, drFixed.drX0, drFixed.drY0,
				    drFixed.drX1- drFixed.drX0,
				    drFixed.drY1- drFixed.drY0, a1, a2 );
	}

    return 0;
    }

static int appMetaDrawEllipseX11(
				DeviceContext *			dc,
				void *				through,
				const DocumentRectangle *	dr,
				int				fillInside,
				int				drawBorder )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);

    if  ( fillInside )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxBrushColor) );

	appDrawFillArc( add, dr->drX0, dr->drY0,
				    dr->drX1- dr->drX0,
				    dr->drY1- dr->drY0,
				    64* 0, 64* 360 );
	}

    if  ( drawBorder )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxPenColor) );

	appDrawDrawArc( add, dr->drX0, dr->drY0,
				    dr->drX1- dr->drX0,
				    dr->drY1- dr->drY0,
				    64* 0, 64* 360 );
	}

    return 0;
    }

static void appMeta_SetFillX11(		DeviceContextX11 *	dcx,
					int			before )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);
    AppDrawingData *	add= &(dc->dcDrawingData);

    if  ( before )
	{ appDrawSetForegroundColor( add, &(dcx->dcxBrushColor) );	}

    if  ( dcx->dcxFillTiled && before )
	{
#	ifdef USE_MOTIF
	XSetFillStyle( add->addDisplay, add->addGc, FillTiled );
#	endif
#	ifdef USE_GTK
	gdk_gc_set_fill( add->addGc, GDK_TILED );
#	endif
	}

    if  ( dcx->dcxFillTiled && ! before )
	{
#	ifdef USE_MOTIF
	XSetFillStyle( add->addDisplay, add->addGc, FillSolid );
#	endif
#	ifdef USE_GTK
	gdk_gc_set_fill( add->addGc, GDK_SOLID );
#	endif
	}

    return;
    }

static int appMeta_PolyPolygonX11(	DeviceContext *		dc,
					void *			through,
					int			polyCount,
					const int *		pointCounts,
					const APP_POINT *	points,
					int			fillInsides,
					int			drawBorders,
					int			closePath )

    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);
    int			poly;

    for ( poly= 0; poly < polyCount; poly++ )
	{
	if  ( fillInsides )
	    {
	    appMeta_SetFillX11( dcx, 1 );

	    appDrawFillPolygon( add, points, pointCounts[poly] );

	    appMeta_SetFillX11( dcx, 0 );
	    }

	if  ( drawBorders )
	    {
	    appDrawSetForegroundColor( add, &(dcx->dcxPenColor) );

	    appDrawDrawLines( add, points, pointCounts[poly], closePath );
	    }

	points += pointCounts[poly];
	}

    return 0;
    }

static int appMetaDrawStringX11(	DeviceContext *		dc,
					void *			through,
					int			x0,
					int			y0,
					const MemoryBuffer *	text )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);

    DocumentRectangle	drText;
    int			wide;

    const char *	s= (const char *)text->mbBytes;
    int			len= text->mbSize;

    if  ( dcx->dcxScreenFont < 0 )
	{ XDEB(dcx->dcxScreenFont); return 0;	}

    appDrawTextExtents( &drText, x0, y0, add, dcx->dcxScreenFont, s, len );
    wide= drText.drX1- drText.drX0;

    switch( dc->dcTextAlignment & 0x01 )
	{
	case TA_NOUPDATECP:
	    break;

	case TA_UPDATECP:
	    x0= DC_xViewport( dc->dcX, dc->dcY, dc );
	    y0= DC_yViewport( dc->dcX, dc->dcY, dc );
	    break;

	default:
	    XDEB(dc->dcTextAlignment & 0x01 );
	    break;
	}

    switch( dc->dcTextAlignment & 0x06 )
	{
	int	xshift;

	case TA_LEFT:
	    break;

	case TA_RIGHT:
	    xshift= -wide;
	    x0 += xshift;
	    drText.drX0 += xshift;
	    drText.drX1 += xshift;
	    break;

	case TA_CENTER:
	    xshift= -wide/ 2;
	    x0 += xshift;
	    drText.drX0 += xshift;
	    drText.drX1 += xshift;
	    break;

	default:
	    XDEB(dc->dcTextAlignment & 0x06);
	    break;
	}

    switch( dc->dcTextAlignment & 0x18 )
	{
	int	yshift;

	case TA_TOP:
	    yshift= y0- drText.drY0;
	    y0 += yshift;
	    drText.drY0 += yshift;
	    drText.drY1 += yshift;
	    break;

	case TA_BOTTOM:
	    yshift= y0- drText.drY1;
	    y0 += yshift;
	    drText.drY0 += yshift;
	    drText.drY1 += yshift;
	    break;

	case TA_BASELINE:
	    break;

	default:
	    break;
	}

    if  ( dc->dcBkMode == OPAQUE )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxBkColor) );

	appDrawFillRectangle( add, drText.drX0, drText.drY0,
				    drText.drX1- drText.drX0+ 1,
				    drText.drY1- drText.drY0+ 1 );
	}

    appDrawSetForegroundColor( add, &(dcx->dcxTextColor) );
    appDrawDrawString( add, x0, y0, s, len );

    if  ( dc->dcFont.lfTextAttribute.taTextIsUnderlined )
	{
	int		thick;
	int		y;

	appDrawUnderlineGeometry( &thick, &y, add, dcx->dcxScreenFont, y0 );

	appDrawFillRectangle( add, drText.drX0, y,
				drText.drX1- drText.drX0+ 1, thick );
	}

    switch( dc->dcTextAlignment & 0x01 )
	{
	case TA_NOUPDATECP:
	    break;

	case TA_UPDATECP:
	    /*
	    XDEB(dc->dcTextAlignment & 0x01 );
	    */
	    break;

	default:
	    XDEB(dc->dcTextAlignment & 0x01 );
	    break;
	}

    return 0;
    }

static int appMetaPatBltX11(	DeviceContext *			dc,
				void *				through,
				long				rop,
				const DocumentRectangle *	drOutput )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppDrawingData *	add= &(dc->dcDrawingData);

    DocumentRectangle	drHere;

    geoNormalizeRectangle( &drHere, drOutput );

    if  ( dc->dcFillInsides )
	{
	appDrawSetForegroundColor( add, &(dcx->dcxBrushColor) );

	appDrawFillRectangle( add, drHere.drX0, drHere.drY0,
			drHere.drX1- drHere.drX0, drHere.drY1- drHere.drY0 );
	}

    return 0;
    }

static int appMetaSetPolyFillModeX11(	DeviceContext *		dc,
					void *			through,
					int			mode )
    {
    AppDrawingData *	add= &(dc->dcDrawingData);

    switch( mode )
	{
	case ALTERNATE:
#	    ifdef USE_MOTIF
	    XSetFillRule( add->addDisplay, add->addGc, EvenOddRule );
#	    endif
#	    ifdef USE_GTK
	    appDrawGtkSetXFillRule( add->addGc, GDK_EVEN_ODD_RULE );
#	    endif
	    break;

	case WINDING:
#	    ifdef USE_MOTIF
	    XSetFillRule( add->addDisplay, add->addGc, WindingRule );
#	    endif
#	    ifdef USE_GTK
	    appDrawGtkSetXFillRule( add->addGc, GDK_WINDING_RULE );
#	    endif
	    break;

	default:
	    break;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Fill the background of the pixmap.					*/
/*									*/
/************************************************************************/

static void appMetaFillBackgroundX11(	DeviceContextX11 *	dcx )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);
    AppDrawingData *	add= &(dc->dcDrawingData);

    appDrawSetForegroundWhite( add );
    appDrawFillRectangle( add, 0, 0, dcx->dcxPixelsWide, dcx->dcxPixelsHigh );

    return;
    }

static int appMetaSetTextColorX11(	DeviceContext *		dc,
					void *			through,
					int			r,
					int			g,
					int			b )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppColors *		ac= dcx->dcxColors;

    if  ( appColorRgb( &(dcx->dcxTextColor), ac, r, g, b ) )
	{ LDEB(1);  return -1;	}

    return 0;
    }

static int appMetaSetBkColorX11(	DeviceContext *		dc,
					void *			through,
					int			r,
					int			g,
					int			b )
    {
    DeviceContextX11 *	dcx= (DeviceContextX11 *)through;
    AppColors *		ac= dcx->dcxColors;

    if  ( appColorRgb( &(dcx->dcxBkColor), ac, r, g, b ) )
	{ LDEB(1);  return -1;	}

    return 0;
    }

/************************************************************************/

static int appMetaStartX11DeviceContext(
				DeviceContextX11 *		dcx,
				DeviceContext *			dc,
				AppColors *			ac,
				AppDrawingData *		parent_add,
				ScreenPixmap			sp,
				int				objectCount,
				const DocumentRectangle *	drLogical,
				int				mapMode,
				int				twipsWide,
				int				twipsHigh,
				int				pixelsWide,
				int				pixelsHigh )
    {
    double		magnification;
    double		pixelsPerTwip;

    appMetaInitDeviceContextX11( dcx, parent_add->addPostScriptFontList,
			    objectCount, drLogical, mapMode,
			    twipsWide, twipsHigh, pixelsWide, pixelsHigh );

    pixelsPerTwip= sqrt( (double)( pixelsWide* pixelsHigh )/
						( twipsWide* twipsHigh ) );
    magnification= pixelsPerTwip/ parent_add->addMagnifiedPixelsPerTwip;

    appCloneDrawingEnvironment( &(dc->dcDrawingData),
		parent_add, magnification, pixelsPerTwip, sp->spBitmapImage );

    if  ( appMetaSetDeviceDefaultsX11( dcx, ac ) )
	{ LDEB(1); return -1;	}

    dcx->dcxFillTiled= 0;
    dcx->dcxFillHatched= 0;

    appMetaFillBackgroundX11( dcx );

    dc->dcCleanObject= appMetaCleanObjectX11;
    dc->dcDrawRasterImage= appDrawMetaBitmapImageX11;
    dc->dcSelectPenObject= appMetaSelectPenObjectX11;
    dc->dcSelectBrushObject= appMetaSelectBrushObjectX11;
    dc->dcSelectFontObject= appMetaSelectFontObjectX11;
    dc->dcSelectPatternBrushObject= appMetaSelectPatternBrushObjectX11;
    dc->dcDrawPolyPolygon= appMeta_PolyPolygonX11;
    dc->dcDrawString= appMetaDrawStringX11;
    dc->dcPatBlt= appMetaPatBltX11;
    dc->dcDrawPie= appMetaDrawPieX11;
    dc->dcDrawArc= appMetaDrawArcX11;
    dc->dcDrawChord= appMetaDrawChordX11;
    dc->dcDrawEllipse= appMetaDrawEllipseX11;
    dc->dcDrawRoundedRectangle= appMetaDrawRoundedRectangleX11;
    dc->dcSetTextColor= appMetaSetTextColorX11;
    dc->dcSetBkColor= appMetaSetBkColorX11;
    dc->dcSetPolyFillMode= appMetaSetPolyFillModeX11;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Play the contents of a 'wmf' original windows metafile.		*/
/*									*/
/************************************************************************/

int appMetaPlayWmfX11(	SimpleInputStream *	sis,
			void **			pPrivate,
			AppDrawingData *	parent_add,
			ScreenPixmap		sp,
			int			mapMode,
			int			xWinExt,
			int			yWinExt,
			int			pixelsWide,
			int			pixelsHigh,
			int			twipsWide,
			int			twipsHigh )
    {
    WmfHeader		wh;

    DeviceContextX11	dcx;
    DeviceContext *	dc= &(dcx.dcxDeviceContext);

    DocumentRectangle	drLogical;

    if  ( xWinExt == 0 || yWinExt == 0 )
	{
	LLLLDEB(xWinExt,yWinExt,pixelsWide,pixelsHigh);
	xWinExt= pixelsWide;
	yWinExt= pixelsHigh;
	}

    drLogical.drX0= 0;
    drLogical.drY0= 0;
    drLogical.drX1= xWinExt;
    drLogical.drY1= yWinExt;

    if  ( sioInGetByte( sis ) == EOF )
	{ return 0;	}
    sioInUngetLastRead( sis );

    if  ( bmMetaReadWmfHeader( &wh, sis ) )
	{ LDEB(1); return -1;		}

    WMFDEB(appDebug( "X11 WMF LOGICAL: [%d x %d] PIXELS [%d x %d] TWIPS: [%d x %d]\n",
				    xWinExt, yWinExt,
				    pixelsWide, pixelsHigh,
				    twipsWide, twipsHigh ));

    if  ( appMetaStartX11DeviceContext( &dcx, dc,
		    sp->spColors, parent_add, sp, wh.wh_objectCount,
		    &drLogical, mapMode,
		    twipsWide, twipsHigh, pixelsWide, pixelsHigh ) )
	{ LDEB(1); return -1;	}

    if  ( appMetaPlayWmf( dc, (void *)&dcx, sis ) )
	{ LDEB(1);	}

    appMetaCleanDeviceContext( dc, (void *)&dcx );

    return 0;
    }

int appMetaPlayEmfX11(	SimpleInputStream *	sis,
			void **			pPrivate,
			AppDrawingData *	parent_add,
			ScreenPixmap		sp,
			int			mapMode,
			int			xWinExt,
			int			yWinExt,
			int			pixelsWide,
			int			pixelsHigh,
			int			twipsWide,
			int			twipsHigh )
    {
    EmfHeader		eh;

    int			done;
    DeviceContextX11	dcx;
    DeviceContext *	dc= &(dcx.dcxDeviceContext);

    done= bmMetaReadEmfHeader( &eh, sis );
    if  ( done < 0 )
	{ LDEB(done); return -1;		}
    while( done < eh.eh_headerSize )
	{ sioInGetByte( sis ); done++; }

    WMFDEB(appDebug( "X11 EMF LOGICAL: [%d..%d x %d..%d] PIXELS: [%d x %d] TWIPS: [%d x %d]\n",
				    eh.ehBounds.drX0, eh.ehBounds.drX1,
				    eh.ehBounds.drY0, eh.ehBounds.drY1,
				    pixelsWide, pixelsHigh,
				    twipsWide, twipsHigh ));

    if  ( appMetaStartX11DeviceContext( &dcx, dc,
			sp->spColors, parent_add, sp, eh.eh_numOfHandles,
			&(eh.ehBounds), MM_ANISOTROPIC,
			twipsWide, twipsHigh, pixelsWide, pixelsHigh ) )
	{ LDEB(1); return -1;	}


    /*********/
    if  ( appMetaPlayEmf( dc, (void *)&dcx, sis ) )
	{ LDEB(1);	}

    appMetaCleanDeviceContext( dc, (void *)&dcx );

    return 0;
    }


int appMacPictPlayFileX11(	SimpleInputStream *	sis,
				void **			pPrivate,
				AppDrawingData *	parent_add,
				ScreenPixmap		sp,
				int			mapMode,
				int			xWinExt,
				int			yWinExt,
				int			pixelsWide,
				int			pixelsHigh,
				int			twipsWide,
				int			twipsHigh )
    {
    MacPictHeader	mph;

    int			done;
    DeviceContextX11	dcx;
    DeviceContext *	dc= &(dcx.dcxDeviceContext);
    const int		handleCount= MACPICThandle_COUNT;

    done= appMacPictGetDeviceHeader( &mph, sis );
    if  ( done < 0 )
	{ LDEB(done); return -1;		}

    WMFDEB(appDebug( "X11 PICT LOGICAL: [%d x %d] PIXELS [%d x %d] TWIPS: [%d x %d]\n",
				    xWinExt, yWinExt,
				    pixelsWide, pixelsHigh,
				    twipsWide, twipsHigh ));

    if  ( appMetaStartX11DeviceContext( &dcx, dc,
			    sp->spColors, parent_add, sp, handleCount,
			    &(mph.mphFrame), MM_ANISOTROPIC,
			    twipsWide, twipsHigh, pixelsWide, pixelsHigh ) )
	{ LDEB(1); return -1;	}

    dc->dcMacPictVersion= mph.mphVersion;

    /*********/
    if  ( appMacPictPlayPict( dc, (void *)&dcx, sis ) )
	{ LDEB(1);	}

    appMetaCleanDeviceContext( dc, (void *)&dcx );

    return 0;
    }

