#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>

#   include	<appWinMetaImpl.h>
#   include	<appMacPictImpl.h>
#   include	<psFontMetrics.h>
#   include	<appMatchFont.h>
#   include	<utilMatchFont.h>
#   include	<bmWmfIo.h>
#   include	<bmEmfIo.h>
#   include	<sioEndian.h>

#   include	<appDebugon.h>

# if 0
#    define	WMFDEB(x)	(x)
# else
#    define	WMFDEB(x)	/*nothing*/
# endif

# if 0
#    define	WMFLOG(x)	(x)
# else
#    define	WMFLOG(x)	/*nothing*/
# endif


typedef struct ListMetaFonts
    {
    PostScriptTypeList *	lmfPstl;
    const char *		lmfPrefix;
    } ListMetaFonts;

static int appDrawMetaBitmapImagePsList(
				DeviceContext *			dc,
				void *				through,
				const AppBitmapImage *		abi,
				const DocumentRectangle *	drSrc,
				const DocumentRectangle *	drDest )
    { return 0;	}

static int appMetaSelectPenObjectPsList(DeviceContext *		dc,
					void *			through,
					LogicalPen *		lp )
    { return 0;	}

static int appCleanObjectPsList(	DeviceContext *		dc,
					void *			through,
					MetaFileObject *	mfo )
    { return 0;	}

static int appMetaSelectBrushObjectPsList(DeviceContext *		dc,
					void *			through,
					LogicalBrush *		lb )
    { return 0;	}

static int appMetaDrawRoundedRectanglePsList(
				DeviceContext *			dc,
				void *				through,
				const DocumentRectangle *	dr,
				int				wide,
				int				high,
				int				fillInside,
				int				drawBorder )
    { return 0;	}

static int appMeta_PolyPolygonPsList(DeviceContext *	dc,
				void *			through,
				int			polyCount,
				const int *		pointCounts,
				const APP_POINT *	points,
				int			fillInsides,
				int			drawBorders,
				int			closePath )
    { return 0;	}

static int appMetaDrawArcPsList(DeviceContext *			dc,
				void *				through,
				const DocumentRectangle *	dr,
				int				xs,
				int				ys,
				int				xe,
				int				ye,
				int				fillInside,
				int				drawBorder )
    { return 0;	}

static int appMetaSelectFontObjectPsList( DeviceContext *	dc,
					void *			through,
					LogicalFont *		lf )
    {
    const ListMetaFonts *	lmf= (const ListMetaFonts *)through;
    DocumentFontList *		dfl= &(dc->dcFontList);
    const PostScriptFontList *	psfl= dc->dcPostScriptFontList;
    const int			appearsInText= 0;

    dc->dcAfi= appGetFontInfoForAttribute( &(lf->lfTextAttribute), dfl, psfl );
    if  ( ! dc->dcAfi )
	{ XDEB(dc->dcAfi); return -1;	}

    if  ( psRememberPostsciptFace( lmf->lmfPstl, dc->dcAfi,
		    &(lf->lfTextAttribute), lmf->lmfPrefix, appearsInText ) )
	{ SDEB(dc->dcAfi->afiFontName); return -1;	}

    return 0;
    }

static int appMetaSelectPatternBrushObjectPsList( DeviceContext *	dc,
						void *			through,
						PatternBrush *		pb )
    { return 0;	}

static int appMetaDrawRectanglePsList(
				DeviceContext *			dc,
				void *				through,
				const DocumentRectangle *	dr,
				int				fillInside,
				int				drawBorder )
    { return 0;	}

static int appMetaDrawStringPsList(	DeviceContext *		dc,
					void *			through,
					int			x0,
					int			y0,
					const MemoryBuffer *	text )
    { return 0;	}

static int appMetaPatBltPsList(	DeviceContext *			dc,
				void *				through,
				long				rop,
				const DocumentRectangle *	dr )
    { return 0;	}

static int appMetaIgnoreColorPsList(	DeviceContext *		dc,
					void *			through,
					int			r,
					int			g,
					int			b )
    { return 0;	}

static int appMetaSetPolyFillModePsList( DeviceContext *	dc,
					void *			through,
					int			mode )
    { return 0;	}

static int appMetaStartPsList(	DeviceContext *			dc,
				int				objectCount,
				const PostScriptFontList *	psfl,
				const DocumentRectangle *	drLogical,
				int				mapMode,
				int				twipsWide,
				int				twipsHigh )
    {
    if  ( appMetaInitDeviceContext( dc, psfl, objectCount, drLogical, mapMode,
				twipsWide, twipsHigh, twipsWide, twipsHigh ) )
	{ LDEB(objectCount); return -1;	}

    dc->dcCleanObject= appCleanObjectPsList;
    dc->dcDrawRasterImage= appDrawMetaBitmapImagePsList;
    dc->dcSelectPenObject= appMetaSelectPenObjectPsList;
    dc->dcSelectBrushObject= appMetaSelectBrushObjectPsList;
    dc->dcSelectFontObject= appMetaSelectFontObjectPsList;
    dc->dcSelectPatternBrushObject= appMetaSelectPatternBrushObjectPsList;
    dc->dcDrawPolyPolygon= appMeta_PolyPolygonPsList;
    dc->dcDrawString= appMetaDrawStringPsList;
    dc->dcPatBlt= appMetaPatBltPsList;
    dc->dcDrawPie= appMetaDrawArcPsList;
    dc->dcDrawArc= appMetaDrawArcPsList;
    dc->dcDrawChord= appMetaDrawArcPsList;
    dc->dcDrawEllipse= appMetaDrawRectanglePsList;
    dc->dcDrawRoundedRectangle= appMetaDrawRoundedRectanglePsList;
    dc->dcSetTextColor= appMetaIgnoreColorPsList;
    dc->dcSetBkColor= appMetaIgnoreColorPsList;
    dc->dcSetPolyFillMode= appMetaSetPolyFillModePsList;

    return 0;
    }

/************************************************************************/
/*									*/
/*  List the fonts in a windows metafile.				*/
/*									*/
/*  The geometry parameters are absolutely irrelevant, but required by	*/
/*  appMetaInitDeviceContext().						*/
/*									*/
/************************************************************************/

int appWmfListFontsPs( PostScriptTypeList *		pstl,
			SimpleInputStream *		sis,
			const PostScriptFontList *	psfl,
			const char *			prefix,
			int				mapMode,
			int				xWinExt,
			int				yWinExt,
			int				twipsWide,
			int				twipsHigh )
    {
    int			rval= 0;

    WmfHeader		wh;
    DeviceContext	dc;

    ListMetaFonts	lmf;

    DocumentRectangle	drLogical;

    drLogical.drX0= 0;
    drLogical.drY0= 0;
    drLogical.drX1= xWinExt;
    drLogical.drY1= yWinExt;

    lmf.lmfPstl= pstl;
    lmf.lmfPrefix= prefix;

    if  ( sioInGetByte( sis ) == EOF )
	{ return 0;	}
    sioInUngetLastRead( sis );

    if  ( bmMetaReadWmfHeader( &wh, sis ) )
	{ LDEB(1); return -1;		}

    if  ( appMetaStartPsList( &dc, wh.wh_objectCount, psfl,
				&drLogical, mapMode, twipsWide, twipsHigh ) )
	{ LDEB(wh.wh_objectCount); return -1;	}

    WMFDEB(appDebug( "PSFONTS WMF\n" ));

    if  ( appMetaPlayWmf( &dc, (void *)&lmf, sis ) )
	{ rval= -1;	}

    appMetaCleanDeviceContext( &dc, (void *)&lmf );

    return 0;
    }

int appEmfListFontsPs( PostScriptTypeList *		pstl,
			SimpleInputStream *		sis,
			const PostScriptFontList *	psfl,
			const char *			prefix,
			int				mapMode,
			int				xWinExt,
			int				yWinExt,
			int				twipsWide,
			int				twipsHigh )
    {
    int			rval= 0;

    int			done;
    EmfHeader		eh;
    DeviceContext	dc;

    ListMetaFonts	lmf;

    lmf.lmfPstl= pstl;
    lmf.lmfPrefix= prefix;

    done= bmMetaReadEmfHeader( &eh, sis );
    if  ( done < 0 )
	{ LDEB(done); return -1;		}
    while( done < eh.eh_headerSize )
	{ sioInGetByte( sis ); done++; }

    if  ( appMetaStartPsList( &dc, eh.eh_numOfHandles, psfl,
			&(eh.ehBounds), MM_ANISOTROPIC, twipsWide, twipsHigh ) )
	{ LDEB(eh.eh_numOfHandles); return -1;	}

    WMFDEB(appDebug( "PSFONTS EMF LOGICAL: [%d..%d x %d..%d] TWIPS: [%d x %d]\n",
				    eh.ehBounds.drX0, eh.ehBounds.drX1,
				    eh.ehBounds.drY0, eh.ehBounds.drY1,
				    twipsWide, twipsHigh ));

    if  ( appMetaPlayEmf( &dc, (void *)&lmf, sis ) )
	{ rval= -1;	}

    appMetaCleanDeviceContext( &dc, (void *)&lmf );

    return rval;
    }


int appMacPictListFontsPs(	PostScriptTypeList *		pstl,
				SimpleInputStream *		sis,
				const PostScriptFontList *	psfl,
				const char *			prefix,
				int				mapMode,
				int				xWinExt,
				int				yWinExt,
				int				twipsWide,
				int				twipsHigh )
    {
    MacPictHeader	mph;
    int			rval= 0;

    int			done;
    DeviceContext	dc;
    const int		handleCount= MACPICThandle_COUNT;

    ListMetaFonts	lmf;

    lmf.lmfPstl= pstl;
    lmf.lmfPrefix= prefix;

    done= appMacPictGetDeviceHeader( &mph, sis );
    if  ( done < 0 )
	{ LDEB(done); return -1;		}

    if  ( appMetaStartPsList( &dc, handleCount, psfl,
		    &(mph.mphFrame), MM_ANISOTROPIC, twipsWide, twipsHigh ) )
	{ LDEB(handleCount); return -1;	}

    dc.dcMacPictVersion= mph.mphVersion;

    WMFDEB(appDebug( "PSFONTS PICT ...\n" ));

    if  ( appMacPictPlayPict( &dc, (void *)&lmf, sis ) )
	{ rval= -1;	}

    appMetaCleanDeviceContext( &dc, (void *)&lmf );

    return rval;
    }

