/************************************************************************/
/*  Really Quit, Really Close dialogs.					*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	<appFrame.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Run a 'Really Close' dialog.					*/
/*									*/
/************************************************************************/

void appRunReallyCloseDialog(	APP_WIDGET			option,
				EditDocument *			ed )
    {
    EditApplication *		ea= ed->edApplication;
    int				rcc;

    AppFileMessageResources *	afmr= &(ea->eaFileMessageResources);

    rcc= appQuestionRunSubjectYesNoCancelDialog( ea,
				    ed->edToplevel.atTopWidget,
				    option, ed->edTitle,
				    afmr->afmrReallyCloseQuestion );

    switch( rcc )
	{
	case AQDrespYES:
	    if  ( ! ea->eaSaveDocument )
		{ XDEB(ea->eaSaveDocument); return;	}

	    if  ( ! ed->edFilename )
		{
		int	done= 0;

#		ifdef USE_MOTIF
		appDocFileSaveAs( option, (void *)ed, (void *)0 );
		done= 1;
#		endif
#		ifdef USE_GTK
		appDocFileSaveAs( option, (void *)ed );
		done= 1;
#		endif
		if  ( ! done )
		    { LXDEB(done,ed->edFilename);	}
		return;
		}
	    else{
		const int	interactive= 1;

		if  ( ! appDocSaveDocumentByName( ed, option, interactive,
					    ed->edFormat, ed->edFilename ) )
		    { appDocumentChanged( ed, 0 ); }
		}

	    if  ( ! ed->edHasBeenChanged )
		{ appCloseDocument( ea, ed );	}
	    break;

	case AQDrespNO:
	    appCloseDocument( ea, ed );
	    break;
	case AQDrespCANCEL:
	    break;
	default:
	    LDEB(rcc); break;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Run a 'Really Quit' dialog.						*/
/*									*/
/************************************************************************/

int appRunReallyQuitDialog(	APP_WIDGET			option,
				APP_WIDGET			relative,
				EditApplication *		ea )
    {
    AppFileMessageResources *	afmr= &(ea->eaFileMessageResources);

    return appQuestionRunYesNoCancelDialog( ea,
					relative, option,
					afmr->afmrReallyQuitQuestion );
    }
