/************************************************************************/
/*									*/
/*  Run file choosers for edit applications.				*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>
#   include	<locale.h>

#   include	<appSystem.h>
#   include	<sioStdio.h>

#   include	<appFrame.h>
#   include	"appPrintJob.h"
#   include	<appDebugon.h>

#   include	"appFileChooser.h"

/************************************************************************/
/*									*/
/*  Error messages.							*/
/*									*/
/************************************************************************/

static AppConfigurableResource APP_ChooserResourceTable[]=
    {
	APP_RESOURCE( "chooserNoFilename",
		    offsetof(AppFileChooserResources,acrNoFilenameMessage),
		    "Please Give a Name" ),
	APP_RESOURCE( "chooserIsDirectory",
		    offsetof(AppFileChooserResources,acrIsDirecoryMessage),
		    "Is a directory" ),
	APP_RESOURCE( "chooserNotWritable",
		    offsetof(AppFileChooserResources,acrNotWritableMessage),
		    "You have no permission to write this file." ),
	APP_RESOURCE( "chooserNotReadable",
		    offsetof(AppFileChooserResources,acrNotReadableMessage),
		    "You have no permission to read this file." ),
	APP_RESOURCE( "chooserOverwrite",
		    offsetof(AppFileChooserResources,acrOverwriteMessage),
		    "Do you want to overwrite this file?" ),
	APP_RESOURCE( "chooserNoSuchDir",
		    offsetof(AppFileChooserResources,acrNoSuchDirMessage),
		    "This directory does not exist." ),
    };

/************************************************************************/
/*									*/
/*  Retrieve the configurable texts of a file chooser.			*/
/*									*/
/************************************************************************/

void appFileChooserGetTexts(	EditApplication *		ea,
				AppChooserInformation *		aci )
    {
    static int				gotResources= 0;
    static AppFileChooserResources	APP_ChooserResourceValues;

    if  ( ! gotResources )
	{
	appGuiGetResourceValues( &gotResources, ea,
				    (void *)&APP_ChooserResourceValues,
				    APP_ChooserResourceTable,
				    sizeof(APP_ChooserResourceTable)/
				    sizeof(AppConfigurableResource) );
	}

    aci->aciResources= &APP_ChooserResourceValues;

    return;
    }

/************************************************************************/
/*									*/
/*  Retrieve the descriptions of the filters in a file chooser.		*/
/*									*/
/************************************************************************/

int appFileFilterGetDescriptions(
				EditApplication *	ea,
				AppFileExtension *	extensions,
				int			extensionCount )
    {
    AppConfigurableResource *	acr;
    AppConfigurableResource *	acri;
    AppFileExtension *		afe;

    int				i;
    int				ignored= 0;

    acr= (AppConfigurableResource *)
		    malloc( extensionCount* sizeof(AppConfigurableResource) );
    if  ( ! acr )
	{ LXDEB(extensionCount,acr); return -1;	}

    afe= extensions;
    acri= acr;
    for ( i= 0; i < extensionCount; afe++, acri++, i++ )
	{
	APP_SET_RESOURCE( acri, afe->afeId,
			i* sizeof(AppFileExtension)+
				    offsetof(AppFileExtension,afeDescription),
			afe->afeDescription );
	}

    appGuiGetResourceValues( &ignored, ea, extensions, acr, extensionCount );

    free( acr );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Some tests on the name of a file that is to be opened.		*/
/*									*/
/************************************************************************/

int appFileChooserTestNameForOpen(
				const AppChooserInformation *	aci,
				const char *			filename  )
    {
    EditApplication *		ea= aci->aciApplication;
    APP_WIDGET			option= aci->aciOption;

    int				fileExists= 0;
    int				fileReadable= 0;
    int				isDir= 0;

    const AppFileChooserResources *	acr= aci->aciResources;

    fileExists= appTestFileExists( filename ) == 0;

    if  ( fileExists )
	{ fileReadable= appTestFileReadable( filename ) == 0;	}
    else{ isDir= appTestDirectory( filename ) == 0;		}

    if  ( isDir )
	{
	appQuestionRunSubjectErrorDialog( ea, aci->aciRelativeTo,
				option, filename, acr->acrIsDirecoryMessage );
	return -1;
	}

    if  ( ! fileExists )
	{
	AppFileMessageResources *	afmr= &(ea->eaFileMessageResources);

	appQuestionRunSubjectErrorDialog( ea, aci->aciRelativeTo,
			    option, filename, afmr->afmrNoSuchFileMessage );

	return -1;
	}

    if  ( ! fileReadable )
	{
	appQuestionRunSubjectErrorDialog( ea, aci->aciRelativeTo,
			    option, filename, acr->acrNotReadableMessage );
	return -1;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Partially validate the file name of a file chooser: if if has the	*/
/*  wrong extension.. set the rigth one.				*/
/*									*/
/*  Return:  0:  Have saved an acceptable file name.			*/
/*  Return:  1:  No an acceptable file name.				*/
/*  Return: -1:  Failure.						*/
/*									*/
/************************************************************************/

int appChooserSaveFilename(	char **				pSavedName,
				const AppChooserInformation *	aci,
				const char *			filename,
				const char *			newExtension )
    {
    int					rval= 0;
    EditApplication *			ea= aci->aciApplication;
    APP_WIDGET				option= aci->aciOption;

    const char *			slash;
    const char *			relativeName;

    int					fileNameLength;

    char *				fresh= (char *)0;

    const AppFileChooserResources *	acr= aci->aciResources;

    fileNameLength= strlen( filename );

    slash= strrchr( filename, '/' );
    if  ( ! slash )
	{ relativeName= filename;		}
    else{ relativeName= slash+ 1;		}

    if  ( ! relativeName[0] )
	{
	appQuestionRunErrorDialog( ea, aci->aciRelativeTo, option,
						acr->acrNoFilenameMessage );

	rval= 1; goto ready;
	}

    if  ( newExtension && newExtension[0] )
	{
	int		target= fileNameLength;
	const char *	oldExtension;

	oldExtension= appFileExtensionOfName( filename );
	if  ( oldExtension )
	    { target -= 1+ strlen( oldExtension );	}

	if  ( ! oldExtension				||
	      strcmp( oldExtension, newExtension )	)
	    {
	    int		lnew;

	    lnew= strlen( newExtension );

	    fresh= malloc( fileNameLength+ 1+ lnew+ 1 );
	    if  ( ! fresh )
		{
		LXDEB(fileNameLength,fresh);
		rval= -1; goto ready;
		}

	    strcpy( fresh, filename );

	    strcpy( fresh+ target+ 0, "." );
	    strcpy( fresh+ target+ 1, newExtension );
	    }
	}

    if  ( ! fresh )
	{
	fresh= strdup( filename );
	if  ( ! fresh )
	    { XDEB(fresh); rval= -1; goto ready;	}
	}

    /*  steal */
    { char * swap= *pSavedName; *pSavedName= fresh; fresh= swap; }

  ready:
    if  ( fresh )
	{ free( fresh ); }

    return rval;
    }

/************************************************************************/
/*									*/
/*  Some tests on the name for a file to save a document to.		*/
/*									*/
/************************************************************************/

int appFileChooserTestNameForWrite(
				const AppChooserInformation *	aci,
				const char *			filename  )
    {
    int				isDir= 0;
    int				fileExists= 0;
    int				dirExists= 0;
    int				fileWritable= 0;

    const AppFileChooserResources *	acr= aci->aciResources;

    fileExists= appTestFileExists( filename ) == 0;

    if  ( fileExists )
	{ fileWritable= appTestFileWritable( filename ) == 0;	}
    else{ isDir= appTestDirectory( filename ) == 0;		}

    if  ( ! fileExists && ! isDir )
	{
	char *	scratch;
	char *	slash;

	scratch= (char *)malloc( strlen( filename )+ 11 );
	if  ( ! scratch )
	    { XDEB(scratch); return ACIrespFAILURE;	}

	strcpy( scratch, filename );
	slash= strrchr( scratch, '/' );
	if  ( slash )
	    {
	    *slash= '\0';
	    dirExists= appTestDirectory( scratch ) == 0;
	    }

	free( scratch );
	}

    if  ( isDir )
	{
	appQuestionRunSubjectErrorDialog( aci->aciApplication,
					aci->aciRelativeTo, aci->aciOption,
					filename, acr->acrIsDirecoryMessage );
	return ACIrespNONE;
	}

    if  ( fileExists )
	{
	if  ( ! fileWritable )
	    {
	    appQuestionRunSubjectErrorDialog( aci->aciApplication,
					aci->aciRelativeTo, aci->aciOption,
					filename, acr->acrNotWritableMessage );
	    return ACIrespNONE;
	    }
	else{
	    return appFileChooserConfirmOverWrite( aci, filename );
	    }
	}
    else{
	if  ( ! dirExists )
	    {
	    char *	slash= strrchr( filename+ 1, '/' );

	    if  ( slash )
		{
		*slash= '\0';

		appQuestionRunSubjectErrorDialog( aci->aciApplication,
					aci->aciRelativeTo, aci->aciOption,
					filename, acr->acrNoSuchDirMessage );
		return ACIrespNONE;
		}
	    }
	}

    return ACIrespSAVE;
    }

static int appDocPrintDocument(	EditDocument *	ed,
				void *		through,
				APP_WIDGET	relative,
				APP_WIDGET	option,
				int		format,
				const char *	filename )
    {
    SimpleOutputStream *	sos;

    PrintJob *			pj= (PrintJob *)through;

    sos= sioOutStdioOpen( filename );

    if  ( ! sos )
	{ SXDEB(filename,sos); return -1;	}

    appCallPrintFunction( sos, pj );

    sioOutClose( sos );

    return 0;
    }

void appDocPrintToFile(	APP_WIDGET			option,
			APP_WIDGET			panel,
			EditDocument *			ed,
			const PrintGeometry *		pg )
    {
    EditApplication *		ea= ed->edApplication;
    PrintJob			pj;

    if  ( ! ea->eaPrintDocument )
	{ XDEB(ea->eaPrintDocument); return;	}

    appPrintJobForEditDocument( &pj, ed, pg );

    appRunPrintToFileChooser( option, panel, appDocPrintDocument, ed, &pj );
    }

/************************************************************************/
/*									*/
/*  Callbacks from the file menu: Save a document and remember name and	*/
/*  type=format of the output file.					*/
/*									*/
/************************************************************************/

static int appDocSaveDocument(	EditDocument *	ed,
				void *		through,
				APP_WIDGET	relative,
				APP_WIDGET	option,
				int		format,
				const char *	filename )
    {
    EditApplication *	ea= ed->edApplication;

    if  ( (*ea->eaSaveDocument)( ed->edPrivateData, format,
			    ea->eaNameAndVersion, ed->edTitle, filename ) )
	{
	appReportSaveFailure( ea, option, relative, filename );
	return -1;
	}

    if  ( format >= 0				&&
	  format < ea->eaFileExtensionCount	)
	{
	const AppFileExtension *	afe;

	afe= &(ea->eaFileExtensions[format]);

	if  ( afe->afeUseFlags & APPFILE_CAN_OPEN )
	    {
	    appDocumentChanged( ed, 0 );

	    if  ( appSetDocumentFilename( ed, filename ) )
		{ SDEB(filename);	}
	    if  ( appSetDocumentTitle( ed, filename ) )
		{ SDEB(filename);	}

	    ed->edFileReadOnly= 0;
	    ed->edFormat= format;
	    }
	}

    return 0;
    }

APP_MENU_CALLBACK_H( appDocFileSaveAs, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    EditApplication *	ea= ed->edApplication;

    if  ( ! ea->eaSaveDocument )
	{ XDEB(ea->eaSaveDocument); return;	}

    appRunSaveChooser( option, ed->edToplevel.atTopWidget,
			    APPFILE_CAN_SAVE, appDocSaveDocument,
			    ed, ed->edPrivateData );
    }

