#   include	"appFrameConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>

#   include	"appFrame.h"
#   include	"appDrawnPulldown.h"
#   include	"appSystem.h"
#   include	<geoString.h>

#   include	<appDebugon.h>

void appDrawnPulldownDrawArrow( const DocumentRectangle *	drClip,
				int *				pRestWide,
				int *				pRestHigh,
				APP_WIDGET			w,
				AppDrawingData *		add )
    {
    int		wide;
    int		high;

    int		x0;
    int		wi;
    int		m;
    int		d;

    APP_POINT	points[4];

    appDrawGetSizeOfWidget( &wide, &high, w );

    wi= ( 2* high )/ 3;
    x0= wide- wi;
    m= x0+ wi/ 2;
    d= wi/ 4;

    points[0].x= m- d;
    points[0].y= high/ 3;
    points[1].x= m+ d;
    points[1].y= high/ 3;
    points[2].x= m;
    points[2].y= ( 2* high )/ 3;

    points[3]= points[0];

    appDrawSetForegroundColor( add, &(add->addBackColor) );
    appDrawFillRectangle( add, drClip->drX0, drClip->drY0,
					    drClip->drX1- drClip->drX0+ 1,
					    drClip->drY1- drClip->drY0+ 1 );

    appDrawSetForegroundBlack( add );
    appDrawFillPolygon( add, points, 3 );

    *pRestWide= wide- wi;
    *pRestHigh= high;
    return;
    }

void appInitDrawnPulldown(		AppDrawnPulldown *		adp )
    {
    adp->adpPulldownShell= (APP_WIDGET)0;
    adp->adpPulldownDrawing= (APP_WIDGET)0;
    adp->adpInplaceDrawing= (APP_WIDGET)0;
    adp->adpClickHandler= (APP_EVENT_HANDLER_T)0;
    adp->adpPulldown= (AppDrawnPulldownPuldown)0;
    adp->adpThrough= (void *)0;
    adp->adpMouseX= -1;
    adp->adpMouseY= -1;

    adp->adpInplaceDrawingDataSet= 0;
    adp->adpPulldownDrawingDataSet= 0;

    appInitDrawingData( &(adp->adpInplaceDrawingData) );
    appInitDrawingData( &(adp->adpPulldownDrawingData) );
    }

void appCleanDrawnPulldown(		AppDrawnPulldown *		adp )
    {
    appCleanDrawingData( &(adp->adpInplaceDrawingData) );
    appCleanDrawingData( &(adp->adpPulldownDrawingData) );
    }

/************************************************************************/
/*									*/
/*  Finish a drawn pulldown after it has been realized: Allocate the	*/
/*  drawing surface for its in place part.				*/
/*									*/
/************************************************************************/

int appFinishDrawnPulldownInplace(	AppDrawnPulldown *	adp )
    {
    if  ( ! adp->adpInplaceDrawingDataSet )
	{
	appSetDrawingDataForWidget( adp->adpInplaceDrawing,
				(AppColors *)0,
				1.0, &(adp->adpInplaceDrawingData) );

	adp->adpInplaceDrawingDataSet= 1;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Finish a drawn pulldown after it has been opened: Allocate the	*/
/*  drawing surface for its pulldown part.				*/
/*									*/
/************************************************************************/

int appFinishDrawnPulldownPulldown(	AppDrawnPulldown *	adp )
    {
    if  ( ! adp->adpPulldownDrawingDataSet )
	{
	appSetDrawingDataForWidget( adp->adpPulldownDrawing,
				    (AppColors *)0,
				    1.0, &(adp->adpPulldownDrawingData) );

	adp->adpPulldownDrawingDataSet= 1;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Force a redraw of a drawn puldown.					*/
/*									*/
/************************************************************************/

void appExposeDrawnPulldownInplace(	AppDrawnPulldown *	adp )
    {
    appExposeDrawingData( &(adp->adpInplaceDrawingData) );
    return;
    }
