/************************************************************************/
/*									*/
/*  Drawing primitives for X11.						*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<limits.h>
#   include	<math.h>

#   include	<geo2DInteger.h>
#   include	<uniUtf8.h>
#   include	"appDraw.h"
#   include	"appScreenFont.h"
#   include	"drawScreenFontAdmin.h"
#   include	"drawTextImplX11.h"

#   include	<appDebugon.h>

#   ifdef USE_X11_FONTS

void appDrawDrawString(		AppDrawingData *	add,
				int			x,
				int			y,
				const char *		s,
				int			len )
    {
    const NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    DrawScreenFont *			dsf;

    TextProgress			tp;

    dsf= drawGetScreenFontByNumber( npl, add->addCurrentScreenFontNumber );
    if  ( ! dsf )
	{ LXDEB(add->addCurrentScreenFontNumber,dsf); return;	}

#   ifdef USE_XFT
    if  ( dsf->dsfXftFont						    &&
	  ! appDrawDrawStringXft( add, dsf, dsf->dsfXftFont, x, y, s, len ) )
	{ return;	}
#   endif

    tp.tpX= x;
    tp.tpY= y;

    drawHandleTextSegmentsX11( &tp, dsf, s, len, drawTextSegment8X11,
			drawTextSegment16X11, &(dsf->dsfEncodedFonts) );
    }

void appDrawTextExtents(	DocumentRectangle *	drText,
				int			x,
				int			y,
				AppDrawingData *	add,
				int			screenFont,
				const char *		s,
				int			len )
    {
    const NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    DrawScreenFont *			dsf;

    TextProgress			tp;

    dsf= drawGetScreenFontByNumber( npl, screenFont );
    if  ( ! dsf )
	{ LXDEB(screenFont,dsf); return;	}

#   ifdef USE_XFT
    if  ( dsf->dsfXftFont						&&
	  ! appDrawTextExtentsXft( drText, x, y, dsf, dsf, s, len ) )
	{ return;	}
#   endif

    tp.tpX= x;
    tp.tpY= y;

    drawHandleTextSegmentsX11( &tp, dsf, s, len,
		    drawTextSegment8LengthX11, drawTextSegment16LengthX11,
		    &(dsf->dsfEncodedFonts) );

    drText->drX0= x;
    drText->drX1= tp.tpX;

    drawVerticalTextExtentsX11( drText, y, &(dsf->dsfEncodedFonts) );

    return;
    }

void appDrawScapsTextExtents(	DocumentRectangle *	drText,
				int			x,
				int			y,
				AppDrawingData *	add,
				int			fullScreenFont,
				int			scapsScreenFont,
				const char *		s,
				int			len )
    {
    const NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    DrawScreenFont *			fullDsf;
    DrawScreenFont *			scapsDsf;

    TextProgress			tp;

    fullDsf= drawGetScreenFontByNumber( npl, fullScreenFont );
    if  ( ! fullDsf )
	{ LXDEB(fullScreenFont,fullDsf); return;	}

    scapsDsf= drawGetScreenFontByNumber( npl, scapsScreenFont );
    if  ( ! scapsDsf )
	{ LXDEB(scapsScreenFont,scapsDsf); return;	}

#   ifdef USE_XFT
    if  ( fullDsf->dsfXftFont						&&
	  scapsDsf->dsfXftFont						&&
	  ! appDrawTextExtentsXft( drText, x, y,
					scapsDsf, fullDsf, s, len ) )
	{ return;	}
#   endif

    tp.tpX= x;
    tp.tpY= y;

    drawHandleTextSegmentsX11( &tp, scapsDsf, s, len,
				    drawTextSegment8LengthX11,
				    drawTextSegment16LengthX11,
				    &(scapsDsf->dsfEncodedFonts) );

    drText->drX0= x;
    drText->drX1= tp.tpX;

    /* note: no scaps here */
    drawVerticalTextExtentsX11( drText, y, &(fullDsf->dsfEncodedFonts) );

    return;
    }

void appDrawSetFont(		AppDrawingData *	add,
				int			screenFont )
    {
    const NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    DrawScreenFont *			dsf;

    dsf= drawGetScreenFontByNumber( npl, screenFont );
    if  ( ! dsf )
	{ LXDEB(screenFont,dsf); return;	}

    if  ( add->addCurrentScreenFontNumber != screenFont )
	{
	add->addCurrentScreenFontNumber= screenFont;
#	ifdef USE_MOTIF
	add->addCurrentFID= None;
#	endif
	}

    return;
    }

#   endif
