/************************************************************************/
/*									*/
/*  Drawing operations.							*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<limits.h>
#   include	<math.h>

#   include	<uniUtf8.h>
#   include	<geo2DInteger.h>
#   include	"appDraw.h"
#   include	"appScreenFont.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Draw a single unicode symbol.					*/
/*									*/
/************************************************************************/

void appDrawSymbolExtents(	DocumentRectangle *	drText,
				int			x0,
				int			y0,
				AppDrawingData *	add,
				int			screenFont,
				int			symbol )
    {
    int				step;
    char			scratch[10];

    step= uniPutUtf8( (unsigned char *)scratch, symbol );
    if  ( step < 1 )
	{ return;	}
    scratch[step]= '\0';

    appDrawTextExtents( drText, x0, y0, add, screenFont, scratch, step );

    return;
    }


void appDrawDrawSymbol(		AppDrawingData *	add,
				int			x,
				int			y,
				int			symbol )
    {
    int				step;
    char			scratch[10];

    step= uniPutUtf8( (unsigned char *)scratch, symbol );
    if  ( step < 1 )
	{ return;	}
    scratch[step]= '\0';

    appDrawDrawString( add, x, y, scratch, step );

    return;
    }

/************************************************************************/
/*									*/
/*  Initialise drawing data.						*/
/*									*/
/************************************************************************/

void appInitDrawingData(	AppDrawingData *	add )
    {
    add->addForScreenDrawing= 0;
    add->addColors= (AppColors *)0;

    geoInitRectangle( &(add->addBackRect) );
    geoInitRectangle( &(add->addPaperRect) );
    geoInitRectangle( &(add->addDocRect) );

    add->addBottomMarginPixels= 0;
    add->addPageGapPixels= 0;
    add->addPageStepPixels= 0;

    add->addMagnification= 1.0;
    add->addMagnifiedPixelsPerTwip= 0.0;
    add->addScreenPixelsPerMM= 0.0;

#   ifdef USE_GTK
    add->addDrawable= (GdkWindow *)0;
    add->addGc= (GdkGC *)0;
#   endif

#   ifdef USE_MOTIF
    add->addDisplay= (Display *)0;
    add->addDrawable= None;
    add->addGc= None;
    add->addScreen= -1;
#   endif

#   ifdef USE_XFT
    appInitDrawingDataXft( add );
#   endif

    add->addPostScriptFontList= (const PostScriptFontList *)0;
    add->addAvoidFontconfig= 0;
    appDrawStartScreenFontList( add );
    add->addCurrentScreenFontNumber= -1;
    }

/************************************************************************/
/*									*/
/*  Remember PostScriptFontList.					*/
/*									*/
/************************************************************************/

void appDrawSetPostScriptFontList(	AppDrawingData *		add,
					const PostScriptFontList *	psfl )
    {
    add->addPostScriptFontList= psfl;

    if  ( psfl )
	{ add->addAvoidFontconfig= psfl->psflAvoidFontconfig;	}
    else{ add->addAvoidFontconfig= 0;				}
    }

/************************************************************************/
/*									*/
/*  Cause subsequent drawing to be done in a certain color.		*/
/*									*/
/************************************************************************/

void appDrawSetForegroundColorRgb8(	AppDrawingData *	add,
					const RGB8Color *	rgb8 )
    {
    APP_COLOR_RGB		xc;

    if  ( appColorRgb( &xc, add->addColors,
				    rgb8->rgb8Red,
				    rgb8->rgb8Green,
				    rgb8->rgb8Blue ) )
	{ LDEB(1); return;	}

    appDrawSetForegroundColor( add, &xc );

    return;
    }

