/************************************************************************/
/*									*/
/*  Rulers, Ted specific functionality.					*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appFrame.h>
#   include	<appMetricRuler.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Draw a selection rectangle over the document. Strictly spoken this	*/
/*  has nothing to do with metric rulers as drawing is done on the	*/
/*  document widget.							*/
/*									*/
/************************************************************************/

void appDrawRectangleSelection(	DocumentRectangle *	drClip,
				DocumentRectangle *	drSelected,
				AppDrawingData *	add,
				AppColors *		ac,
				int			ox,
				int			oy )
    {
    if  ( drSelected->drX0 < 0	&&
	  drSelected->drX1 < 0	&&
	  drSelected->drY0 < 0	&&
	  drSelected->drY1 < 0	)
	{ return;	}

    appDrawSetForegroundBlack( add );

    if  ( drSelected->drX0 >= 0 )
	{
	appDrawFillRectangle( add,
			drSelected->drX0- ox- 1,
			add->addBackRect.drY0- oy,
			1,
			add->addBackRect.drY1- add->addBackRect.drY0 );
	}

    if  ( drSelected->drX1 >= 0 )
	{
	appDrawFillRectangle( add,
			drSelected->drX1- ox,
			add->addBackRect.drY0- oy,
			1,
			add->addBackRect.drY1- add->addBackRect.drY0 );
	}

    if  ( drSelected->drY0 >= 0 )
	{
	appDrawFillRectangle( add,
			add->addBackRect.drX0- ox,
			drSelected->drY0- oy- 1,
			add->addBackRect.drX1- add->addBackRect.drX0,
			1 );
	}

    if  ( drSelected->drY1 >= 0 )
	{
	appDrawFillRectangle( add,
			add->addBackRect.drX0- ox,
			drSelected->drY1- oy,
			add->addBackRect.drX1- add->addBackRect.drX0,
			1 );
	}

    appDrawSetForegroundWhite( add );

    if  ( drSelected->drX0 >= 0 )
	{
	appDrawFillRectangle( add,
			drSelected->drX0- ox- 2,
			add->addBackRect.drY0- oy,
			1,
			add->addBackRect.drY1- add->addBackRect.drY0 );
	}

    if  ( drSelected->drX1 >= 0 )
	{
	appDrawFillRectangle( add,
			drSelected->drX1- ox+ 1,
			add->addBackRect.drY0- oy,
			1,
			add->addBackRect.drY1- add->addBackRect.drY0 );
	}

    if  ( drSelected->drY0 >= 0 )
	{
	appDrawFillRectangle( add,
			add->addBackRect.drX0- ox,
			drSelected->drY0- oy- 2,
			add->addBackRect.drX1- add->addBackRect.drX0,
			1 );
	}

    if  ( drSelected->drY1 >= 0 )
	{
	appDrawFillRectangle( add,
			add->addBackRect.drX0- ox,
			drSelected->drY1+ 1- oy,
			add->addBackRect.drX1- add->addBackRect.drX0,
			1 );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Remove the rectangle selection and redraw the appropriate		*/
/*  rectangles.								*/
/*									*/
/************************************************************************/

static void appMetricRulerExposeX0(
				const DocumentRectangle *	drVisible,
				int				x0,
				AppDrawingData *		add )
    {
    int			ox= drVisible->drX0;
    int			high= drVisible->drY1- drVisible->drY0;

    DocumentRectangle	drExpose;

    drExpose.drX0= x0- ox- 2;
    drExpose.drX1= x0+ 1;
    drExpose.drY0= 0;
    drExpose.drY1= high- 1;

    appExposeRectangle( add, &drExpose );
    }

static void appMetricRulerExposeY0(
				const DocumentRectangle *	drVisible,
				int				y0,
				AppDrawingData *		add )
    {
    int			oy= drVisible->drY0;
    int			wide= drVisible->drX1- drVisible->drX0;

    DocumentRectangle	drExpose;

    drExpose.drX0= 0;
    drExpose.drX1= wide- 1;
    drExpose.drY0= y0- oy- 2;
    drExpose.drY1= y0+ 1;

    appExposeRectangle( add, &drExpose );
    }

static void appMetricRulerExposeX1(
				const DocumentRectangle *	drVisible,
				int				x1,
				AppDrawingData *		add )
    {
    int			ox= drVisible->drX0;
    int			high= drVisible->drY1- drVisible->drY0;

    DocumentRectangle	drExpose;

    drExpose.drX0= x1- ox;
    drExpose.drX1= x1+ 1;
    drExpose.drY0= 0;
    drExpose.drY1= high- 1;

    appExposeRectangle( add, &drExpose );
    }

static void appMetricRulerExposeY1(
				const DocumentRectangle *	drVisible,
				int				y1,
				AppDrawingData *		add )
    {
    int			oy= drVisible->drY0;
    int			wide= drVisible->drX1- drVisible->drX0;

    DocumentRectangle	drExpose;

    drExpose.drX0= 0;
    drExpose.drX1= wide- 1;
    drExpose.drY0= y1- oy;
    drExpose.drY1= y1+ 1;

    appExposeRectangle( add, &drExpose );
    }

void appRemoveRectangleSelection( const DocumentRectangle *	drVisible,
				DocumentRectangle *		drSelected,
				AppDrawingData *		add )
    {
    if  ( drSelected->drX0 >= 0 )
	{
	appMetricRulerExposeX0( drVisible, drSelected->drX0, add );
	drSelected->drX0= -1;
	}

    if  ( drSelected->drX1 >= 0 )
	{
	appMetricRulerExposeX1( drVisible, drSelected->drX1, add );
	drSelected->drX1= -1;
	}

    if  ( drSelected->drY0 >= 0 )
	{
	appMetricRulerExposeY0( drVisible, drSelected->drY0, add );
	drSelected->drY0= -1;
	}

    if  ( drSelected->drY1 >= 0 )
	{
	appMetricRulerExposeY1( drVisible, drSelected->drY1, add );
	drSelected->drY1= -1;
	}

    return;
    }

void appSetHorRectangleSelection( DocumentRectangle *	drVisible,
				DocumentRectangle *	drSelected,
				int			x0Screen,
				int			x1Screen,
				AppDrawingData *	add )
    {
    if  ( drSelected->drX0 != x0Screen )
	{
	if  ( drSelected->drX0 >= 0 )
	    {
	    appMetricRulerExposeX0( drVisible, drSelected->drX0, add );
	    }

	if  ( x0Screen >= 0 )
	    {
	    appMetricRulerExposeX0( drVisible, x0Screen, add );
	    }

	drSelected->drX0= x0Screen;
	}

    if  ( drSelected->drX1 != x1Screen )
	{
	if  ( drSelected->drX1 >= 0 )
	    {
	    appMetricRulerExposeX1( drVisible, drSelected->drX1, add );
	    }

	if  ( x1Screen >= 0 )
	    {
	    appMetricRulerExposeX1( drVisible, x1Screen, add );
	    }

	drSelected->drX1= x1Screen;
	}

    return;
    }


void appSetVertRectangleSelection( DocumentRectangle *	drVisible,
				DocumentRectangle *	drSelected,
				int			y0Screen,
				int			y1Screen,
				AppDrawingData *	add )
    {
    if  ( drSelected->drY0 != y0Screen )
	{
	if  ( drSelected->drY0 >= 0 )
	    {
	    appMetricRulerExposeY0( drVisible, drSelected->drY0, add );
	    }

	if  ( y0Screen >= 0 )
	    {
	    appMetricRulerExposeY0( drVisible, y0Screen, add );
	    }

	drSelected->drY0= y0Screen;
	}

    if  ( drSelected->drY1 != y1Screen )
	{
	if  ( drSelected->drY1 >= 0 )
	    {
	    appMetricRulerExposeY1( drVisible, drSelected->drY1, add );
	    }

	if  ( y1Screen >= 0 )
	    {
	    appMetricRulerExposeY1( drVisible, y1Screen, add );
	    }

	drSelected->drY1= y1Screen;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Make the ruler administration for the top ruler widget of a		*/
/*  document.								*/
/*									*/
/************************************************************************/

void appDocSetMetricTopRuler(	EditDocument *		ed,
				int			topRulerHeight,
				double			magnification,
				int			unitInt,
				APP_EVENT_HANDLER_T	mouseDown )
    {
    EditApplication *		ea= ed->edApplication;
    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);

    ed->edTopRuler= appMakeMetricRuler(

		    topRulerHeight,		/*  sizeAcross		*/
		    add->addMagnifiedPixelsPerTwip,
		    magnification,		/*  magnification	*/

		    ed->edLeftRulerWidePixels,	/*  minUnused		*/
		    ed->edRightRulerWidePixels,/*  maxUnused		*/

		    add->addDocRect.drX0,	/*  documentC0		*/
		    add->addDocRect.drX1,	/*  documentC1		*/
		    ed->edVisibleRect.drX0,	/*  visisbleC0		*/
		    ed->edVisibleRect.drX1,	/*  visisbleC1		*/
		    add->addPaperRect.drX1,	/*  rulerC1		*/

		    ea->eaRulerFont,
		    unitInt );			/*  whatUnit		*/

    appDrawSetConfigureHandler( ed->edTopRulerWidget,
			appHorizontalRulerConfigure, (void *)ed->edTopRuler );

    appDrawSetRedrawHandler( ed->edTopRulerWidget,
		    appRedrawHorizontalMetricRuler, (void *)ed->edTopRuler );

    appDrawSetButtonPressHandler( ed->edTopRulerWidget,
						mouseDown, (void *)ed );
#   ifdef USE_GTK
    gtk_widget_add_events( ed->edTopRulerWidget, GDK_POINTER_MOTION_MASK );
#   endif

    return;
    }

/************************************************************************/
/*									*/
/*  Make the ruler administration for the left ruler widget of a	*/
/*  document.								*/
/*									*/
/************************************************************************/

void appDocSetMetricLeftRuler(	EditDocument *		ed,
				int			leftRulerWidth,
				double			magnification,
				int			unitInt,
				APP_EVENT_HANDLER_T	mouseDown )
    {
    EditApplication *		ea= ed->edApplication;
    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);

    ed->edLeftRuler= appMakeMetricRuler(
		    leftRulerWidth,		/*  sizeAcross		*/
		    add->addMagnifiedPixelsPerTwip,
		    magnification,		/*  magnification	*/

		    0, 0,			/*  {min,max}Unused	*/

		    add->addDocRect.drY0,	/*  documentC0		*/
		    add->addDocRect.drY1,	/*  documentC1		*/
		    ed->edVisibleRect.drY0,	/*  visisbleC0		*/
		    ed->edVisibleRect.drY1,	/*  visisbleC1		*/
		    add->addPaperRect.drY1,	/*  rulerC1		*/

		    ea->eaRulerFont,
		    unitInt );			/*  whatUnit		*/

    appDrawSetConfigureHandler( ed->edLeftRulerWidget,
			appVerticalRulerConfigure, (void *)ed->edLeftRuler );

    appDrawSetRedrawHandler( ed->edLeftRulerWidget,
			    appRedrawVerticalMetricRuler, ed->edLeftRuler );

    appDrawSetButtonPressHandler( ed->edLeftRulerWidget,
						    mouseDown, (void *)ed );
#   ifdef USE_GTK
    gtk_widget_add_events( ed->edTopRulerWidget, GDK_POINTER_MOTION_MASK );
#   endif

    return;
    }
