#   include	"appFrameConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>

#   include	"appFrame.h"
#   include	"appSystem.h"
#   include	<geoString.h>

#   include	<appDebugon.h>

#   ifdef USE_MOTIF

#   include	<X11/Xatom.h>
#   include	<Xm/RowColumn.h>
#   include	<Xm/PushB.h>
#   include	<Xm/PushBG.h>
#   include	<Xm/Form.h>
#   include	<Xm/Label.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/PanedW.h>
#   include	<Xm/MwmUtil.h>
#   include	<Xm/Protocols.h>
#   include	<Xm/DialogS.h>
#   include	<Xm/DrawnB.h>
#   include	<Xm/Separator.h>
#   include	<Xm/List.h>
#   include	<Xm/ScrollBar.h>
#   include	<Xm/SashP.h>
#   include	<Xm/DrawingA.h>

/************************************************************************/
/*									*/
/*  Make the initial connection to the gui environment.			*/
/*									*/
/************************************************************************/

static int appXErrorHandler( Display * display, XErrorEvent * ev )
    {
    char	text[250+1];
    static int	count= 0;

    XGetErrorText( display, ev->error_code, text, sizeof(text)- 1 );

    appDebug( "%3d: %s\n", count, text );

    if  ( count++ >= 100 )
	{ LDEB(count); abort(); }

    return 0;
    }

int appGuiInitApplication(	EditApplication *	ea,
				int *			pArgc,
				char ***		pArgv )
    {
    int			argc= *pArgc;
    char **		argv= *pArgv;

    MwmHints		hints;

    Arg			al[20];
    int			ac= 0;

#   ifndef USE_X11_R5
    char *		cloneCommand[2];
#   endif

    if  ( ! XSupportsLocale() )
	{ SLDEB(getenv("LANG"),XSupportsLocale()); }

    /*  1  */
    hints.flags= MWM_HINTS_FUNCTIONS|MWM_HINTS_DECORATIONS;
    hints.functions=	MWM_FUNC_MOVE		|
			MWM_FUNC_MINIMIZE	|
			MWM_FUNC_CLOSE		;
    hints.decorations=	MWM_DECOR_BORDER	|
			MWM_DECOR_TITLE		|
			MWM_DECOR_MENU		|
			MWM_DECOR_MINIMIZE	;
    ac= 0;
    XtSetArg( al[ac], XmNinput,			True ); ac++;
    XtSetArg( al[ac], XmNallowShellResize,	True ); ac++;
    XtSetArg( al[ac], XmNuseAsyncGeometry,	True ); ac++;
    XtSetArg( al[ac], XmNwaitForWm,		False ); ac++; /* LessTif BUG */
    XtSetArg( al[ac], XmNwmTimeout,		0 ); ac++; /* LessTif BUG */
    XtSetArg( al[ac], XmNmwmDecorations,	hints.decorations ); ac++;
    XtSetArg( al[ac], XmNmwmFunctions,		hints.functions ); ac++;

#   ifdef USE_X11_R5
    /* applicationShellWidgetClass, */
    ea->eaToplevel.atTopWidget= XtAppInitialize( &(ea->eaContext),
					ea->eaApplicationName,
					NULL, 0, &argc, argv, NULL, al, ac );
#   else
    cloneCommand[0]= argv[0];
    cloneCommand[1]= (char *)0;
    XtSetArg( al[ac], XtNcloneCommand,		cloneCommand ); ac++;

    ea->eaToplevel.atTopWidget= XtOpenApplication( &(ea->eaContext),
					ea->eaApplicationName,
					NULL, 0, &argc, argv, NULL,
					sessionShellWidgetClass,
					al, ac );
#   endif

    /*  2  */
    ea->eaScreenPixelsWide=
		    DisplayWidth( XtDisplay( ea->eaToplevel.atTopWidget ),
		    DefaultScreen( XtDisplay( ea->eaToplevel.atTopWidget ) ) );
    ea->eaScreenPixelsHigh=
		    DisplayHeight( XtDisplay( ea->eaToplevel.atTopWidget ),
		    DefaultScreen( XtDisplay( ea->eaToplevel.atTopWidget ) ) );

    ea->eaInputMethod= XOpenIM( XtDisplay( ea->eaToplevel.atTopWidget ),
							NULL, NULL, NULL );
    ea->eaDocumentCursor= (Cursor)0;

    /*  3  */
    ea->eaCloseAtom= XmInternAtom( XtDisplay( ea->eaToplevel.atTopWidget ),
					(char *)"WM_DELETE_WINDOW", False );

    ea->eaArgc= argc;
    ea->eaArgv= argv;

    appSetCloseCallback( ea->eaToplevel.atTopWidget, ea,
						appAppWmClose, (void *)ea );

    XtRealizeWidget( ea->eaToplevel.atTopWidget );

    *pArgc= argc;
    *pArgv= argv;

    if  ( getenv( "CATCH_X_ERRORS" ) )
	{ XSetErrorHandler( appXErrorHandler );	}

    return 0;
    }

#   endif
