/************************************************************************/
/*									*/
/*  Ted: Interface to the generic symbol picker.			*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"
#   include	<appSymbolPicker.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Switch to the symbol page of the inspector.				*/
/*									*/
/************************************************************************/

void tedFormatShowSymbolPage(	EditApplication *	ea )
    {
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    if  ( ! tar->tarInspector )
	{ XDEB(tar->tarInspector); return;	}

    appEnableInspectorSubject( tar->tarInspector, TEDtsiSYMBOL, 1 );

    appInspectorSelectSubject( tar->tarInspector, TEDtsiSYMBOL );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt fonts tool to the current document.				*/
/*									*/
/************************************************************************/

void tedRefreshSymbolPicker(	SymbolPicker *			sp,
				int *				pEnabled,
				int *				pPref,
				InspectorSubject *		is,
				const DocumentSelection *	ds,
				const SelectionDescription *	sd,
				const BufferDocument *		bd,
				int				documentId )
    {
    const DocumentProperties *	dp= &(bd->bdProperties);
    const DocumentFontList *	dfl= &(dp->dpFontList);

    if  ( appAdaptSymbolPickerToFontFamily( sp, documentId, dfl,
			&(sd->sdTextAttribute), &(sd->sdTextAttributeMask) ) )
	{ LDEB(1);	}

    *pEnabled= sd->sdCanReplace;
    return;
    }

/************************************************************************/
/*									*/
/*  Insert callback for the symbol picker.				*/
/*									*/
/************************************************************************/

void tedSymbolPickerInsert(	void *			voidea,
				const char *		bytes,
				int			size,
				const TextAttribute *	taSet,
				const PropertyMask *	taSetMask )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedDocInsertStringWithAttribute( ed, bytes, size, taSet, taSetMask );

    return;
    }

