/************************************************************************/
/*									*/
/*  Definitions relating to rulers.					*/
/*									*/
/************************************************************************/

#   include	<appUnit.h>

#   include	<appFrame.h>
#   include	<appRuler.h>

#   include	<docBuf.h>

typedef struct ColumnSeparator
    {
    int		csX0;
    int		csX1;
    } ColumnSeparator;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void * tedMakeTopRuler(	int			height,
				double			magnifiedPixelsPerTwip,
				double			magnification,

				int			leftRulerWidth,
				int			rightRulerWidth,
				int			docX0,
				int			docX1,

				int			minVisible,
				int			maxVisible,
				int			rulerC1,

				const char *		rulerFont,
				int			whatUnit );

extern void * tedMakeBottomRuler( int			height,
				int			leftRulerWidth,
				int			rightRulerWidth,
				const char *		rulerFont,
				const char *		pageFormat );

extern void tedFreeTopRuler(	void *		voidttr );
extern void tedFreeBottomRuler(	void *		voidtlr );

extern APP_EVENT_HANDLER_H( tedRedrawTopRuler, w, voidttr, event );
extern APP_EVENT_HANDLER_H( tedRedrawBottomRuler, w, voidtlr, event );

extern void tedScrollTopRuler(	void *			voidttr,
					APP_WIDGET		w,
					int			d	);

extern void tedSetTopRulerRange(	void *		voidttr,
					APP_WIDGET	w,
					int		docVisX0,
					int		docVisX1,
					int		docBackX1 );

extern void tedAdaptTopRuler(	void *			voidttr,
					APP_WIDGET		w,
					int			docX0,
					int			docX1,
					int			firstIndent,
					int			leftIndent,
					int			rightIndent,
					int			rulerC1,
					const TabStopList *	tslSet );

extern void tedTopRulerTrackMouse( int *			pFirstIndent,
					int *			pLeftIndent,
					int *			pRightIndent,
					TabStopList *		tsl,
					int *			pCsCount,
					ColumnSeparator **	pCs,
					int *			pProperty,
					APP_WIDGET		w,
					EditApplication *	ea,
					APP_EVENT *		downEvent,
					void *			voidttr,
					EditDocument *		ed );

extern APP_EVENT_HANDLER_H( tedTopRulerConfigure, w, voidttr, event );
extern APP_EVENT_HANDLER_H( tedBottomRulerConfigure, w, voidtlr, event );

extern int tedSetRulerColumns(	APP_WIDGET		w,
				void *			voidttr,
				int			bfX0Pixels,
				int			bfX1Pixels,
				int			pfX0Pixels,
				int			pfX1Pixels,
				ColumnSeparator *	cs,
				int			csCount );

extern void tedSetBottomRulerValues(
				void *			voidtbr,
				int			page,
				int			pages,
				int			section,
				int			sections );

