#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   include	"tedRuler.h"
#   include	<appMetricRuler.h>
#   include	<appFrame.h>

#   include	<appDebugon.h>

#   define	BACK_MARG(s)	((s)/3)
#   define	WHITE_TOP(s)	BACK_MARG(s)
#   define	WHITE_BOTTOM(s)	((s)-BACK_MARG(s))
#   define	WHITE_HEIGHT(s)	(WHITE_BOTTOM(s)-WHITE_TOP(s))

#   define	TAG_DIST(s)	1
#   define	TAG_TOP(s)	(WHITE_TOP(s)+TAG_DIST(s))
#   define	TAG_BOTTOM(s)	(WHITE_BOTTOM(s)-TAG_DIST(s))
#   define	TAG_HEIGHT(s)	(TAG_BOTTOM(s)-TAG_TOP(s))

#   define	FONT_HEIGHT(s)	(WHITE_HEIGHT(s)-2)
#   define	FONT_BOTTOM(s)	(TAG_BOTTOM(s)-1)

#   define	TICK_DIST(s)	((s)/12)
#   define	TICK_TOP(s)	(WHITE_TOP(s)+TICK_DIST(s))
#   define	TICK_BOTTOM(s)	(WHITE_BOTTOM(s)-TICK_DIST(s))
#   define	TICK_HEIGHT(s)	(TICK_BOTTOM(s)-TICK_TOP(s))

#   define	BUTTON_MARG		1

#   define	BUTTON_DIST(s)		(((s)/6)-1)
#   define	BUTTON_RECTH(s)		((s)/6)
#   define	BUTTON_TRIH(s)		((s)/6)
#   define	BUTTON_HWIDTH(s)	((s)/6)


#   define	HBUTTON_BASE(s)		BUTTON_DIST(s)
#   define	HBUTTON_APEX(s)		(HBUTTON_BASE(s)+ \
					    BUTTON_RECTH(s)+BUTTON_TRIH(s))

#   define	SBUTTON_BASE(s)		((s)-BUTTON_DIST(s))
#   define	SBUTTON_APEX(s)		(SBUTTON_BASE(s)- \
					    BUTTON_RECTH(s)-BUTTON_TRIH(s))

#   define	BUTTON_LEFT(v,s)	((v)-BUTTON_HWIDTH((s))-BUTTON_MARG)
#   define	BUTTON_RIGHT(v,s)	((v)+BUTTON_HWIDTH((s))+BUTTON_MARG)

#   define	TAB_HEIGHT(s)		((s)/6)
#   define	TAB_TOP(s)		(WHITE_BOTTOM(s)-TAB_HEIGHT(s))
#   define	TAB_WIDTH(s)		((s)/6)
#   define	TAB_THICK(s)		3

typedef struct TedTopRuler
    {
    RulerData		ttrRulerData;
    double		ttrMagnification;
					/********************************/
					/*  Describe an area that is	*/
					/*  not to be used.		*/
					/********************************/
    int			ttlBlockFrameX0;
    int			ttlBlockFrameX1;
    int			ttlParaFrameX0;
    int			ttlParaFrameX1;
					/********************************/
					/*  Describe the area that is	*/
					/*  accessible as values.	*/
					/********************************/

    int			ttrFirstIndent;		/*  pixels		*/
    int			ttrLeftIndent;		/*  pixels		*/
    int			ttrRightIndent;		/*  pixels		*/

    TabStopList		ttrTabStopList;
    int			ttrTabKind;		/************************/
						/*  alignment for fresh	*/
						/*  tabs.		*/
						/************************/
    int			ttrColumnCount;
    ColumnSeparator *	ttrColumns;
    } TedTopRuler;

typedef struct TopRulerDrag
    {
    int			trdValue;
    int *		trdV0Pointer;
    int *		trdV1Pointer;
    int *		trdYPointer;
    int *		trdChangedPointer;
    TedTopRuler *	trdTtr;
    APP_WIDGET		trdWidget;
    int			trdOc;
    int			trdXmin;
    int			trdXmax;
    EditDocument *	trdDocument;
    } TopRulerDrag;

/************************************************************************/
/*									*/
/*  Make the top ruler for a document widget.				*/
/*									*/
/************************************************************************/

void * tedMakeTopRuler(	int			height,
			double			magnifiedPixelsPerTwip,
			double			magnification,

			int			leftRulerWidth,
			int			rightRulerWidth,

			int			documentC0,
			int			documentC1,
			int			visibleC0,
			int			visibleC1,
			int			rulerC1,

			const char *		fontName,
			int			whatUnit )
    {
    TedTopRuler *		ttr;
    RulerData *			rd;

    ttr= (TedTopRuler *)malloc( sizeof( TedTopRuler ) );
    if  ( ! ttr )
	{ XDEB(ttr); return (void *)0;	}
    rd= &(ttr->ttrRulerData);

    appInitRulerData( rd );

    rd->rdUnit= whatUnit;
    rd->rdFontName= fontName;

    appRulerCalculateIncrements( rd, magnifiedPixelsPerTwip, magnification );

    rd->rdMinUsed= leftRulerWidth;
    rd->rdMaxUsed= 0;
    rd->rdExtraAfterMaxUsed= rightRulerWidth;

    rd->rdDocumentC0= documentC0;
    rd->rdDocumentC1= documentC1;
    rd->rdVisibleC0= visibleC0;
    rd->rdVisibleC1= visibleC1;
    rd->rdRulerC1= rulerC1;

    ttr->ttrMagnification= magnification;

    ttr->ttlBlockFrameX0= documentC0;
    ttr->ttlBlockFrameX1= documentC1;
    ttr->ttlParaFrameX0= documentC0;
    ttr->ttlParaFrameX1= documentC1;

    rd->rdSizeAcross= height;
    rd->rdSizeAlong= 0;

    docInitTabStopList( &(ttr->ttrTabStopList) );
    ttr->ttrTabKind= DOCtaLEFT;

    ttr->ttrColumnCount= 0;
    ttr->ttrColumns= (ColumnSeparator *)0;

    ttr->ttrFirstIndent= -1;
    ttr->ttrLeftIndent= -1;
    ttr->ttrRightIndent= -1;

    return (void *)ttr;
    }

void tedFreeTopRuler(	void *		voidttr )
    {
    TedTopRuler *		ttr= (TedTopRuler *)voidttr;

    docCleanTabStopList( &(ttr->ttrTabStopList) );

    appCleanRulerData( &(ttr->ttrRulerData) );

    free( ttr );

    return;
    }

/************************************************************************/
/*									*/
/*  Draw the little button for the 'First Indent' of a paragraph	*/
/*									*/
/*	       v							*/
/*	4 ---- . ---- 0 = 5						*/
/*	|      .      |							*/
/*	|      .      |							*/
/*	3      .      1							*/
/*	 \     .     / 							*/
/*	  \    .    /  							*/
/*	   \   .   /   							*/
/*	    \  .  /    							*/
/*	     \ . /     							*/
/*	       2       							*/
/*									*/
/************************************************************************/

static void tedHangingButtonRect(	DocumentRectangle *	drButton,
					int			value,
					int			sizeAcross )
    {
    drButton->drX0= value- BUTTON_HWIDTH(sizeAcross)- 1;
    drButton->drX1= value+ BUTTON_HWIDTH(sizeAcross)+ 1;

    drButton->drY0= BUTTON_HWIDTH(sizeAcross)- 1;
    drButton->drY1= HBUTTON_APEX(sizeAcross)+ 1;

    return;
    }

static void tedRulerDrawHangingButton(	int			value,
					int			ox,
					int			sizeAcross,
					APP_BITMAP_MASK		stipple,
					AppDrawingData *	add )
    {
    APP_POINT	points[6];
    int		w= BUTTON_MARG;

    value -= ox;

    points[0].x= value+ BUTTON_HWIDTH(sizeAcross);
    points[0].y= HBUTTON_BASE(sizeAcross);

    points[1].x= points[0].x;
    points[1].y= HBUTTON_BASE(sizeAcross)+ BUTTON_RECTH(sizeAcross);

    points[2].x= value;
    points[2].y= HBUTTON_APEX(sizeAcross);

    points[3].x= value- BUTTON_HWIDTH(sizeAcross);
    points[3].y= points[1].y;

    points[4].x= points[3].x;
    points[4].y= points[0].y;

    points[5]= points[0];

    appDrawSetForegroundColor( add, &(add->addBackColor) );

#   ifdef USE_MOTIF
    if  ( stipple )
	{ XSetFillStyle( add->addDisplay, add->addGc, FillStippled ); }
#   endif

    appDrawFillPolygon( add, points, 6 );

#   ifdef USE_MOTIF
    if  ( stipple )
	{ XSetFillStyle( add->addDisplay, add->addGc, FillSolid ); }
#   endif

    appDrawSetForegroundColor( add, &(add->addForeColor) );
    appDrawDrawLines( add, points, 6, 0 );

    if  ( ! stipple )
	{
	points[0].x -= w; points[0].y += (w+1)/2;
	points[1].x -= w;
	points[2].y -= w;
	points[3].x += w;
	points[4].x += w; points[4].y += w;
	points[5].x -= w; points[5].y += w;

	appDrawSetForegroundColor( add, &(add->addBottomColor) );
	appDrawDrawLines( add, points, 4, 0 );
	appDrawSetForegroundColor( add, &(add->addTopColor) );
	appDrawDrawLines( add, points+ 3, 3, 0 );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Draw the little buttons for the 'Left, Right Indent' of a paragraph	*/
/*									*/
/*	       3   							*/
/*	     / . \     							*/
/*	    /  .  \    							*/
/*	   /   .   \   							*/
/*	  /    .    \  							*/
/*	 /     .     \ 							*/
/*	4      .      2							*/
/*	|      .      |							*/
/*	|      .      |							*/
/*  5 = 0 ---- . ---- 1							*/
/*	       v							*/
/*									*/
/************************************************************************/

static void tedStandingButtonRect(	DocumentRectangle *	drButton,
					int			value,
					int			sizeAcross )
    {
    drButton->drX0= value- BUTTON_HWIDTH(sizeAcross)- 1;
    drButton->drX1= value+ BUTTON_HWIDTH(sizeAcross)+ 1;

    drButton->drY0= SBUTTON_APEX(sizeAcross)- 1;
    drButton->drY1= SBUTTON_BASE(sizeAcross)+ 1;

    return;
    }

static void tedRulerDrawStandingButton(	int			value,
					int			ox,
					int			sizeAcross,
					APP_BITMAP_MASK		stipple,
					AppDrawingData *	add )
    {
    APP_POINT	points[6];
    int		w= BUTTON_MARG;

    value -= ox;

    points[0].x= value- BUTTON_HWIDTH(sizeAcross);
    points[0].y= SBUTTON_BASE(sizeAcross);

    points[1].x= value+ BUTTON_HWIDTH(sizeAcross);
    points[1].y= points[0].y;

    points[2].x= points[1].x;
    points[2].y= SBUTTON_BASE(sizeAcross)- BUTTON_RECTH(sizeAcross);

    points[3].x= value;
    points[3].y= SBUTTON_APEX(sizeAcross);

    points[4].x= points[0].x;
    points[4].y= points[2].y;

    points[5]= points[0];

    appDrawSetForegroundColor( add, &(add->addBackColor) );

#   ifdef USE_MOTIF
    if  ( stipple )
	{ XSetFillStyle( add->addDisplay, add->addGc, FillStippled ); }
#   endif

    appDrawFillPolygon( add, points, 6 );

#   ifdef USE_MOTIF
    if  ( stipple )
	{ XSetFillStyle( add->addDisplay, add->addGc, FillSolid ); }
#   endif

    appDrawSetForegroundColor( add, &(add->addForeColor) );
    appDrawDrawLines( add, points, 6, 0 );

    if  ( ! stipple )
	{
	points[0].x += (w+1)/2; points[0].y -= w;
	points[1].x -= w; points[1].y -= w;
	points[2].x -= w;
	points[3].y += (w+1)/2;
	points[4].x += w;
	points[5].x += w; points[5].y -= w;

	appDrawSetForegroundColor( add, &(add->addBottomColor) );
	appDrawDrawLines( add, points, 4, 0 );
	appDrawSetForegroundColor( add, &(add->addTopColor) );
	appDrawDrawLines( add, points+ 3, 3, 0 );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Draw the little holes for the table columns on the ruler.		*/
/*									*/
/*	3-------------2							*/
/*	|      .      |							*/
/*	|      .      |							*/
/*	|      .      |							*/
/*	|      .      |							*/
/*	|      .      |							*/
/*  4 = 0 ---- . ---- 1							*/
/*	       v							*/
/*									*/
/************************************************************************/

static void tedRulerColumnControlRect(	DocumentRectangle *	drButton,
					int			x0,
					int			x1,
					int			sizeAcross )
    {
    if  ( x1- x0 < BUTTON_HWIDTH( sizeAcross ) )
	{
	int	m= ( x1+ x0 )/ 2;

	x0= m- BUTTON_HWIDTH( sizeAcross )/2;
	x1= m+ BUTTON_HWIDTH( sizeAcross )/2;
	}

    drButton->drX0= x0- 1;
    drButton->drX1= x1+ 1;

    drButton->drY0= WHITE_TOP(sizeAcross)- 1;
    drButton->drY1= WHITE_BOTTOM(sizeAcross)+ 1;

    return;
    }

static void tedRulerDrawColumnControl(	int			x0,
					int			x1,
					int			ox,
					int			sizeAcross,
					APP_BITMAP_MASK		stipple,
					AppDrawingData *	add )
    {
    APP_POINT	points[5];
    int		w= BUTTON_MARG;

    x0 -= ox;
    x1 -= ox;

    if  ( x1- x0 < BUTTON_HWIDTH( sizeAcross ) )
	{
	int	m= ( x1+ x0 )/ 2;

	x0= m- BUTTON_HWIDTH( sizeAcross )/2;
	x1= m+ BUTTON_HWIDTH( sizeAcross )/2;
	}

    points[0].x= x0;
    points[0].y= WHITE_BOTTOM(sizeAcross);

    points[1].x= x1;
    points[1].y= points[0].y;

    points[2].x= points[1].x;
    points[2].y= WHITE_TOP(sizeAcross);

    points[3].x= points[0].x;
    points[3].y= points[2].y;

    points[4]= points[0];

    appDrawSetForegroundColor( add, &(add->addBackColor) );

#   ifdef USE_MOTIF
    if  ( stipple )
	{ XSetFillStyle( add->addDisplay, add->addGc, FillStippled ); }
#   endif

    appDrawFillPolygon( add, points, 5 );

#   ifdef USE_MOTIF
    if  ( stipple )
	{ XSetFillStyle( add->addDisplay, add->addGc, FillSolid ); }
#   endif

    appDrawSetForegroundColor( add, &(add->addForeColor) );
    appDrawDrawLines( add, points, 5, 0 );

    if  ( ! stipple )
	{
	points[0].x += w; points[0].y -= w;
	points[1].x -= w; points[1].y -= w;
	points[2].x -= w; points[2].y += w;
	points[3].x += w; points[3].y += w;
	points[4].x += w; points[4].y -= w;

	appDrawSetForegroundColor( add, &(add->addTopColor) );
	appDrawDrawLines( add, points, 3, 0 );
	appDrawSetForegroundColor( add, &(add->addBottomColor) );
	appDrawDrawLines( add, points+ 2, 2, 0 );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Draw a 'Tab' symbol.						*/
/*									*/
/************************************************************************/

static void tedTabSymbolRect(	DocumentRectangle *	drButton,
				int			x,
				int			y,
				int			sizeAcross )
    {
    int		thick= TAB_THICK(sizeAcross);
    int		tabWidth= TAB_WIDTH(sizeAcross);
    int		tabHeight= TAB_HEIGHT(sizeAcross);

    drButton->drX0= x+ (thick+1)/2- tabWidth;
    drButton->drX1= x- thick/2+ tabWidth;

    drButton->drY0= y- tabHeight- 1;
    drButton->drY1= y+ 1;

    return;
    }

static void tedDrawTabSymbol(	AppDrawingData *	add,
				int			x,
				int			ox,
				int			y,
				int			sizeAcross,
				int			kind )
    {
    int		thick= TAB_THICK(sizeAcross);
    int		tabWidth= TAB_WIDTH(sizeAcross);
    int		tabHeight= TAB_HEIGHT(sizeAcross);

    int		xx;

    x -= ox;

    /*  standing  */
    xx= x- thick/2;
    appDrawFillRectangle( add, xx, y- tabHeight, thick, tabHeight );

    if  ( kind == DOCtaLEFT		||
	  kind == DOCtaCENTER		||
	  kind == DOCtaDECIMAL		)
	{
	xx= x- thick/2;

	/*  laying right	*/
	appDrawFillRectangle( add, xx, y- thick, tabWidth, thick );
	}

    if  ( kind == DOCtaRIGHT		||
	  kind == DOCtaCENTER		||
	  kind == DOCtaDECIMAL		)
	{
	xx= x+ (thick+1)/2- tabWidth;

	/*  laying left	*/
	appDrawFillRectangle( add, xx, y- thick, tabWidth, thick );
	}

    if  ( kind == DOCtaDECIMAL	)
	{
	int	dec= ( thick+ 1 )/ 2;

	xx= x- thick/2+ tabWidth- dec;

	/*  dot right	*/
	appDrawFillRectangle( add, xx, y- tabHeight, dec, dec );
	}

    return;
    }

static void tedTabButtonRectangle(	DocumentRectangle *	drButton,
					int			x,
					int			y,
					int			sizeAcross )
    {
    tedTabSymbolRect( drButton, x, y, sizeAcross );

    drButton->drX0 -= 3;
    drButton->drX1 += 3;

    drButton->drY0 -= 5;
    drButton->drY1 += 0;

    return;
    }

static void tedDrawTabButton(	RulerData *	rd,
				int		x,
				int		y,
				int		sizeAcross,
				int		kind )
    {
    AppDrawingData *	add= &(rd->rdDrawingData);
    int			tw= TAB_WIDTH(sizeAcross);
    DocumentRectangle	dr;
    int			ox= 0;

    tedTabButtonRectangle( &dr, x, y, sizeAcross );


#   define xfr( x, y, w, h ) \
    appDrawFillRectangle( add, (x), (y), (w), (h) );

    /*  top, bottom */
    appDrawSetForegroundColor( add, &(add->addForeColor) );

    xfr(	dr.drX0,	dr.drY0,	dr.drX1- dr.drX0, 1 );
    xfr(	dr.drX0,	dr.drY1,	dr.drX1- dr.drX0, 1 );

    /*  left, right */
    xfr(	dr.drX0,	dr.drY0,	1, dr.drY1- dr.drY0+ 1 );
    xfr(	dr.drX1- 1,	dr.drY0,	1, dr.drY1- dr.drY0 );


    /*  top, left */
    appDrawSetForegroundColor( add, &(add->addTopColor) );

    xfr(	dr.drX0+ 1,	dr.drY0+ 1,	dr.drX1- dr.drX0- 2, 1 );
    xfr(	dr.drX0+ 1,	dr.drY0+ 1,	1, dr.drY1- dr.drY0- 1 );

    /*  bottom, right */
    appDrawSetForegroundColor( add, &(add->addBottomColor) );

    xfr(	dr.drX0+ 2,	dr.drY1- 1,	dr.drX1- dr.drX0- 3, 1 );
    xfr(	dr.drX1- 2,	dr.drY0+ 2,	1, dr.drY1- dr.drY0- 3 );

    appDrawSetForegroundColor( add, &(add->addForeColor) );

    tedDrawTabSymbol( add, x, ox, y- tw/2+ 1, sizeAcross, kind );
    }

/************************************************************************/
/*									*/
/*  Draw a horizontal ruler.						*/
/*									*/
/************************************************************************/

static void tedDrawTopRuler(	APP_WIDGET		w,
				TedTopRuler *		ttr,
				DocumentRectangle *	drClip,
				int			ox )
    {
    RulerData *		rd= &(ttr->ttrRulerData);
    AppDrawingData *	add= &(rd->rdDrawingData);
    int			sizeAcross= rd->rdSizeAcross;

    int			tick;
    double		units;

    int			tab;
    TabStop *		ts;

    int			whiteY= WHITE_TOP(sizeAcross);
    int			whiteH= WHITE_HEIGHT(sizeAcross);

    int			tagY= TAG_TOP(sizeAcross);
    int			tagH= TAG_HEIGHT(sizeAcross);

    int			tickY= TICK_TOP(sizeAcross);
    int			tickH= TICK_HEIGHT(sizeAcross);

    int			fontBottom= FONT_BOTTOM(sizeAcross);

    ColumnSeparator *	cs;

    DocumentRectangle	drWhite;
    DocumentRectangle	drButton;

    if  ( rd->rdSizeAlong == 0 )
	{
	int	high;

	appDrawGetSizeOfWidget( &(rd->rdSizeAlong), &high, w );

	rd->rdMaxUsed= rd->rdSizeAlong- rd->rdExtraAfterMaxUsed;
	}

    appRulerDrawBackground( &(ttr->ttrRulerData),
		    drClip->drX0- ox, drClip->drY0,
		    drClip->drX1- drClip->drX0, drClip->drY1- drClip->drY0 );

    drWhite.drX0= 0;
    drWhite.drX1= rd->rdRulerC1;
    drWhite.drY0= whiteY;
    drWhite.drY1= whiteY+ whiteH;

    if  ( geoIntersectRectangle( &drWhite, &drWhite, drClip ) )
	{
	int			x0= drWhite.drX0- ox;
	int			x1= drWhite.drX1- ox;

	appDrawSetForegroundWhite( add );

	if  ( x0 < rd->rdMinUsed )
	    { x0=  rd->rdMinUsed;	}
	if  ( x1 > rd->rdMaxUsed )
	    { x1=  rd->rdMaxUsed;	}

	appDrawFillRectangle( add,
		    x0, drWhite.drY0,
		    x1- x0+ 1, drWhite.drY1- drWhite.drY0 );
	}

    tedDrawTabButton( rd, rd->rdMinUsed, whiteY, sizeAcross, ttr->ttrTabKind );

    appDrawSetForegroundColor( add, &(add->addForeColor) );

    units= 0; tick= 0;
    for (;;)
	{
	int	twips= units* rd->rdTwipsPerUnit;
	int	iitem= rd->rdMagnifiedPixelsPerTwip* twips;

	if  ( iitem > rd->rdVisibleC1 )
	    { break;	}

	if  ( iitem < rd->rdVisibleC0 )
	    {
	    units += rd->rdUnitsPerTick; tick++;
	    continue;
	    }

	if  ( iitem != 0 && tick % rd->rdTicksPerText == 0 )
	    {
	    char	scratch[30];
	    int		len;
	    int		wide;

	    appRulerTagText( scratch, &wide, &len, rd, units );

	    if  ( iitem- ox- wide/2 >= rd->rdMinUsed	&&
		  iitem- ox+ wide/2 <  rd->rdMaxUsed	)
		{
		appDrawDrawString( add,
			    iitem- ox- wide/2, fontBottom, scratch, len );
		}
	    else{
		appDrawFillRectangle( add, iitem- ox, tagY, 1, tagH );
		}
	    }
	else{
	    if  ( tick % rd->rdTicksPerTag == 0 )
		{ appDrawFillRectangle( add, iitem- ox, tagY,  1, tagH );  }
	    else{ appDrawFillRectangle( add, iitem- ox, tickY, 1, tickH ); }
	    }

	units += rd->rdUnitsPerTick; tick++;
	continue;
	}

    cs= ttr->ttrColumns;
    for ( tab= 0; tab < ttr->ttrColumnCount; cs++, tab++ )
	{
	int	m= ( cs->csX0+ cs->csX1 )/ 2;

	if  ( m > rd->rdVisibleC1	||
	      m < rd->rdVisibleC0	)
	    { continue;	}

	tedRulerColumnControlRect( &drButton, cs->csX0, cs->csX1, sizeAcross );

	if  ( ! geoIntersectRectangle( &drButton, &drButton, drClip ) )
	    { continue;	}

	tedRulerDrawColumnControl( cs->csX0, cs->csX1, ox, sizeAcross,
						    rd->rdBackStipple, add );
	}

    if  ( ttr->ttrFirstIndent >= 0					&&
	  ttr->ttrFirstIndent >= rd->rdVisibleC0			&&
	  ttr->ttrFirstIndent <= rd->rdVisibleC1			)
	{
	tedHangingButtonRect( &drButton, ttr->ttrFirstIndent, sizeAcross );

	if  ( geoIntersectRectangle( &drButton, &drButton, drClip ) )
	    {
	    tedRulerDrawHangingButton( ttr->ttrFirstIndent, ox, sizeAcross,
						    rd->rdBackStipple, add );
	    }
	}

    if  ( ttr->ttrLeftIndent >= 0					&&
	  ttr->ttrLeftIndent >= rd->rdVisibleC0			&&
	  ttr->ttrLeftIndent <= rd->rdVisibleC1			)
	{
	tedStandingButtonRect( &drButton, ttr->ttrLeftIndent, sizeAcross );

	if  ( geoIntersectRectangle( &drButton, &drButton, drClip ) )
	    {
	    tedRulerDrawStandingButton( ttr->ttrLeftIndent, ox, sizeAcross,
						    rd->rdBackStipple, add );
	    }
	}

    if  ( ttr->ttrRightIndent >= 0					&&
	  ttr->ttrRightIndent >= rd->rdVisibleC0			&&
	  ttr->ttrRightIndent <= rd->rdVisibleC1			)
	{
	tedStandingButtonRect( &drButton, ttr->ttrRightIndent, sizeAcross );

	if  ( geoIntersectRectangle( &drButton, &drButton, drClip ) )
	    {
	    tedRulerDrawStandingButton( ttr->ttrRightIndent, ox, sizeAcross,
						    rd->rdBackStipple, add );
	    }
	}

    appDrawSetForegroundColor( add, &(add->addForeColor) );

    ts= ttr->ttrTabStopList.tslTabStops;
    for ( tab= 0; tab < ttr->ttrTabStopList.tslTabStopCount; ts++, tab++ )
	{
	if  ( ts->tsPixels < rd->rdVisibleC0	||
	      ts->tsPixels > rd->rdVisibleC1	)
	    { continue;	}

	tedTabSymbolRect( &drButton, ts->tsPixels, whiteY+ whiteH, sizeAcross );

	if  ( ! geoIntersectRectangle( &drButton, &drButton, drClip ) )
	    { continue;	}

	tedDrawTabSymbol( add, ts->tsPixels, ox, whiteY+ whiteH,
						sizeAcross, ts->tsAlignment );
	}

    appDrawNoClipping( add );

    return;
    }

APP_EVENT_HANDLER_H( tedRedrawTopRuler, w, voidttr, event )
    {
    TedTopRuler *	ttr= (TedTopRuler *)voidttr;
    RulerData *		rd= &(ttr->ttrRulerData);
    AppDrawingData *	add= &(rd->rdDrawingData);

    int			ox= rd->rdVisibleC0- rd->rdMinUsed;
    int			oy= 0;

    DocumentRectangle	drClip;

    if  ( ! rd->rdDrawingDataAllocated )
	{
	const int	vertical= 0;

	appRulerAllocateDrawingData( rd, vertical,
		    FONT_HEIGHT(rd->rdSizeAcross), ttr->ttrMagnification, w );
	}

    appCollectExposures( &drClip, add, ox, oy, event );

    tedDrawTopRuler( w, ttr, &drClip, ox );
    }

APP_EVENT_HANDLER_H( tedTopRulerConfigure, w, voidttr, event )
    {
    TedTopRuler *	ttr= (TedTopRuler *)voidttr;
    RulerData *		rd= &(ttr->ttrRulerData);

    int			wide;
    int			high;

    if  ( appDrawGetSizeFromConfigureEvent( &wide, &high, w, event ) )
	{ return;	}

    rd->rdSizeAlong= wide;
    rd->rdMaxUsed= wide- rd->rdExtraAfterMaxUsed;

    return;
    }

/************************************************************************/
/*									*/
/*  Scroll the horizontal ruler.					*/
/*									*/
/*  1)  Stretch the rectangle to contain whole controls.		*/
/*									*/
/************************************************************************/

static void tedRulerChangeRect(	int *				pChanged,
				DocumentRectangle *		drRedraw,
				const DocumentRectangle *	drClip,
				int				d,
				const TedTopRuler *		ttr )
    {
    const RulerData *		rd= &(ttr->ttrRulerData);
    int				sizeAcross= rd->rdSizeAcross;
    int				whY= WHITE_TOP(sizeAcross);

    TabStop *			ts;
    ColumnSeparator *		cs;
    int				tab;

    int				changed= 0;

    DocumentRectangle		drButMore;
    DocumentRectangle		drButLess;
    DocumentRectangle		drScratch;

    *drRedraw= *drClip;

    tedHangingButtonRect( &drButMore, ttr->ttrFirstIndent+ d, sizeAcross );
    tedHangingButtonRect( &drButLess, ttr->ttrFirstIndent- d, sizeAcross );
    geoUnionRectangle( &drButMore, &drButMore, &drButLess );
    if  ( geoIntersectRectangle( &drScratch, drClip, &drButMore ) )
	{ geoUnionRectangle( drRedraw, drRedraw, &drButMore ); changed= 1; }

    tedStandingButtonRect( &drButMore, ttr->ttrLeftIndent+ d, sizeAcross );
    tedStandingButtonRect( &drButLess, ttr->ttrLeftIndent- d, sizeAcross );
    geoUnionRectangle( &drButMore, &drButMore, &drButLess );
    if  ( geoIntersectRectangle( &drScratch, drClip, &drButMore ) )
	{ geoUnionRectangle( drRedraw, drRedraw, &drButMore ); changed= 1; }

    tedStandingButtonRect( &drButMore, ttr->ttrRightIndent+ d, sizeAcross );
    tedStandingButtonRect( &drButLess, ttr->ttrRightIndent- d, sizeAcross );
    geoUnionRectangle( &drButMore, &drButMore, &drButLess );
    if  ( geoIntersectRectangle( &drScratch, drClip, &drButMore ) )
	{ geoUnionRectangle( drRedraw, drRedraw, &drButMore ); changed= 1; }

    tedTabButtonRectangle( &drButMore, rd->rdVisibleC0+ d, whY, sizeAcross );
    tedTabButtonRectangle( &drButLess, rd->rdVisibleC0- d, whY, sizeAcross );
    geoUnionRectangle( &drButMore, &drButMore, &drButLess );
    if  ( geoIntersectRectangle( &drScratch, drClip, &drButMore ) )
	{ geoUnionRectangle( drRedraw, drRedraw, &drButMore ); changed= 1; }

    cs= ttr->ttrColumns;
    for ( tab= 0; tab < ttr->ttrColumnCount; cs++, tab++ )
	{
	tedRulerColumnControlRect( &drButMore,
					cs->csX0+ d, cs->csX1+ d, sizeAcross );
	tedRulerColumnControlRect( &drButLess,
					cs->csX0- d, cs->csX1- d, sizeAcross );

	geoUnionRectangle( &drButMore, &drButMore, &drButLess );
	if  ( geoIntersectRectangle( &drScratch, drClip, &drButMore ) )
	    { geoUnionRectangle( drRedraw, drRedraw, &drButMore ); changed= 1; }
	}

    ts= ttr->ttrTabStopList.tslTabStops;
    for ( tab= 0; tab < ttr->ttrTabStopList.tslTabStopCount; ts++, tab++ )
	{
	int	y= whY+ WHITE_HEIGHT(sizeAcross);

	tedTabSymbolRect( &drButMore, ts->tsPixels+ d, y, sizeAcross );
	tedTabSymbolRect( &drButLess, ts->tsPixels- d, y, sizeAcross );

	geoUnionRectangle( &drButMore, &drButMore, &drButLess );
	if  ( geoIntersectRectangle( &drScratch, drClip, &drButMore ) )
	    { geoUnionRectangle( drRedraw, drRedraw, &drButMore ); changed= 1; }
	}

    *pChanged= changed;
    return;
    }

void tedScrollTopRuler(	void *			voidttr,
				APP_WIDGET		w,
				int			d	)
    {
    TedTopRuler *		ttr= (TedTopRuler *)voidttr;
    RulerData *			rd= &(ttr->ttrRulerData);

    int				changed;

    DocumentRectangle		drClip;
    DocumentRectangle		drRedraw;

    int				ox;

    appScrollHorizontalRuler( rd, &drClip, d );

    ox= rd->rdVisibleC0- rd->rdMinUsed;

    changed= 0;
    tedRulerChangeRect( &changed, &drRedraw, &drClip, d, ttr );

    tedDrawTopRuler( w, ttr, &drRedraw, ox );

    if  ( d > 0 )
	{ drClip.drX0= rd->rdVisibleC0- 1; drClip.drX1= rd->rdVisibleC0+ 1; }
    else{ drClip.drX0= rd->rdVisibleC1- 1; drClip.drX1= rd->rdVisibleC1+ 1; }

    changed= 0;
    tedRulerChangeRect( &changed, &drRedraw, &drClip, d, ttr );

    if  ( changed )
	{ tedDrawTopRuler( w, ttr, &drRedraw, ox ); }
    }

void tedSetTopRulerRange(	void *			voidttr,
					APP_WIDGET		w,
					int			docVisX0,
					int			docVisX1,
					int			docBackX1 )
    {
    TedTopRuler *		ttr= (TedTopRuler *)voidttr;
    RulerData *			rd= &(ttr->ttrRulerData);
    AppDrawingData *		add= &(rd->rdDrawingData);

    rd->rdVisibleC0= docVisX0;
    rd->rdVisibleC1= docVisX1;
    rd->rdMaxUsed= docBackX1;

    appExposeDrawingData( add );

    return;
    }

/************************************************************************/
/*									*/
/*  Let the user drag one of the controls on the top ruler.		*/
/*									*/
/*  0)  Refuse to move outside the permitted range, but do not jump	*/
/*	back into it: Some documents do have strange settings and a	*/
/*	forced correction confuses the user. This is implemented by	*/
/*	refusing to move outside the possible rance, and to refuse to	*/
/*	move further outside.						*/
/*  1)  Draw a 'hair' over the document that corresponds to the		*/
/*	position of the control.					*/
/*  2)  Until the mouse button is released, observe events.		*/
/*  3)  Merge as many mouse motion events as possible.			*/
/*  4)  If the event is a mouse motion or a button release, redraw the	*/
/*	old an new position of the control on the ruler. (Assume that	*/
/*	the buttons are wider than the tab marks.			*/
/*  5)  Let the document move the hair.					*/
/*  6)  When the mouse button is released, the loop ends.		*/
/*  7)  Let the toolkit dispatch all events that are not relevant for	*/
/*	this routine.							*/
/*									*/
/************************************************************************/

static void tedTopRulerSetValue(	TopRulerDrag *		trd,
					int			newValue )
    {
    TedTopRuler *		ttr= trd->trdTtr;
    RulerData *			rd= &(ttr->ttrRulerData);
    AppDrawingData *		add= &(rd->rdDrawingData);
    int				oldValue= trd->trdValue;
    int				ox= trd->trdOc;
    const int			oy= 0;

    int				v0;
    int				v1;
    int				nv0;
    int				nv1;

    DocumentRectangle		drExpose;

    if  ( newValue == oldValue )
	{ return;	}

    trd->trdValue= newValue;
    *(trd->trdChangedPointer)= 1;

    v1= v0= *(trd->trdV0Pointer);
    nv1= nv0= *(trd->trdV0Pointer)+ newValue- oldValue;

    if  ( trd->trdV1Pointer )
	{
	v1= *(trd->trdV1Pointer);
	nv1= *(trd->trdV1Pointer)+ newValue- oldValue;
	}

    /*  0  */
    if  ( nv0 < v0 && nv0 < trd->trdXmin )
	{
	if  ( v0 < trd->trdXmin )
	    { nv0= v0;			}
	else{ nv0= trd->trdXmin;	}

	nv1= nv0+ ( v1- v0 );
	}

    if  ( nv1 > v1 && nv1 > trd->trdXmax )
	{
	if  ( v1 > trd->trdXmax )
	    { nv1= v1;			}
	else{ nv1= trd->trdXmax;	}

	nv0= nv1- ( v1- v0 );
	}

    *(trd->trdV0Pointer)= nv0;
    if  ( trd->trdV1Pointer )
	{ *(trd->trdV1Pointer)= nv1;	}

    if  ( v0 < nv0 )
	{
	drExpose.drX0= v0-  BUTTON_HWIDTH(rd->rdSizeAcross)- BUTTON_MARG;
	drExpose.drX1= nv1+ BUTTON_HWIDTH(rd->rdSizeAcross)+ BUTTON_MARG;
	drExpose.drY0= 0;
	drExpose.drY1= rd->rdSizeAcross;
	}
    else{
	drExpose.drX0= nv0- BUTTON_HWIDTH(rd->rdSizeAcross)- BUTTON_MARG;
	drExpose.drX1= v1+  BUTTON_HWIDTH(rd->rdSizeAcross)+ BUTTON_MARG;
	drExpose.drY0= 0;
	drExpose.drY1= rd->rdSizeAcross;
	}

    /*
    tedDrawTopRuler( trd->trdWidget, ttr, &drClip, trd->trdOc );
    */
    drExpose.drX0 -= ox;
    drExpose.drX1 -= ox;
    drExpose.drY0 -= oy;
    drExpose.drY1 -= oy;
    appExposeRectangle( add, &drExpose );

    /*  5  */
    appMetricRulerChangeValue( trd->trdDocument, newValue );

    return;
    }

static APP_EVENT_HANDLER_H( tedTopRulerMouseMove, w, vtrd, event )
    {
    TopRulerDrag *		trd= (TopRulerDrag *)vtrd;

    int				x;
    int				y;

    if  ( appGetCoordinatesFromMouseMoveEvent( &x, &y, w, event ) )
	{ return;	}

    if  ( trd->trdYPointer )
	{ *trd->trdYPointer= y;	}

    tedTopRulerSetValue( trd, x+ trd->trdOc );

    return;
    }

static APP_EVENT_HANDLER_H( tedTopRulerMouseUp, w, vtrd, event )
    {
    TopRulerDrag *		trd= (TopRulerDrag *)vtrd;

    int				x;
    int				y;

    int				button;
    int				upDown;
    int				seq;
    unsigned int		keyState;

    if  ( appGetCoordinatesFromMouseButtonEvent(
			&x, &y, &button, &upDown, &seq, &keyState, w, event ) )
	{ return;	}

    tedTopRulerSetValue( trd, x+ trd->trdOc );
    appMetricRulerExposeValue( trd->trdDocument );

    *(trd->trdYPointer)= y;

    return;
    }

static void tedTopRulerDragItem(	int *			pV0,
					int *			pV1,
					int *			pY,
					int *			pChanged,
					APP_WIDGET		w,
					EditApplication *	ea,
					APP_EVENT *		downEvent,
					TedTopRuler *		ttr,
					int			x0,
					int			x1,
					int			v,
					int			ox,
					EditDocument *		ed )
    {
    SelectRectangle *	sr= sr= &(ed->edSelectRectangle);
    TopRulerDrag	trd;
    int			startValue= *pV0;
    int			oldDirection= sr->srDirection;

    int			nv0;
    int			nv1;

    trd.trdValue= v;
    trd.trdV0Pointer= pV0;
    trd.trdV1Pointer= pV1;
    trd.trdYPointer= pY;
    trd.trdChangedPointer= pChanged;
    trd.trdTtr= ttr;
    trd.trdWidget= w;
    trd.trdXmin= x0;
    trd.trdXmax= x1;
    trd.trdOc= ox;
    trd.trdDocument= ed;

    nv0= nv1= *(trd.trdV0Pointer);
    if  ( trd.trdV1Pointer )
	{ nv1= *(trd.trdV1Pointer); }

    sr->srSelected.drX0= ( nv0+ nv1 )/ 2;
    sr->srDirection= DOCselW;

    sr->srLTM.drX0= nv0- sr->srSelected.drX0;
    sr->srLTM.drX1= nv1- sr->srSelected.drX0;

    appMetricRulerExposeValue( ed );

    appRunDragLoop( w, ea, downEvent,
				tedTopRulerMouseUp,
				tedTopRulerMouseMove,
				0, (APP_TIMER_CALLBACK)0,
				(void *)&trd );

    appMetricRulerExposeValue( ed );

    if  ( pChanged && *pV0 != startValue )
	{ *pChanged= 1;	}

    sr->srDirection= oldDirection;
    }

/************************************************************************/
/*									*/
/*  The user clicked on the top ruler, make her happy.			*/
/*									*/
/*  1)  Only accept 'left mouse down' events.				*/
/*  2)  If the click is on one of the tab marks, apparently the user	*/
/*	wants to move the tab.						*/
/*  3)  If the tab was dragged from the ruler, assume that the user	*/
/*	wants to delete it.						*/
/*  4)  Move first indent?						*/
/*  5)  Move left indent?						*/
/*  6)  Move right indent?						*/
/*  7)  Not on one of the controls.. If the click is on the white band,	*/
/*	assume she wants to set a new tab.				*/
/*  8)  Is it on one of the table column separators? Allow the user to	*/
/*	drag it.							*/
/*  9)  Is it on the button with the kind of thabs that is to be added?	*/
/*	Rotate the type.						*/
/*									*/
/************************************************************************/

static int tedCompareTabStopsPixels(	const void *	voidts1,
					const void *	voidts2	)
    {
    const TabStop *	ts1= (const TabStop *)voidts1;
    const TabStop *	ts2= (const TabStop *)voidts2;

    return ts1->tsPixels- ts2->tsPixels;
    }

/*  2  */
static void tedTopRulerDragTab(	int *			pChanged,
				APP_WIDGET		w,
				EditApplication *	ea,
				APP_EVENT *		downEvent,
				TedTopRuler *		ttr,
				int			item,
				int			x,
				int			ox,
				int			mouseX,
				int			mouseY,
				EditDocument *		ed )
    {
    RulerData *		rd= &(ttr->ttrRulerData);
    AppDrawingData *	add= &(rd->rdDrawingData);
    int			sizeAcross= rd->rdSizeAcross;
    int			whiteTop= WHITE_TOP(sizeAcross);
    int			whiteHigh= WHITE_HEIGHT(sizeAcross);

    TabStop *		ts= ttr->ttrTabStopList.tslTabStops+ item;

    int			x0= ts->tsPixels;
    int			x1;
    int			dxAbs;

    x1= ts->tsPixels;

    tedTopRulerDragItem( &x1, (int *)0, &mouseY, pChanged, w, ea, downEvent,
		    ttr, ttr->ttlParaFrameX0, ttr->ttlParaFrameX1, x, ox, ed );

    ts->tsPixels= x1;

    dxAbs= x1- x0;
    if  ( dxAbs < 0 )
	{ dxAbs= -dxAbs;	}

    /*  3  */
    if  ( dxAbs < 2* whiteHigh )
	{
	const int	n= 4;
	const int	m= n+ 1;

	if  ( mouseY <  whiteTop- ( 1* whiteHigh )/n	||
	      mouseY >  whiteTop+ ( m* whiteHigh )/n	)
	    {
	    docDeleteTabFromList( &(ttr->ttrTabStopList), item );
	    *pChanged= 1;

	    appExposeDrawingData( add );
	    }
	}

    qsort( ttr->ttrTabStopList.tslTabStops,
				ttr->ttrTabStopList.tslTabStopCount,
				sizeof(TabStop), tedCompareTabStopsPixels );

    return;
    }

void tedTopRulerTrackMouse(	int *			pFirstIndent,
				int *			pLeftIndent,
				int *			pRightIndent,
				TabStopList *		tsl,
				int *			pCsCount,
				ColumnSeparator **	pCs,
				int *			pProperty,
				APP_WIDGET		w,
				EditApplication *	ea,
				APP_EVENT *		downEvent,
				void *			voidttr,
				EditDocument *		ed )
    {
    TedTopRuler  *	ttr= (TedTopRuler *)voidttr;
    RulerData *		rd= &(ttr->ttrRulerData);
    AppDrawingData *	add= &(rd->rdDrawingData);
    int			sizeAcross= rd->rdSizeAcross;

    int			mouseX;
    int			mouseY;
    int			ox= rd->rdVisibleC0- rd->rdMinUsed;

    int			item;
    int			tabWidth= TAB_WIDTH(sizeAcross);

    int			whiteY= WHITE_TOP(sizeAcross);
    int			whiteH= WHITE_HEIGHT(sizeAcross);

    int			changed= 0;
    int			yy;

    DocumentRectangle	dr;

    int			button;
    int			upDown;
    int			seq;
    unsigned int	keyState;

    if  ( appGetCoordinatesFromMouseButtonEvent(
			&mouseX, &mouseY, &button, &upDown, &seq, &keyState,
			w, downEvent ) )
	{ return;	}

    if  ( upDown < 1 || button != 1 || seq > 1 )
	{ return;	}

    /*  2  */
    if  ( mouseY >= whiteY		&&
	  mouseY <  whiteY+ whiteH	)
	{
	TabStop *		ts;

	ts= ttr->ttrTabStopList.tslTabStops;
	for ( item= 0; item < ttr->ttrTabStopList.tslTabStopCount; ts++, item++ )
	    {
	    if  ( mouseX+ ox >= ts->tsPixels- tabWidth	&&
		  mouseX+ ox <  ts->tsPixels+ tabWidth	)
		{
		tedTopRulerDragTab( &changed, w, ea, downEvent, ttr,
				item, mouseX+ ox, ox, mouseX, mouseY, ed );

		if  ( changed )
		    {
		    *tsl= ttr->ttrTabStopList;
		    *pProperty= PPpropTAB_STOPS;
		    appExposeDrawingData( add );
		    }
		else{ *pProperty= PPprop_NONE; }

		return;
		}
	    }
	}

    /*  4  */
    if  ( ttr->ttrFirstIndent >= 0					&&
	  mouseY < HBUTTON_APEX(sizeAcross)					&&
	  mouseX+ ox >= ttr->ttrFirstIndent- BUTTON_HWIDTH(sizeAcross)	&&
	  mouseX+ ox <= ttr->ttrFirstIndent+ BUTTON_HWIDTH(sizeAcross)	)
	{
	tedTopRulerDragItem(
		    &(ttr->ttrFirstIndent), (int *)0, &yy, &changed,
		    w, ea, downEvent, ttr,
		    ttr->ttlParaFrameX0, ttr->ttlParaFrameX1, mouseX+ ox, ox, ed );

	if  ( changed )
	    {
	    *pFirstIndent= ttr->ttrFirstIndent;
	    *tsl= ttr->ttrTabStopList;
	    *pProperty= PPpropFIRST_INDENT;
	    appExposeDrawingData( add );
	    }
	else{ *pProperty= PPprop_NONE; }
	return;
	}

    /*  5  */
    if  ( ttr->ttrLeftIndent >= 0					&&
	  mouseY >= SBUTTON_APEX(sizeAcross)					&&
	  mouseY <= SBUTTON_BASE(sizeAcross)					&&
	  mouseX+ ox >= ttr->ttrLeftIndent- BUTTON_HWIDTH(sizeAcross)	&&
	  mouseX+ ox <= ttr->ttrLeftIndent+ BUTTON_HWIDTH(sizeAcross)	)
	{
	tedTopRulerDragItem(
		    &ttr->ttrLeftIndent, (int *)0, &yy, &changed,
		    w, ea, downEvent, ttr,
		    ttr->ttlParaFrameX0, ttr->ttlParaFrameX1, mouseX+ ox, ox, ed );

	if  ( changed )
	    {
	    *pLeftIndent= ttr->ttrLeftIndent;
	    *tsl= ttr->ttrTabStopList;
	    *pProperty= PPpropLEFT_INDENT;
	    appExposeDrawingData( add );
	    }
	else{ *pProperty= PPprop_NONE; }
	return;
	}

    /*  6  */
    if  ( ttr->ttrRightIndent >= 0					&&
	  mouseY >= SBUTTON_APEX(sizeAcross)					&&
	  mouseY <= SBUTTON_BASE(sizeAcross)					&&
	  mouseX+ ox >= ttr->ttrRightIndent- BUTTON_HWIDTH(sizeAcross)	&&
	  mouseX+ ox <= ttr->ttrRightIndent+ BUTTON_HWIDTH(sizeAcross)	)
	{
	tedTopRulerDragItem(
		&ttr->ttrRightIndent, (int *)0, &yy, &changed,
		w, ea, downEvent, ttr,
		ttr->ttlParaFrameX0, ttr->ttlParaFrameX1, mouseX+ ox, ox, ed );

	if  ( changed )
	    {
	    *pRightIndent= ttr->ttrRightIndent;
	    *tsl= ttr->ttrTabStopList;
	    *pProperty= PPpropRIGHT_INDENT;
	    appExposeDrawingData( add );
	    }
	else{ *pProperty= PPprop_NONE; }
	return;
	}

    /*  7  */
    if  ( mouseY >= whiteY			&&
	  mouseY <  whiteY+ whiteH		&&
	  mouseX+ ox >= ttr->ttlParaFrameX0	&&
	  mouseX+ ox <= ttr->ttlParaFrameX1	)
	{
	TabStop		tsNew;

	docInitTabStop( &tsNew );

	tsNew.tsPixels= mouseX+ ox;
	tsNew.tsAlignment= ttr->ttrTabKind;

	item= docAddTabToListPixels( &(ttr->ttrTabStopList), &tsNew );
	if  ( item < 0 )
	    { LDEB(item); *pProperty= PPprop_NONE; return;	}

	appExposeDrawingData( add );

	tedTopRulerDragTab( &changed, w, ea, downEvent, ttr,
				item, mouseX+ ox, mouseX, mouseY, ox, ed );

	*tsl= ttr->ttrTabStopList;
	*pProperty= PPpropTAB_STOPS;
	appExposeDrawingData( add );
	return;
	}

    /*  8  */
    if  ( mouseY >= whiteY			&&
	  mouseY <  whiteY+ whiteH		)
	{
	for ( item= 0; item < ttr->ttrColumnCount; item++ )
	    {
	    if  ( mouseX+ ox >= ttr->ttrColumns[item].csX0		&&
		  mouseX+ ox <  ttr->ttrColumns[item].csX1		)
		{
		int		wide;
		int		x0;
		int		x1;

		wide= ttr->ttrColumns[item].csX1- ttr->ttrColumns[item].csX0;
		x0= ttr->ttlBlockFrameX0- wide;
		x1= ttr->ttlBlockFrameX1+ wide;

		if  ( item > 0 )
		    { x0= ttr->ttrColumns[item- 1].csX1; }
		if  ( item < ttr->ttrColumnCount- 1 )
		    { x1= ttr->ttrColumns[item+ 1].csX0; }

		tedTopRulerDragItem( &ttr->ttrColumns[item].csX0,
				    &ttr->ttrColumns[item].csX1,
				    &yy, &changed,
				    w, ea, downEvent, ttr,
				    x0, x1, mouseX+ ox, ox, ed );

		if  ( changed )
		    {
		    *pCsCount= ttr->ttrColumnCount; *pCs= ttr->ttrColumns;
		    *pProperty= PPprop_COLUMNS;
		    appExposeDrawingData( add );
		    }
		else{ *pProperty= PPprop_NONE;	}
		return;
		}
	    }
	}

    /*  9  */
    tedTabButtonRectangle( &dr, rd->rdMinUsed, whiteY, sizeAcross );

    if  ( mouseX >= dr.drX0 && mouseX <= dr.drX1	&&
	  mouseY >= dr.drY0 && mouseY <= dr.drY1	)
	{
	switch( ttr->ttrTabKind )
	    {
	    case DOCtaLEFT:	ttr->ttrTabKind= DOCtaRIGHT;	break;
	    case DOCtaRIGHT:	ttr->ttrTabKind= DOCtaCENTER;	break;
	    case DOCtaCENTER:	ttr->ttrTabKind= DOCtaDECIMAL;	break;
	    case DOCtaDECIMAL:	ttr->ttrTabKind= DOCtaLEFT;	break;
	    default:
		LDEB(ttr->ttrTabKind);
	    }

	appExposeRectangle( add, &dr );
	}

    *pProperty= PPprop_NONE; return;
    }

/************************************************************************/
/*									*/
/*  Adapt an horizontal ruler to the paragraph.				*/
/*									*/
/************************************************************************/

void tedAdaptTopRuler(		void *			voidttr,
				APP_WIDGET		w,
				int			documentC0,
				int			documentC1,
				int			firstIndent,
				int			leftIndent,
				int			rightIndent,
				int			rulerC1,
				const TabStopList *	tslSet )
    {
    TedTopRuler *	ttr= (TedTopRuler *)voidttr;
    RulerData *		rd= &(ttr->ttrRulerData);
    AppDrawingData *	add= &(rd->rdDrawingData);

    int			tabsChanged= 0;
    int			changed= 0;
    const int		pixels= 1;

    rd->rdDocumentC0= documentC0;
    rd->rdDocumentC1= documentC1;

    if  ( ttr->ttrFirstIndent != firstIndent )
	{ ttr->ttrFirstIndent=   firstIndent; changed= 1;	}

    if  ( ttr->ttrLeftIndent != leftIndent )
	{ ttr->ttrLeftIndent=   leftIndent; changed= 1;	}

    if  ( ttr->ttrRightIndent != rightIndent )
	{ ttr->ttrRightIndent=   rightIndent; changed= 1;	}

    if  ( rd->rdRulerC1 != rulerC1 )
	{ rd->rdRulerC1=   rulerC1; changed= 1;	}

    if  ( docCopyTabStopList( &tabsChanged, &(ttr->ttrTabStopList),
							tslSet, pixels ) )
	{ LDEB(1); return;	}
    if  ( tabsChanged )
	{ changed= 1;	}

#   ifdef USE_MOTIF
    if  ( changed && XtIsRealized( w ) )
#   endif
#   ifdef USE_GTK
    if  ( changed && GTK_WIDGET_REALIZED( w ) )
#   endif
	{
	const int	vertical= 0;

	if  ( ! rd->rdDrawingDataAllocated )
	    {
	    appRulerAllocateDrawingData( rd, vertical,
					FONT_HEIGHT(rd->rdSizeAcross),
					ttr->ttrMagnification, w );
	    }
	if  ( ! rd->rdDrawingDataAllocated )
	    { LDEB(1); return;	}

	appExposeDrawingData( add );
	}

    return;
    }

int tedSetRulerColumns(		APP_WIDGET		w,
				void *			voidttr,
				int			bfX0Pixels,
				int			bfX1Pixels,
				int			pfX0Pixels,
				int			pfX1Pixels,
				ColumnSeparator *	cs,
				int			csCount )
    {
    TedTopRuler *	ttr= (TedTopRuler *)voidttr;
    RulerData *		rd= &(ttr->ttrRulerData);
    AppDrawingData *	add= &(rd->rdDrawingData);
    int			changed= 0;
    int			i;

    ttr->ttlBlockFrameX0= bfX0Pixels;
    ttr->ttlBlockFrameX1= bfX1Pixels;
    ttr->ttlParaFrameX0= pfX0Pixels;
    ttr->ttlParaFrameX1= pfX1Pixels;

    if  ( csCount != ttr->ttrColumnCount )
	{
	if  ( csCount > ttr->ttrColumnCount )
	    {
	    ColumnSeparator *	fresh;

	    fresh= (ColumnSeparator *)
		realloc( ttr->ttrColumns, csCount* sizeof(ColumnSeparator) );
	    if  ( ! fresh )
		{ LXDEB(csCount,fresh); return -1;	}

	    ttr->ttrColumns= fresh;
	    fresh += ttr->ttrColumnCount;

	    while( ttr->ttrColumnCount < csCount )
		{
		fresh->csX0= 0;
		fresh->csX1= 0;

		ttr->ttrColumnCount++; fresh++;
		}
	    }

	ttr->ttrColumnCount= csCount;
	changed= 1;
	}

    for ( i= 0; i < csCount; i++ )
	{
	if  ( ttr->ttrColumns[i].csX0 != cs[i].csX0 )
	    { ttr->ttrColumns[i].csX0=   cs[i].csX0; changed= 1; }
	if  ( ttr->ttrColumns[i].csX1 != cs[i].csX1 )
	    { ttr->ttrColumns[i].csX1=   cs[i].csX1; changed= 1; }
	}

#   ifdef USE_MOTIF
    if  ( changed && XtIsRealized( w ) )
#   endif
#   ifdef USE_GTK
    if  ( changed && GTK_WIDGET_REALIZED( w ) )
#   endif
	{
	appExposeDrawingData( add );
	}

    return 0;
    }

