/************************************************************************/
/*  Ted: interaction with the page layout tool.				*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	"tedApp.h"
#   include	"tedRuler.h"
#   include	"tedLayout.h"
#   include	"docScreenLayout.h"
#   include	"docEvalField.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Reformat and redisplay the document because of a major format	*/
/*  change. etc.							*/
/*									*/
/************************************************************************/

void tedRedoDocumentLayout(	EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;
    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);

    int				scrolledX= 0;
    int				scrolledY= 0;

    int				hasSelection= tedHasSelection( td );

    LayoutContext		lc;

    layoutInitContext( &lc );
    tedSetLayoutContext( &lc, ed );

    tedLayoutDocumentTree( td, &lc );

    if  ( tedOpenExternalItemObjects( &(bd->bdBody), &lc ) )
	{ LDEB(1); 	}

    appSetShellConstraints( ed );

    if  ( hasSelection )
	{ tedDelimitCurrentSelection( ed );	}

    appDocSetScrollbarValues( ed );
    appSetShellConstraints( ed );

    if  ( hasSelection )
	{
	DocumentSelection		ds;
	SelectionGeometry		sg;
	SelectionDescription		sd;
	const BufferItem *		bodySectBi;

	if  ( tedGetSelection( &ds, &sg, &sd,
				    (DocumentTree **)0, &bodySectBi, td ) )
	    { LDEB(1); return;	}

	tedDocAdaptTopRuler( ed, &ds, &sg, &sd, bodySectBi );

	tedScrollToSelection( ed, &scrolledX, &scrolledY );

	tedDescribeSelection( ed );

	if  ( td->tdSelectionDescription.sdIsObjectSelection )
	    { tedMoveObjectWindows( ed );	}
	}

    appExposeDrawingData( add );

    return;
    }

/************************************************************************/
/*									*/
/*  Change the document geometry: Callback from the page layout tool	*/
/*  etc.								*/
/*									*/
/************************************************************************/

void tedSetPageLayout(	EditDocument *			ed,
			const DocumentGeometry *	dg,
			const PropertyMask *		dgSetMask,
			int				wholeDocument )
    {
    AppDrawingData *		add;
    TedDocument *		td;
    BufferDocument *		bd;
    DocumentProperties *	dp;

    PropertyMask		changed;
    PropertyMask		dgUpdMask;

    int				i;

    utilPropMaskClear( &changed );
    utilPropMaskClear( &dgUpdMask );

    add= &(ed->edDocumentWidget.dwDrawingData);
    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    dp= &(bd->bdProperties);

    utilPropMaskClear( &dgUpdMask );
    utilPropMaskFill( &dgUpdMask, DGprop_COUNT );
    utilPropMaskAnd( &dgUpdMask, &dgUpdMask, dgSetMask );

    if  ( wholeDocument )
	{
	BufferItem *	bodyBi= bd->bdBody.eiRoot;

	utilUpdDocumentGeometry( &(dp->dpGeometry), dg, &changed, &dgUpdMask );

	for ( i= 0; i < bodyBi->biChildCount; i++ )
	    {
	    PropertyMask		sectChanged;
	    BufferItem *		sectBi= bodyBi->biChildren[i];

	    utilPropMaskClear( &sectChanged );

	    utilUpdDocumentGeometry( &(sectBi->biSectDocumentGeometry),
						dg, &sectChanged, dgSetMask );

	    utilPropMaskOr( &changed, &changed, &sectChanged );
	    }

	if  ( ! utilPropMaskIsEmpty( &changed ) )
	    {
	    appDocumentChanged( ed, 1 );

	    tedScreenRectangles( add, &(dp->dpGeometry) );

	    tedRedoDocumentLayout( ed );

	    tedAdaptToolsToSelection( ed );
	    }
	}
    else{
	SectionProperties	spNew;
	PropertyMask		spDoneMask;
	const PropertyMask *	spSetMask= dgSetMask;

	TextAttribute		taSet;

	PropertyMask		taUpdMask;
	PropertyMask		ppSetMask;

	utilPropMaskClear( &taUpdMask );
	utilPropMaskClear( &ppSetMask );

	utilInitTextAttribute ( &taSet );

	docInitSectionProperties( &spNew );
	utilPropMaskClear( &spDoneMask );

	utilUpdDocumentGeometry( &(spNew.spDocumentGeometry), dg,
						    &spDoneMask, dgSetMask );

	if  ( tedChangeSelectionProperties( ed,
				    &taUpdMask, &taSet,
				    &ppSetMask, (ParagraphProperties *)0,
				    spSetMask, &spNew ) )
	    { XDEB(spSetMask);	}

	docCleanSectionProperties( &spNew );
	}

    return;
    }

int tedAppSetDocumentProperties( EditApplication *		ea,
				const DocumentProperties *	dpNew,
				const PropertyMask *		updMask )
    {
    EditDocument *		ed= ea->eaCurrentDocument;
    AppDrawingData *		add;
    TedDocument *		td;
    BufferDocument *		bd;
    DocumentProperties *	dp;

    PropertyMask		changed;

    RecalculateFields		rf;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    utilPropMaskClear( &changed );

    docInitRecalculateFields( &rf );

    add= &(ed->edDocumentWidget.dwDrawingData);
    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    dp= &(bd->bdProperties);

    rf.rfBd= bd;
    rf.rfEi= &(bd->bdBody);
    rf.rfCloseObject= docScreenCloseObject;
    rf.rfUpdateFlags= 0;
    rf.rfFieldsUpdated= 0;

    if  ( docUpdDocumentProperties( &changed, dp, updMask, dpNew ) )
	{ LDEB(1); return -1;	}

    if  ( ! utilPropMaskIsEmpty( &changed ) )
	{
	int		noteNumbersChanged= 0;

	if  ( PROPmaskISSET( &changed, DPpropFOOTNOTE_RESTART )	||
	      PROPmaskISSET( &changed, DPpropENDNOTE_RESTART )	)
	    { docRenumberNotes( &noteNumbersChanged, bd );	}

	if  ( noteNumbersChanged				||
	      PROPmaskISSET( &changed, DPpropFOOTNOTE_STYLE )	||
	      PROPmaskISSET( &changed, DPpropFOOTNOTE_STARTNR )	||
	      PROPmaskISSET( &changed, DPpropENDNOTE_STYLE )	||
	      PROPmaskISSET( &changed, DPpropENDNOTE_STARTNR )	)
	    { rf.rfUpdateFlags |= FIELDdoCHFTN;	}

	if  ( PROPmaskISSET( &changed, DPpropTITLE )	||
	      PROPmaskISSET( &changed, DPpropSUBJECT )	||
	      PROPmaskISSET( &changed, DPpropKEYWORDS )	||
	      PROPmaskISSET( &changed, DPpropDOCCOMM )	||
	      PROPmaskISSET( &changed, DPpropAUTHOR )	||
	      PROPmaskISSET( &changed, DPpropCOMPANY )	||
	      PROPmaskISSET( &changed, DPpropCREATIM )	||
	      PROPmaskISSET( &changed, DPpropREVTIM )	||
	      PROPmaskISSET( &changed, DPpropPRINTIM )	)
	    { rf.rfUpdateFlags |= FIELDdoDOC_INFO;	}

	if  ( rf.rfUpdateFlags != 0 )
	    {
	    if  ( docRecalculateTextLevelFields( &rf, bd->bdBody.eiRoot ) )
		{ LDEB(1); return -1;	}
	    }

	appDocumentChanged( ed, 1 );

	tedScreenRectangles( add, &(dp->dpGeometry) );

	tedRedoDocumentLayout( ed );

	tedAdaptToolsToSelection( ed );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Adapt the page tool to a document.					*/
/*									*/
/************************************************************************/

void tedAdaptPageToolToDocument(	EditApplication *	ea,
					EditDocument *		ed )
    {
    TedDocument *		td;
    BufferDocument *		bd;
    DocumentProperties *	dp;

    if  ( ! ea->eaPageTool )
	{ return;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    dp= &(bd->bdProperties);

    appPageToolSetProperties( ea->eaPageTool, &(dp->dpGeometry) );

    appEnablePageTool( ea->eaPageTool, ! ed->edIsReadonly );

    return;
    }

/************************************************************************/
/*									*/
/*  Derive private rectangles from document properties.			*/
/*									*/
/************************************************************************/

void tedScreenRectangles(	AppDrawingData *		add,
				const DocumentGeometry *	dg )
    {
    double			xfac= add->addMagnifiedPixelsPerTwip;
    double			yfac= add->addMagnifiedPixelsPerTwip;

    int				leftMarginPixels;
    int				rightMarginPixels;

#   if 0
    /*  1  */
    if  ( dg->dgLeftMarginTwips < MINMARG )
	{ dg->dgLeftMarginTwips= MINMARG;	}
    if  ( dg->dgTopMarginTwips < MINMARG )
	{ dg->dgTopMarginTwips= MINMARG;	}
    if  ( dg->dgRightMarginTwips < MINMARG )
	{ dg->dgRightMarginTwips= MINMARG;	}
    if  ( dg->dgBottomMarginTwips < MINMARG )
	{ dg->dgBottomMarginTwips= MINMARG;	}
#   endif

    leftMarginPixels= COORDtoGRID( xfac, dg->dgLeftMarginTwips );
    rightMarginPixels= COORDtoGRID( xfac, dg->dgRightMarginTwips );
    add->addBottomMarginPixels= COORDtoGRID( xfac, dg->dgBottomMarginTwips );

    add->addBackRect.drX0= 0;
    add->addBackRect.drY0= 0;
    add->addBackRect.drX1= COORDtoGRID( xfac, dg->dgPageWideTwips );
    add->addBackRect.drY1= COORDtoGRID( yfac, dg->dgPageHighTwips );

    add->addPaperRect.drX0= 0;
    add->addPaperRect.drY0= 0;
    add->addPaperRect.drX1= COORDtoGRID( xfac, dg->dgPageWideTwips );
    add->addPaperRect.drY1= COORDtoGRID( yfac, dg->dgPageHighTwips );

    add->addDocRect.drX0= leftMarginPixels;
    add->addDocRect.drY0= COORDtoGRID( xfac, dg->dgTopMarginTwips );
    add->addDocRect.drX1= add->addBackRect.drX1- rightMarginPixels;
    add->addDocRect.drY1= add->addBackRect.drY1- add->addBottomMarginPixels;

    add->addPageStepPixels= add->addPaperRect.drY1- add->addPaperRect.drY0+
							add->addPageGapPixels;

    return;
    }

/************************************************************************/
/*									*/
/*  (re)Calculate the layout of a whole document.			*/
/*									*/
/************************************************************************/

int tedLayoutDocumentTree(	TedDocument *		td,
				const LayoutContext *	lc )
    {
    BufferDocument *		bd= td->tdDocument;
    DocumentProperties *	dp= &(bd->bdProperties);

    DocumentRectangle		drChanged;

    /*  1  */
    if  ( dp->dpFontList.dflFontCount == 0 )
	{ LDEB(dp->dpFontList.dflFontCount); return -1;	}

    drChanged= lc->lcAdd->addBackRect;

    if  ( docScreenLayoutItem( bd->bdBody.eiRoot, lc, &drChanged ) )
	{ LDEB(1); return -1;	}

    /* LDEB(1);docListItem(0,bd->bdBody.eiRoot); */

    return 0;
    }

