/************************************************************************/
/*									*/
/*  Ted: Field,Bookmark,Hyperlink related editing functionality.	*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   include	"tedEdit.h"
#   include	"docScreenLayout.h"
#   include	"docEvalField.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Insert a footnote in the document.					*/
/*									*/
/*  1)  Change the selection to a reference to a note.			*/
/*  2)	Insert a note immediately after the reference.			*/
/*  3)	Preliminary layout of the footnote.				*/
/*  4)	Layout of the item thet receives the footnote. (Usually redoes	*/
/*	the layout of the footnote)					*/
/*  5)	Select the end of the freshly inserted footnote.		*/
/*  6)	Finish the edit operation with the cursor immediately after the	*/
/*	number of the note.						*/
/*  7)	Notes only have a single location: Make the formatter happy and	*/
/*	tell that it has been selected where it belongs.		*/
/*									*/
/************************************************************************/

void tedDocInsertNote(	EditDocument *	ed,
			int		noteInExtIt,
			int		sepInExtIt )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    DocumentSelection		dsField;

    MemoryBuffer		mbFieldInst;
    const unsigned int		fieldUpdMask= FIELDdoCHFTN;

    DocumentNote *		dn;
    DocumentField *		dfNote;
    BufferItem *		bodySectBi;

    int				changed;

    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);

    SelectionGeometry		sg;
    SelectionDescription	sd;

    DocumentPosition		dpEnd;

    RecalculateFields		rf;

    TextAttribute		taSet;
    PropertyMask		taSetMask;

    int				headPart;
    int				tailPart;

    int				fieldKind= DOCfkCHFTN;

    utilInitMemoryBuffer( &mbFieldInst );
    if  ( utilSetMemoryBuffer( &mbFieldInst, (unsigned char *)"-CHFTN", 6 ) )
	{ LDEB(6); goto ready;	}

    utilInitTextAttribute( &taSet );
    utilPropMaskClear( &taSetMask );

    tedStartEditOperation( &teo, &sg, &sd, ed, 0 );

    if  ( sd.sdInExternalItem != DOCinBODY )
	{ LDEB(sd.sdInExternalItem); goto ready;	}

    bodySectBi= docGetSectItem( eo->eoHeadDp.dpBi );
    if  ( ! bodySectBi )
	{ XDEB(bodySectBi); goto ready;	}

    /*  1  */
    if  ( tedDocReplaceSelectionWithField( &dfNote,
					    &headPart, &tailPart, &dsField,
					    &teo, &mbFieldInst, fieldKind,
					    &taSetMask, &taSet ) )
	{ LDEB(1); goto ready;	}

    /*  2  */
    if  ( docMakeNote( &dn, bd, dfNote, bodySectBi, noteInExtIt, fieldKind ) )
	{ LDEB(1); goto ready;	}

    if  ( docCheckNoteSeparatorItem( bd, sepInExtIt ) )
	{ LDEB(1); goto ready;	}

    changed= 0;
    docRenumberNotes( &changed, bd );
    teo.teoEo.eoNotesAdded++;

    if  ( changed )
	{
	docInitRecalculateFields( &rf );

	rf.rfBd= bd;
	rf.rfEi= &(bd->bdBody);
	rf.rfCloseObject= docScreenCloseObject;
	rf.rfUpdateFlags= fieldUpdMask;
	rf.rfFieldsUpdated= 0;

	if  ( docRecalculateTextLevelFields( &rf, bodySectBi ) )
	    { XDEB(fieldUpdMask);	}
	}

    /*  3  */
    docInitRecalculateFields( &rf );

    rf.rfBd= bd;
    rf.rfEi= &(dn->dnDocumentTree);
    rf.rfCloseObject= teo.teoLayoutContext.lcCloseObject;
    rf.rfUpdateFlags= fieldUpdMask;
    rf.rfFieldsUpdated= 0;

    if  ( docRecalculateTextLevelFields( &rf, dn->dnDocumentTree.eiRoot ) )
	{ XDEB(fieldUpdMask);	}

    /*  NO! Is just to setup the note.
    docEditIncludeItemInReformatRange( eo, dn->dnDocumentTree.eiRoot );
    */

    /*  Exclude from Edit operation: In another tree */
    if  ( docScreenLayoutItem( dn->dnDocumentTree.eiRoot,
						    &(teo.teoLayoutContext),
						    &(teo.teoChangedRect) ) )
	{ LDEB(1); goto ready;	}

    /*  4  */
    if  ( tedLayoutFieldItem( &teo, &dsField, fieldUpdMask ) )
	{ LDEB(1); goto ready;	}

    /*  5  */
    if  ( docLastPosition( &dpEnd, dn->dnDocumentTree.eiRoot ) )
	{ LDEB(1); goto ready;	}

    /*  7  */
    dn->dnDocumentTree.eiPageSelectedUpon= sg.sgEnd.pgBasePosition.lpPage;
    dn->dnDocumentTree.eiColumnSelectedIn= sg.sgEnd.pgBasePosition.lpColumn;

    /*  6  */
    tedEditFinishIBarSelection( &teo, dpEnd.dpBi, dpEnd.dpStroff );

    /*  7  */
    dn->dnDocumentTree.eiPageSelectedUpon=
			    dn->dnDocumentTree.eiRoot->biTopPosition.lpPage;
    dn->dnDocumentTree.eiColumnSelectedIn=
			    dn->dnDocumentTree.eiRoot->biTopPosition.lpColumn;

    appDocumentChanged( ed, 1 );

  ready:
    utilCleanMemoryBuffer( &mbFieldInst );

    return;
    }

/************************************************************************/
/*									*/
/*  Change the kind of note for the current selection.			*/
/*									*/
/************************************************************************/

int tedChangeCurrentNote(	EditApplication *	ea,
				const NoteProperties *	npSet )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    DocumentNote *		dn= (DocumentNote *)0;
    DocumentTree *		eiNote= (DocumentTree *)0;

    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);
    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    DocumentField *		dfNote= (DocumentField *)0;
    int				changed= 0;

    tedStartEditOperation( &teo, &sg, &sd, ed, 1 );

    docEditOperationGetSelection( &ds, eo );

    dfNote= docGetSelectedNote( &dn, eo->eoBd, &ds );
    if  ( ! dfNote )
	{ XDEB(dfNote); return -1;	}

    if  ( docEqualNoteProperties( &(dn->dnNoteProperties), npSet ) )
	{ return 0;	}

    if  ( dn->dnNoteProperties.npExternalItemKind != npSet->npExternalItemKind )
	{
	switch( npSet->npExternalItemKind )
	    {
	    case DOCinFOOTNOTE:
		if  ( docCheckNoteSeparatorItem( eo->eoBd, DOCinFTNSEP ) )
		    { LDEB(DOCinFTNSEP); return -1;	}
		break;

	    case DOCinENDNOTE:
		if  ( docCheckNoteSeparatorItem( eo->eoBd, DOCinAFTNSEP ) )
		    { LDEB(DOCinAFTNSEP); return -1;	}
		break;

	    default:
		LDEB(npSet->npExternalItemKind); return -1;
	    }

	eiNote= &(dn->dnDocumentTree);

	if  ( ds.dsSelectionScope.ssInExternalItem ==
				  dn->dnNoteProperties.npExternalItemKind )
	    { ds.dsSelectionScope.ssInExternalItem= npSet->npExternalItemKind; }

	dn->dnNoteProperties.npExternalItemKind= npSet->npExternalItemKind;
	dn->dnNoteNumber= 0;
	eiNote->eiPageFormattedFor= -1;
	eiNote->eiColumnFormattedFor= -1;

	if  ( ! eiNote->eiRoot )
	    { XDEB(eiNote->eiRoot); return -1;	}

	docSetExternalItemKind( eiNote->eiRoot, npSet->npExternalItemKind );
	changed= 1;
	}

    if  ( docCopyNoteProperties( &(dn->dnNoteProperties), npSet ) )
	{ LDEB(1); return -1;	}

    eo->eoFieldUpdate |= FIELDdoCHFTN;
    eo->eoNotesDeleted++;
    eo->eoNotesAdded++;

    if  ( tedEditFinishOldSelection( &teo ) )
	{ LDEB(1);	}

    appDocumentChanged( ed, 1 );

    return 0;
    }

