#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<limits.h>
#   include	<math.h>

#   include	"appMatchFont.h"

#   include	"tedApp.h"
#   include	"tedEdit.h"
#   include	"tedLayout.h"
#   include	"docScreenLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Redo the layout of a paragraph because its contents have changed	*/
/*  during editing.							*/
/*									*/
/************************************************************************/

int tedAdjustParagraphLayout(	TedEditOperation *		teo,
				BufferItem *			paraBi )
    {
    EditOperation *	eo= &(teo->teoEo);
    int			stroffFrom= eo->eoParaAdjustStroffFrom;
    int			stroffShift= eo->eoParaAdjustStroffShift;
    int			stroffUpto= eo->eoParaAdjustStroffUpto;

    LayoutJob		lj;

    if  ( ! teo->teoChangedRectSet )
	{ LDEB(teo->teoChangedRectSet);	}

    docInitLayoutJob( &lj );

    lj.ljContext= teo->teoLayoutContext;
    docSetScreenLayoutFunctions( &lj );
    lj.ljChangedRectanglePixels= &(teo->teoChangedRect);
    lj.ljChangedItem= paraBi;

    lj.ljBodySectBi= eo->eoBodySectBi;

    if  ( docAdjustParaLayout( paraBi, ! eo->eoIBarSelectionOld,
				stroffFrom, stroffShift, stroffUpto, &lj ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

/************************************************************************/

void tedSetLayoutContext(	LayoutContext *		lc,
				EditDocument *		ed )
    {
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    lc->lcScreenWidget= ed->edScreenWidget;
    lc->lcDrawingSurface= ed->edDrawingSurface;
    lc->lcAdd= &(ed->edDocumentWidget.dwDrawingData);
    lc->lcAttributeToScreenFont= &(td->tdAttributeToScreenFont);
    lc->lcPostScriptFontList= &(ea->eaPostScriptFontList);
    lc->lcDocument= td->tdDocument;
    lc->lcCloseObject= docScreenCloseObject;

    lc->lcOx= ed->edVisibleRect.drX0;
    lc->lcOy= ed->edVisibleRect.drY0;

    return;
    }

