/************************************************************************/
/*									*/
/*  Ted: Get/Set/Delete Hyperlinks.					*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   include	"tedEdit.h"
#   include	"docEvalField.h"

#   include	<appDebugon.h>

int tedDocSetHyperlink(	EditDocument *		ed,
			const char *		file,
			const char *		mark )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    DocumentField *		dfHyperlink;
    int				newFileSize= strlen( file );
    int				newMarkSize= 0;

    char *			adaptedMark= (char *)0;

    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);

    TextAttribute		taSet;
    PropertyMask		taSetMask;

    utilInitTextAttribute( &taSet );
    utilPropMaskClear( &taSetMask );

    tedStartEditOperation( &teo, &sg, &sd, ed, 0 );

    docEditOperationGetSelection( &ds, eo );

    if  ( mark )
	{
	adaptedMark= strdup( mark );
	if  ( ! adaptedMark )
	    { XDEB(adaptedMark); return -1;	}

	docAdaptBookmarkName( &newMarkSize, adaptedMark );
	}

    dfHyperlink= docFindTypedFieldForPosition( bd, &(ds.dsHead),
							    DOCfkHYPERLINK );
    if  ( ! dfHyperlink )
	{
	DocumentProperties *	dp= &(bd->bdProperties);

	DocumentSelection	dsRep;
	DocumentSelection	dsHyperlink;
	DocumentSelection	dsInsideLink;
	DocumentSelection	dsAroundLink;
	int			beginMoved= 0;
	int			endMoved= 0;

	unsigned int		whenMask= FIELDdoNOTHING;

	RGB8Color		blueColor;
	int			blueIndex;

	const int		avoidZero= 1;
	const int		maxColors= 255;
	const int		singlePara= 1;

	int			linkStartPart;
	int			linkEndPart;

	bmInitRGB8Color( &blueColor );
	blueColor.rgb8Red= 0;
	blueColor.rgb8Green= 0;
	blueColor.rgb8Blue= 255;

	blueIndex= bmInsertColor( &(dp->dpColors), &(dp->dpColorCount),
					avoidZero, maxColors, &blueColor );
	if  ( blueIndex < 0 )
	    { LDEB(blueIndex);					}
	else{ PROPmaskADD( &taSetMask, TApropTEXT_COLOR );	}

	taSet.taTextColorNumber= blueIndex;
	taSet.taTextIsUnderlined= 1;

	PROPmaskADD( &taSetMask, TApropTEXTUNDERLINED );

	dsRep= ds;

	docConstrainSelectionToOneParagraph( &beginMoved, &endMoved, &dsRep );

	dsHyperlink= dsRep;

	/*  4  */
	if  ( docSurroundTextSelectionByField( &dfHyperlink,
					    &dsInsideLink, &dsAroundLink,
					    &linkStartPart, &linkEndPart,
					    bd, teo.teoEo.eoEi,
					    singlePara, &dsHyperlink,
					    &taSetMask, &taSet ) )
	    { LDEB(1); return -1;	}

	if  ( docFieldSetHyperlink( dfHyperlink, file, newFileSize,
						adaptedMark, newMarkSize ) )
	    { SSDEB(file,adaptedMark); return -1;	}

	dfHyperlink->dfKind= DOCfkHYPERLINK;

	/*  5  */
	if  ( tedFinishSetField( &dsInsideLink, &teo, whenMask ) )
	    { LDEB(1); return -1;	}

	if  ( adaptedMark )
	    { free( adaptedMark );	}

	return 0;
	}
    else{
	if  ( docFieldSetHyperlink( dfHyperlink, file, newFileSize,
						adaptedMark, newMarkSize ) )
	    { SSDEB(file,adaptedMark); return -1;	}

	appDocumentChanged( ed, 1 );

	if  ( adaptedMark )
	    { free( adaptedMark );	}

	return 0;
	}
    }

int tedDocRemoveHyperlink(	EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    DocumentField *		dfHyperlink;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td );

    dfHyperlink= docFindTypedFieldForPosition( bd, &(ds.dsHead),
							    DOCfkHYPERLINK );
    if  ( ! dfHyperlink )
	{ XDEB(dfHyperlink); return -1;	}
    else{
	DocumentProperties *	dp= &(bd->bdProperties);
	BufferItem *		paraBi= ds.dsHead.dpBi;

	DocumentSelection	dsInsideLink;
	DocumentSelection	dsAroundLink;
	int			headPart;
	int			tailPart;

	PropertyMask		foundMask;
	PropertyMask		changeMask;
	TextAttribute		linkAttribute;

	if  ( docDelimitFieldInDoc( &dsInsideLink, &dsAroundLink,
				    &headPart, &tailPart, bd, dfHyperlink ) )
	    { LDEB(1); return -1; }

	utilPropMaskClear( &foundMask );
	utilPropMaskClear( &changeMask );
	PROPmaskADD( &changeMask, TApropTEXT_COLOR );
	PROPmaskADD( &changeMask, TApropTEXTUNDERLINED );
	utilInitTextAttribute( &linkAttribute );

	docGetSelectionAttributes( bd, &dsInsideLink,
					    &foundMask, &linkAttribute );

	utilPropMaskAnd( &changeMask, &changeMask, &foundMask );

	if  ( PROPmaskISSET( &changeMask, TApropTEXTUNDERLINED )	&&
	      ! linkAttribute.taTextIsUnderlined			)
	    { PROPmaskUNSET( &changeMask, TApropTEXTUNDERLINED );	}

	if  ( PROPmaskISSET( &changeMask, TApropTEXT_COLOR )	&&
	      linkAttribute.taTextColorNumber == 0		)
	    { PROPmaskUNSET( &changeMask, TApropTEXT_COLOR );	}

	if  ( PROPmaskISSET( &changeMask, TApropTEXT_COLOR )	)
	    {
	    const RGB8Color *	linkColor;

	    linkColor= dp->dpColors+ linkAttribute.taTextColorNumber;
	    if  ( linkColor->rgb8Red != 0	||
		  linkColor->rgb8Green != 0	||
		  linkColor->rgb8Blue != 255	)
		{ PROPmaskUNSET( &changeMask, TApropTEXT_COLOR );	}
	    }

	linkAttribute.taTextIsUnderlined= 0;
	linkAttribute.taTextColorNumber= 0;

	if  ( ! utilPropMaskIsEmpty( &changeMask ) )
	    {
	    if  ( docChangeParticuleAttributes( &foundMask, bd, paraBi,
			headPart+ 1, tailPart, &linkAttribute, &changeMask ) )
		{ LDEB(1);	}
	    }

	tedFlattenField( ed, &dsAroundLink, headPart, tailPart, dfHyperlink );

	return 0;
	}
    }

