/************************************************************************/
/*									*/
/*  The Frame page of the Format Tool.					*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<limits.h>

#   include	<geoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Refresh the frame page.						*/
/*									*/
/************************************************************************/

static void tedFormatRefreshXPosText(	FrameTool *	ft )
    {
    const FrameProperties *	fp= &(ft->ftPropertiesChosen);

    if  ( fp->fpXPosition == FXposXGIVEN )
	{
	appEnableText( ft->ftXText, 1 );
	appLengthToTextWidget( ft->ftXText,  fp->fpXTwips, ft->ftUnit );
	}
    else{
	appEnableText( ft->ftXText, 0 );
	appStringToTextWidget( ft->ftXText, "" );
	}

    return;
    }

static void tedFormatRefreshYPosText(	FrameTool *	ft )
    {
    const FrameProperties *	fp= &(ft->ftPropertiesChosen);

    if  ( fp->fpYPosition == FYposYGIVEN )
	{
	appEnableText( ft->ftYText, 1 );
	appLengthToTextWidget( ft->ftYText,  fp->fpYTwips, ft->ftUnit );
	}
    else{
	appEnableText( ft->ftYText, 0 );
	appStringToTextWidget( ft->ftYText, "" );
	}

    return;
    }

static void tedFormatToolRefreshFramePage( FrameTool *	ft )
    {
    const FrameProperties *	fp= &(ft->ftPropertiesChosen);

    /*  X  */
    appLengthToTextWidget( ft->ftWidthText, fp->fpWideTwips, ft->ftUnit );

    tedFormatRefreshXPosText( ft );

    appSetOptionmenu( &(ft->ftXRefMenu), fp->fpXReference );
    appSetOptionmenu( &(ft->ftXPosMenu), fp->fpXPosition );

    /*  Y  */
    tedFormatRefreshHeightChooser( &(ft->ftHeightChooser),
						    fp->fpHighTwips );

    tedFormatRefreshYPosText( ft );

    appSetOptionmenu( &(ft->ftYRefMenu), fp->fpYReference );
    appSetOptionmenu( &(ft->ftYPosMenu), fp->fpYPosition );
    }

void tedRefreshFrameTool(	FrameTool *			ft,
				int *				pEnabled,
				int *				pPref,
				InspectorSubject *		is,
				const DocumentSelection *	ds,
				const SelectionDescription *	sd,
				BufferDocument *		bd )
    {
    const BufferItem *		paraBi;

    paraBi= ds->dsHead.dpBi;

if(1)
{ *pEnabled= 0; return;	}

    if  ( ! paraBi || ! sd->sdIsSingleCell )
	{ *pEnabled= 0; return;	}

    docGetFramePropertiesByNumber( &(ft->ftPropertiesSet),
		    &(bd->bdFramePropertyList), paraBi->biParaFrameNumber );

    if  ( DOCisFRAME( &(ft->ftPropertiesSet) ) )
	{ *pPref += 2;	}

    docCopyFrameProperties( &(ft->ftPropertiesChosen),
						&(ft->ftPropertiesSet) );

    tedFormatToolRefreshFramePage( ft );

    appGuiEnableWidget( is->isSelectButton, sd->sdIsSingleFrame );
    appGuiEnableWidget( is->isDeleteButton, sd->sdIsSingleFrame );

    *pEnabled= ! sd->sdDocumentReadonly;
    return;
    }

/************************************************************************/
/*									*/
/*  The 'Change' button of the frame tool has been pushed.		*/
/*									*/
/************************************************************************/

static APP_BUTTON_CALLBACK_H( tedFormatChangeFramePushed, w, voidft )
    {
    FrameTool *			ft= (FrameTool *)voidft;
    FrameProperties *		fp= &(ft->ftPropertiesChosen);

    EditApplication *		ea= ft->ftApplication;
    EditDocument *		ed;
    BufferDocument *		bd= tedFormatCurDoc( &ed, ft->ftApplication );

    ParagraphProperties		pp;
    PropertyMask		ppUpdMask;

    int				changed;

    const int			minPos= INT_MIN;
    const int			minWidth= 1;
    const int			adaptToMin= 0;
    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;

    docInitParagraphProperties( &pp );

    if  ( ! bd )
	{ XDEB(bd); goto ready;	}

    if  ( tedFormatToolGetHeight( &(fp->fpHighTwips),
						&(ft->ftHeightChooser) ) )
	{ goto ready;	}

    if  ( appGetLengthFromTextWidget( ft->ftWidthText,
					    &(fp->fpWideTwips), &changed,
					    UNITtyPOINTS,
					    minWidth, adaptToMin,
					    maxValue, adaptToMax ) )
	{ goto ready;	}

    if  ( fp->fpXPosition == FXposXGIVEN )
	{
	if  ( appGetLengthFromTextWidget( ft->ftXText,
					    &(fp->fpXTwips), &changed,
					    UNITtyPOINTS,
					    minPos, adaptToMin,
					    maxValue, adaptToMax ) )
	    { goto ready;	}
	}

    if  ( fp->fpYPosition == FYposYGIVEN )
	{
	if  ( appGetLengthFromTextWidget( ft->ftYText,
					    &(fp->fpYTwips), &changed,
					    UNITtyPOINTS,
					    minPos, adaptToMin,
					    maxValue, adaptToMax ) )
	    { goto ready;	}
	}

    pp.ppFrameNumber= docFramePropertiesNumber(
					&(bd->bdFramePropertyList), fp );
    if  ( pp.ppFrameNumber < 0 )
	{ LDEB(pp.ppFrameNumber); goto ready;	}

    utilPropMaskClear( &ppUpdMask );
    PROPmaskADD( &ppUpdMask, PPpropFRAME );

    if  ( tedAppChangeParagraphProperties( ea, &ppUpdMask, &pp ) )
	{ LDEB(1); goto ready;	}

  ready:

    docCleanParagraphProperties( &pp );

    return;
    }

/************************************************************************/
/*									*/
/*  The frame height/width changed, check it.				*/
/*									*/
/************************************************************************/

static APP_TXACTIVATE_CALLBACK_H( tedFrameHeightChanged, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    int			value;

    if  ( ! tedFormatToolGetHeight( &value, &(ft->ftHeightChooser) ) )
	{
	tedFormatRefreshHeightChooser( &(ft->ftHeightChooser), value );
	}
    }

static APP_TXACTIVATE_CALLBACK_H( tedFrameWidthChanged, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    FrameProperties *	fp= &(ft->ftPropertiesChosen);

    int			value;
    int			changed;

    tedFormatValidateDimension( &value, &changed,
				    ft->ftWidthText, fp->fpWideTwips );

    return;
    }

static APP_TXACTIVATE_CALLBACK_H( tedFrameXChanged, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    FrameProperties *	fp= &(ft->ftPropertiesChosen);

    int			value;
    int			changed;

    tedFormatValidateDimension( &value, &changed,
				    ft->ftXText, fp->fpXTwips );

    return;
    }

static APP_TXACTIVATE_CALLBACK_H( tedFrameYChanged, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    FrameProperties *	fp= &(ft->ftPropertiesChosen);

    int			value;
    int			changed;

    tedFormatValidateDimension( &value, &changed,
				    ft->ftYText, fp->fpYTwips );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Revert' button of the frame tool has been pushed.		*/
/*									*/
/************************************************************************/

static APP_BUTTON_CALLBACK_H( tedFormatRevertFramePushed, w, voidft )
    {
    FrameTool *	ft= (FrameTool *)voidft;

    docCopyFrameProperties( &(ft->ftPropertiesChosen), &(ft->ftPropertiesSet) );

    tedFormatToolRefreshFramePage( ft );

    return;
    }

static APP_BUTTON_CALLBACK_H( tedFormatSelectFrame, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    EditApplication *	ea= ft->ftApplication;

    tedAppSelectCurrentFrame( ea );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Delete' button of the frame tool has been pushed.		*/
/*									*/
/************************************************************************/

static APP_BUTTON_CALLBACK_H( tedFormatDeleteFrame, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    EditApplication *	ea= ft->ftApplication;

    tedAppDeleteCurrentFrame( ea );

    return;
    }

/************************************************************************/
/*									*/
/*  Insert/Append Row buttons have been pushed.				*/
/*									*/
/************************************************************************/

static APP_BUTTON_CALLBACK_H( tedFormatSetFrame, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    EditApplication *	ea= ft->ftApplication;

    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    LDEB(1);

    appDocumentChanged( ed, 1 );
    }

static APP_BUTTON_CALLBACK_H( tedFormatUnsetFrame, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    EditApplication *	ea= ft->ftApplication;

    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    LDEB(1);

    appDocumentChanged( ed, 1 );
    }

static APP_OITEM_CALLBACK_H( tedFrameHeightChosen, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    HeightChooser *	hc= &(ft->ftHeightChooser);
    int			how;

    int			defaultValue;

    defaultValue= ft->ftPropertiesChosen.fpHighTwips;
    if  ( defaultValue == 0 )
	{ defaultValue= ft->ftPropertiesSet.fpHighTwips;	}
    if  ( defaultValue == 0 )
	{ defaultValue= 240;	}

    how= appGuiGetOptionmenuItemIndex( &(hc->hcOptionmenu), w );
    if  ( how < 0 || how >= HC__COUNT )
	{ LDEB(how); return;	}

    tedFormatHeightChosen( how, hc, defaultValue );

    return;
    }

static APP_OITEM_CALLBACK_H( tedFrameXRefChosen, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    FrameProperties *	fp= &(ft->ftPropertiesChosen);

    int			ref;

    ref= appGuiGetOptionmenuItemIndex( &(ft->ftXRefMenu), w );
    if  ( ref < 0 || ref >= FXref__FRAME_COUNT )
	{ LLDEB(ref,FXref__FRAME_COUNT); return;	}

    fp->fpXReference= ref;

    return;
    }

static APP_OITEM_CALLBACK_H( tedFrameXPosChosen, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    FrameProperties *	fp= &(ft->ftPropertiesChosen);

    int			pos;

    pos= appGuiGetOptionmenuItemIndex( &(ft->ftXPosMenu), w );
    if  ( pos < 0 || pos >= FXpos_COUNT )
	{ LLDEB(pos,FXpos_COUNT); return;	}

    fp->fpXPosition= pos;
    tedFormatRefreshXPosText( ft );

    return;
    }

/************************************************************************/
/*									*/
/*  Combinations of YRef/Ypos:						*/
/*									*/
/************************************************************************/

static APP_OITEM_CALLBACK_H( tedFrameYRefChosen, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    FrameProperties *	fp= &(ft->ftPropertiesChosen);

    int			ref;

    ref= appGuiGetOptionmenuItemIndex( &(ft->ftYRefMenu), w );
    if  ( ref < 0 || ref >= FYref__FRAME_COUNT )
	{ LLDEB(ref,FYref__FRAME_COUNT); return;	}

    fp->fpYReference= ref;

    if  ( ! docFrameYAllowed[fp->fpYPosition][fp->fpYReference] )
	{
	int	pos;

	for ( pos= 0; pos < FYpos_COUNT; pos++ )
	    {
	    if  ( docFrameYAllowed[pos][ref] )
		{
		fp->fpYPosition= pos;
		appSetOptionmenu( &(ft->ftYPosMenu), fp->fpYPosition );
		tedFormatRefreshYPosText( ft );
		}
	    }
	}

    return;
    }

static APP_OITEM_CALLBACK_H( tedFrameYPosChosen, w, voidft )
    {
    FrameTool *		ft= (FrameTool *)voidft;
    FrameProperties *	fp= &(ft->ftPropertiesChosen);

    int			pos;

    pos= appGuiGetOptionmenuItemIndex( &(ft->ftYPosMenu), w );
    if  ( pos < 0 || pos >= FYpos_COUNT )
	{ LLDEB(pos,FYpos_COUNT); return;	}

    fp->fpYPosition= pos;
    tedFormatRefreshYPosText( ft );

    if  ( ! docFrameYAllowed[fp->fpYPosition][fp->fpYReference] )
	{
	int		ref;

	for ( ref= 0; ref < FYref__FRAME_COUNT; ref++ )
	    {
	    if  ( docFrameYAllowed[pos][ref] )
		{
		fp->fpYReference= ref;
		appSetOptionmenu( &(ft->ftYRefMenu), fp->fpYReference );
		}
	    }
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Make the controls to select a frame position.			*/
/*									*/
/************************************************************************/

static void tedFillFramePositionTool(
				APP_WIDGET *			pRow,
				APP_WIDGET *			pText,
				void *				through,
				APP_WIDGET			parent,
				AppOptionmenu *			aom,
				APP_TXACTIVATE_CALLBACK_T	callback )
    {
    APP_WIDGET	row;
    APP_WIDGET	text;

    const int	menuColumn= 0;
    const int	menuColspan= 1;
    const int	textColumn= menuColumn+ menuColspan;
    const int	textColspan= 1;
    const int	heightResizable= 0;

    row= appMakeRowInColumn( parent, 2, heightResizable );

    appMakeOptionmenuInRow( aom, row, menuColumn, menuColspan );

    appMakeTextInRow( &text, row, textColumn, textColspan, 10, 0 );

    if  ( callback )
	{ appGuiSetGotValueCallbackForText( text, callback, through ); }

    *pRow= row;
    *pText= text;

    return;
    }

/************************************************************************/
/*									*/
/*  Make the frame that controls the horizontal position and size.	*/
/*									*/
/************************************************************************/

static void tedFrameToolMakeHorizontalGroup(
			    FrameTool *				ft,
			    const FramePageResources *		fpr,
			    APP_WIDGET				pageWidget )
    {
    APP_WIDGET	label;
    APP_WIDGET	row;

    const int	textColumns= 9;

    appMakeColumnFrameInColumn( &(ft->ftHorizontalFrame),
				&(ft->ftHorizontalPaned),
				pageWidget, fpr->fprHorizontal );

    appMakeLabelAndTextRow( &row, &(ft->ftWidthLabel), &(ft->ftWidthText),
				ft->ftHorizontalPaned,
				fpr->fprWidth, textColumns, 1 );
    appGuiSetGotValueCallbackForText( ft->ftWidthText,
				tedFrameWidthChanged, (void *)ft );


    tedFillFramePositionTool( &row, &(ft->ftXText), (void *)ft,
				ft->ftHorizontalPaned,
				&(ft->ftXPosMenu),
				tedFrameXChanged );

    appInspectorMakeMenuRow( &row, &(ft->ftXRefMenu),
				&label, ft->ftHorizontalPaned,
				fpr->fprXReference );
    return;
    }

/************************************************************************/
/*									*/
/*  Make the frame that controls the fertical position and size.	*/
/*									*/
/************************************************************************/

static void tedFrameToolMakeVerticalGroup(
			    FrameTool *				ft,
			    const FramePageResources *		fpr,
			    APP_WIDGET				pageWidget )
    {
    APP_WIDGET	label;
    APP_WIDGET	row;

    appMakeColumnFrameInColumn( &(ft->ftVerticalFrame),
				&(ft->ftVerticalPaned),
				pageWidget, fpr->fprVertical );

    tedFormatMakeHeightRow( &row, ft, ft->ftVerticalPaned,
				&(ft->ftHeightChooser),
				tedFrameHeightChanged );

    tedFillFramePositionTool( &row, &(ft->ftYText), (void *)ft,
				ft->ftVerticalPaned,
				&(ft->ftYPosMenu),
				tedFrameYChanged );

    appInspectorMakeMenuRow( &row, &(ft->ftYRefMenu),
				&label, ft->ftVerticalPaned,
				fpr->fprYReference );

    return;
    }

/************************************************************************/
/*									*/
/*  Make a frame tool. I.E. the 'Frame' page of the format tool.	*/
/*									*/
/************************************************************************/

void tedFormatFillFramePage( FrameTool *			ft,
			    const FramePageResources *		fpr,
			    AppInspector *			ai,
			    int					subjectPage,
			    InspectorSubject *			is,
			    APP_WIDGET				pageWidget,
			    const InspectorSubjectResources *	isr )
    {
    APP_WIDGET	row;

    /**/
    is->isPrivate= ft;

    ft->ftPageResources= fpr;

    /**************/
    tedFrameToolMakeHorizontalGroup( ft, fpr, pageWidget );
    tedFrameToolMakeVerticalGroup( ft, fpr, pageWidget );

    /**************/
    appInspectorMakeButtonRow( &row, pageWidget,
	    &(is->isSelectButton), &(is->isDeleteButton),
	    isr->isrSelectButtonText, isr->isrDeleteButtonText,
	    tedFormatSelectFrame, tedFormatDeleteFrame, (void *)ft );

    appInspectorMakeButtonRow( &row, pageWidget,
	    &(is->isInsertButton), &(is->isAppendButton),
	    isr->isrInsertButtonText, isr->isrAppendButtonText,
	    tedFormatSetFrame, tedFormatUnsetFrame, (void *)ft );

    appInspectorMakeButtonRow( &row, pageWidget,
	    &(is->isRevertButton), &(is->isApplyButton),
	    isr->isrRevert, isr->isrApplyToSubject,
	    tedFormatRevertFramePushed,
	    tedFormatChangeFramePushed, (void *)ft );

    return;
    }

void tedFrameToolFillChoosers(		FrameTool *			ft,
					const FramePageResources *	fpr )
    {
    tedFormatFillHeightChooser( &(ft->ftHeightChooser),
					    tedFrameHeightChosen, (void *)ft,
					    fpr->fprHeightFree,
					    fpr->fprHeightAtLeast,
					    fpr->fprHeightExactly );

    appFillInspectorMenu( FXref__FRAME_COUNT, FXrefCOLUMN,
					    ft->ftXRefItems,
					    fpr->fprXRefItemTexts,
					    &(ft->ftXRefMenu),
					    tedFrameXRefChosen, (void *)ft );

    appFillInspectorMenu( FXpos_COUNT, FXposXL,
					    ft->ftXPosItems,
					    fpr->fprXPosItemTexts,
					    &(ft->ftXPosMenu),
					    tedFrameXPosChosen, (void *)ft );

    appFillInspectorMenu( FYref__FRAME_COUNT, FYrefMARGIN,
					    ft->ftYRefItems,
					    fpr->fprYRefItemTexts,
					    &(ft->ftYRefMenu),
					    tedFrameYRefChosen, (void *)ft );

    appFillInspectorMenu( FYpos_COUNT, FYposYT,
					    ft->ftYPosItems,
					    fpr->fprYPosItemTexts,
					    &(ft->ftYPosMenu),
					    tedFrameYPosChosen, (void *)ft );

    }

void tedFinishFrameTool( 	FrameTool *			ft,
				const FramePageResources *	fpr )
    {
    appOptionmenuRefreshWidth( &(ft->ftHeightChooser.hcOptionmenu) );

    appOptionmenuRefreshWidth( &(ft->ftXRefMenu) );
    appOptionmenuRefreshWidth( &(ft->ftXPosMenu) );

    appOptionmenuRefreshWidth( &(ft->ftYRefMenu) );
    appOptionmenuRefreshWidth( &(ft->ftYPosMenu) );
    }

/************************************************************************/
/*									*/
/*  Clean a frame tool.							*/
/*									*/
/************************************************************************/

void tedInitFrameTool(	FrameTool *	ft )
    {
    ft->ftApplication= (EditApplication *)0;
    ft->ftInspector= (AppInspector *)0;
    ft->ftPageResources= (const FramePageResources *)0;

    ft->ftUnit= UNITtyPOINTS;

    docInitFrameProperties( &(ft->ftPropertiesSet) );
    docInitFrameProperties( &(ft->ftPropertiesChosen) );

    ft->ftWidthLabel= (APP_WIDGET)0;
    ft->ftWidthText= (APP_WIDGET)0;

    tedInitHeightChooser( &(ft->ftHeightChooser) );

    appInitOptionmenu( &(ft->ftXRefMenu) );
    appInitOptionmenu( &(ft->ftYRefMenu) );

    ft->ftXText= (APP_WIDGET)0;
    ft->ftYText= (APP_WIDGET)0;

    return;
    }

void tedCleanFrameTool(	FrameTool *	ft )
    {
    docCleanFrameProperties( &(ft->ftPropertiesSet) );
    docCleanFrameProperties( &(ft->ftPropertiesChosen) );

    return;
    }

/************************************************************************/
/*									*/
/*  Get frame tool resources.						*/
/*									*/
/************************************************************************/

static AppConfigurableResource TED_TedFrameSubjectResourceTable[]=
    {
    APP_RESOURCE( "tableToolFrame",
		offsetof(InspectorSubjectResources,isrSubjectName),
		"Frame" ),
    APP_RESOURCE( "frameToolChangeRow",
		offsetof(InspectorSubjectResources,isrApplyToSubject),
		"Apply" ),
    APP_RESOURCE( "frameToolRevert",
		offsetof(InspectorSubjectResources,isrRevert),
		"Revert" ),
    APP_RESOURCE( "frameToolSelectFrame",
		offsetof(InspectorSubjectResources,isrSelectButtonText),
		"Select Frame" ),
    APP_RESOURCE( "frameToolDeleteFrame",
		offsetof(InspectorSubjectResources,isrDeleteButtonText),
		"Delete Frame" ),
    APP_RESOURCE( "frameToolInsertRow",
		offsetof(InspectorSubjectResources,isrInsertButtonText),
		"Insert Row" ),
    APP_RESOURCE( "frameToolAppendRow",
		offsetof(InspectorSubjectResources,isrAppendButtonText),
		"Append Row" ),
    };

static AppConfigurableResource TED_TedFrameToolResourceTable[]=
    {
    APP_RESOURCE( "frameToolHorizontal",
	    offsetof(FramePageResources,fprHorizontal),
	    "Horizontal" ),
    APP_RESOURCE( "frameToolVertical",
	    offsetof(FramePageResources,fprVertical),
	    "Vertical" ),

    APP_RESOURCE( "frameToolWidth",
	    offsetof(FramePageResources,fprWidth),
	    "Width" ),

    /**/
    APP_RESOURCE( "frameToolHeightFree",
	    offsetof(FramePageResources,fprHeightFree),
	    "Height Free" ),
    APP_RESOURCE( "frameToolHeightExactly",
	    offsetof(FramePageResources,fprHeightExactly),
	    "Height Exactly" ),
    APP_RESOURCE( "frameToolHeightAtLeast",
	    offsetof(FramePageResources,fprHeightAtLeast),
	    "Height at Least" ),

    /**/
    APP_RESOURCE( "frameToolXPosGiven",
		offsetof(FramePageResources,fprXPosItemTexts[FXposXGIVEN]),
		"X at" ),
    APP_RESOURCE( "frameToolXPosLeft",
		offsetof(FramePageResources,fprXPosItemTexts[FXposXL]),
		"X Left" ),
    APP_RESOURCE( "frameToolXPosRight",
		offsetof(FramePageResources,fprXPosItemTexts[FXposXR]),
		"X Right" ),
    APP_RESOURCE( "frameToolXPosCenter",
		offsetof(FramePageResources,fprXPosItemTexts[FXposXC]),
		"X Centered" ),
    APP_RESOURCE( "frameToolXPosInside",
		offsetof(FramePageResources,fprXPosItemTexts[FXposXI]),
		"X Inside" ),
    APP_RESOURCE( "frameToolXPosOutside",
		offsetof(FramePageResources,fprXPosItemTexts[FXposXO]),
		"X Outside" ),
    APP_RESOURCE( "frameToolXReference",
	    offsetof(FramePageResources,fprXReference),
	    "Relative To" ),
    APP_RESOURCE( "frameToolXRefColumn",
		offsetof(FramePageResources,fprXRefItemTexts[FXrefCOLUMN]),
		"Column" ),
    APP_RESOURCE( "frameToolXRefPage",
		offsetof(FramePageResources,fprXRefItemTexts[FXrefPAGE]),
		"Page" ),
    APP_RESOURCE( "frameToolXRefMargin",
		offsetof(FramePageResources,fprXRefItemTexts[FXrefMARGIN]),
		"Margin" ),
    APP_RESOURCE( "frameToolYPosGiven",
		offsetof(FramePageResources,fprYPosItemTexts[FYposYGIVEN]),
		"Y at" ),
    APP_RESOURCE( "frameToolYPosInside",
		offsetof(FramePageResources,fprYPosItemTexts[FYposYIN]),
		"Y Inside" ),
    APP_RESOURCE( "frameToolYPosOutside",
		offsetof(FramePageResources,fprYPosItemTexts[FYposYOUT]),
		"Y Outside" ),
    APP_RESOURCE( "frameToolYPosTop",
		offsetof(FramePageResources,fprYPosItemTexts[FYposYT]),
		"Y at Top" ),
    APP_RESOURCE( "frameToolYPosCenter",
		offsetof(FramePageResources,fprYPosItemTexts[FYposYC]),
		"Y at Center" ),
    APP_RESOURCE( "frameToolYPosBottom",
		offsetof(FramePageResources,fprYPosItemTexts[FYposYB]),
		"Y at Bottom" ),
    APP_RESOURCE( "frameToolYReference",
	    offsetof(FramePageResources,fprYReference),
	    "Relative To" ),
    APP_RESOURCE( "frameToolYRefMargin",
		offsetof(FramePageResources,fprYRefItemTexts[FYrefMARGIN]),
		"Margin" ),
    APP_RESOURCE( "frameToolYRefPage",
		offsetof(FramePageResources,fprYRefItemTexts[FYrefPAGE]),
		"Page" ),
    APP_RESOURCE( "frameToolYRefParagraph",
		offsetof(FramePageResources,fprYRefItemTexts[FYrefPARA]),
		"Paragraph" ),
    };

void tedFrameToolGetResourceTable(	EditApplication *		ea,
					FramePageResources *		fpr,
					InspectorSubjectResources *	isr )
    {
    static int	gotToolResources= 0;
    static int	gotSubjectResources= 0;

    if  ( ! gotToolResources )
	{
	appGuiGetResourceValues( &gotToolResources, ea, (void *)fpr,
				TED_TedFrameToolResourceTable,
				sizeof(TED_TedFrameToolResourceTable)/
				sizeof(AppConfigurableResource) );
	}

    if  ( ! gotSubjectResources )
	{
	appGuiGetResourceValues( &gotSubjectResources, ea, (void *)isr,
				TED_TedFrameSubjectResourceTable,
				sizeof(TED_TedFrameSubjectResourceTable)/
				sizeof(AppConfigurableResource) );
	}

    return;
    }
