/************************************************************************/
/*									*/
/*  Format changes to the document/selection.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"docLayout.h"
#   include	"tedEdit.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Change the attributes of the selection.				*/
/*									*/
/*  A)  Exclude properties that are derived from a list from the task.	*/
/*  1)  Adjust the start line for recalculating the layout of the first	*/
/*	paragraph in the selection.					*/
/*  2)  If necessary, split the first particule to change the text	*/
/*	attributes of the second half.					*/
/*  3)  For all paragraphs in the selection upto the last one..		*/
/*  4)  Change the text attributes.					*/
/*									*/
/************************************************************************/

static int tedChangeParaProperties( TedEditOperation *		teo,
				    PropertyMask *		pPpChgMask,
				    PropertyMask *		pTaChgMask,
				    BufferItem *		paraBi,
				    int				partFrom,
				    int				partUpto,
				    const PropertyMask *	taSetMask,
				    const TextAttribute *	taSet,
				    const PropertyMask *	ppSetMask,
				    const ParagraphProperties *	ppNew )
    {
    const LayoutContext *	lc= &(teo->teoLayoutContext);
    BufferDocument *		bd= lc->lcDocument;

    PropertyMask		ppChgMask;
    PropertyMask		ppSetMaskThisPara;
    PropertyMask		taDoneMask;

    ppSetMaskThisPara= *ppSetMask;

    utilPropMaskClear( &ppChgMask );
    utilPropMaskClear( &taDoneMask );

    /*  A  */
    if  ( paraBi->biParaListOverride > 0 )
	{
	int		override= -1;

	DocumentField *		dfHead= (DocumentField *)0;
	DocumentSelection	dsInsideHead;
	DocumentSelection	dsAroundHead;
	int			bulletPartBegin= -1;
	int			bulletPartEnd= -1;

	override= paraBi->biParaListOverride;

	if  ( docDelimitParaHeadField( &dfHead,
			    &dsInsideHead, &dsAroundHead,
			    &bulletPartBegin, &bulletPartEnd, paraBi, bd ) )
	    { LDEB(1);	}

	if  ( partFrom <= bulletPartEnd )
	    { partFrom= bulletPartEnd+ 1;	}

	PROPmaskUNSET( &ppSetMaskThisPara, PPpropLEFT_INDENT );
	PROPmaskUNSET( &ppSetMaskThisPara, PPpropFIRST_INDENT );
	}

    if  ( ! utilPropMaskIsEmpty( taSetMask ) )
	{
	if  ( tedChangeParticuleAttributes( &taDoneMask, lc,
						paraBi, partFrom, partUpto,
						taSet, taSetMask ) )
	    { LLDEB(partFrom,partUpto); return -1;	}
	}

    if  ( ! utilPropMaskIsEmpty( &ppSetMaskThisPara ) )
	{
	if  ( docEditUpdParaProperties( &(teo->teoEo), &ppChgMask, paraBi,
					&ppSetMaskThisPara, ppNew,
					(const DocumentAttributeMap *)0 ) )
	    { LDEB(1); return -1;	}
	}

    *pTaChgMask= taDoneMask;
    *pPpChgMask= ppChgMask;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Use the new ruler settings, or other geometry properties of a	*/
/*  BufferItem.								*/
/*									*/
/************************************************************************/

static void tedApplyItemFormat(	TedEditOperation *		teo,
				BufferItem *			bi )
    {
    const LayoutContext *	lc= &(teo->teoLayoutContext);
    DocumentRectangle		drLocal;

    const LayoutPosition *	lpBelow= &(bi->biBelowPosition);

    if  ( docIsRowItem( bi ) )
	{ lpBelow= &(bi->biRowBelowAllPosition); }

    docGetPixelRectForPos( &drLocal, lc,
				lc->lcAdd->addBackRect.drX0,
				lc->lcAdd->addBackRect.drX1,
				&(bi->biTopPosition), lpBelow );

    tedIncludeRectangleInChange( teo, &drLocal );

    docEditIncludeItemInReformatRange( &(teo->teoEo), bi );

    return;
    }

/************************************************************************/
/*									*/
/*  Change properties of the current selection.				*/
/*									*/
/************************************************************************/

int tedChangeSelectionProperties( EditDocument *		ed,
				const PropertyMask *		taSetMaskCall,
				const TextAttribute *		taSet,
				const PropertyMask *		ppSetMask,
				const ParagraphProperties *	ppNew,
				const PropertyMask *		spSetMask,
				const SectionProperties *	spNew )
    {
    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    int				part;
    int				part1;

    TextParticule *		tp;

    BufferItem *		paraBi;
    BufferItem *		sectBi= (BufferItem *)0;

    int				firstParticuleSplit= 0;

    PropertyMask		taSetMask;

    PropertyMask		selTaChgMask;
    PropertyMask		selPpChgMask;
    PropertyMask		selSpChgMask;

    PropertyMask		paraTaChgMask;
    PropertyMask		paraPpChgMask;
    PropertyMask		sectSpChgMask;

    PropertyMask		pmSplit;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);
    const BufferItem *		bodySectBi= (const BufferItem *)0;

    int				redoParaLayout= 1;

    tedStartEditOperation( &teo, &sg, &sd, ed, 1 );
    bodySectBi= teo.teoEo.eoBodySectBi;

    docEditOperationGetSelection( &ds, eo );

    taSetMask= *taSetMaskCall;

    utilPropMaskClear( &selTaChgMask );
    utilPropMaskClear( &selPpChgMask );
    utilPropMaskClear( &selSpChgMask );

    if  ( ! ds.dsHead.dpBi || ! ds.dsTail.dpBi )
	{ XXDEB(ds.dsHead.dpBi,ds.dsTail.dpBi); return -1; }

    if  ( docIsIBarSelection( &ds ) )
	{ utilPropMaskClear( &taSetMask );	}

    if  ( sd.sdIsSingleParagraph		&&
	  utilPropMaskIsEmpty( ppSetMask )	&&
	  utilPropMaskIsEmpty( spSetMask )	)
	{
	const int	stroffShift= 0;

	redoParaLayout= 0;

	docSetParagraphAdjust( &(teo.teoEo), ds.dsHead.dpBi,
					    stroffShift, ds.dsTail.dpStroff );
	}

    paraBi= ds.dsHead.dpBi;
    if  ( docFindParticuleOfPosition( &part, &(ds.dsHead), 1 ) )
	{ LDEB(ds.dsHead.dpStroff); return -1;	}
    if  ( docFindParticuleOfPosition( &part1, &(ds.dsTail), 0 ) )
	{ LDEB(ds.dsTail.dpStroff); return -1;	}

    /*  0  */
    if  ( PROPmaskISSET( &taSetMask, TApropDOC_FONT_NUMBER ) )
	{ docRememberFontUsed( bd, taSet );	}

    /*  1  */
    tp= paraBi->biParaParticules+ part;

    /*  2  */
    utilPropMaskClear( &pmSplit );
    if  ( (unsigned)ds.dsHead.dpStroff > tp->tpStroff )
	{
	TextAttribute	ta;

	utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
						tp->tpTextAttrNr );

	utilAttributeDifference( &pmSplit, &ta, taSet, &taSetMask );
	}

    if  ( ! utilPropMaskIsEmpty( &pmSplit ) )
	{
	int		stroff= ds.dsHead.dpStroff;

	if  ( (unsigned)stroff < tp->tpStroff+ tp->tpStrlen )
	    {
	    TextParticule *	oldTp;

	    if  ( docSplitTextParticule( &oldTp, &tp, paraBi, part, stroff ) )
		{ LDEB(part); return -1;	}

	    part++;

	    if  ( ds.dsTail.dpBi == paraBi )
		{ firstParticuleSplit= 1;	}
	    }
	else{ tp++; part++; }
	}

    utilPropMaskClear( &sectSpChgMask );

    sectBi= paraBi->biParent->biParent->biParent;
    if  ( ! utilPropMaskIsEmpty( spSetMask ) )
	{
	int	redraw= 0;

	if  ( docChangeSectionProperties( &sectSpChgMask, &redraw, bd, sectBi,
							spSetMask, spNew ) )
	    { XDEB(spSetMask); return -1;	}

	if  ( redraw )
	    { tedIncludeRectangleInChange( &teo, &(add->addBackRect) ); }

	utilPropMaskOr( &selSpChgMask, &selSpChgMask, &sectSpChgMask );
	}

    if  ( sectBi->biInExternalItem == DOCinBODY )
	{ bodySectBi= sectBi;	}

    /*  3  */
    while( paraBi != ds.dsTail.dpBi )
	{
	int	col;
	int	partUpto= paraBi->biParaParticuleCount;

	col= paraBi->biParent->biNumberInParent;

	if  ( ds.dsCol0 < 0					||
	      ds.dsCol1 < 0					||
	      ( col >= ds.dsCol0 && col <= ds.dsCol1 )	)
	    {
	    /*  4  */
	    if  ( tedChangeParaProperties( &teo, &paraPpChgMask, &paraTaChgMask,
				    paraBi, part, partUpto,
				    &taSetMask, taSet, ppSetMask, ppNew ) )
		{ LDEB(1);	}

	    if  ( sectBi != paraBi->biParent->biParent->biParent )
		{
		if  ( ! utilPropMaskIsEmpty( &sectSpChgMask ) )
		    { tedApplyItemFormat( &teo, sectBi );	}

		sectBi= paraBi->biParent->biParent->biParent;
		if  ( ! utilPropMaskIsEmpty( spSetMask ) )
		    {
		    int		redraw= 0;

		    if  ( docChangeSectionProperties( &sectSpChgMask, &redraw,
						bd, sectBi, spSetMask, spNew ) )
			{ XDEB(spSetMask); return -1;	}

		    if  ( redraw )
			{
			tedIncludeRectangleInChange( &teo,
						    &(add->addBackRect) );
			}

		    utilPropMaskOr( &selSpChgMask,
					    &selSpChgMask, &sectSpChgMask );
		    }
		if  ( sectBi->biInExternalItem == DOCinBODY )
		    { bodySectBi= sectBi;	}
		}

	    if  ( ! utilPropMaskIsEmpty( &paraPpChgMask )	||
		  ! utilPropMaskIsEmpty( &paraTaChgMask )	)
		{
		if  ( redoParaLayout )
		    { tedApplyItemFormat( &teo, paraBi );	}

		utilPropMaskOr( &selTaChgMask, &selTaChgMask, &paraTaChgMask );
		utilPropMaskOr( &selPpChgMask, &selPpChgMask, &paraPpChgMask );
		}
	    }

	paraBi= docNextParagraph( paraBi );
	if  ( ! paraBi )
	    { XDEB(paraBi); return -1;	}

	part= 0; firstParticuleSplit= 0;
	}

    /*  4  */
    if  ( tedChangeParaProperties( &teo, &paraPpChgMask, &paraTaChgMask, paraBi,
			part, part1+ firstParticuleSplit,
			&taSetMask, taSet, ppSetMask, ppNew ) )
	{ LDEB(1);	}

    part= part1+ firstParticuleSplit;
    tp= paraBi->biParaParticules+ part;

    if  ( sectBi != paraBi->biParent->biParent->biParent )
	{
	if  ( ! utilPropMaskIsEmpty( &sectSpChgMask ) )
	    { tedApplyItemFormat( &teo, sectBi ); }

	sectBi= paraBi->biParent->biParent->biParent;
	if  ( ! utilPropMaskIsEmpty( spSetMask ) )
	    {
	    int		redraw= 0;

	    if  ( docChangeSectionProperties( &sectSpChgMask, &redraw,
					    bd, sectBi, spSetMask, spNew ) )
		{ XDEB(spSetMask); return -1;	}

	    if  ( redraw )
		{ tedIncludeRectangleInChange( &teo, &(add->addBackRect) ); }

	    utilPropMaskOr( &selSpChgMask, &selSpChgMask, &sectSpChgMask );
	    }
	if  ( sectBi->biInExternalItem == DOCinBODY )
	    { bodySectBi= sectBi;	}
	}

    if  ( ! utilPropMaskIsEmpty( &sectSpChgMask ) )
	{ tedApplyItemFormat( &teo, sectBi ); }

    utilPropMaskClear( &pmSplit );
    if  ( part < paraBi->biParaParticuleCount )
	{
	TextAttribute	ta;

	utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
						tp->tpTextAttrNr );

	utilAttributeDifference( &pmSplit, &ta, taSet, &taSetMask );
	}

    if  ( ! utilPropMaskIsEmpty( &pmSplit ) )
	{
	int	strend= tp->tpStroff+ tp->tpStrlen;

	if  ( ds.dsTail.dpStroff < strend )
	    {
	    TextParticule *	tpNext;

	    if  ( docSplitTextParticule( &tp, &tpNext,
					paraBi, part, ds.dsTail.dpStroff ) )
		{ LDEB(1); return -1;	}
	    }

	utilPropMaskClear( &pmSplit );

	/*  2  */
	if  ( tedChangeParticuleAttributes( &pmSplit, &(teo.teoLayoutContext),
						    paraBi, part, part+ 1,
						    taSet, &taSetMask ) )
	    { LDEB(1);	}

	utilPropMaskOr( &paraTaChgMask, &paraTaChgMask, &pmSplit );
	}

    if  ( ! utilPropMaskIsEmpty( &paraPpChgMask )	||
	  ! utilPropMaskIsEmpty( &paraTaChgMask )	)
	{
	if  ( redoParaLayout )
	    { tedApplyItemFormat( &teo, paraBi );	}

	utilPropMaskOr( &selPpChgMask, &selPpChgMask, &paraPpChgMask );
	utilPropMaskOr( &selTaChgMask, &selTaChgMask, &paraTaChgMask );
	}

    if  ( ! utilPropMaskIsEmpty( &selPpChgMask )	||
	  ! utilPropMaskIsEmpty( &selTaChgMask )	||
	  ! utilPropMaskIsEmpty( &selSpChgMask )	)
	{
	PropertyMask	taDoneMask;

	utilPropMaskClear( &taDoneMask );

	utilUpdateTextAttribute( &taDoneMask, &(teo.teoSavedTextAttribute),
							taSet, taSetMaskCall );
	if  ( ! utilPropMaskIsEmpty( &taDoneMask ) )
	    {
	    teo.teoSavedTextAttributeNumber=
		    utilTextAttributeNumber( &(bd->bdTextAttributeList),
						&(teo.teoSavedTextAttribute) );
	    }

	if  ( tedEditFinishOldSelection( &teo ) )
	    { LDEB(1);	}

	tedAdaptToolsToSelection( ed );

	appDocumentChanged( ed, 1 );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Utility routines around tedChangeSelectionProperties():		*/
/*									*/
/************************************************************************/

int tedAppChangeSectionProperties( EditApplication *		ea,
				const PropertyMask *		spSetMask,
				const SectionProperties *	spNew )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    TextAttribute		taSet;

    PropertyMask		taUpdMask;
    PropertyMask		ppSetMask;

    utilPropMaskClear( &taUpdMask );
    utilPropMaskClear( &ppSetMask );

    utilInitTextAttribute ( &taSet );

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    if  ( tedChangeSelectionProperties( ed,
				    &taUpdMask, &taSet,
				    &ppSetMask, (ParagraphProperties *)0,
				    spSetMask, spNew ) )
	{ XDEB(spSetMask); return -1;	}

    return 0;
    }

int tedDocChangeParagraphProperties(
				EditDocument *			ed,
				const PropertyMask *		ppSetMask,
				const ParagraphProperties *	ppNew )
    {
    TextAttribute		taSet;

    PropertyMask		taUpdMask;
    PropertyMask		spSetMask;

    utilPropMaskClear( &taUpdMask );
    utilPropMaskClear( &spSetMask );

    utilInitTextAttribute ( &taSet );

    if  ( tedChangeSelectionProperties( ed,
				    &taUpdMask, &taSet,
				    ppSetMask, ppNew,
				    &spSetMask, (SectionProperties *)0 ) )
	{ XDEB(ppSetMask); return -1;	}

    return 0;
    }

int tedAppChangeParagraphProperties(
				EditApplication *		ea,
				const PropertyMask *		ppSetMask,
				const ParagraphProperties *	ppNew )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocChangeParagraphProperties( ed, ppSetMask, ppNew );
    }

/************************************************************************/
/*									*/
/*  Make a new list and set it as the list of the current selection.	*/
/*									*/
/************************************************************************/

static int tedDocSetNewList(	EditDocument *	ed )
    {
    int				rval= 0;
    PropertyMask		ppSetMask;
    ParagraphProperties		ppNew;
    int				ls;
    int				lsExample= -1;

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    PropertyMask		taSetMask;
    TextAttribute		taNew;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    utilPropMaskClear( &ppSetMask );
    utilInitTextAttribute( &taNew );

    utilPropMaskClear( &ppSetMask );
    docInitParagraphProperties( &ppNew );

    PROPmaskADD( &ppSetMask, PPpropLISTOVERRIDE );

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ LDEB(1); rval= -1; goto ready;	}

    if  ( sd.sdHasLists		&&
	  ! sd.sdMultiList	&&
	  sd.sdListOverride > 0	)
	{ lsExample= sd.sdListOverride;	}

    utilPropMaskFill( &taSetMask, TAprop_COUNT );
    taNew= td->tdCurrentTextAttribute;

    PROPmaskUNSET( &taSetMask, TApropSUPERSUB );
    PROPmaskUNSET( &taSetMask, TApropSMALLCAPS );
    PROPmaskUNSET( &taSetMask, TApropCAPITALS );
    PROPmaskUNSET( &taSetMask, TApropSTRIKETHROUGH );
    PROPmaskUNSET( &taSetMask, TApropTEXT_COLOR );
    PROPmaskUNSET( &taSetMask, TApropTEXT_STYLE );

    if  ( docNewList( &ls, lsExample, bd, &taSetMask, &taNew ) )
	{ LDEB(1); rval= -1; goto ready;	}

    ppNew.ppListOverride= ls;

    rval= tedDocChangeParagraphProperties( ed, &ppSetMask, &ppNew );
    if  ( rval )
	{ LLDEB(ls,rval);	}

  ready:

    docCleanParagraphProperties( &ppNew );

    return rval;
    }

int tedAppSetNewList(	EditApplication *		ea )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocSetNewList( ed );
    }

/************************************************************************/
/*									*/
/*  Adapt format tool to the circumstances.				*/
/*									*/
/************************************************************************/

void tedAdaptFormatToolToDocument(	EditDocument *	ed,
					int		choosePage )
    {
    EditApplication *		ea= ed->edApplication;
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentTree *		ei;
    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    if  ( ! tar->tarInspector )
	{ return;	}

    if  ( tedGetSelection( &ds, &sg, &sd, &ei, (const BufferItem **)0, td ) )
	{ LDEB(1); return;	}

    tedFormatToolAdaptToSelection( tar->tarInspector, ed, choosePage,
							ei, &ds, &sg, &sd );

    return;
    }

/************************************************************************/
/*									*/
/*  Get a suggestion about the line height: Used for the initial value	*/
/*  for space before/after in the format tool.				*/
/*									*/
/************************************************************************/

int tedGetParaLineHeight(	int *			pLineHeight,
				EditDocument *		ed )
    {
    EditApplication *		ea= ed->edApplication;
    const PostScriptFontList *	psfl= &(ea->eaPostScriptFontList);

    TedDocument *		td;
    BufferDocument *		bd;
    AppDrawingData *		add;

    BufferItem *		paraBi;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;
    int				fontSize= 0;

    add= &(ed->edDocumentWidget.dwDrawingData);
    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ LDEB(1); return -1;	}

    paraBi= ds.dsHead.dpBi;

    if  ( docLayoutParagraphLineExtents( &fontSize, bd, psfl, paraBi ) )
	{ LDEB(1); return -1;	}

    *pLineHeight= fontSize;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Change properties of all sections.					*/
/*									*/
/*  9)  Eventually this routine must be combined with the set document	*/
/*	properties routine. Now it is called in conjunction with its	*/
/*	colleague that takes care of reformats and redraws.		*/
/*									*/
/************************************************************************/

int tedAppChangeAllSectionProperties(
				EditApplication *		ea,
				const PropertyMask *		spSetMask,
				const SectionProperties *	spNew )
    {
    int				i;
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;
    BufferItem *		bodyBi;

    TextAttribute		taSet;

    PropertyMask		taUpdMask;
    PropertyMask		ppSetMask;

    PropertyMask		changed;

    utilPropMaskClear( &taUpdMask );
    utilPropMaskClear( &ppSetMask );
    utilPropMaskClear( &changed );

    utilInitTextAttribute ( &taSet );

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    bodyBi= bd->bdBody.eiRoot;

    for ( i= 0; i < bodyBi->biChildCount; i++ )
	{
	PropertyMask		sectChanged;
	BufferItem *		sectBi= bodyBi->biChildren[i];

	utilPropMaskClear( &sectChanged );

	if  ( docUpdSectProperties( &sectChanged,
			    &(sectBi->biSectProperties), spSetMask, spNew ) )
	    { LDEB(1);	}

	utilPropMaskOr( &changed, &changed, &sectChanged );
	}

    /*  9  */

    return 0;
    }

/************************************************************************/
/*									*/
/*  Increase/Decrease the indentation level of the paragraphs in the	*/
/*  selection.								*/
/*									*/
/************************************************************************/

int tedFormatShiftIndent(	EditDocument *	ed,
				int		step )
    {
    int				rval= 0;

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    BufferItem *		paraBi;

    SelectionGeometry		sg;
    SelectionDescription	sd;

    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);
    int				changed= 0;

    ParagraphProperties		ppNew;

    docInitParagraphProperties( &ppNew );

    tedStartEditOperation( &teo, &sg, &sd, ed, 1 );

    paraBi= eo->eoHeadDp.dpBi;
    while( paraBi )
	{
	PropertyMask	ppDoneMask;
	PropertyMask	ppSetMask;
	int		apply= 0;

	utilPropMaskClear( &ppDoneMask );
	utilPropMaskClear( &ppSetMask );

	if  ( paraBi->biParaListOverride >= 1 )
	    {
	    ListOverride *		lo;
	    DocumentList *		dl;
	    int				ilvl;

	    ilvl= paraBi->biParaListLevel;
	    ilvl += step;

	    if  ( docGetListOfParagraph( &lo, &dl,
					    paraBi->biParaListOverride, bd ) )
		{ LDEB(paraBi->biParaListOverride); rval= -1; goto ready; }

	    if  ( ilvl >= 0 )
		{
		if  ( ilvl < dl->dlLevelCount )
		    {
		    PROPmaskADD( &ppSetMask, PPpropLISTLEVEL );

		    ppNew.ppListLevel= ilvl;
		    apply= 1;
		    }
		}
#	    if 0
	    No!
	    * Is difficult to understand.
	    * Has no natural reverse operation.
	    * Does not work this way in MS-Word
	    else{
		ppNew.ppLeftIndentTwips= 0;
		ppNew.ppFirstIndentTwips= 0;
		ppNew.ppListOverride= 0;
		ppNew.ppListLevel= 0;

		PROPmaskADD( &ppSetMask, PPpropLISTOVERRIDE );
		PROPmaskADD( &ppSetMask, PPpropLISTLEVEL );
		PROPmaskADD( &ppSetMask, PPpropLEFT_INDENT );
		PROPmaskADD( &ppSetMask, PPpropFIRST_INDENT );
		apply= 1;
		}
#	    endif
	    }
	else{
	    const DocumentProperties *	dp= &(bd->bdProperties);

	    ppNew.ppLeftIndentTwips= paraBi->biParaLeftIndentTwips+
						step* dp->dpTabIntervalTwips;

	    if  ( ppNew.ppLeftIndentTwips >= 0 )
		{
		PROPmaskADD( &ppSetMask, PPpropLEFT_INDENT );
		apply= 1;

		if  ( ppNew.ppLeftIndentTwips+ ppNew.ppFirstIndentTwips < 0 )
		    {
		    ppNew.ppFirstIndentTwips= -ppNew.ppLeftIndentTwips;
		    PROPmaskADD( &ppSetMask, PPpropFIRST_INDENT );
		    }
		}
	    }

	if  ( apply )
	    {
	    if  ( docEditUpdParaProperties( eo, &ppDoneMask, paraBi,
				    &ppSetMask, &ppNew,
				    (const DocumentAttributeMap *)0 ) )
		{ LDEB(1); rval= -1; goto ready; }

	    if  ( ! utilPropMaskIsEmpty( &ppDoneMask ) )
		{
		docEditIncludeItemInReformatRange( eo, paraBi );

		changed= 1;
		}
	    }

	if  ( paraBi == eo->eoTailDp.dpBi )
	    { break;	}

	paraBi= docNextParagraph( paraBi );
	if  ( ! paraBi )
	    { XDEB(paraBi);	}
	}

    if  ( changed )
	{
	if  ( tedEditFinishOldSelection( &teo ) )
	    { LDEB(1);	}

	tedAdaptToolsToSelection( ed );

	appDocumentChanged( ed, 1 );
	}

  ready:
    docCleanParagraphProperties( &ppNew );

    return rval;
    }

/************************************************************************/
/*									*/
/*  Menu options to change paragraph alignment.				*/
/*									*/
/************************************************************************/

void tedFormatSetParaIndent(	EditDocument *		ed,
				int			align )
    {
    ParagraphProperties		ppNew;
    PropertyMask		ppSetMask;

    utilPropMaskClear( &ppSetMask );
    PROPmaskADD( &ppSetMask, PPpropALIGNMENT );

    docInitParagraphProperties( &ppNew );
    ppNew.ppAlignment= align;

    if  ( tedDocChangeParagraphProperties( ed, &ppSetMask, &ppNew ) )
	{ LDEB(1);	}

    docCleanParagraphProperties( &ppNew );

    return;
    }


/************************************************************************/
/*									*/
/*  Menu options to change paragraph alignment.				*/
/*									*/
/************************************************************************/

void tedDocSetParaOutlineLevel(		EditDocument *		ed,
					int			level )
    {
    ParagraphProperties		ppNew;
    PropertyMask		ppSetMask;

    utilPropMaskClear( &ppSetMask );
    PROPmaskADD( &ppSetMask, PPpropOUTLINELEVEL );

    docInitParagraphProperties( &ppNew );
    ppNew.ppOutlineLevel= level;

    if  ( tedDocChangeParagraphProperties( ed, &ppSetMask, &ppNew ) )
	{ LDEB(1);	}

    docCleanParagraphProperties( &ppNew );

    return;
    }

