/************************************************************************/
/*  Ted: Interface to the find tool.					*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"

#   include	<appSpellTool.h>
#   include	<docFind.h>
#   include	"tedFind.h"
#   include	"tedFindTool.h"
#   include	"tedSpellTool.h"
#   include	<ind.h>

#   include	<appDebugon.h>

static int tedDocFindNext(	EditDocument *	ed )
    {
    TedDocument *		td;
    BufferDocument *		bd;

    int				ret;

    DocumentSelection		dsNew;

    int				scrolledX= 0;
    int				scrolledY= 0;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;

    if  ( ! td->tdFindProg )
	{ XDEB(td->tdFindProg); return -1;	}

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ LDEB(1); return -1;	}

    docInitDocumentSelection( &dsNew );

    ret= docFindFindNextInDocument( &dsNew, &(ds.dsTail), bd,
				docFindParaFindNext, (void *)td->tdFindProg );

    if  ( ret < 0 )
	{ LDEB(ret); return -1;	}

    if  ( ret == 0 )
	{
	const int		lastLine= 0;

	tedSetSelection( ed, &dsNew, lastLine, &scrolledX, &scrolledY );

	tedAdaptToolsToSelection( ed );
	}

    return ret;
    }

static int tedDocFindPrev(	EditDocument *	ed )
    {
    TedDocument *		td;
    BufferDocument *		bd;

    int				ret;

    DocumentSelection		dsNew;

    int				scrolledX= 0;
    int				scrolledY= 0;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;

    if  ( ! td->tdFindProg )
	{ XDEB(td->tdFindProg); return -1;	}

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ LDEB(1); return -1;	}

    docInitDocumentSelection( &dsNew );

    ret= docFindFindPrevInDocument( &dsNew, &(ds.dsHead), bd,
				docFindParaFindPrev, (void *)td->tdFindProg );

    if  ( ret < 0 )
	{ LDEB(ret); return -1;	}

    if  ( ret == 0 )
	{
	const int		lastLine= 0;

	tedSetSelection( ed, &dsNew, lastLine, &scrolledX, &scrolledY );

	tedAdaptToolsToSelection( ed );
	}

    return ret;
    }

int tedFindToolFindNext(		void *		voidea )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocFindNext( ed );
    }

int tedFindToolFindPrev(		void *		voidea )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocFindPrev( ed );
    }

int tedFindToolSetPattern(	void *		voidea,
				const char *	pattern,
				int		useRegex )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    EditDocument *		ed= ea->eaCurrentDocument;
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;
    TedDocument *		td;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;

    tar->tarFindPattern= (char *)0;

    return docFindSetPattern( &(td->tdFindProg), pattern, useRegex );
    }

static void tedShowFindTool(	EditDocument *		ed )
    {
    EditApplication *	ea= ed->edApplication;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;
    TedAppResources *	tar= (TedAppResources *)ea->eaResourceData;

    /*  To get the correct title  */
    tedShowFormatTool( td->tdToolsFormatToolOption, ea );
    tedAdaptFormatToolToDocument( ed, 0 );

    tedFormatShowFindPage( ea );

    if  ( tar->tarFindPattern )
	{
	tedFormatSetFindPattern( ea, tar->tarFindPattern, tar->tarFindRegex );
	}

    return;
    }

APP_MENU_CALLBACK_H( tedDocToolFind, findOption, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;

    tedShowFindTool( ed );

    return;
    }

APP_MENU_CALLBACK_H( tedDocToolFindNext, findOption, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;

    if  ( ! td->tdFindProg )
	{
	tedShowFindTool( ed );
	return;
	}

    tedDocFindNext( ed );

    return;
    }

int tedSpellFindNext(	void *			voidea,
				MemoryBuffer *		mbGuess,
				const SpellChecker *	spc,
				SpellDictionary *	spd )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;

    int				ret;

    DocumentSelection		dsNew;

    int				scrolledX= 0;
    int				scrolledY= 0;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ LDEB(1); return -1;	}

    docInitDocumentSelection( &dsNew );

    ret= docFindFindNextInDocument( &dsNew, &(ds.dsTail), bd,
					docSpellParaFindNext, (void *)spd );

    if  ( ret < 0 )
	{ LDEB(ret); return -1;	}

    if  ( ret == 0 )
	{
	const int	lastLine= 0;

	tedSetSelection( ed, &dsNew, lastLine, &scrolledX, &scrolledY );

	tedAdaptToolsToSelection( ed );

	if  ( mbGuess && utilMemoryBufferGetRange(
			mbGuess, &(dsNew.dsTail.dpBi->biParaStringBuffer),
			dsNew.dsHead.dpStroff,
			dsNew.dsTail.dpStroff- dsNew.dsHead.dpStroff ) )
	    { LDEB(1); return -1;	}
	}

    return ret;
    }

/************************************************************************/
/*									*/
/*  Show or create a spelling tool.					*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocToolSpell, spellOption, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    EditApplication *	ea= ed->edApplication;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    /*  To get the correct title  */
    tedShowFormatTool( td->tdToolsFormatToolOption, ea );
    tedAdaptFormatToolToDocument( ed, 0 );

    tedFormatShowSpellPage( ea );

    return;
    }
