/************************************************************************/
/*									*/
/*  Rulers, Ted specific functionality.					*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<sioMemory.h>
#   include	<sioStdio.h>

#   include	"docPageGrid.h"
#   include	<appMatchFont.h>
#   include	"docRtfReadWrite.h"

#   include	"tedApp.h"
#   include	"tedRuler.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Obtain the separator positions for a table.				*/
/*									*/
/************************************************************************/

static int tedGetColumns(	BufferItem *			paraBi,
				const AppDrawingData *		add,
				const BlockFrame *		bf,
				ColumnSeparator **		pCs,
				int *				pCsCount )
    {
    static ColumnSeparator *	cs;
    ColumnSeparator *		fresh;

    BufferItem *		rowBi;
    CellProperties *		cp;

    int				i;

    int				rg2p;

    rowBi= docGetRowItem( paraBi );
    if  ( ! rowBi )
	{ XDEB(rowBi); return -1;	}

    fresh= (ColumnSeparator *)realloc( cs, ( rowBi->biRowCellCount+ 1 )*
					sizeof( ColumnSeparator ) );
    if  ( ! fresh )
	{ LXDEB(rowBi->biRowCellCount,fresh); return -1;	}
    cs= fresh;

    rg2p= X_PIXELS( add, rowBi->biRowHalfGapWidthTwips );

    cp= rowBi->biRowCells;
    for ( i= 0; i < rowBi->biRowCellCount; fresh++, cp++, i++ )
	{
	const BufferItem *	cellBi= rowBi->biChildren[i];

	ParagraphFrame		pf;

	docCellFrameTwips( &pf, bf, cellBi );

	if  ( i == 0 )
	    {
	    fresh[0].csX0= X_PIXELS( add, pf.pfCellRect.drX0 )- rg2p;
	    fresh[0].csX1= X_PIXELS( add, pf.pfCellRect.drX0 )+ rg2p;
	    }

	fresh[1].csX0= X_PIXELS( add, pf.pfCellRect.drX1 )- rg2p;
	fresh[1].csX1= X_PIXELS( add, pf.pfCellRect.drX1 )+ rg2p;
	}

    *pCs= cs; *pCsCount= rowBi->biRowCellCount+ 1; return 0;
    }

static void tedUpdateTableColumns(	EditDocument *		ed,
					BufferItem *		paraBi,
					const BlockFrame *	bf,
					int			csCountNew,
					ColumnSeparator *	csNew )
    {
    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);
    double			xfac= add->addMagnifiedPixelsPerTwip;

    int			csCount;
    ColumnSeparator *	cs;
    int			changed= 0;

    BufferItem *	sectBi;
    BufferItem *	rowBi;

    RowProperties *	rp;
    CellProperties *	cp;

    int			col;
    int			row;
    int			row0;
    int			row1;

    int			i;

    if  ( docDelimitTable( paraBi, &sectBi, &col, &row0, &row, &row1 ) )
	{ LDEB(1); return;	}

    if  ( tedGetColumns( paraBi, add, bf, &cs, &csCount ) )
	{ LDEB(1); return;	}

    if  ( csCountNew != csCount )
	{ LLDEB(csCountNew,csCount); return;	}

    rowBi= sectBi->biChildren[row0];
    rp= &(rowBi->biRowProperties);

    if  ( csNew[0].csX0 != cs[0].csX0 )
	{
	int	rowLeftIndentPixels;

	rowLeftIndentPixels= X_PIXELS( add, rowBi->biRowLeftIndentTwips );

	rowLeftIndentPixels += ( csNew[0].csX0- cs[0].csX0 );
	rp->rpLeftIndentTwips= GRIFtoCOORD( rowLeftIndentPixels, xfac );

	changed= 1;
	}

    cp= rp->rpCells;
    for ( i= 1; i < csCount; cp++, i++ )
	{
	if  ( csNew[i].csX0 != cs[i].csX0 )
	    {
	    int	rightBoundaryPixels=
			    X_PIXELS( add, cp->cpRightBoundaryTwips );

	    rightBoundaryPixels += ( csNew[i].csX0- cs[i].csX0 );
	    cp->cpRightBoundaryTwips=
			    GRIFtoCOORD( rightBoundaryPixels, xfac );
	    changed= 1;
	    }
	}

    if  ( changed )
	{
	PropertyMask	rpSetMask;
	PropertyMask	cpSetMask;

	const int	col0= 0;
	const int	col1= csCount- 1;

	utilPropMaskClear( &rpSetMask );
	utilPropMaskClear( &cpSetMask );

	PROPmaskADD( &rpSetMask, RPpropLEFT_INDENT );
	PROPmaskADD( &cpSetMask, CLpropCELLX );

	tedChangeTableLayout( ed, sectBi, row0, row1, col0, col1, row1,
						&rpSetMask, &cpSetMask, rp );

	tedAdaptToolsToSelection( ed );

	tedAdaptFormatToolToDocument( ed, 0 );

	appDocumentChanged( ed, 1 );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  The user wants something with the mouse on the horizontal ruler	*/
/*									*/
/************************************************************************/

static int tedGetRulerTwips(
			const AppDrawingData *		add,
			const BlockFrame *		bf,
			const ParagraphFrame *		pf,
			BufferItem *			paraBi,
			ParagraphProperties *		pp,
			int				firstIndentPixels,
			int				leftIndentPixels,
			int				rightIndentPixels,
			const TabStopList *		tslNew )
    {
    double			xfac= add->addMagnifiedPixelsPerTwip;

    int				pfX0Pixels;
    int				pfX1Pixels;

    int				tabCount= tslNew->tslTabStopCount;
    const TabStop *		tabStops= tslNew->tslTabStops;

    {
    TabStopList *	tsl= &(paraBi->biParaTabStopList);
    int			tab;
    TabStop *		ts= tsl->tslTabStops;

    for ( tab= 0; tab < tsl->tslTabStopCount; ts++, tab++ )
	{
	ts->tsPixels= X_PIXELS( add, pf->pfCellContentRect.drX0+ ts->tsTwips );
	}
    }

    pfX0Pixels= X_PIXELS( add, pf->pfCellContentRect.drX0 );
    pfX1Pixels= X_PIXELS( add, pf->pfCellContentRect.drX1 );

    leftIndentPixels -= pfX0Pixels;
    pp->ppLeftIndentTwips= GRIFtoCOORD( leftIndentPixels, xfac );

    firstIndentPixels -= pfX0Pixels;
    firstIndentPixels -= leftIndentPixels;
    pp->ppFirstIndentTwips= GRIFtoCOORD( firstIndentPixels, xfac );

    rightIndentPixels= pfX1Pixels- rightIndentPixels;
    pp->ppRightIndentTwips= GRIFtoCOORD( rightIndentPixels, xfac );

    if  ( docRulerMergeTabs( &(pp->ppTabStopList), xfac, pfX0Pixels,
						    tabCount, tabStops ) )
	{ LDEB(tabCount); return -1;	}

    return 0;
    }

static APP_EVENT_HANDLER_H( tedTopRulerButtonDown, w, voided, downEvent )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;
    BufferItem *		paraBi;
    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);

    int				leftIndentNew;
    int				firstIndentNew;
    int				rightIndentNew;
    TabStopList			tslNew;

    int				csCountNew= 0;
    ColumnSeparator *		csNew= (ColumnSeparator *)0;

    int				prop= PPprop_NONE;

    PropertyMask		taSetMask;
    PropertyMask		ppChgMask;
    PropertyMask		ppUpdMask;
    PropertyMask		spUpdMask;

    ParagraphProperties		ppNew;
    TextAttribute		taSet;

    ParagraphFrame		pf;
    BlockFrame			bf;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;
    const BufferItem *		bodySectBi;
    const TextLine *		tl;

    DocumentRectangle *		drParaContent= &(pf.pfParaContentRect);

    docInitTabStopList( &tslNew );

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, &bodySectBi, td ) )
	{ LDEB(1); return;	}
    paraBi= ds.dsHead.dpBi;
    tl= paraBi->biParaLines+ sg.sgBegin.pgLine;

    tslNew.tslTabStopCount= paraBi->biParaTabStopCount;

    utilPropMaskClear( &taSetMask );
    utilPropMaskClear( &ppUpdMask );
    utilPropMaskClear( &spUpdMask );

    docBlockFrameTwips( &bf, paraBi, bodySectBi, bd,
					    tl->tlTopPosition.lpPage,
					    tl->tlTopPosition.lpColumn );

    docParagraphFrameTwips( &pf, &bf, paraBi );

    leftIndentNew= X_PIXELS( add, drParaContent->drX0 );
    firstIndentNew= X_PIXELS( add, drParaContent->drX0+
					    paraBi->biParaFirstIndentTwips );
    rightIndentNew= X_PIXELS( add, drParaContent->drX1 );

    tedTopRulerTrackMouse( &firstIndentNew, &leftIndentNew, &rightIndentNew,
			    &tslNew,
			    &csCountNew, &csNew, &prop,
			    w, ea, downEvent, ed->edTopRuler, ed );

    switch( prop )
	{
	case PPprop_NONE:
	    return;

	case PPpropLEFT_INDENT:
	case PPpropFIRST_INDENT:
	    PROPmaskADD( &ppUpdMask, PPpropLEFT_INDENT );
	    PROPmaskADD( &ppUpdMask, PPpropFIRST_INDENT );
	    break;

	case PPpropRIGHT_INDENT:
	case PPpropTAB_STOPS:
	    PROPmaskADD( &ppUpdMask, prop );
	    break;

	case PPprop_COLUMNS:
	    tedUpdateTableColumns( ed, paraBi, &bf, csCountNew, csNew );
	    return;
	default:
	    LDEB(prop); return;
	}

    docInitParagraphProperties( &ppNew );
    utilInitTextAttribute( &taSet );

    utilPropMaskClear( &ppChgMask );

    if  ( docUpdParaProperties( &ppChgMask, &ppNew, &ppUpdMask,
					    &(paraBi->biParaProperties),
					    (const DocumentAttributeMap *)0 ) )
	{ LDEB(1); return;	}

    if  ( tedGetRulerTwips( add, &bf, &pf, paraBi, &ppNew,
			    firstIndentNew, leftIndentNew, rightIndentNew,
			    &tslNew ) )
	{ LDEB(1); return;	}

    if  ( tedChangeSelectionProperties( ed,
				    &taSetMask, &taSet,
				    &ppUpdMask, &ppNew,
				    &spUpdMask, (SectionProperties *)0 ) )
	{ LDEB(1);	}

    docCleanParagraphProperties( &ppNew );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt the horizontal ruler to the current paragraph.		*/
/*									*/
/************************************************************************/

void tedDocAdaptTopRuler(	EditDocument *			ed,
				const DocumentSelection *	ds,
				const SelectionGeometry *	sg,
				const SelectionDescription *	sd,
				const BufferItem *		bodySectBi )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);

    int				leftIndent;
    int				firstIndent;
    int				rightIndent;

    BlockFrame			bf;
    ParagraphFrame		pf;

    int				bfX0Pixels;
    int				bfX1Pixels;
    int				pfX0Pixels;
    int				pfX1Pixels;

    BufferItem *		paraBi= ds->dsHead.dpBi;
    const TextLine *		tl= paraBi->biParaLines+ sg->sgBegin.pgLine;

    if  ( ! ed->edTopRuler )
	{ return;	}

    docLayoutInitBlockFrame( &bf );
    docBlockFrameTwips( &bf, paraBi, bodySectBi, bd,
					tl->tlTopPosition.lpPage,
					tl->tlTopPosition.lpColumn );

    docParagraphFrameTwips( &pf, &bf, paraBi );

    {
    TabStopList *	tsl= &(paraBi->biParaTabStopList);
    int		tab;
    TabStop *	ts= tsl->tslTabStops;

    for ( tab= 0; tab < tsl->tslTabStopCount; ts++, tab++ )
	{
	ts->tsPixels= X_PIXELS( add,
				    pf.pfCellContentRect.drX0+ ts->tsTwips );
	}
    }

    bfX0Pixels= X_PIXELS( add, bf.bfContentRect.drX0 );
    bfX1Pixels= X_PIXELS( add, bf.bfContentRect.drX1 );

    pfX0Pixels= X_PIXELS( add, pf.pfCellContentRect.drX0 );
    pfX1Pixels= X_PIXELS( add, pf.pfCellContentRect.drX1 );

    leftIndent= X_PIXELS( add, pf.pfParaContentRect.drX0 );
    firstIndent= X_PIXELS( add, pf.pfParaContentRect.drX0+
					paraBi->biParaFirstIndentTwips );
    rightIndent= X_PIXELS( add, pf.pfParaContentRect.drX1 );

    {
    TabStopList *	tsl= &(paraBi->biParaTabStopList);

    tedAdaptTopRuler( ed->edTopRuler, ed->edTopRulerWidget,
		add->addDocRect.drX0, add->addDocRect.drX1,
		firstIndent, leftIndent, rightIndent,
		add->addPaperRect.drX1, tsl );
    }

    if  ( paraBi->biParaTableNesting > 0 )
	{
	int			csCount;
	ColumnSeparator *	cs;

	BufferItem *		parentBi;

	int			col;
	int			row;
	int			row0;
	int			row1;

	if  ( docDelimitTable( paraBi, &parentBi, &col, &row0, &row, &row1 ) )
	    { LDEB(1); return;	}

	if  ( tedGetColumns( paraBi, add, &bf, &cs, &csCount ) )
	    { LDEB(1); return;	}

	tedSetRulerColumns( ed->edTopRulerWidget, ed->edTopRuler,
				    bfX0Pixels,
				    bfX1Pixels,
				    pfX0Pixels,
				    pfX1Pixels,
				    cs, csCount );
	}
    else{
	tedSetRulerColumns( ed->edTopRulerWidget, ed->edTopRuler,
				    bfX0Pixels,
				    bfX1Pixels,
				    pfX0Pixels,
				    pfX1Pixels,
				    (ColumnSeparator *)0, 0 );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Make the ruler administration for the top ruler widget of a		*/
/*  document.								*/
/*									*/
/************************************************************************/

int tedDocSetTopRuler(	EditDocument *	ed )
    {
    EditApplication *		ea= ed->edApplication;
    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);

    int				topRulerHeight= ed->edTopRulerHighPixels;
    int				unitInt= ea->eaUnitInt;

    ed->edTopRuler= tedMakeTopRuler(
			topRulerHeight,		/*  sizeAcross		*/
			add->addMagnifiedPixelsPerTwip,
			add->addMagnification,	/*  magnification	*/

			ed->edLeftRulerWidePixels,	/*  minUnused	*/
			ed->edRightRulerWidePixels,	/*  maxUnused	*/

			add->addDocRect.drX0,
			add->addDocRect.drX1,
			ed->edVisibleRect.drX0,
			ed->edVisibleRect.drX1,

			add->addPaperRect.drX1,	/*  rulerC1		*/
			ea->eaRulerFont,
			unitInt );		/*  whatUnit		*/

    appDrawSetConfigureHandler( ed->edTopRulerWidget,
			    tedTopRulerConfigure, (void *)ed->edTopRuler );

    appDrawSetRedrawHandler( ed->edTopRulerWidget,
				tedRedrawTopRuler, (void *)ed->edTopRuler );

    appDrawSetButtonPressHandler( ed->edTopRulerWidget,
					tedTopRulerButtonDown, (void *)ed );

#   ifdef USE_GTK
    gtk_widget_add_events( ed->edTopRulerWidget, GDK_POINTER_MOTION_MASK );
#   endif

    return 0;
    }

int tedDocSetBottomRuler(	EditDocument *	ed )
    {
    EditApplication *		ea= ed->edApplication;
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    int				bottomRulerHigh= ed->edBottomRulerHighPixels;

    ed->edBottomRuler= tedMakeBottomRuler(
			bottomRulerHigh,		/*  sizeAcross	*/
			ed->edLeftRulerWidePixels,	/*  minUnused	*/
			ed->edRightRulerWidePixels,	/*  maxUnused	*/
			ea->eaRulerFont,
			tar->tarPageNumberFormat );

    appDrawSetConfigureHandler( ed->edBottomRulerWidget,
			tedBottomRulerConfigure, (void *)ed->edBottomRuler );

    appDrawSetRedrawHandler( ed->edBottomRulerWidget,
			    tedRedrawBottomRuler, (void *)ed->edBottomRuler );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Merge the paragraphs in the selection.				*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocFormatOnePara, option, voided, e )
    {
    EditDocument *			ed= (EditDocument *)voided;

    tedMergeParagraphsInSelection( ed );

    tedAdaptToolsToSelection( ed );

    appDocumentChanged( ed, 1 );
    }

