/************************************************************************/
/*									*/
/*  Ted: Link tool.							*/
/*									*/
/************************************************************************/

#   ifndef	TED_BOOKMARK_TOOL_H
#   define	TED_BOOKMARK_TOOL_H

#   include	<appFrame.h>

/************************************************************************/
/*									*/
/*  User data for a bookmark dialog.					*/
/*									*/
/************************************************************************/

typedef struct BookmarkPageResources
    {
    char *		bprMarkText;

    char *		bprCopyHeaderText;
    char *		bprCopyButtonText;
    char *		bprCopyAsItemTexts[LINKkind_COUNT];
    } BookmarkPageResources;

typedef struct BookmarkTool
    {
    EditApplication *			btApplication;
    AppInspector *			btInspector;
    const BookmarkPageResources *	btResources;

    APP_WIDGET				btMarkLabelWidget;
    APP_WIDGET				btMarkTextWidget;

    APP_WIDGET				btMarkListWidget;

    APP_WIDGET				btSetBookmarkButton;
    APP_WIDGET				btGoToBookmarkButton;
    APP_WIDGET				btRemoveBookmarkButton;

    unsigned int			btCurrentDocumentId;
    int					btDocumentReadonly;
    int					btIBarSelection;
    int					btMarkExists;
    char *				btMarkSet;
    char *				btMarkChosen;
    } BookmarkTool;

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern void tedFillBookmarkTool(BookmarkTool *			bt,
				const BookmarkPageResources *	bpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedInitBookmarkTool(	BookmarkTool *		bt );
extern void tedFormatCleanBookmarkTool(	BookmarkTool *		bt );

extern void tedBookmarkToolGetResourceTable(
				EditApplication *		ea,
				BookmarkPageResources *		bpr,
				InspectorSubjectResources *	isr );

extern void tedBookmarkToolFillChoosers(BookmarkTool *			bt );

extern void tedFinishBookmarkTool(	BookmarkTool *			bt );

extern void tedRefreshBookmarkTool(
				BookmarkTool *			bt,
				int *				pEnabled,
				int *				pPref,
				InspectorSubject *		is,
				const DocumentSelection *	ds,
				const SelectionDescription *	sd,
				DocumentTree *			ei,
				BufferDocument *		bd );

#   endif	/*  TED_BOOKMARK_TOOL_H  */
