/************************************************************************/
/*									*/
/*  Ted: Changing font and text attributes.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	"tedLayout.h"
#   include	"docScreenLayout.h"
#   include	"docExpandedTextAttribute.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Change to font attributes of the current selection.			*/
/*									*/
/************************************************************************/

static void tedSetCurrentAttribute(
				TedDocument *			td,
				const LayoutContext *		lc )
    {
    BufferDocument *		bd= td->tdDocument;

    td->tdCurrentTextAttributeNumber= utilTextAttributeNumber(
					    &(bd->bdTextAttributeList),
					    &(td->tdCurrentTextAttribute) );

    if  ( td->tdCurrentTextAttributeNumber < 0 )
	{ LDEB(td->tdCurrentTextAttributeNumber); return;	}

    td->tdCurrentScreenFont= docOpenScreenFont( lc,
					td->tdCurrentTextAttributeNumber );

    return;
    }

static void tedDocChangeSelectionAttribute(
					EditDocument *		ed,
					const PropertyMask *	taSetMask,
					const TextAttribute *	taSet )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    PropertyMask		ppUpdMask;
    PropertyMask		spUpdMask;
    PropertyMask		changeMask;

    LayoutContext		lc;

    layoutInitContext( &lc );
    tedSetLayoutContext( &lc, ed );

    utilPropMaskClear( &ppUpdMask );
    utilPropMaskClear( &spUpdMask );

    utilPropMaskClear( &changeMask );

    utilUpdateTextAttribute( &changeMask,
			    &(td->tdCurrentTextAttribute), taSet, taSetMask );

    if  ( ! utilPropMaskIsEmpty( &changeMask )	||
	  td->tdCurrentScreenFont < 0		)
	{ tedSetCurrentAttribute( td, &lc );	}

    tedChangeSelectionProperties( ed,
			    taSetMask, taSet,
			    &ppUpdMask, (const ParagraphProperties *)0,
			    &spUpdMask, (const SectionProperties *)0 );

    return;
    }

/************************************************************************/
/*									*/
/*  1)  Adapt fonts tool &c to the current values.			*/
/*  2)  Adapt fonts tool &c to the current selection.			*/
/*									*/
/************************************************************************/

/*  1  */
static void tedAdaptFontIndicatorsToValues(
					EditDocument *		ed,
					const PropertyMask *	taSetMask,
					TextAttribute *		taSet )
    {
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    appGuiSetToggleItemState( td->tdFontBoldOption,
			    PROPmaskISSET( taSetMask, TApropFONTBOLD ) &&
			    taSet->taFontIsBold );

    appGuiSetToggleItemState( td->tdFontItalicOption,
			    PROPmaskISSET( taSetMask, TApropFONTSLANTED ) &&
			    taSet->taFontIsSlanted );

    appGuiSetToggleItemState( td->tdFontUnderlinedOption,
			    PROPmaskISSET( taSetMask, TApropTEXTUNDERLINED ) &&
			    taSet->taTextIsUnderlined );

    appGuiSetToggleItemState( td->tdFontSuperscriptOption,
			    PROPmaskISSET( taSetMask, TApropSUPERSUB ) &&
			    taSet->taSuperSub == DOCfontSUPERSCRIPT );

    appGuiSetToggleItemState( td->tdFontSubscriptOption,
			    PROPmaskISSET( taSetMask, TApropSUPERSUB ) &&
			    taSet->taSuperSub == DOCfontSUBSCRIPT );

    return;
    }

/*  2  */
void tedAdaptFontIndicatorsToSelection(	EditApplication *	ea,
					EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    PropertyMask		taCurrMask;
    TextAttribute		taCurr;

    utilPropMaskClear( &taCurrMask );
    utilInitTextAttribute( &taCurr );

    if  ( tedGetDocumentAttributes( td, &taCurrMask, &taCurr ) )
	{ goto ready;	}

    td->tdInProgrammaticChange++;

    tedAdaptFontIndicatorsToValues( ed, &taCurrMask, &taCurr );

    td->tdInProgrammaticChange--;

  ready:

    return;
    }


/************************************************************************/
/*									*/
/*  One of the text attribute options has been pushed.			*/
/*									*/
/************************************************************************/

static void tedTextAttributePushed(	APP_WIDGET	attributeOption,
					void *		voided,
					int		set,
					int		prop )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    TextAttribute	taSet;
    PropertyMask	taSetMask;

    utilPropMaskClear( &taSetMask );
    utilInitTextAttribute( &taSet );

    if  ( td->tdInProgrammaticChange )
	{ return;	}

    switch( prop )
	{
	case TApropFONTBOLD:
	    taSet.taFontIsBold= ( set != 0 );
	    PROPmaskADD( &taSetMask, prop );
	    break;

	case TApropFONTSLANTED:
	    taSet.taFontIsSlanted= ( set != 0 );
	    PROPmaskADD( &taSetMask, prop );
	    break;

	case TApropTEXTUNDERLINED:
	    taSet.taTextIsUnderlined= ( set != 0 );
	    PROPmaskADD( &taSetMask, prop );
	    break;

	default:
	    LDEB(prop);
	    return;
	}

    if  ( ! utilPropMaskIsEmpty( &taSetMask ) )
	{ tedDocChangeSelectionAttribute( ed, &taSetMask, &taSet );	}

    return;
    }

APP_MENU_CALLBACK_H( tedDocFontBold, option, voided, e )
    {
    int	set= appGuiGetMenuToggleStateFromCallback( option, e );
    tedTextAttributePushed( option, voided, set, TApropFONTBOLD );
    }

APP_MENU_CALLBACK_H( tedDocFontItalic, option, voided, e )
    {
    int	set= appGuiGetMenuToggleStateFromCallback( option, e );
    tedTextAttributePushed( option, voided, set, TApropFONTSLANTED );
    }

APP_MENU_CALLBACK_H( tedDocFontUnderlined, option, voided, e )
    {
    int	set= appGuiGetMenuToggleStateFromCallback( option, e );
    tedTextAttributePushed( option, voided, set, TApropTEXTUNDERLINED );
    }

APP_MENU_CALLBACK_H( tedDocFontSupersub, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    PropertyMask	taSetMask;
    TextAttribute	taSet;
    int			set;

    if  ( td->tdInProgrammaticChange )
	{ return;	}

    utilPropMaskClear( &taSetMask );
    PROPmaskADD( &taSetMask, TApropSUPERSUB );

    utilInitTextAttribute( &taSet );

    set= appGuiGetMenuToggleStateFromCallback( option, e );

    if  ( set )
	{
	if  ( option == td->tdFontSubscriptOption )
	    { taSet.taSuperSub= DOCfontSUBSCRIPT;	}

	if  ( option == td->tdFontSuperscriptOption )
	    { taSet.taSuperSub= DOCfontSUPERSCRIPT;	}
	}
    else{ taSet.taSuperSub= DOCfontREGULAR;	}

    tedDocChangeSelectionAttribute( ed, &taSetMask, &taSet );

    appGuiSetToggleItemState( td->tdFontSuperscriptOption,
				PROPmaskISSET( &taSetMask, TApropSUPERSUB ) &&
				taSet.taSuperSub == DOCfontSUPERSCRIPT );

    appGuiSetToggleItemState( td->tdFontSubscriptOption,
				PROPmaskISSET( &taSetMask, TApropSUPERSUB ) &&
				taSet.taSuperSub == DOCfontSUBSCRIPT );

    return;
    }

/************************************************************************/
/*									*/
/*  Ted: The 'Set' button on the font tool was pushed.			*/
/*									*/
/************************************************************************/

void tedFontToolSet(		void *				voidea,
				const ExpandedTextAttribute *	etaSet,
				const PropertyMask *		taSetMask )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;
    DocumentProperties *	dp;
    DocumentFontList *		dfl;

    PropertyMask		doneMask;
    TextAttribute		taSet;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    dp= &(bd->bdProperties);
    dfl= &(dp->dpFontList);

    utilInitTextAttribute( &taSet );
    utilPropMaskClear( &doneMask );

    docIndirectTextAttribute( &doneMask, &taSet, etaSet, taSetMask,
				&(dp->dpColors), &(dp->dpColorCount) );

    tedDocChangeSelectionAttribute( ed, taSetMask, &taSet );

    tedAdaptFontIndicatorsToSelection( ea, ed );

    return;
    }

/************************************************************************/
/*									*/
/*  Insert a string with known attributes (font)			*/
/*									*/
/************************************************************************/

void tedDocInsertStringWithAttribute(	EditDocument *		ed,
					const char *		bytes,
					int			size,
					const TextAttribute *	taSet,
					const PropertyMask *	taSetMask )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    LayoutContext		lc;

    layoutInitContext( &lc );
    tedSetLayoutContext( &lc, ed );

    if  ( tedHasSelection( td )		&&
	  td->tdCanReplaceSelection	)
	{
	if  ( PROPmaskISSET( taSetMask, TApropDOC_FONT_NUMBER ) )
	    {
	    PropertyMask	tadoneMask;

	    utilPropMaskClear( &tadoneMask );

	    if  ( taSet->taFontNumber < 0 )
		{ LDEB(taSet->taFontNumber); return;	}

	    td->tdCurrentTextAttribute.taFontNumber= taSet->taFontNumber;

	    tedSetCurrentAttribute( td, &lc );
	    }

	/*  1  */
	tedDocReplaceSelection( ed, bytes, size );
	}

    return;
    }

