#   include	<appFrame.h>
#   include	<appImage.h>

#   include	<utilPropMask.h>
#   include	<utilMemoryBuffer.h>
#   include	"docExpandedTextAttribute.h"

#   include	<geo2DInteger.h>
#   include	<docBuf.h>
#   include	"docTocField.h"
#   include	<utilIndexMapping.h>

#   ifndef	TED_APP_H
#   define	TED_APP_H

#   define	RESIZE_BLOCK	10

#   define	RESIZE_BOTTOM_LEFT	0
#   define	RESIZE_BOTTOM_MIDDLE	1
#   define	RESIZE_BOTTOM_RIGHT	2

#   define	RESIZE_MIDDLE_LEFT	3
#   define	RESIZE_MIDDLE_RIGHT	4

#   define	RESIZE_TOP_LEFT		5
#   define	RESIZE_TOP_MIDDLE	6
#   define	RESIZE_TOP_RIGHT	7

#   define	RESIZE_COUNT		8

/************************************************************************/
/*									*/
/*  Private data for a document.					*/
/*									*/
/************************************************************************/

typedef struct TedDocument
    {
    BufferDocument *		tdDocument;
    TextAttribute		tdCurrentTextAttribute;
    int				tdCurrentTextAttributeNumber;
    int				tdCurrentScreenFont;

    int				tdPageGapTwips;

    DocumentSelection		tdDocumentSelection;
    SelectionGeometry		tdSelectionGeometry;
    SelectionDescription	tdSelectionDescription;
    int				tdBodySectionNumber;

    IndexMapping		tdAttributeToScreenFont;

    APP_WIDGET			tdCopyWidget;
    APP_WIDGET			tdCutWidget;
    APP_WIDGET			tdPasteWidget;

    APP_WIDGET			tdInsertMenu;
    APP_WIDGET			tdInsertMenuButton;
    APP_WIDGET			tdInsPictOption;
    APP_WIDGET			tdInsFileOption;
    APP_WIDGET			tdInsSymbolOption;
    APP_WIDGET			tdInsHyperlinkOption;
    APP_WIDGET			tdInsBookmarkOption;
    APP_WIDGET			tdInsInsertFootnoteOption;
    APP_WIDGET			tdInsInsertEndnoteOption;
    APP_WIDGET			tdInsInsertChftnsepOption;
    APP_WIDGET			tdInsInsertTableOption;
    APP_WIDGET			tdInsInsertPageNumberOption;
    APP_WIDGET			tdInsInsertLineBreakOption;
    APP_WIDGET			tdInsInsertPageBreakOption;
    APP_WIDGET			tdInsInsertColumnBreakOption;
    APP_WIDGET			tdInsInsertSectBreakOption;

    APP_WIDGET			tdTableMenu;
    APP_WIDGET			tdTableMenuButton;
    APP_WIDGET			tdTabInsertTableOption;
    APP_WIDGET			tdTabAddRowOption;
    APP_WIDGET			tdTabAddColumnOption;

    APP_WIDGET			tdFormatMenu;
    APP_WIDGET			tdFormatMenuButton;
    APP_WIDGET			tdFormatOneParaOption;

    APP_WIDGET			tdSelectTableWidget;
    APP_WIDGET			tdSelectRowWidget;
    APP_WIDGET			tdSelectColumnOption;

    APP_WIDGET			tdDeleteTableWidget;
    APP_WIDGET			tdDeleteRowWidget;
    APP_WIDGET			tdDeleteColumnOption;

    APP_WIDGET			tdDrawTableGridOption;

    APP_WIDGET			tdFontMenu;
    APP_WIDGET			tdFontMenuButton;
    APP_WIDGET			tdFontBoldOption;
    APP_WIDGET			tdFontItalicOption;
    APP_WIDGET			tdFontUnderlinedOption;
    APP_WIDGET			tdFontSuperscriptOption;
    APP_WIDGET			tdFontSubscriptOption;

    APP_WIDGET			tdToolsMenu;
    APP_WIDGET			tdToolsMenuButton;
    APP_WIDGET			tdToolsFormatToolOption;

    APP_WIDGET			tdFindOption;

    APP_COLOR_RGB		tdFieldColor;

    RGB8Color			tdTableColor;
    RGB8Color			tdSelColor;
    RGB8Color			tdCopiedSelColor;

    int				tdVisibleSelectionCopied;
    int				tdCanReplaceSelection;
    int				tdCopiedSelectionClosed;
    MemoryBuffer		tdCopiedSelection;
    MemoryBuffer		tdCopiedFont;
    MemoryBuffer		tdCopiedRuler;
    AppBitmapImage		tdCopiedImage;
    int				tdOwnsPrimarySelection;

    void *			tdFindProg;

#   ifdef USE_MOTIF
    XtIntervalId		tdHideIBarId;
    XtIntervalId		tdShowIBarId;
#   endif

#   ifdef USE_GTK
    guint			tdHideIBarId;
    guint			tdShowIBarId;
#   endif

#   ifdef USE_QT
    int				tdHideIBarId;
    int				tdShowIBarId;
#   endif

    APP_WINDOW			tdObjectWindow;
    APP_WINDOW			tdObjectResizeWindows[RESIZE_COUNT];
    int				tdObjectCornerMovedX;
    int				tdObjectCornerMovedY;
    int				tdScaleChangedX;
    int				tdScaleChangedY;
    int				tdObjectResizeCorner;

    int				tdDrawTableGrid;
    int				tdDrawMonochrome;

    int				tdInProgrammaticChange;
    } TedDocument;

/************************************************************************/
/*									*/
/*  Ted specific resources.						*/
/*									*/
/*  Also: Some global data items.					*/
/*									*/
/************************************************************************/

typedef struct TedAppResources
    {
				/****************************************/
				/*  Texts.				*/
				/****************************************/

    char *			tarFileNotRtf;
    char *			tarHeadFootNotReachable;

    char *			tarAppFileMenuText;
    char *			tarAppWinMenuText;
    char *			tarDocFileMenuText;
    char *			tarDocEditMenuText;
    char *			tarDocInsertMenuText;
    char *			tarDocWinMenuText;
    char *			tarDocFontMenuText;
    char *			tarDocFormatMenuText;
    char *			tarDocToolMenuText;
    char *			tarDocTableMenuText;
    char *			tarHelpMenuText;
    char *			tarAppHelpFileName;

    char *			tarSelectionColor;
    char *			tarCopiedSelectionColor;
    char *			tarPageNumberFormat;

				/****************************************/
				/*  Defaults.				*/
				/****************************************/
    char *			tarShowTableGridString;
    int				tarShowTableGridInt;

    char *			tarAutoHyphenateString;
    int				tarAutoHyphenateInt;

    char *			tarShadingMeshTwipsString;
    double			tarShadingMeshPointsDouble;

				/****************************************/
				/*  Global data.			*/
				/****************************************/

    AppInspector *		tarInspector;
    EditDocument *		tarManualDocument;

				/****************************************/
				/*  For Ted --Find and Ted --RegFind	*/
				/****************************************/

    const char *		tarFindPattern;
    int				tarFindRegex;
    } TedAppResources;

/************************************************************************/
/*									*/
/*  Used on 'Hyperlink' and 'Bookmark' dialogs.				*/
/*									*/
/************************************************************************/

typedef enum LinkKind
    {
    LINKkindHYPERLINK,
    LINKkindPAGE_NUMBER,
    LINKkindBOOKMARK_TEXT,
    LINKkindTEXT_PLUS_PAGE,

    LINKkind_COUNT
    } LinkKind;

/************************************************************************/
/*									*/
/*  Supported document formats.						*/
/*  Match an array in tedMain.c.					*/
/*									*/
/************************************************************************/

typedef enum TedDocumentKind
    {
    TEDdockindRTF= 0,
    TEDdockindTEXT_OPEN,
    TEDdockindTEXT_SAVE_WIDE,
    TEDdockindTEXT_SAVE_FOLDED,
    TEDdockindHTML_FILES,
    TEDdockindALL_FILES,

    TEDdockind_COUNT
    } TedDocumentKind;

/************************************************************************/
/*									*/
/*  Shared resources.							*/
/*									*/
/************************************************************************/

extern const int TedClipboardTextTargetCount;
extern AppSelectionTargetType TedClipboardTextTargets[];

extern const int TedPrimaryTargetCount;
extern AppSelectionTargetType TedPrimaryTargets[];

extern const int TedRulerTargetCount;
extern AppSelectionTargetType TedRulerTargets[];

extern const int TedFontTargetCount;
extern AppSelectionTargetType TedFontTargets[];

/************************************************************************/
/*									*/
/*  Geometry calculations.						*/
/*									*/
/************************************************************************/

extern int tedHasSelection(	const TedDocument *		td );
extern int tedHasIBarSelection(	const TedDocument *		td );

extern APP_EVENT_HANDLER_H( tedObserveFocus, w, voided, event );

extern void tedSplitParagraph(		EditDocument *		ed,
					int			onNewPage );

extern void tedEditReplaceSelectionWithTab(	EditDocument *		ed );

extern int tedChangeSelectionProperties(
				EditDocument *			ed,
				const PropertyMask *		taSetMask,
				const TextAttribute *		taSet,
				const PropertyMask *		ppUpdMask,
				const ParagraphProperties *	ppNew,
				const PropertyMask *		spUpdMask,
				const SectionProperties *	spNew );

extern void tedDelimitCurrentSelection(	EditDocument *		ed );

extern APP_MENU_CALLBACK_H( tedDocToolFind, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocToolFindNext, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocToolSpell, w, voided, event );

extern int tedIncludePlainDocument(	EditDocument *		ed,
					BufferDocument *	bdFrom );

extern int tedIncludeRtfDocument(	EditDocument *		ed,
					BufferDocument *	bdFrom );

extern int tedGetDocumentAttributes(
				TedDocument *			td,
				PropertyMask *			pUpdMask,
				TextAttribute *			pTaNew );

extern void tedDocCopy(		EditDocument *	ed );
extern void tedDocCut(		EditDocument *	ed );

extern void tedDocSelAll(	EditDocument *	ed );

extern void tedSetSelection(	EditDocument *			ed,
				const DocumentSelection *	dsSet,
				int				lastLine,
				int *				pScrolledX,
				int *				pScrolledY );

extern APP_MENU_CALLBACK_H( tedDocEditPaste, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFontCopy, w, voided, event );

extern void tedDocReplaceSelection(	EditDocument *		ed,
					const char *		word,
					int			len );

extern int tedDeleteTableSliceSelection(	EditDocument *	ed );

extern void tedSetSelectedPosition(
				EditDocument *			ed,
				const DocumentPosition *	dp,
				int				lastLine,
				int *				pScrolledX,
				int *				pScrolledY );

extern int tedSelectItemHome(	EditDocument *			ed,
				BufferItem *			bi,
				int *				pScrolledX,
				int *				pScrolledY );

extern void tedAdaptFontIndicatorsToSelection(	EditApplication *	ea,
						EditDocument *		ed );

extern void tedAdaptToolsToSelection(	EditDocument *		ed );

extern int tedExtendSelectionToPosition(
				EditDocument *			ed,
				const DocumentPosition *	dpAnchor,
				const DocumentPosition *	dpFound );

extern void tedScrollToSelection(	EditDocument *		ed,
					int *			pScrolledX,
					int *			pScrolledY );

extern APP_MENU_CALLBACK_H( tedDocFontBold, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFontItalic, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFontUnderlined, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFontSupersub, w, voided, event );

extern void tedScreenRectangles(	AppDrawingData *		add,
					const DocumentGeometry *	dg );

extern void tedAdaptPageToolToDocument(	EditApplication *	ea,
					EditDocument *		ed );

extern void tedAppReplace(	void *		voidea,
				const char *	word	);

extern void tedGetNamedPictures(	EditApplication *	ea );

extern int tedDocSetTopRuler(		EditDocument *	ed );
extern int tedDocSetBottomRuler(	EditDocument *	ed );

extern void tedDocAdaptTopRuler(
				EditDocument *			ed,
				const DocumentSelection *	ds,
				const SelectionGeometry *	sg,
				const SelectionDescription *	sd,
				const BufferItem *		bodySectBi );

extern void tedUndrawIBar(	const EditDocument *	ed );

extern void tedStartCursorBlink(	EditDocument *	ed );
extern void tedStopCursorBlink(		EditDocument *	ed );
extern void tedCleanCursorBlink(	TedDocument *	td );

extern APP_MENU_CALLBACK_H( tedDocInsertPicture, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertFile, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertLink, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertBookmark, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertFootnote, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertEndnote, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertChftnsep, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertPageNumber, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertLineBreak, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertPageBreak, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertColumnBreak, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocInsertSectBreak, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocToolInsertSymbol, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFormatOnePara, w, voided, event );

extern APP_PASTE_REPLY( tedPasteClipboardRtf, w, event, voided );
extern APP_PASTE_REPLY( tedPasteClipboardString, w, event, voided );
extern APP_PASTE_REPLY( tedPastePrimaryString, w, event, voided );
extern APP_PASTE_REPLY( tedPasteRulerTed, w, event, voided );
extern APP_PASTE_REPLY( tedPasteFontTed, w, event, voided );
extern APP_PASTE_REPLY( tedPasteClipboardPixmap, w, event, voided );
extern APP_PASTE_REPLY( tedPasteClipboardPng, w, event, voided );

extern APP_GIVE_COPY( tedCopyClipboardRtf, w, event, voided );
extern APP_GIVE_COPY( tedCopyClipboardString, w, event, voided );
extern APP_GIVE_COPY( tedCopyPrimaryString, w, event, voided );
extern APP_GIVE_COPY( tedCopyClipboardPng, w, event, voided );
extern APP_GIVE_COPY( tedCopyClipboardPixmap, w, event, voided );
extern APP_GIVE_COPY( tedCopyFontTed, w, event, voided );
extern APP_GIVE_COPY( tedCopyRulerTed, w, event, voided );

extern void tedClipboardLost(	APP_WIDGET			w,
				void *				voided,
				APP_EVENT *			clrEvent );

extern void tedPrimaryLost(	APP_WIDGET			w,
				void *				voided,
				APP_EVENT *			clrEvent );

extern int tedGetObjectSelection(
				TedDocument *  		 	td,
				const BufferItem **		pBodySectBi,
				int *				pPart,
				DocumentPosition *		dpObject,
				InsertedObject **		pIo );

extern void tedMoveObjectWindows(	EditDocument *		ed );

extern int tedEditReopenObject(		EditDocument *			ed,
					int				part,
					const DocumentPosition *	dpObj,
					const PositionGeometry *	pgObj );

extern int tedSaveObjectPicture(	AppBitmapImage *	abiTo,
					InsertedObject *	io );

extern void tedExposeSelection(	EditDocument *			ed,
				const DocumentSelection *	ds,
				const BufferItem *		bodySectBi,
				int				scrolledX,
				int				scrolledY );

extern void tedDrawRectangle(	EditDocument *		ed,
				DocumentRectangle *	drClip,
				int			ox,
				int			oy );

APP_SCROLLBAR_CALLBACK_H( tedDocHorizontalScrollbarCallback, bar, voided, e );
APP_SCROLLBAR_CALLBACK_H( tedDocVerticalScrollbarCallback, bar, voided, e );

extern int tedFinishDocumentSetup(	EditDocument *		ed );
extern void tedDocumentFirstVisible(	EditDocument *		ed );

extern APP_MENU_CALLBACK_H( tedDocFormatCopyRul, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFormatPasteRul, w, voided, event );

extern APP_MENU_CALLBACK_H( tedDocFormatIncreaseIndent, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFormatDecreaseIndent, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFormatAlignLeft, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFormatAlignRight, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFormatAlignCenter, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocFormatAlignJustify, w, voided, event );

extern int tedLayoutDocument(	void *				privateData,
				int				format,
				AppDrawingData *		add,
				const DocumentGeometry *	defDg );

extern int tedMakeDocumentWidget(	EditApplication *	ea,
					EditDocument *		ed );

extern int tedInsertTable(		EditDocument *		ed,
					int			rows,
					int			columns );

extern int tedInsertColumnInTable(	EditDocument *		ed );
extern int tedAppendColumnToTable(	EditDocument *		ed );
extern int tedInsertRowInTable(		EditDocument *		ed );
extern int tedAppendRowToTable(		EditDocument *		ed );

extern APP_MENU_CALLBACK_H( tedDocTableSelectTable, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocTableSelectRow, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocTableSelectColumn, w, voided, event );

extern APP_MENU_CALLBACK_H( tedDocTableDeleteTable, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocTableDeleteRow, w, voided, event );
extern APP_MENU_CALLBACK_H( tedDocTableDeleteColumn, w, voided, event );

extern void tedDocSetTableProperties(	EditDocument *		ed,
					const TableRectangle *	tr,
					const PropertyMask *	rpSetMask,
					const PropertyMask *	cpSetMask,
					const RowProperties *	rp );

extern void tedAppSetTableProperties(	EditApplication *	ea,
					const TableRectangle *	tr,
					const PropertyMask *	rpSetMask,
					const PropertyMask *	cpSetMask,
					const RowProperties *	rp );

extern void tedAppSetImageProperties(
				EditApplication *		ea,
				const PropertyMask *		pipSetMask,
				const PictureProperties *	pip );

extern void tedAdaptFormatToolToDocument(	EditDocument *	ed,
						int		choosePage );

extern void tedAppSetTableSelection(	EditDocument *		ed,
					const TableRectangle *	tr );

extern void tedChangeTableLayout(	EditDocument *		ed,
					BufferItem *		sectBi,
					int			row0Change,
					int			row1Change,
					int			col0Change,
					int			col1Change,
					int			row1Reformat,
					const PropertyMask *	rpSetMask,
					const PropertyMask *	cpSetMask,
					const RowProperties *	rp );

extern APP_MENU_CALLBACK_H( tedDocTableDrawGrid, w, voided, event );

extern void tedMergeParagraphsInSelection(	EditDocument *	ed );

extern int tedDeleteRowsFromTable(	EditDocument *		ed,
					int			row0,
					int			row1 );

extern int tedRollRowsInTable(		EditDocument *		ed,
					int			rowsdown );

extern int tedDeleteColumnsFromRows(	EditDocument *	ed,
					int		delRow0,
					int		delRow1,
					int		delCol0,
					int		delCol1 );

extern int tedRunPropertyDialog( EditDocument *			ed,
				const DocumentStatistics *	ds,
				APP_WIDGET			option,
				const char *			pixmapName );

extern int tedDocSetHyperlink(	EditDocument *		ed,
				const char *		file,
				const char *		mark );

extern int tedAppSetHyperlink(	EditApplication *	ea,
				const char *		file,
				const char *		mark );

extern int tedDocSetBookmark(	EditDocument *		ed,
				const char *		mark );

extern int tedDocRemoveHyperlink(	EditDocument *		ed );
extern int tedAppRemoveHyperlink(	EditApplication *	ea );

extern int tedDocRemoveBookmark(	EditDocument *		ed );

extern int tedDocGoToBookmark(	EditDocument *		ed,
				const char *		markName,
				int			markSize );

extern int tedSaveDocument(	const void *			privateData,
				int				format,
				const char *			applicationId,
				const char *			documentTitle,
				const char *			filename );

extern void * tedMakePrivateData( void );

extern void tedMakeDocumentReadonly(	EditDocument *	ed );

extern int tedDocFollowLink(	APP_WIDGET		option,
				EditDocument *		edFrom,
				const char *		fileName,
				int			fileSize,
				const char *		markName,
				int			markSize );

extern int tedAppFollowLink(	APP_WIDGET		option,
				EditApplication *	ea,
				const char *		fileName,
				int			fileSize,
				const char *		markName,
				int			markSize );

extern int tedSelectWholeParagraph(	EditApplication *	ea,
					int			direction );

extern int tedSelectWholeSection(	EditApplication *	ea,
					int			direction );

extern int tedDocDeleteCurrentFrame(		EditDocument *		ed );
extern int tedDocDeleteSelectedParagraphs(	EditDocument *		ed );
extern int tedAppDeleteSelectedParagraphs(	EditApplication *	ea );
extern int tedDeleteCurrentSection(	EditApplication *	ea );

extern int tedInsertParagraph(	EditApplication *	ea,
				int			after );

extern int tedInsertSection(	EditApplication *	ea,
				int			after );

extern int tedGetParaLineHeight(	int *			pLineHeight,
					EditDocument *		ed );

extern void tedShowFormatTool(	APP_WIDGET		toolOption,
				EditApplication *	ea );

extern void tedFormatToolAdaptToSelection( AppInspector *	ai,
				EditDocument *			ed,
				int				choosePage,
				DocumentTree *			ei,
				const DocumentSelection *	ds,
				const SelectionGeometry *	sg,
				const SelectionDescription *	sd );

extern int tedNewDocument(	EditApplication *	ea,
				EditDocument *		ed,
				const char *		filename );

extern int tedPrintDocument(	SimpleOutputStream *		sos,
				const struct PrintJob *		pj,
				const struct PrintGeometry *	pg );

extern void tedSuggestNup(	struct PrintGeometry *		pg,
				void *				privateData );

extern void tedFreeDocument(		void *			voidtd,
					int			format );

extern void tedRedoDocumentLayout(	EditDocument *		ed );

extern void tedFormatShowPagePage( EditApplication *		ea );
extern void tedFormatShowFontPage( EditApplication *		ea );
extern void tedFormatShowSymbolPage( EditApplication *		ea );
extern void tedFormatShowLinkPage( EditApplication *		ea );
extern void tedFormatShowBookmarkPage( EditApplication *	ea );

extern void tedFormatSetFindPattern(
				EditApplication *		ea,
				const char *			findPattern,
				int				findRegexp );

extern void tedSetPageLayout(	EditDocument *			ed,
				const DocumentGeometry *	dg,
				const PropertyMask *		setMask,
				int				whileDocument );

extern int tedAppSetDocumentProperties(
				EditApplication *		ea,
				const DocumentProperties *	dpNew,
				const PropertyMask *		updMask );

extern int tedChangeCurrentNote( EditApplication *		ea,
				const NoteProperties *		npSet );

extern APP_EVENT_HANDLER_H( tedMouseButtonPressed, w, voided, downEvent );
extern APP_EVENT_HANDLER_H( tedScrollEventHandler, w, voided, scrollEvent );

extern void tedDocGotKey(	void *				voided,
				int				keySym,
				unsigned int			state );

extern void tedDocGotString(	void *				voided,
				const char *			string,
				int				length );

extern void tedHideObjectWindows(	EditDocument *	ed );

extern int tedAppChangeSectionProperties(
				EditApplication *		ea,
				const PropertyMask *		spUpdMask,
				const SectionProperties *	spNew );

extern int tedAppChangeAllSectionProperties(
				EditApplication *		ea,
				const PropertyMask *		spUpdMask,
				const SectionProperties *	spNew );

extern int tedAppChangeParagraphProperties(
				EditApplication *		ea,
				const PropertyMask *		ppUpdMask,
				const ParagraphProperties *	ppNew );

extern int tedAppSetNewList(	EditApplication *		ea );

extern int tedAppChangeCurrentList(
				EditApplication *		ea,
				const DocumentList *		dlNew );

extern int tedDocChangeParagraphProperties(
				EditDocument *			ed,
				const PropertyMask *		ppUpdMask,
				const ParagraphProperties *	ppNew );

extern void tedAppDeleteHeaderFooter(	EditApplication *	ea,
					int			which );

extern void tedAppEditHeaderFooter(	EditApplication *	ea,
					APP_WIDGET		relative,
					APP_WIDGET		option,
					int			which );

extern int tedGetSelection(	DocumentSelection *		ds,
				SelectionGeometry *		sg,
				SelectionDescription *		sd,
				DocumentTree **			pEi,
				const BufferItem **		pBodySectBi,
				const TedDocument *		td );

extern void tedFillBookmarkList(	APP_WIDGET		list,
					const BufferDocument *	bd );

extern int tedFindRootForPosition(	DocumentTree **		pEi,
					BufferItem **		pSelSectBi,
					BufferItem **		pBodySectBi,
					int *			pPage,
					int *			pColumn,
					EditDocument *		ed,
					int			docX,
					int			docY );

extern void tedDetermineDefaultSettings(	TedAppResources *	tar );

extern void tedAppEditNote(		EditApplication *	ea );
extern void tedAppGotoNoteRef(		EditApplication *	ea );

extern int tedSetIBarSelection(		EditDocument *		ed,
					const DocumentPosition *	dp,
					int			lastLine,
					int *			pScrolledX,
					int *			pScrolledY );

extern int tedAppAllocateDocumentColor(	EditApplication *	ea,
					const RGB8Color *	rgb8 );

extern int tedDocAllocateDocumentColor(	EditDocument *		ed,
					const RGB8Color *	rgb8 );

extern void tedFontToolSet(	void *				voidea,
				const ExpandedTextAttribute *	etaSet,
				const PropertyMask *		taSetMask );

extern void tedListFontToolSet(	void *				voidea,
				const ExpandedTextAttribute *	etaSet,
				const PropertyMask *		taSetMask );

extern int tedOpenDocumentFile(	EditApplication *	ea,
				int *			pFormat,
				BufferDocument **	pBd,
				const char *		filename,
				APP_WIDGET		relative,
				APP_WIDGET		option );

extern int tedObjectDrag(	APP_WIDGET			w,
				EditDocument *			ed,
				APP_EVENT *			downEvent );

extern void tedObjectSetImageProperties(
				PropertyMask *			pipDoneMask,
				EditDocument *			ed,
				const BufferItem *		bodySectBi,
				InsertedObject *		io,
				const DocumentPosition *	dpObject,
				int				partObject,
				const PositionGeometry *	pgObject,
				const PropertyMask *		pipSetMask,
				const PictureProperties *	pipFrom );

extern int tedAppSelectCurrentFrame(	EditApplication *	ea );
extern int tedDocSelectCurrentFrame(	EditDocument *		ed );
extern int tedAppDeleteCurrentFrame(	EditApplication *	ea );

extern int tedAppSetBookmark(	EditApplication *	ea,
				const char *		markName );

extern int tedAppGoToBookmark(	EditApplication *	ea,
				const char *		markName,
				int			markSize );

extern int tedAppRemoveBookmark(EditApplication *	ea );

extern int tedAppGetBookmarkField(
				DocumentField **		pDf,
				EditApplication *		ea,
				const char *			markName,
				int				markSize );

extern void tedAppSetTocField(	EditApplication *		ea,
				const TocField *		tf );

extern void tedAppDeleteTocField( EditApplication *		ea );

extern void tedAppAddTocField(	EditApplication *		ea,
				const TocField *		tf );

extern void tedDocSetTocField(	EditDocument *			ed,
				const TocField *		tf );

extern void tedDocDeleteTocField( EditDocument *		ed );

extern void tedDocAddTocField(	EditDocument *			ed,
				const TocField *		tf );

extern int tedDocGetBookmarkField(
				DocumentField **		pDf,
				EditDocument *			ed,
				const char *			markName,
				int				markSize );

extern void tedDocInsertNote(	EditDocument *			ed,
				int				noteInExtIt,
				int				sepInExtIt );

extern void tedDocTableSelectTableRectangle(
				EditDocument *			ed,
				const TableRectangle *		tr );

extern void tedEditInsertSpecialParticule(
				EditDocument *			ed,
				int				kind,
				int				redoLayout );

extern void tedFormatSetParaIndent(
				EditDocument *			ed,
				int				align );

extern void tedDocSetParaOutlineLevel(
				EditDocument *			ed,
				int				level );

extern void tedAppSetParaOutlineLevel(
				EditApplication *		ea,
				int				level );

extern int tedFormatShiftIndent( EditDocument *			ed,
				int				step );

extern void tedInsertPageNumber( EditDocument *			ed );

extern int tedTtfToAfm(		EditApplication *		ea,
				const char *			prog,
				const char *			call,
				int				argc,
				char **				argv );

extern int tedAfmToGSFontmap(	EditApplication *		ea,
				const char *			prog,
				const char *			call,
				int				argc,
				char **				argv );

extern int tedOpenDocument(	EditApplication *		ea,
				void *				voidtd,
				int *				pFormat,
				APP_WIDGET			relative,
				APP_WIDGET			option,
				const char *			filename );

extern APP_MENU_CALLBACK_H( tedDocFilePrint, printOption, voided, e );
extern APP_MENU_CALLBACK_H( tedDocTableInsertTable, option, voided, e );
extern APP_MENU_CALLBACK_H( tedDocTableAddRow, option, voided, e );
extern APP_MENU_CALLBACK_H( tedDocTableAddColumn, option, voided, e );
extern APP_MENU_CALLBACK_H( tedDocFormatTool, option, voided, e );
extern APP_MENU_CALLBACK_H( tedDocShowPageTool, pageOption, voided, e );
extern APP_MENU_CALLBACK_H( tedDocFontPaste, option, voided, e );
extern APP_MENU_CALLBACK_H( tedDocToolFont, option, voided, e );
extern APP_MENU_CALLBACK_H( tedDocFileProps, option, voided, e );

extern void tedDocInsertStringWithAttribute(
					EditDocument *		ed,
					const char *		bytes,
					int			size,
					const TextAttribute *	taSet,
					const PropertyMask *	taSetMask );

extern void tedScaleObjectToSelectedParagraph(	EditDocument *		ed,
						InsertedObject *	io );

extern int tedObjectOpenPicture(	EditApplication *	ea,
					void *			voided,
					APP_WIDGET		relative,
					APP_WIDGET		option,
					const char *		filename );

extern void tedSetCurrentTextAttribute(	TedDocument *			td,
					int				IBar,
					const DocumentPosition *	dp );

extern void tedManagePrimarySelection(	EditDocument *			ed );

extern void tedDescribeSelection(	EditDocument *			ed );

#   endif	/*  TED_APP_H	*/
