/************************************************************************/
/*									*/
/*  PostScript printing.						*/
/*									*/
/************************************************************************/

#   include	<sioGeneral.h>
#   include	<psPrint.h>
#   include	<docBuf.h>
#   include	"docDraw.h"
#   include	"docParticuleData.h"

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int docPsPrintGetDocumentFonts(
				BufferDocument *		bd,
				PostScriptTypeList *		pstl,
				const PostScriptFontList *	x_psfl );

extern int docPsListImageFonts( PostScriptTypeList *		pstl,
				const PictureProperties *	pip,
				const MemoryBuffer *		mb,
				const PostScriptFontList *	psfl,
				const char *			prefix );

extern int docPsPrintTab(	PrintingState *			ps,
				DrawingContext *		dc,
				int				xShift,
				int				yShift,
				const BufferItem *		bi,
				const TextParticule *		tp,
				ParticuleData *			pd,
				int				baseLine,
				int				lineHeight );

extern void docPsSaveTabLeaderProcedures(	SimpleOutputStream *	sos );

extern int docPsPrintDrawDrawingShape(
				const DocumentRectangle *	drTwips,
				int				page,
				DrawingShape *			ds,
				DrawingContext *		dc,
				void *				vps );

extern int docPsPrintObject(	PrintingState *			ps,
				DrawingContext *		dc,
				int				xShift,
				int				yShift,
				InsertedObject *		io,
				const PostScriptFontList *	psfl,
				const ParticuleData *		pd,
				int				baseLine );

extern int docPsPrintShapeImage( PrintingState *		ps,
				DrawingContext *		dc,
				DrawingShape *			ds,
				const AffineTransform2D *	at,
				const PostScriptFontList *	psfl );

extern int docPsPrintTextLine(	BufferItem *			paraBi,
				int				line,
				const ParagraphFrame *		pf,
				const DocumentRectangle *	drLine,
				void *				vps,
				DrawingContext *		dc,
				const BlockOrigin *		bo );

extern int docPsPrintDocument(
			SimpleOutputStream *		sos,
			const char *			title,
			const char *			applicationName,
			const char *			applicationReference,
			const char *			fontDirectory,
			double				shadingMesh,
			const LayoutContext *		lc,
			const PrintGeometry *		pg );

