/************************************************************************/
/*									*/
/*  List the fonts in a document.					*/
/*  Manage resources for layout.					*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	<appMatchFont.h>

#   include	<appImage.h>
#   include	"docParticuleData.h"
#   include	"docPsPrint.h"
#   include	"docListFonts.h"
#   include	<sioHex.h>
#   include	<sioMemory.h>
#   include	<appWinMeta.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Recursively retrieve the list of PostScriptFonts that is used in	*/
/*  a document.								*/
/*									*/
/************************************************************************/

/************************************************************************/
/*									*/
/*  Find the fonts of an image.						*/
/*									*/
/************************************************************************/

typedef int (*LIST_IMG_FONTS_PS)(
				PostScriptTypeList *	pstl,
				SimpleInputStream *	sis,
				const PostScriptFontList * psfl,
				const char *		prefix,
				int			mapMode,
				int			xWinExt,
				int			yWinExt,
				int			twipsWide,
				int			twipsHigh );

int docPsListImageFonts(	PostScriptTypeList *		pstl,
				const PictureProperties *	pip,
				const MemoryBuffer *		mb,
				const PostScriptFontList *	psfl,
				const char *			prefix )
    {
    LIST_IMG_FONTS_PS		listFontsPs;

    SimpleInputStream *		sisMem;
    SimpleInputStream *		sisMeta;

    switch( pip->pipType )
	{
	case DOCokPICTWMETAFILE:
	    listFontsPs= appWmfListFontsPs;
	    break;

	case DOCokMACPICT:
	    listFontsPs= appMacPictListFontsPs;
	    break;

	case DOCokPICTEMFBLIP:
	    listFontsPs= appEmfListFontsPs;
	    break;

	default:
	    LDEB(pip->pipType); return 0;
	}

    sisMem= sioInMemoryOpen( mb );
    if  ( ! sisMem )
	{ XDEB(sisMem); return -1;	}

    sisMeta= sioInHexOpen( sisMem );
    if  ( ! sisMeta )
	{ XDEB(sisMem); return -1;	}

    if  ( (*listFontsPs)( pstl, sisMeta, psfl, prefix, pip->pipMapMode,
				    pip->pip_xWinExt, pip->pip_yWinExt,
				    pip->pipTwipsWide, pip->pipTwipsHigh ) )
	{ LDEB(1); return -1;	}

    sioInClose( sisMeta );
    sioInClose( sisMem );

    return 0;
    }

/************************************************************************/

typedef struct GetDocumentFonts
    {
    DocumentFontList *			gdfDocumentFontList;
    const PostScriptFontList *		gdfPostScriptFontList;
    PostScriptTypeList *		gdfPostScriptTypeList;
    } GetDocumentFonts;

/************************************************************************/

static int docPsListObjectFonts( const InsertedObject *		io,
				const char *			prefix,
				void *				through )
    {
    GetDocumentFonts *		gdf= (GetDocumentFonts *)through;
    const PostScriptFontList *	psfl= gdf->gdfPostScriptFontList;
    PostScriptTypeList *	pstl= gdf->gdfPostScriptTypeList;

    switch( io->ioKind )
	{
	case DOCokMACPICT:
	case DOCokPICTWMETAFILE:
	case DOCokPICTEMFBLIP:
	    return docPsListImageFonts( pstl,
				&(io->ioPictureProperties),
				&(io->ioObjectData), psfl, prefix );
	    break;

	case DOCokPICTJPEGBLIP:
	case DOCokPICTPNGBLIP:
	    return 0;

	case DOCokOLEOBJECT:
	    if  ( io->ioResultKind == DOCokPICTWMETAFILE	||
		  io->ioResultKind == DOCokPICTEMFBLIP		)
		{
		return docPsListImageFonts( pstl,
				&(io->ioPictureProperties),
				&(io->ioResultData), psfl, prefix );
		}
	    else{ /*LDEB(io->ioResultKind);*/ return 0;	}

	case DOCokEPS_FILE:
	    LDEB(io->ioKind);
	    return 0;

	case DOCokDRAWING_SHAPE:
	    return 0;

	default:
	    LDEB(io->ioKind); return 0;
	}
    }

static int docPsPrintGotSpan(	const BufferDocument *		bd,
				BufferItem *			paraBi,
				const TextAttribute *		ta,
				int				from,
				int				upto,
				void *				through )
    {
    GetDocumentFonts *		gdf= (GetDocumentFonts *)through;
    DocumentFontList *		dfl= gdf->gdfDocumentFontList;
    const PostScriptFontList *	psfl= gdf->gdfPostScriptFontList;
    PostScriptTypeList *	pstl= gdf->gdfPostScriptTypeList;

    const AfmFontInfo *		afi;

    const int			appearsInText= 1;

    afi= appGetFontInfoForAttribute( ta, dfl, psfl );
    if  ( ! afi )
	{ XDEB(afi); return -1;	}

    if  ( psRememberPostsciptFace( pstl, afi, ta, "f", appearsInText ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

int docPsPrintGetDocumentFonts(	BufferDocument *		bd,
				PostScriptTypeList *		pstl,
				const PostScriptFontList *	psfl )
    {
    DocumentFontList *		dfl= &(bd->bdProperties.dpFontList);

    ScanDocumentFonts		sdf;
    GetDocumentFonts		gdf;

    gdf.gdfDocumentFontList= dfl;
    gdf.gdfPostScriptFontList= psfl;
    gdf.gdfPostScriptTypeList= pstl;

    sdf.sdfListObjectFonts= docPsListObjectFonts;
    sdf.sdfDocListSpanFont= docPsPrintGotSpan;
    sdf.sdfThrough= &gdf;

    /*  a  */
    if  ( docListDocumentFonts( bd, &sdf ) )
	{ LDEB(1); return -1;;	}

    return 0;
    }

