/************************************************************************/
/*									*/
/*  Open the objects embedded in a document.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<sioMemory.h>
#   include	<sioStdio.h>
#   include	<sioHex.h>
#   include	<sioEndian.h>

#   include	<appImage.h>
#   include	<appWinMeta.h>

#   include	<appDebugon.h>

#   include	<docBuf.h>

/************************************************************************/
/*									*/
/*  Make the bitmap for an image.					*/
/*  Make a name for an image.						*/
/*									*/
/************************************************************************/

static int docGetBitmap(	bmReadBitmap		readBitmap,
				void **			pPrivate,
				const MemoryBuffer *	mb )
    {
    int			res;
    AppBitmapImage *	abi= (AppBitmapImage *)malloc( sizeof(AppBitmapImage) );

    SimpleInputStream *	sisMem;
    SimpleInputStream *	sisBitmap;

    if  ( ! abi )
	{ XDEB(abi); return -1;	}
    bmInitBitmapImage( abi );

    sisMem= sioInMemoryOpen( mb );
    if  ( ! sisMem )
	{ XDEB(sisMem); return -1;	}

    sisBitmap= sioInHexOpen( sisMem );
    if  ( ! sisBitmap )
	{ XDEB(sisMem); return -1;	}

    res= (*readBitmap)( &(abi->abiBitmap), &(abi->abiBuffer), sisBitmap );

    sioInClose( sisBitmap );
    sioInClose( sisMem );

    if  ( res < 0 )
	{ LDEB(res); return -1;	}
    if  ( res > 0 )
	{ return 0;		}

    *pPrivate= (void *)abi;

    return 0;
    }

int docGetBitmapForObjectData(	int			kind,
				void **			pPrivate,
				const MemoryBuffer *	mb )
    {
    switch( kind )
	{
	case DOCokPICTWMETAFILE:
	    if  ( docGetBitmap( appMetaPlayWmfImg, pPrivate, mb )	)
		{ LDEB(1); return -1;	}

	    break;

	case DOCokPICTPNGBLIP:
	    if  ( docGetBitmap( bmPngReadPng, pPrivate, mb )	)
		{ LDEB(1); return -1;	}
	    break;

	case DOCokPICTJPEGBLIP:
	    if  ( docGetBitmap( bmJpegReadJfif, pPrivate, mb )	)
		{ LDEB(1); return -1;	}

	    break;

	case DOCokMACPICT:
	case DOCokPICTEMFBLIP:
	default:
	    LDEB(kind); return -1;
	}

    return 0;
    }

int docGetBitmapForObject(	InsertedObject *	io )
    {
    switch( io->ioKind )
	{
	case DOCokPICTWMETAFILE:
	    if  ( ! io->ioPrivate					&&
		  docGetBitmapForObjectData( io->ioKind,
				&(io->ioPrivate), &(io->ioObjectData) )	)
		{ LDEB(1); return 0;	}

	    if  ( io->ioPrivate )
		{ io->ioPictureProperties.pipMetafileIsBitmap= 1;	}

	    break;

	case DOCokPICTPNGBLIP:
	case DOCokPICTJPEGBLIP:
	    if  ( ! io->ioPrivate					&&
		  docGetBitmapForObjectData( io->ioKind,
				&(io->ioPrivate), &(io->ioObjectData) )	)
		{ LDEB(1); return 0;	}
	    break;

	case DOCokOLEOBJECT:
	    if  ( io->ioResultKind == DOCokPICTWMETAFILE )
		{
		if  ( ! io->ioPrivate					&&
		      docGetBitmapForObjectData( io->ioResultKind,
				&(io->ioPrivate), &(io->ioResultData) )	)
		    { LDEB(1); return 0;	}

		if  ( io->ioPrivate )
		    { io->ioPictureProperties.pipMetafileIsBitmap= 1;	}

		return 0;
		}

	    if  ( io->ioResultKind == DOCokPICTPNGBLIP	||
		  io->ioResultKind == DOCokPICTJPEGBLIP )
		{
		if  ( ! io->ioPrivate					&&
		      docGetBitmapForObjectData( io->ioResultKind,
				&(io->ioPrivate), &(io->ioResultData) )	)
		    { LDEB(1); return 0;	}

		return 0;
		}

	    return 0;

	case DOCokMACPICT:
	case DOCokPICTEMFBLIP:
	default:
	    LDEB(io->ioKind); return 0;
	}

    return 0;
    }

