/************************************************************************/
/*									*/
/*  Layout utility functions relating to DrawingShapes			*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	"docPageGrid.h"
#   include	"docLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Remember that the layout calculations for a shape must be redone.	*/
/*									*/
/************************************************************************/

void docDrawingShapeInvalidateTextLayout(	DrawingShape *	ds )
    {
    int		child;

    ds->dsDocumentTree.eiPageFormattedFor= -1;
    ds->dsDocumentTree.eiColumnFormattedFor= -1;

    for ( child= 0; child < ds->dsChildCount; child++ )
	{ docDrawingShapeInvalidateTextLayout( ds->dsChildren[child] ); }

    return;
    }

/************************************************************************/
/*									*/
/*  Calculate the page rectangle for a shape.				*/
/*									*/
/************************************************************************/

void docShapePageY(		LayoutPosition *	lpShapeTop,
				LayoutPosition *	lpBelowShape,
				const DrawingShape *	ds,
				const BufferItem *	paraBi,
				const LayoutPosition *	lpLineTop,
				const BlockFrame *	bf )
    {
    const ShapeProperties *	sp= &(ds->dsShapeProperties);
    int				yRefProp= sp->spYReference;
    int				shapeHigh= sp->spRect.drY1- sp->spRect.drY0;

    BlockFrame			bfShape;

    docLayoutInitBlockFrame( &bfShape );

    if  ( yRefProp == FYrefIGNORE )
	{ yRefProp= ds->dsYReference; }

    *lpShapeTop= *lpLineTop;

    docLayoutFrameY( &bfShape,
			yRefProp, ds->dsYPosition, sp->spRect.drY0,
			lpLineTop, &(paraBi->biTopPosition),
			bf, -shapeHigh, shapeHigh );

    lpShapeTop->lpPageYTwips= bfShape.bfContentRect.drY0;

    *lpBelowShape= *lpShapeTop;
    lpBelowShape->lpPageYTwips += shapeHigh;

    return;
    }

void docShapePageRectangle(	LayoutPosition *	lpShapeTop,
				LayoutPosition *	lpBelowShape,
				int *			pX0,
				int *			pX1,
				const DrawingShape *	ds,
				const BufferItem *	paraBi,
				const LayoutPosition *	lpLineTop,
				const ParagraphFrame *	pfRef,
				const BlockFrame *	bfRef,
				int			xChar )
    {
    const ShapeProperties *	sp= &(ds->dsShapeProperties);
    int				xRefProp= sp->spXReference;
    int				shapeWide= sp->spRect.drX1- sp->spRect.drX0;

    BlockFrame			bfShape;

    docLayoutInitBlockFrame( &bfShape );

    docShapePageY( lpShapeTop, lpBelowShape, ds, paraBi, lpLineTop, bfRef );

    if  ( xRefProp == FXrefIGNORE )
	{ xRefProp= ds->dsXReference; }

    docLayoutFrameX( &bfShape,
			xRefProp, ds->dsXPosition, sp->spRect.drX0,
			paraBi->biParaTableNesting > 0 && ds->ds_fLayoutInCell,
			pfRef, bfRef, xChar, shapeWide );

    *pX0= bfShape.bfContentRect.drX0;
    *pX1= bfShape.bfContentRect.drX0+ shapeWide;

    return;
    }

/************************************************************************/
/*									*/
/*  Recalculate the layout of a text box (shptxt) if necessary.		*/
/*									*/
/************************************************************************/

int docShapeCheckTextLayout(
			DrawingShape *			ds,
			const DocumentRectangle *	drTwips,
			DocumentRectangle *		drChanged,
			const BufferItem *		bodySectBi,
			int				page,
			int				column,
			const LayoutContext *		lc,
			INIT_LAYOUT_EXTERNAL		initLayoutExternal )
    {
    DocumentGeometry	dgBox;

    int			wide;
    int			high;

    utilInitDocumentGeometry( &dgBox );

    if  ( drTwips->drX0 <= drTwips->drX1 )
	{
	wide= drTwips->drX1- drTwips->drX0;
	dgBox.dgLeftMarginTwips= drTwips->drX0;
	}
    else{
	wide= drTwips->drX0- drTwips->drX1;
	dgBox.dgLeftMarginTwips= drTwips->drX1;
	}

    if  ( drTwips->drY0 <= drTwips->drY1 )
	{
	high= drTwips->drY1- drTwips->drY0;
	dgBox.dgTopMarginTwips= drTwips->drY0;
	}
    else{
	high= drTwips->drY0- drTwips->drY1;
	dgBox.dgTopMarginTwips= drTwips->drY1;
	}

    dgBox.dgRightMarginTwips=  dgBox.dgPageWideTwips- 
					dgBox.dgLeftMarginTwips- wide;

    dgBox.dgLeftMarginTwips += EMUtoTWIPS( ds->ds_dxTextLeft );
    dgBox.dgTopMarginTwips += EMUtoTWIPS( ds->ds_dyTextTop );
    dgBox.dgRightMarginTwips += EMUtoTWIPS( ds->ds_dxTextRight );
    /* Irrelevant: */
    dgBox.dgBottomMarginTwips= 0;

    ds->dsDocumentTree.eiRoot->biSectDocumentGeometry= dgBox;

    if  ( page != ds->dsDocumentTree.eiPageFormattedFor		||
	  column != ds->dsDocumentTree.eiColumnFormattedFor	)
	{
	if  ( docLayoutExternalItem( &(ds->dsDocumentTree),
		drChanged, page, column, dgBox.dgTopMarginTwips,
		bodySectBi, lc, initLayoutExternal ) )
	    { LLDEB(page,column); return -1;	}
	}

    return 0;
    }
