#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<limits.h>

#   include	"docDraw.h"
#   include	"docPageGrid.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Paragraph drawing machinery.					*/
/*									*/
/************************************************************************/

/************************************************************************/
/*									*/
/*  Draw paragraph borders and shading.					*/
/*									*/
/************************************************************************/

int docDrawParaOrnaments(	void *				through,
				const ParagraphDrawingStrip *	pds,
				const BufferItem *		paraBi,
				const ParagraphFrame *		pf,
				DrawingContext *		dc,
				const BlockOrigin *		bo )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    const BufferDocument *	bd= lc->lcDocument;

    LayoutPosition		lpTop;
    LayoutPosition		lpBelow;

    BlockOrnaments		ornaments;
    DocumentRectangle		drPara;
    DocumentRectangle		drOutside;
    DocumentRectangle		drInside;

    docInitBlockOrnaments( &ornaments );

    drPara= pf->pfParaContentRect;
    if  ( paraBi->biParaFirstIndentTwips < 0 )
	{ drPara.drX0 += paraBi->biParaFirstIndentTwips;	}

    docShiftPosition( &lpTop, bo, &(pds->pdsShadeTop) );
    docShiftPosition( &lpBelow, bo, &(pds->pdsShadeBelow) );

    drPara.drY0= lpTop.lpPageYTwips;
    drPara.drY1= lpBelow.lpPageYTwips;

    if  ( pds->pdsAtParaTop && ( paraBi->biParaFlags & PARAflagFILL_BEFORE ) )
	{ drPara.drY0 -= paraBi->biParaSpaceBeforeTwips;	}

    if  ( pds->pdsAtParaBottom && ( paraBi->biParaFlags & PARAflagFILL_AFTER ) )
	{ drPara.drY1 += paraBi->biParaSpaceAfterTwips;	}

    if  ( paraBi->biParaTableNesting > 0 )
	{
	const BufferItem *	rowBi= docGetRowItem( (BufferItem *)paraBi );

	if  ( ! rowBi )
	    { XDEB(rowBi);	}
	else{
	    int	x0= pf->pfParaContentRect.drX0- rowBi->biRowHalfGapWidthTwips;
	    int	x1= pf->pfParaContentRect.drX1+ rowBi->biRowHalfGapWidthTwips;

	    if  ( drPara.drX0 < x0 )
		{ drPara.drX0=  x0;	}
	    if  ( drPara.drX1 > x1 )
		{ drPara.drX1=  x1;	}
	    }
	}

    docGetParaOrnaments( &ornaments, &drOutside, &drInside, &drPara,
			bd, paraBi, pds->pdsAtParaTop, pds->pdsAtParaBottom );

    if  ( (*dc->dcDrawOrnaments)( &ornaments, lpTop.lpPage,
						&drOutside, &drInside,
						through, dc ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Count the number of lines that fit on the current page.		*/
/*									*/
/************************************************************************/

int docDelimitParagraphDrawingStrip(
			ParagraphDrawingStrip *		pds,
			const BufferItem *		paraBi,
			int				countAfter,
			const LayoutPosition *		lpShadeTop,
			int				lineFrom,
			const LayoutPosition *		lpThisFrame,
			const BlockOrigin *		bo )
    {
    const TextLine *	tl;
    LayoutPosition	lp;

    int			line= lineFrom;
    int			atTop= lineFrom == 0;
    int			atBottom= 0;

    LayoutPosition	lpBelow= *lpShadeTop;

    tl= paraBi->biParaLines+ line;
    while( line < paraBi->biParaLineCount )
	{
	docShiftPosition( &lp, bo, &(tl->tlTopPosition) );

	if  ( DOC_COLUMN_AFTER( &lp, lpThisFrame ) )
	    { break;	}
	if  ( DOC_COLUMN_AFTER( lpThisFrame, &lp ) )
	    { line++; tl++; continue;	}

	lp.lpPageYTwips += tl->tlLineStride;
	lp.lpAtTopOfColumn= 0;

	docLayoutPushBottomDown( &lpBelow, &lp );

	line++; tl++;
	}

    if  ( line == paraBi->biParaLineCount )
	{
	lp= paraBi->biBelowPosition;

	if  ( ! countAfter )
	    { lp.lpPageYTwips -= paraBi->biParaSpaceAfterTwips;	}

	docLayoutPushBottomDownShifted( &lpBelow, &lp, bo );
	atBottom= 1;
	}

    pds->pdsLineFrom= lineFrom;
    pds->pdsLineUpto= line;
    pds->pdsAtParaTop= atTop;
    pds->pdsAtParaBottom= atBottom;

    pds->pdsShadeTop= *lpShadeTop;
    pds->pdsShadeBelow= lpBelow;

    return 0;
    }

/************************************************************************/

int docDrawParagraphStrip(		void *			through,
					ParagraphDrawingStrip *	pds,
					BufferItem *		paraBi,
					int			countAfter,
					const LayoutPosition *	lpShadeTop,
					int			lineFrom,
					const ParagraphFrame *	pf,
					DrawingContext *	dc,
					const LayoutPosition *	lpThisFrame,
					const BlockOrigin *	bo )
    {
    if  ( docDelimitParagraphDrawingStrip( pds, paraBi, countAfter,
				    lpShadeTop, lineFrom, lpThisFrame, bo ) )
	{ LDEB(1); return -1;	}

    if  ( pds->pdsLineUpto > lineFrom && dc->dcDrawOrnaments )
	{
	if  ( docDrawParaOrnaments( through, pds, paraBi, pf, dc, bo ) )
	    { LDEB(1); return -1;	}
	}

    if  ( docDrawTextLines( through, pds, paraBi, pf, dc, bo ) )
	{ LDEB(lpThisFrame->lpPage); return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Print a node in the BufferItem hierarchy.				*/
/*									*/
/*  1)  The last page is finished by the caller.			*/
/*									*/
/************************************************************************/

int docDrawParaItem(		LayoutPosition *		lpBelow,
				BufferItem *			paraBi,
				void *				through,
				DrawingContext *		dc,
				const BlockOrigin *		bo )
    {
    ParagraphFrame		pf;
    int				line= 0;

    const LayoutContext *	lc= &(dc->dcLayoutContext);
    const BufferDocument *	bd= lc->lcDocument;

    BlockFrame			bf;
    LayoutPosition		lpTop;
    LayoutPosition		lpShadeTop;

    docLayoutInitBlockFrame( &bf );
    docParaBlockFrameTwips( &bf, paraBi, dc->dcBodySectBi, bd,
					    paraBi->biTopPosition.lpPage,
					    paraBi->biTopPosition.lpColumn );

    docParagraphFrameTwips( &pf, &bf, paraBi );

    docShiftPosition( &lpTop, bo, &(paraBi->biTopPosition) );
    lpShadeTop= lpTop;

    if  ( ! lpShadeTop.lpAtTopOfColumn )
	{ lpShadeTop.lpPageYTwips += paraBi->biParaSpaceBeforeTwips; }

    while( line < paraBi->biParaLineCount )
	{
	const int		countAfter= 0;

	ParagraphDrawingStrip	pds;

	if  ( docDrawParagraphStrip( through, &pds, paraBi, countAfter,
			    &lpShadeTop, line, &pf, dc, &lpTop, bo ) )
	    { LDEB(line); return -1;	}

	line= pds.pdsLineUpto;
	docLayoutPushBottomDown( lpBelow, &(pds.pdsShadeBelow) );

	/*  1  */
if  ( paraBi->biInExternalItem == DOCinSHPTXT )
    { break;	}

	if  ( DOC_COLUMN_AFTER( &(paraBi->biBelowPosition), &lpTop ) )
	    {
	    int ret= docDrawToNextColumn( paraBi, paraBi,
					    through, &lpTop, &bf, dc );
	    if  ( ret < 0 )
		{ SLDEB(docLevelStr(paraBi->biLevel),ret);return -1;	}
	    if  ( ret > 0 )
		{ break;						}

	    docParagraphFrameTwips( &pf, &bf, paraBi );
	    lpShadeTop= lpTop;
	    }
	}

    if  ( line >= paraBi->biParaLineCount )
	{
	docLayoutPushBottomDownShifted( lpBelow, &(paraBi->biBelowPosition),
									bo );
	}

    return 0;
    }

