#   include	"tedConfig.h"

#   include	<stdlib.h>

#   include	"docDraw.h"
#   include	"docLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Draw external items such as headers/footers/footnotes/endnotes.	*/
/*									*/
/************************************************************************/

/************************************************************************/
/*									*/
/*  Print/Draw Headers/Footers.						*/
/*									*/
/************************************************************************/

static int docDrawHeaderFooter(	BufferItem *		bodySectBi,
				void *			through,
				DocumentTree *		ei,
				DrawingContext *	dc,
				int			page )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);

    const int		column= 0; /* irrelevant */

    LayoutPosition	lpBelow;

    docInitLayoutPosition( &lpBelow );

    if  ( dc->dcClipRect )
	{
	const int		justUsed= 1;
	DocumentRectangle	drExtern;

	if  ( docGetExternalItemBox( &drExtern, bodySectBi, ei, justUsed,
							    page, column, lc ) )
	    { LDEB(1); return -1;	}

	if  ( ! geoIntersectRectangle( &drExtern, &drExtern, dc->dcClipRect ) )
	    { return 0;	}
	}

    if  ( page != ei->eiPageFormattedFor	||
	  column != ei->eiColumnFormattedFor	)
	{
	if  ( docLayoutExternalItem( ei, (DocumentRectangle *)0,
			page, column, ei->eiY0UsedTwips,
			bodySectBi, lc, dc->dcInitLayoutExternal )	)
	    { LLDEB(page,column); return -1;	}
	}

    dc->dcBodySectBi= bodySectBi;

    if  ( docDrawItem( &lpBelow, ei->eiRoot, through, dc ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

int docDrawPageHeader(	BufferItem *			bodySectBi,
			void *				through,
			DrawingContext *		dc,
			int				page )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferDocument *		bd= lc->lcDocument;

    DocumentTree *		ei= (DocumentTree *)0;
    int				inExternalItem;
    int				isEmpty;

    inExternalItem= docWhatPageHeader( &ei, &isEmpty, bodySectBi, page, bd );

    if  ( ! ei || ! ei->eiRoot )
	{ return 0;	}

    if  ( docDrawShapesForTree( ei, bodySectBi, through, dc, 1, page ) )
	{ LDEB(page);	}

    if  ( docDrawHeaderFooter( bodySectBi, through, ei, dc, page ) )
	{ LDEB(page); return 1;	}

    if  ( docDrawShapesForTree( ei, bodySectBi, through, dc, 0, page ) )
	{ LDEB(page);	}

    return 0;
    }

int docDrawPageFooter(	BufferItem *			bodySectBi,
			void *				through,
			DrawingContext *		dc,
			int				page )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferDocument *		bd= lc->lcDocument;
    DocumentTree *		ei= (DocumentTree *)0;
    int				inHeaderFooter;
    int				isEmpty;

    inHeaderFooter= docWhatPageFooter( &ei, &isEmpty, bodySectBi, page, bd );

    if  ( ! ei || ! ei->eiRoot )
	{ return 0;	}

    if  ( docDrawShapesForTree( ei, bodySectBi, through, dc, 1, page ) )
	{ LDEB(page);	}

    if  ( docDrawHeaderFooter( bodySectBi, through, ei, dc, page ) )
	{ LDEB(page); return 1;	}

    if  ( docDrawShapesForTree( ei, bodySectBi, through, dc, 0, page ) )
	{ LDEB(page);	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw the notes on a page.						*/
/*									*/
/*  1)  Calculate the position of the separator.			*/
/*  2)  In clipped drawing.. Will the separator be visible anyway?	*/
/*  3)  If necassary recalculate the layout of the separator.		*/
/*  4)  Draw it.							*/
/*									*/
/************************************************************************/

static int docDrawNoteSeparator(LayoutPosition *	lpBelow,
				void *			through,
				DrawingContext *	dc,
				const DocumentField *	dfFirstNote,
				const DocumentNote *	dnFirstNote,
				int			extItKind )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferDocument *		bd= lc->lcDocument;
    const DocumentTree *	eiFirstNote;
    DocumentTree *		eiNoteSep;
    int				y0Twips;

    int				ret;

    DocumentRectangle		drExtern;
    int				page;
    int				column;

    const BufferItem *		bodySectBi;

    eiFirstNote= &(dnFirstNote->dnDocumentTree);
    page= eiFirstNote->eiRoot->biTopPosition.lpPage;
    column= eiFirstNote->eiRoot->biTopPosition.lpColumn;

    bodySectBi= docGetBodySectBiOfScope( &(dfFirstNote->dfSelectionScope), bd );

    /*  1  */
    ret= docNoteSeparatorRectangle( &drExtern, &eiNoteSep, &y0Twips,
				bodySectBi, dnFirstNote, extItKind, lc );
    if  ( ret < 0 )
	{ LDEB(ret); return -1;	}
    if  ( ret > 0 )
	{ return 0;	}

    /*  2  */
    if  ( dc->dcClipRect						&&
	  ! geoIntersectRectangle( &drExtern, &drExtern, dc->dcClipRect ) )
	{ return 0;	}

    /*  3  */
    if  ( page != eiNoteSep->eiPageFormattedFor		||
	  column != eiNoteSep->eiColumnFormattedFor	)
	{
	if  ( docLayoutExternalItem( eiNoteSep, (DocumentRectangle *)0,
			page, column, y0Twips,
			bodySectBi, lc, dc->dcInitLayoutExternal )	)
	    { LDEB(1); return -1;	}
	}

    /*  4  */
    if  ( docDrawItem( lpBelow, eiNoteSep->eiRoot, through, dc ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

int docDrawFootnotesForColumn(	int				page,
				int				column,
				void *				through,
				DrawingContext *		dc )
    {
    int				rval= 0;
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferDocument *		bd= lc->lcDocument;
    DocumentField *		dfNote;
    DocumentNote *		dn;

    const DocumentTree *	eiFirstNote;
    const BufferItem *		bodySectBi;

    const BufferItem *		bodySectBiSave= dc->dcBodySectBi;

    LayoutPosition		lpBelow;

    docInitLayoutPosition( &lpBelow );

    dfNote= docGetFirstNoteFromColumn( &dn, bd,
					    page, column, DOCinFOOTNOTE );
    if  ( ! dfNote )
	{ goto ready;	}

    eiFirstNote= &(dn->dnDocumentTree);
    bodySectBi= docGetBodySectBiOfScope( &(dfNote->dfSelectionScope), bd );

    dc->dcBodySectBi= bodySectBi;

    if  ( docDrawNoteSeparator( &lpBelow, through, dc, dfNote, dn, DOCinFTNSEP ) )
	{ LDEB(page);	}

    for ( ;
	  dfNote;
	  dfNote= docGetNextNoteInDocument( &dn, bd, dfNote, DOCinFOOTNOTE ) )
	{
	DocumentTree *	ei= &(dn->dnDocumentTree);

	if  ( dn->dnReferringPage < page )
	    { LLDEB(page,dn->dnReferringPage); continue;	}
	if  ( dn->dnReferringPage > page )
	    { break;	}
	if  ( dn->dnReferringColumn < column )
	    { LLLDEB(page,column,dn->dnReferringColumn); continue;	}
	if  ( dn->dnReferringColumn > column )
	    { break;	}
	if  ( ! ei->eiRoot )
	    { XDEB(ei->eiRoot); continue;	}

	if  ( docDrawItem( &lpBelow, ei->eiRoot, through, dc ) )
	    { LDEB(1); rval= -1; goto ready;	}
	}

  ready:
    dc->dcBodySectBi= bodySectBiSave;
    return rval;
    }

/************************************************************************/
/*									*/
/*  Draw the notes belonging to a section immediately below its text.	*/
/*									*/
/*  1)  Are there any?							*/
/*  2)  Get separator.							*/
/*  3)  Draw the separator.						*/
/*  4)  Draw the endnotes of this section.				*/
/*									*/
/************************************************************************/

int docDrawEndnotesForSection(		LayoutPosition *	lpBelow,
					int			sect,
					void *			through,
					DrawingContext *	dc )
    {
    int				rval= 0;
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferDocument *		bd= lc->lcDocument;
    BufferItem *		bodySectBi;

    DocumentNote *		dn;
    DocumentField *		dfNote;
    DocumentTree *		ei;

    LayoutPosition		lpHere;
    DocumentPosition		dp;

    const BufferItem *		bodySectBiSave= dc->dcBodySectBi;

    BlockOrigin			bo;

    docInitBlockOrigin( &bo );

    /*  1  */
    if  ( sect >= 0 )
	{
	bodySectBi= bd->bdBody.eiRoot->biChildren[sect];
	dfNote= docGetFirstNoteOfSection( &dn, bd, sect, DOCinENDNOTE );

	if  ( ! dfNote )
	    { goto ready;	}

	if  ( docLastPosition( &dp, bodySectBi ) )
	    { LDEB(1); rval= -1; goto ready;	}

	dc->dcBodySectBi= bodySectBi;
	}
    else{
	int lastSect= bd->bdBody.eiRoot->biChildCount- 1;
	bodySectBi= bd->bdBody.eiRoot->biChildren[lastSect];
	dfNote= docGetFirstNoteOfDocument( &dn, bd, DOCinENDNOTE );     

	if  ( ! dfNote )
	    { goto ready;	}

	if  ( docLastDocumentPosition( &dp, bd ) )
	    { LDEB(1); rval= -1; goto ready;	}

	dc->dcBodySectBi= bodySectBi;
	}

    lpHere= dp.dpBi->biBelowPosition;

    ei= &(dn->dnDocumentTree);
    if  ( dc->dcLastPage >= 0					&&
	  ei->eiRoot->biTopPosition.lpPage > dc->dcLastPage	)
	{ goto ready;	}

    if  ( docDrawToColumnOfItem( bodySectBi, bodySectBi, ei->eiRoot,
						through, &lpHere, dc, &bo ) )
	{ LDEB(1); rval= -1; goto ready;	}

    /*  2  */
    if  ( dc->dcFirstPage < 0					||
	  ei->eiRoot->biBelowPosition.lpPage >= dc->dcFirstPage	)
	{
	if  ( docDrawNoteSeparator( lpBelow, through, dc, dfNote, dn, DOCinAFTNSEP ) )
	    { LDEB(sect);	}
	}

    /*  4  */
    for ( ;
	  dfNote;
	  dfNote= docGetNextNoteInSection( &dn, bd, sect,
						    dfNote, DOCinENDNOTE ) )
	{
	ei= &(dn->dnDocumentTree);
	if  ( dc->dcLastPage >= 0				&&
	      ei->eiRoot->biTopPosition.lpPage > dc->dcLastPage	)
	    { goto ready;	}

	if  ( docDrawToColumnOfItem( bodySectBi, bodySectBi, ei->eiRoot,
						through, &lpHere, dc, &bo ) )
	    { LDEB(1); rval= -1; goto ready;	}

	if  ( dc->dcFirstPage < 0					||
	      ei->eiRoot->biBelowPosition.lpPage >= dc->dcFirstPage	)
	    {
	    if  ( docDrawItem( lpBelow, ei->eiRoot, through, dc ) )
		{ LDEB(1); rval= -1; goto ready;	}
	    }

	lpHere= ei->eiRoot->biBelowPosition;
	}

  ready:
    dc->dcBodySectBi= bodySectBiSave;
    return rval;
    }

int docDrawEndnotesForDocument(		LayoutPosition *	lpBelow,
					void *			through,
					DrawingContext *	dc )
    {
    return docDrawEndnotesForSection( lpBelow, -1, through, dc );
    }

