/************************************************************************/
/*									*/
/*  Obtain the list of dictionaries.					*/
/*									*/
/*  The initialistation of the character classification should be	*/
/*  based on some kind of knowledge, NOT on the name of the language.	*/
/*									*/
/************************************************************************/

#   include	<string.h>
#   include	<stdlib.h>
#   include	<errno.h>

#   include	<appDebugon.h>
#   include	<appSystem.h>

#   include	<indSpellChecker.h>
#   include	<ind.h>

#   define FILEL 600
static const char * const	INDSPELL_DfaExtension= "dfa";

/************************************************************************/
/*									*/
/*  Obtain the list of dictionaries.					*/
/*									*/
/*  The initialistation of the character classification should be	*/
/*  based on some kind of knowledge, NOT on the name of the language.	*/
/*									*/
/*  The font of the List the Text widgets should be adapted to the	*/
/*  character set of the language. Now things look ridiculous.		*/
/*									*/
/************************************************************************/

static int indSpellAddDictionary(	const char *		filename,
					void *			voidsc )
    {
    SpellChecker *		sc= (SpellChecker *)voidsc;
    SpellCheckContext *		scc;
    SpellDictionary *		fresh;

    const char *		relative;
    int				relativeLength;

    relative= appRelativeName( filename );

#   ifdef __VMS
    {
    char * semicolon= strrchr( (char *)relative , ';' );
    if  ( semicolon )
	{ *semicolon= '\0';	}
    }
#   endif

    relativeLength= strlen( relative );
    if  ( relativeLength == 0 )
	{ LDEB(relativeLength); return 0;	}

    fresh= (SpellDictionary *)realloc( sc->scDictionaries,
		(sc->scDictionaryCount+ 1)*sizeof(SpellDictionary) );
    if  ( ! fresh )
	{ XDEB(fresh); return -1;	}
    sc->scDictionaries= fresh;

    fresh += sc->scDictionaryCount;

    indInitSpellDictionary( fresh );
    fresh->sdLocale= strdup( relative );
    fresh->sdLocaleLabel= strdup( relative );
    fresh->sdFileName= strdup( filename );

    fresh->sdLocale[relativeLength-strlen(INDSPELL_DfaExtension)-1]='\0';
    fresh->sdLocaleLabel[relativeLength-strlen(INDSPELL_DfaExtension)-1]='\0';

    fresh->sdSpellCheckContext= scc= malloc( sizeof(SpellCheckContext) );
    indInitSpellCheckContext( scc );
    if  ( ! scc )
	{ XDEB(scc); return -1;	}

    sc->scDictionaryCount++;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Open a private dictionary.						*/
/*									*/
/************************************************************************/

static FILE *	indSpellOpenPrivateDictionary(
					const char *	locale,
					const char *	privateDicts,
					int		read_only,
					SpellComplain	complain,
					void *		through )
    {
    char		scratch1[FILEL+ 1];
    char		scratch2[FILEL+ 1];
    int			len;

    FILE *		f;
    const char *	mode;
    
    const char *	suffix= ".changes";
    int			suffixLen= strlen( suffix );

    len= appHomeDirectory( scratch1, sizeof(scratch1)- 1 );
    if  ( len < 0 )
	{ LDEB(len); return (FILE *)0;	}

    if  ( appAbsoluteName( scratch2, sizeof(scratch2)- 1,
					    privateDicts, 0, scratch1 ) < 0 )
	{ SSDEB(scratch1,privateDicts); return (FILE *)0;	}

    if  ( appTestDirectory( scratch2 ) )
	{
	if  ( read_only )
	    { return (FILE *)0;	}

	if  ( appMakeDirectory( scratch2 ) )
	    {
	    (*complain)( SCerrPRIVATE_DIR_NOT_MADE, scratch2, through );
	    return (FILE *)0;
	    }
	}

    if  ( appAbsoluteName( scratch1, sizeof(scratch1)- suffixLen- 1,
					    locale, 0, scratch2 ) < 0 )
	{ SSDEB(scratch2,privateDicts); return (FILE *)0;	}
    strcat( scratch1, suffix );

    if  ( read_only )
	{ mode= "r";	}
    else{ mode= "a";	}

    f= fopen( scratch1, mode );
    if  ( ! f && ! read_only )
	{ SLDEB(scratch1,errno); return (FILE *)0; }

    return f;
    }

/************************************************************************/
/*									*/
/*  Open index files for a certain dictionary.				*/
/*									*/
/************************************************************************/

static int indSpellOpenDictionary(	SpellDictionary *	sd,
					SpellComplain		complain,
					void *			through,
					const SpellChecker *	sc )
    {
    FILE *		privateDict;
    SpellCheckContext *	scc= sd->sdSpellCheckContext;

    const int		read_only= 1;

    if  ( ! scc )
	{ XDEB(scc); return -1;	}
    if  ( scc->sccStaticInd )
	{ return 0;	}

    scc->sccStaticInd= indRead( sd->sdFileName, 1 );
    if  ( ! scc->sccStaticInd )
	{
	(*complain)( SCerrDICT_NO_ACCESS, sd->sdFileName, through );
	return -1;
	}

    privateDict= indSpellOpenPrivateDictionary(
					sd->sdLocale, sc->scPrivateDirectory,
					read_only, complain, through );

    if  ( privateDict )
	{
	if  ( indReadPrivateDictionary( privateDict,
				&scc->sccLearntInd, &(scc->sccForgotInd) ) )
	    {
	    (*complain)( SCerrPRIVATE_DICT_WRONG_FORMAT,
						    sd->sdLocale, through );
	    }

	fclose( privateDict );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Learn/Forget/Ignore a word.						*/
/*									*/
/************************************************************************/

static void indSpellLearnWord(	SpellDictionary *	sd,
				SpellComplain		complain,
				void *			through,
				const SpellChecker *	sc,
				const char *		word )
    {
    FILE *		privateDict;
    SpellCheckContext *	scc= sd->sdSpellCheckContext;

    const int		read_only= 0;

    if  ( ! scc )
	{ XDEB(scc); return;	}

    if  ( ! scc->sccStaticInd					&&
	  indSpellOpenDictionary( sd, complain, through, sc )	)
	{ return;	}

    if  ( ! scc->sccLearntInd )
	{
	scc->sccLearntInd= indMake();
	if  ( ! scc->sccLearntInd )
	    { XDEB(scc->sccLearntInd); return;	}
	}

    privateDict= indSpellOpenPrivateDictionary( sd->sdLocale, sc->scPrivateDirectory,
						read_only, complain, through );
    if  ( ! privateDict )
	{ return;	}

    if  ( indLearnWord( privateDict,
			    scc->sccLearntInd, scc->sccForgotInd, word ) )
	{ SDEB((char *)word);	}

    fclose( privateDict );

    return;
    }

static void indSpellForgetWord(	SpellDictionary *	sd,
				SpellComplain		complain,
				void *			through,
				const SpellChecker *	sc,
				const char *		word )
    {
    FILE *		privateDict;
    SpellCheckContext *	scc= sd->sdSpellCheckContext;

    const int		read_only= 0;

    if  ( ! scc )
	{ XDEB(scc); return;	}

    if  ( ! scc->sccStaticInd					&&
	  indSpellOpenDictionary( sd, complain, through, sc )	)
	{ return;	}

    if  ( ! scc->sccForgotInd )
	{
	scc->sccForgotInd= indMake();
	if  ( ! scc->sccForgotInd )
	    { XDEB(scc->sccForgotInd); return;	}
	}

    privateDict= indSpellOpenPrivateDictionary(
					sd->sdLocale, sc->scPrivateDirectory,
					read_only, complain, through );
    if  ( ! privateDict )
	{ return;	}

    if  ( indForgetWord( privateDict,
				scc->sccLearntInd, scc->sccForgotInd, word ) )
	{ SDEB((char *)word);	}

    fclose( privateDict );

    return;
    }

static void indSpellIgnoreWord(	SpellDictionary *	sd,
				SpellComplain		complain,
				void *			through,
				const SpellChecker *	sc,
				const char *		word )
    {
    SpellCheckContext *	scc= sd->sdSpellCheckContext;

    if  ( ! scc )
	{ XDEB(scc); return;	}

    if  ( ! scc->sccLearntInd )
	{
	scc->sccLearntInd= indMake();
	if  ( ! scc->sccLearntInd )
	    { XDEB(scc->sccLearntInd); return;	}
	}

    if  ( indMoveWord( scc->sccForgotInd, scc->sccLearntInd, word ) )
	{ SDEB((char *)word);	}

    return;
    }

/************************************************************************/
/*									*/
/*  Make guesses.							*/
/*									*/
/************************************************************************/

static int indSpellGuess(	IndGuessList *		igl,
				SpellDictionary *	sd,
				SpellComplain		complain,
				void *			through,
				const SpellChecker * 	sc,
				const char *		word )
    {
    int			count= 0;
    int			limit;
    SpellCheckContext *	scc= sd->sdSpellCheckContext;

    if  ( ! scc )
	{ XDEB(scc); return -1;	}

    if  ( ! scc->sccStaticInd					&&
	  indSpellOpenDictionary( sd, complain, through, sc )	)
	{ return -1;	}

    limit= indCollectGuesses( igl, scc, word );

    for ( count= 0; count < igl->iglGuessCount; count++ )
	{
	if  ( igl->iglGuesses[count].igsScore < limit )
	    { break;	}
	}

    return count;
    }

/************************************************************************/
/*									*/
/*  Clean a SpellChecker						*/
/*									*/
/************************************************************************/

static void indSpellCleanDict(	SpellDictionary *	sd )
    {
    SpellCheckContext *	scc= sd->sdSpellCheckContext;

    if  ( scc )
	{
	indCleanSpellCheckContext( scc );
	free( scc );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Configure a spell checker.						*/
/*									*/
/************************************************************************/

int indSpellSetup(		SpellChecker *	sc,
				SpellComplain	complain,
				void *		through )
    {
    if  ( appForAllFiles( sc->scSystemDirectory, INDSPELL_DfaExtension,
					(void *)sc, indSpellAddDictionary ) )
	{ SDEB(sc->scSystemDirectory); return -1;	}

    if  ( sc->scDictionaryCount == 0 )
	{
	if  ( appTestDirectory( sc->scSystemDirectory ) )
	    {
	    (*complain)( SCerrDIR_DOES_NOT_EXIST,
					    sc->scSystemDirectory, through );
	    }
	else{
	    if  ( appTestFileReadable( sc->scSystemDirectory ) )
		{
		(*complain)( SCerrDIR_NO_ACCESS,
					    sc->scSystemDirectory, through );
		}
	    else{
		(*complain)( SCerrDIR_HAS_NO_DICTS,
					    sc->scSystemDirectory, through );
		}
	    }

	return 1;
	}

    sc->scOpenDict= indSpellOpenDictionary;
    sc->scCleanDict= indSpellCleanDict;
    sc->scLearnWord= indSpellLearnWord;
    sc->scForgetWord= indSpellForgetWord;
    sc->scIgnoreWord= indSpellIgnoreWord;
    sc->scGuessWord= indSpellGuess;

    return 0;
    }

