/************************************************************************/
/*									*/
/*  Delimit tables and table rectangles.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Find the range of rows for a 'table'				*/
/*									*/
/************************************************************************/

int docDelimitTable(	BufferItem *		paraBi,
			BufferItem **		pParentBi,
			int *			pCol,
			int *			pRow0,
			int *			pRow,
			int *			pRow1 )
    {
    BufferItem *	rowBi;
    BufferItem *	parentBi;
    int			col;

    if  ( paraBi->biLevel != DOClevPARA		||
	  paraBi->biParaTableNesting == 0	)
	{ /* LLDEB(paraBi->biLevel,paraBi->biParaInTable); */ return -1; }

    rowBi= paraBi->biParent->biParent;
    parentBi= rowBi->biParent;
    col= paraBi->biParent->biNumberInParent;

    *pParentBi= parentBi; *pCol= col;
    *pRow0= rowBi->biRowTableFirst;
    *pRow= rowBi->biNumberInParent;
    *pRow1= rowBi->biRowTablePast- 1;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Determine the spans of a table cell.				*/
/*									*/
/************************************************************************/

void docTableDetermineCellspans(	int *			pRowspan,
					int *			pColspan,
					const BufferItem *	rowBi0,
					int			col0 )
    {
    const BufferItem *		parentBi0= rowBi0->biParent;
    const CellProperties *	cp;

    int				colspan= 1;
    int				rowspan= 1;

    int				row0;
    int				rowp;

    row0= rowBi0->biNumberInParent;
    rowp= rowBi0->biRowTablePast;
    cp= &(rowBi0->biRowCells[col0]);

    if  ( cp->cpMergedWithLeft )
	{ colspan= 0;	}
    else{
	if  ( cp->cpLeftInMergedRow )
	    { /* right= */ docGetCellRight( &colspan, rowBi0, col0 );	}
	}

    if  ( cp->cpMergedWithAbove )
	{ rowspan= 0;	}
    else{
	if  ( cp->cpTopInMergedColumn )
	    {
	    int		nRow;
	    int		csp= 1;
	    int		l, r;

	    if  ( col0 == 0 )
		{ l= rowBi0->biRowLeftIndentTwips;	}
	    else{ l= cp[-1].cpRightBoundaryTwips;	}
	    r= docGetCellRight( &csp,  rowBi0, col0 );

	    for ( nRow= row0+ 1; nRow < rowp; nRow++ )
		{
		int			ncsp= 1;
		const BufferItem *	nRowBi= parentBi0->biChildren[nRow];
		int			nCol;

		nCol= docGetMatchingCell( &ncsp, nRowBi, l, r );
		if  ( nCol < 0 )
		    { break;	}

		if  ( ! nRowBi->biRowCells[nCol].cpMergedWithAbove )
		    { break;	}

		rowspan++;
		}
	    }
	}

    *pRowspan= rowspan;
    *pColspan= colspan;
    return;
    }

/************************************************************************/
/*									*/
/*  Determine the rectangular area as it is selected in a table.	*/
/*									*/
/*  This funtion fails if the whole selection is not inside ONE table.	*/
/*									*/
/*  1)  Find the table environment of the beginning of the selection.	*/
/*  2)  Find the table environment of the end of the selection.		*/
/*  3)  Different section -> Different table.				*/
/*  4)  Different begin or different end -> Different table.		*/
/*  5)  Paranoia checks.						*/
/*  6)  Delimit rectangle.						*/
/*  7)  If the selection is inside one cell determine its		*/
/*	colspan/rowspan.						*/
/*									*/
/************************************************************************/

int docGetTableRectangle(	TableRectangle *		tr,
				const DocumentSelection *	ds )
    {
    BufferItem *	parentBi0;
    BufferItem *	parentBi1;

    TableRectangle	trBegin;
    TableRectangle	trEnd;

    /*  1  */
    if  ( docDelimitTable( ds->dsHead.dpBi, &parentBi0,
						&(trBegin.trCol0),
						&(trBegin.trRow00),
						&(trBegin.trRow0),
						&(trBegin.trRow11) ) )
	{ /* LDEB(1); */ return -1;	}

    /*  2  */
    if  ( docDelimitTable( ds->dsTail.dpBi, &parentBi1,
						&(trEnd.trCol0),
						&(trEnd.trRow00),
						&(trEnd.trRow0),
						&(trEnd.trRow11) ) )
	{ /* LDEB(1); */ return -1;	}

    /*  3  */
    if  ( parentBi0 != parentBi1 )
	{ /* XXDEB(parentBi0,parentBi1); */ return -1;	}

    /*  4  */
    if  ( trBegin.trRow00 != trEnd.trRow00	||
	  trBegin.trRow11 != trEnd.trRow11	)
	{ return -1;	}

    /*  5  */
    if  ( trBegin.trCol0 > trEnd.trCol0 )
	{ return -1;	}
    if  ( trBegin.trRow0 > trEnd.trRow0 )
	{ return -1;	}

    /*  6  */
    tr->trCol0= trBegin.trCol0;
    tr->trCol1= trEnd.trCol0;
    tr->trCol11= parentBi0->biChildren[trBegin.trRow0]->biChildCount- 1;

    tr->trRow00= trBegin.trRow00;
    tr->trRow0= trBegin.trRow0;
    tr->trRow1= trEnd.trRow0;
    tr->trRow11= trBegin.trRow11;

    tr->trCellColspan= 0;
    tr->trCellRowspan= 0;

    /*  7  */
    if  ( tr->trRow0 == tr->trRow1	&&
	  tr->trCol0 == tr->trCol1	)
	{
	docTableDetermineCellspans(
			    &(tr->trCellRowspan), &(tr->trCellColspan),
			    parentBi0->biChildren[trBegin.trRow0], tr->trCol0 );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Get a slice from a table. Either horizontal or vertical or both:	*/
/*  the table as a whole.						*/
/*									*/
/*  1)  Not in a table.. Not a slice either.				*/
/*  2)  Let us decide that a single cell cannot be a slice		*/
/*  3)  Whole column?							*/
/*  4)  Whole row?							*/
/*  5)  Not a row, not a column -> not a slice.				*/
/*									*/
/************************************************************************/

int docGetTableSliceSelection(	int *				pIsRowSlice,
				int *				pIsColSlice,
				TableRectangle *		tr,
				const DocumentSelection *	ds )
    {
    int			isRowSlice= 0;
    int			isColSlice= 0;
    TableRectangle	trTry;

    /*  1  */
    if  ( docGetTableRectangle( &trTry, ds ) )
	{ return 1;	}

    /*  2  */
    if  ( trTry.trRow0 == trTry.trRow1	&&
	  trTry.trCol0 == trTry.trCol1	)
	{ return 1;	}

    /*  3  */
    if  ( trTry.trRow0 == trTry.trRow00 && trTry.trRow1 == trTry.trRow11 )
	{ isColSlice= 1;	}
    /*  4  */
    if  ( trTry.trCol0 == 0 && trTry.trCol1 == trTry.trCol11 )
	{ isRowSlice= 1;	}

    /*  5  */
    if  ( ! isRowSlice && ! isColSlice )
	{ return 1;	}

    *tr= trTry;
    *pIsRowSlice= isRowSlice;
    *pIsColSlice= isColSlice;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Delimit the tables in a section.					*/
/*									*/
/************************************************************************/

void docDelimitTables(	BufferItem *		parentBi )
    {
    int		n;
    int		headerRow= -1;

    n= 0;
    while( n < parentBi->biChildCount )
	{
	BufferItem *	rowBiFirst;
	BufferItem *	rowBi;

	int		first;
	int		past;

	rowBiFirst= parentBi->biChildren[n];
	if  ( ! docIsRowItem( rowBiFirst ) )
	    {
	    if  ( rowBiFirst->biLevel == DOClevROW )
		{
		rowBiFirst->biRowTableHeaderRow= -1;
		rowBiFirst->biRowTableFirst= -1;
		rowBiFirst->biRowTablePast= -1;
		}

	    headerRow= -1;
	    n++; continue;
	    }

	first= n;
	past= n+ 1;

	while( past < parentBi->biChildCount )
	    {
	    rowBi= parentBi->biChildren[past];

	    if  ( ! docIsRowItem( rowBi ) )
		{ break;	}

	    /*
	    if  ( ! docApproximatelyAlignedColumns(
					&(rowBiFirst->biRowProperties),
					&(rowBi->biRowProperties) )	)
		{ break;	}
	    */

	    past++; 
	    }

	while( n < past )
	    {
	    rowBi= parentBi->biChildren[n];

	    if  ( rowBi->biRowIsTableHeader )
		{ headerRow= n;	}

	    rowBi->biRowTableHeaderRow= headerRow;
	    rowBi->biRowTableFirst= first;
	    rowBi->biRowTablePast= past;

	    n++;
	    }
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Get colspan and right border of a cell.				*/
/*									*/
/************************************************************************/

int docGetCellRight(	int *			pColspan,
			const BufferItem *	rowBi,
			int			col )
    {
    int				colspan= 1;
    const CellProperties *	cp= rowBi->biRowCells+ col;
    int				right= cp->cpRightBoundaryTwips;

    if  ( cp->cpLeftInMergedRow )
	{
	int		c;

	for ( c= col+ 1; c < rowBi->biChildCount; c++ )
	    {
	    if  ( ! rowBi->biRowCells[c].cpMergedWithLeft )
		{ break;	}

	    colspan++;
	    right= rowBi->biRowCells[c].cpRightBoundaryTwips;
	    }
	}

    *pColspan= colspan; return right;
    }

/************************************************************************/
/*									*/
/*  Find the cell with left and right borders as given.			*/
/*									*/
/************************************************************************/

int docGetMatchingCell(		int *			pColspan,
				const BufferItem *	rowBi,
				int			l,
				int			r )
    {
    int				col;
    int				ll, rr;
    const CellProperties *	cp;

    /*  2  */
    rr= rowBi->biRowLeftIndentTwips;
    cp= rowBi->biRowCells;
    for ( col= 0; col < rowBi->biChildCount; cp++, col++ )
	{
	int		colspan= 1;

	if  ( cp->cpMergedWithLeft )
	    { continue;	}

	ll= rr; rr= cp->cpRightBoundaryTwips;
	if  ( cp->cpLeftInMergedRow )
	    { rr= docGetCellRight( &colspan, rowBi, col );	}

	if  ( ll == l && rr == r )
	    { *pColspan= colspan; return col;	}
	}

    return -1;
    }

