/************************************************************************/
/*									*/
/*  Calculate 'Symbol' fields.						*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	<uniLegacyEncoding.h>
#   include	<uniUtf8.h>
#   include	"docBuf.h"
#   include	"docEdit.h"
#   include	"docEvalField.h"

/************************************************************************/
/*									*/
/*  Extract the values from a symbol field.				*/
/*									*/
/************************************************************************/

# define SYMB_FIC_COUNT 10

typedef enum SymbolFieldEncoding
    {
    SYMBOLencANSI= 0,
    SYMBOLencUNICODE,
    SYMBOLencSHIFT_JIS,

    SYMBOLenc_COUNT
    } SymbolFieldEncoding;

static int docFieldGetSymbol(	const DocumentField *	df,
				const char **		pFontName,
				int *			pFontSize,
				int *			pSymbol,
				int *			pSizePoints,
				int *			pEncoding,
				int *			pIsHigh )
    {
    FieldInstructionsComponent	fic[SYMB_FIC_COUNT];
    int				n;
    int				comp;
    unsigned char *		bytes= df->dfInstructions.mbBytes;

    const char *		fontName= (const char *)0;
    int				fontSize= 0;

    int				encoding= SYMBOLencANSI;
    int				symbol= -1;
    int				sizePoints= -1;
    int				isHigh= 0;

    if  ( df->dfKind != DOCfkSYMBOL )
	{ return -1;	}

    n= docSplitFieldInstructions( &(df->dfInstructions), fic, SYMB_FIC_COUNT );
    if  ( n < 2 )
	{ LDEB(n); return -1;	}

    comp= 0;
    if  ( fic[comp].ficSize != 6				||
	  memcmp( bytes+ fic[comp].ficOffset, "SYMBOL", 6 )	)
	{ SDEB((char *)bytes); return -1;	}
    comp++;

    while( comp < n )
	{
	if  ( fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\a", 2 )	)
	    { encoding= SYMBOLencANSI; comp++; continue;	}

	if  ( fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\f", 2 )	&&
	      comp < n- 1					)
	    {
	    fontName= (char *)bytes+ fic[comp+ 1].ficOffset;
	    fontSize= fic[comp+ 1].ficSize;
	    comp += 2; continue;
	    }

	if  ( fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\h", 2 )	)
	    { isHigh= 1; comp++; continue;	}

	if  ( fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\j", 2 )	)
	    { encoding= SYMBOLencSHIFT_JIS; comp++; continue;	}

	if  ( fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\s", 2 )	&&
	      comp < n- 1					)
	    {
	    if  ( fic[comp+ 1].ficSize < 1 )
		{ LLDEB(comp,fic[comp+ 1].ficSize);	}
	    else{
		char *	from= (char *)bytes+ fic[comp+ 1].ficOffset;
		char *	past= (char *)bytes+ fic[comp+ 1].ficOffset;

		sizePoints= strtol( from, &past, 10 );
		if  ( past == from )
		    { SDEB(from);	}
		}

	    comp += 2; continue;
	    }

	if  ( fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\u", 2 )	)
	    { encoding= SYMBOLencUNICODE; comp++; continue;	}

	if  ( bytes[fic[comp].ficOffset] != '\\' )
	    {
	    char *	from= (char *)bytes+ fic[comp].ficOffset;
	    char *	past= (char *)bytes+ fic[comp].ficOffset;

	    symbol= strtol( from, &past, 10 );
	    if  ( past == from )
		{ SDEB(from);	}
	    comp++; continue;
	    }

	SDEB((char *)bytes);
	break;
	}

    while( comp < n )
	{ LSDEB(comp,(char *)bytes+ fic[comp].ficOffset); comp++; }

    if  ( symbol < 0 )
	{ LDEB(symbol); return -1;	}

    *pFontName= fontName;
    *pFontSize= fontSize;
    *pSymbol= symbol;
    *pSizePoints= sizePoints;
    *pEncoding= encoding;
    *pIsHigh= isHigh;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Format the value of a 'symbol' field.				*/
/*									*/
/************************************************************************/

int docCalculateSymbolFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf )
    {
    const char *	fN;
    int			fS;

    int			encoding;
    int			symbol;
    int			sizePoints;
    int			isHigh;

    int			step;

    char		scratch[20];
    const int *		unicodes= uniWinCp1252GlyphUnicodes;

    if  ( docFieldGetSymbol( df, &fN, &fS,
				&symbol, &sizePoints, &encoding, &isHigh ) )
	{ LDEB(1); *pCalculated= 0; return 0;	}

    if  ( fN						&&
	  fS == 6 && ! strncmp( fN, "Symbol", fS )	)
	{ unicodes= uniSymbolGlyphUnicodes;	}

    if  ( fN							           &&
	  ( ( fS == 17 && ! strncmp( fN, "ITC Zapf Dingbats", fS ) )	||
	    ( fS == 12 && ! strncmp( fN, "ZapfDingbats", fS )	)	||
	    ( fS == 8 && ! strncmp( fN, "Dingbats", fS )	)	)  )
	{ unicodes= uniDingbatsGlyphUnicodes;	}

    switch( encoding )
	{
	case SYMBOLencANSI:
	    if  ( symbol >= 0 && symbol < 256 && unicodes[symbol] >= 0 )
		{ symbol= unicodes[symbol];	}
	    else{ LDEB(symbol); *pCalculated= 0; return 0;	}
	    break;
	case SYMBOLencUNICODE:
	    break;

	case SYMBOLencSHIFT_JIS:
	default:
	    LDEB(encoding); *pCalculated= 0; return 0;
	}

    step= uniPutUtf8( (unsigned char *)scratch, symbol );
    if  ( step < 1 )
	{ LLDEB(symbol,step); *pCalculated= 0; return 0;	}
    utilAddToMemoryBuffer( mbResult, (unsigned char *)scratch, step );
    *pCalculated= 1;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Evaluate Footnote number fields.					*/
/*									*/
/************************************************************************/

int docRecalculateParaSymbolTextParticules(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf )
    {
    int				rval= 0;

    const char *		fontName;
    int				fontSize;

    int				encoding;
    int				symbol;
    int				sizePoints;
    int				isHigh;

    char *			allocated= (char *)0;

    DocumentProperties *	dp= &(rf->rfBd->bdProperties);

    if  ( docFieldGetSymbol( df, &fontName, &fontSize,
				&symbol, &sizePoints, &encoding, &isHigh ) )
	{ LDEB(1); *pCalculated= 0; goto ready;	}

    rval= docRecalculateParaStringTextParticules( pCalculated,
		    pPartShift, pStroffShift, paraBi, part, partCount, df, rf );

    if  ( rval )
	{ LDEB(rval); goto ready;	}

    if  ( *pCalculated )
	{
	TextAttribute		taSet;
	PropertyMask		taSetMask;

	utilPropMaskClear( &taSetMask );
	utilInitTextAttribute( &taSet );

	if  ( fontSize > 0 )
	    {
	    int		fontNumber;

	    allocated= malloc( fontSize+ 1 );
	    if  ( ! allocated )
		{ LXDEB(fontSize,allocated); rval= -1; goto ready;	}

	    strncpy( allocated, fontName, fontSize )[fontSize]= '\0';

	    fontNumber= docGetFontByName( &(dp->dpFontList), allocated );
	    if  ( fontNumber < 0 )
		{ SLDEB(allocated,fontNumber);	}
	    else{
		taSet.taFontNumber= fontNumber;
		PROPmaskADD( &taSetMask, TApropDOC_FONT_NUMBER );
		}
	    }

	if  ( sizePoints > 0 )
	    {
	    taSet.taFontSizeHalfPoints= 2* sizePoints;
	    PROPmaskADD( &taSetMask, TApropFONTSIZE );
	    }

	if  ( ! utilPropMaskIsEmpty( &taSetMask ) )
	    {
	    if  ( docChangeParticuleAttributes( (PropertyMask *)0, rf->rfBd,
					paraBi, part+ 1,
					part+ 1+ partCount+ *pPartShift,
					&taSet, &taSetMask ) )
		{ LDEB(part); rval= -1; goto ready;	}
	    }
	}

  ready: 

    if  ( allocated )
	{ free( allocated );	}

    return rval;
    }
