/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docSetRowProperties.h"

/************************************************************************/
/*									*/
/*  Update borders for a certain number of columns.			*/
/*									*/
/************************************************************************/

void docRowSetTopBorderInCols(	RowProperties *			rp,
				int				col0,
				int				col1,
				NumberedPropertiesList *		bpl,
				const PropertyMask *		bpSetMask,
				const BorderProperties *	bpSet )
    {
    CellProperties *			cp;
    int					col;
    int					fresh;

    PropertyMask			bpDoneMask;

    cp= rp->rpCells+ col0;
    for ( col= col0; col <= col1; cp++, col++ )
	{
	BorderProperties	bp;

	docGetBorderPropertiesByNumber( &bp, bpl, cp->cpTopBorderNumber );

	docUpdateBorderProperties( &bpDoneMask, &bp, bpSetMask, bpSet );

	fresh= docBorderPropertiesNumber( bpl, &bp );
	if  ( fresh < 0 )
	    { LDEB(fresh); continue;	}
	cp->cpTopBorderNumber= fresh;
	}

    return;
    }


void docRowSetBottomBorderInCols(RowProperties *		rp,
				int				col0,
				int				col1,
				NumberedPropertiesList *		bpl,
				const PropertyMask *		bpSetMask,
				const BorderProperties *	bpSet )
    {
    CellProperties *			cp;
    int					col;
    int					fresh;

    PropertyMask			bpDoneMask;

    cp= rp->rpCells+ col0;
    for ( col= col0; col <= col1; cp++, col++ )
	{
	BorderProperties	bp;

	docGetBorderPropertiesByNumber( &bp, bpl, cp->cpBottomBorderNumber );

	docUpdateBorderProperties( &bpDoneMask, &bp, bpSetMask, bpSet );

	fresh= docBorderPropertiesNumber( bpl, &bp );
	if  ( fresh < 0 )
	    { LDEB(fresh); continue;	}
	cp->cpBottomBorderNumber= fresh;
	}

    return;
    }


void docRowSetLeftBorderInCols(	RowProperties *			rp,
				int				col0,
				int				col1,
				NumberedPropertiesList *		bpl,
				const PropertyMask *		bpSetMask,
				const BorderProperties *	bpSet )
    {
    CellProperties *			cp;
    int					col;
    int					fresh;

    PropertyMask			bpDoneMask;

    cp= rp->rpCells+ col0;
    for ( col= col0; col <= col1; cp++, col++ )
	{
	BorderProperties	bp;

	docGetBorderPropertiesByNumber( &bp, bpl, cp->cpLeftBorderNumber );

	docUpdateBorderProperties( &bpDoneMask, &bp, bpSetMask, bpSet );

	fresh= docBorderPropertiesNumber( bpl, &bp );
	if  ( fresh < 0 )
	    { LDEB(fresh); continue;	}
	cp->cpLeftBorderNumber= fresh;
	}

    return;
    }


void docRowSetRightBorderInCols(RowProperties *			rp,
				int				col0,
				int				col1,
				NumberedPropertiesList *		bpl,
				const PropertyMask *		bpSetMask,
				const BorderProperties *	bpSet )
    {
    CellProperties *			cp;
    int					col;
    int					fresh;

    PropertyMask			bpDoneMask;

    cp= rp->rpCells+ col0;
    for ( col= col0; col <= col1; cp++, col++ )
	{
	BorderProperties	bp;

	docGetBorderPropertiesByNumber( &bp, bpl, cp->cpRightBorderNumber );

	docUpdateBorderProperties( &bpDoneMask, &bp, bpSetMask, bpSet );

	fresh= docBorderPropertiesNumber( bpl, &bp );
	if  ( fresh < 0 )
	    { LDEB(fresh); continue;	}
	cp->cpRightBorderNumber= fresh;
	}

    return;
    }

void docRowSetShadingInCols(	RowProperties *			rp,
				int				col0,
				int				col1,
				NumberedPropertiesList *		isl,
				const PropertyMask *		isSetMask,
				const ItemShading *		isSet )
    {
    CellProperties *		cp;
    int				col;
    int					fresh;

    PropertyMask		isDoneMask;

    const int * const		colorMap= (const int *)0;

    cp= rp->rpCells+ col0;
    for ( col= col0; col <= col1; cp++, col++ )
	{
	ItemShading		is;

	docGetItemShadingByNumber( &is, isl, cp->cpShadingNumber );

	docUpdateItemShading( &isDoneMask, &is, isSetMask, isSet, colorMap );

	fresh= docItemShadingNumber( isl, &is );
	if  ( fresh < 0 )
	    { LDEB(fresh); continue;	}
	cp->cpShadingNumber= fresh;
	}

    return;
    }

