#   ifndef		DOC_SELECTION_SCOPE_H
#   define		DOC_SELECTION_SCOPE_H

#   include		"docLayoutPosition.h"

/************************************************************************/
/*									*/
/*  Scope of a selection.						*/
/*									*/
/*  1)  Indication for the kind of root item for the selection.		*/
/*  2)  Geometry is derived from the position, NOT the other way round.	*/
/*									*/
/*  A)  Indication for the kind of root item for the selection.		*/
/*  B)  When the selection is not in the body of the document, the	*/
/*	number of the section that the external item belongs to.	*/
/*  D)  If the external item is a footnote/endnote: The number of the	*/
/*	note field in the body that owns the note.			*/
/*									*/
/************************************************************************/

typedef struct SelectionScope
    {
    int			ssInExternalItem;			/*  A  */
    int			ssSectNr;				/*  B  */
    int			ssOwnerSectNr;				/*  B  */
    int			ssOwnerNumber;				/*  D  */
    } SelectionScope;

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern void docInitSelectionScope(	SelectionScope *	ss );

extern int docSelectionSameScope(
				const SelectionScope *		ssFrom,
				const SelectionScope *		ssTo );

#   endif	/*	DOC_SELECTION_SCOPE_H	*/
