/************************************************************************/
/*									*/
/*  Describe selections.						*/
/*  [Used by the tools.]						*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Describe a selection and its relevance for application tools.	*/
/*									*/
/************************************************************************/

void docDescribeSelection(	SelectionDescription *		sd,
				const DocumentSelection *	ds,
				const SelectionGeometry *	sg,
				BufferDocument *		bd,
				unsigned int			documentId,
				int				documentRo )
    {
    const DocumentPosition *	dpBegin= &(ds->dsHead);
    const DocumentPosition *	dpEnd= &(ds->dsTail);
    const BufferItem *		sectBi;

    int				i;
    DocumentField *		df;

    FrameProperties		fp;
    SelectionScope		ssBegin;
    SelectionScope		ssEnd;

    sectBi= docGetSectItem( dpBegin->dpBi );
    if  ( ! sectBi )
	{ XDEB(sectBi); return;	}

    sd->sdDocumentId= documentId;
    sd->sdIsSet= 1;
    sd->sdDocumentReadonly= documentRo;
    sd->sdIsIBarSelection= docIsIBarSelection( ds );
    sd->sdIsSingleParagraph= docPositionsInsideParagraph( dpBegin, dpEnd );
    sd->sdIsSingleCell= docPositionsInsideCell( dpBegin, dpEnd );

    sd->sdBeginInTable= dpBegin->dpBi->biParaTableNesting > 0;
    sd->sdEndInTable= dpEnd->dpBi->biParaTableNesting > 0;
    sd->sdBeginInTableHeader= 0;
    sd->sdBeginInMultiColumnSection= 0;
    sd->sdIsColSlice= 0;
    sd->sdIsRowSlice= 0;
    sd->sdIsTableSlice= 0;
    sd->sdIsTableRectangle= 0;
    sd->sdIsObjectSelection= 0;

    sd->sdStartPage= sg->sgBegin.pgTopPosition.lpPage;
    sd->sdEndPage= sg->sgEnd.pgTopPosition.lpPage;
    sd->sdDocumentPages= bd->bdBody.eiRoot->biBelowPosition.lpPage+ 1;

    docGetSelectionScope( &ssBegin, dpBegin->dpBi );
    docGetSelectionScope( &ssEnd, dpEnd->dpBi );

    sd->sdInExternalItem= dpBegin->dpBi->biInExternalItem;
    if  ( dpBegin->dpBi->biInExternalItem != dpEnd->dpBi->biInExternalItem )
	{
	LLDEB(dpBegin->dpBi->biInExternalItem,dpEnd->dpBi->biInExternalItem);
	}

    if  ( sd->sdInExternalItem == DOCinBODY )
	{
	sd->sdStartSection= ssBegin.ssSectNr;
	sd->sdEndSection= ssEnd.ssSectNr;

	if  ( sectBi->biSectColumnCount > 1 )
	    { sd->sdBeginInMultiColumnSection= 1;	}
	}
    else{
	sd->sdStartSection= ssBegin.ssOwnerSectNr;
	sd->sdEndSection= ssEnd.ssOwnerSectNr;
	}

    sd->sdDocumentSections= bd->bdBody.eiRoot->biChildCount;

    docGetFramePropertiesByNumber( &fp, &(bd->bdFramePropertyList),
					    dpBegin->dpBi->biParaFrameNumber );
    sd->sdBeginInFrame= DOCisFRAME( &fp );
    sd->sdIsSingleFrame= 0;

    if  ( sd->sdBeginInFrame && sd->sdIsSingleCell )
	{
	BufferItem *	cellBi= dpBegin->dpBi->biParent;
	int		para;

	sd->sdIsSingleFrame= 1;

	for ( para= dpBegin->dpBi->biNumberInParent+ 1;
	      para < dpEnd->dpBi->biNumberInParent;
	      para++ )
	    {
	    if  ( cellBi->biChildren[para]->biParaFrameNumber !=
					    dpBegin->dpBi->biParaFrameNumber )
		{ sd->sdIsSingleFrame= 0; break;	}
	    }
	}

    if  ( sd->sdBeginInTable )
	{
	const BufferItem *	rowBi= docGetRowItem( dpBegin->dpBi );

	if  ( rowBi				&&
	      rowBi->biRowIsTableHeader		)
	    { sd->sdBeginInTableHeader= 1;	}
	}

    sd->sdInDocumentBody= ( sd->sdInExternalItem == DOCinBODY );
    sd->sdInHeaderFooter= 0;

    for ( i= 0; i < PAGES__COUNT; i++ )
	{
	if  ( sd->sdInExternalItem == DOC_HeaderScopes[i] )
	    { sd->sdInHeaderFooter= 1; break;	}
	if  ( sd->sdInExternalItem == DOC_FooterScopes[i] )
	    { sd->sdInHeaderFooter= 1; break;	}
	}

    docInitTableRectangle( &(sd->sdTableRectangle) );
    if  ( ! docGetTableRectangle( &(sd->sdTableRectangle), ds ) )
	{ sd->sdIsTableRectangle= 1;	}

    if  ( ! sd->sdIsIBarSelection )
	{
	if  ( sd->sdIsTableRectangle )
	    {
	    if  ( ! docGetTableSliceSelection( &(sd->sdIsRowSlice),
			&(sd->sdIsColSlice), &(sd->sdTableRectangle), ds ) )
		{ sd->sdIsTableSlice= 1;	}
	    }
	}

    if  ( documentRo )
	{
	sd->sdCanReplace= 0;
	}
    else{
	sd->sdCanReplace= ! sd->sdIsTableRectangle || sd->sdIsSingleCell;
	}

    df= docFindFieldForPosition( bd, dpBegin );
    sd->sdBeginInField= ( df != (DocumentField *)0 );

    sd->sdBeginInHyperlink= 0;
    sd->sdBeginInBookmark= 0;

    if  ( docFindTypedFieldForPosition( bd, dpBegin, DOCfkHYPERLINK ) )
	{ sd->sdBeginInHyperlink= 1;	}
    if  ( docFindTypedFieldForPosition( bd, dpBegin, DOCfkBOOKMARK ) )
	{ sd->sdBeginInBookmark= 1;	}

    utilInitTextAttribute( &(sd->sdTextAttribute) );
    utilPropMaskClear( &(sd->sdTextAttributeMask) );

    docGetSelectionAttributes( bd, ds, &(sd->sdTextAttributeMask),
						    &(sd->sdTextAttribute) );

    sd->sdHasLists= 0;
    sd->sdListOverride= -1;
    sd->sdListLevel= -1;
    sd->sdMultiList= 0;
    sd->sdMultiLevel= 0;
    sd->sdFirstListParaNr= -1;

    sd->sdHasLists= ! docFindListOfSelection(
				&(sd->sdListOverride), &(sd->sdListLevel),
				&(sd->sdMultiList), &(sd->sdMultiLevel),
				&(sd->sdFirstListParaNr), ds );

    sd->sdIsListBullet= 0;
    if  ( sd->sdHasLists			&&
	  sd->sdIsSingleParagraph		&&
	  dpBegin->dpBi->biParaListOverride > 0	)
	{
	DocumentField *		dfHead= (DocumentField *)0;
	DocumentSelection	dsInsideHead;
	DocumentSelection	dsAroundHead;
	int			partBegin= -1;
	int			partEnd= -1;

	if  ( docDelimitParaHeadField( &dfHead, &dsInsideHead, &dsAroundHead,
				    &partBegin, &partEnd, dpBegin->dpBi, bd ) )
	    { LDEB(dpBegin->dpBi->biParaListOverride);	}
	else{
	    if  ( dsAroundHead.dsHead.dpStroff == dpBegin->dpStroff	&&
		  dsAroundHead.dsTail.dpStroff == dpEnd->dpStroff	)
		{
		ListOverride *			lo;
		DocumentList *			dl;
		const DocumentListLevel *	dll;

		int * const			startPath= (int *)0;
		int * const			formatPath= (int *)0;
		const ParagraphProperties *	pp= &(dpBegin->dpBi->biParaProperties);

		sd->sdIsListBullet= 1;

		if  ( docGetListLevelOfParagraph( startPath, formatPath,
						    &lo, &dl, &dll, pp, bd ) )
		    { LLDEB(pp->ppListOverride,pp->ppListLevel);	}
		else{
		    sd->sdTextAttributeMask= dll->dllTextAttributeMask;
		    sd->sdTextAttribute= dll->dllTextAttribute;
		    }
		}
	    }
	}

    {
    DocumentPosition	dpObject;
    int			part;
    InsertedObject *	io;

    if  ( ! docGetObjectSelection( ds, bd, &part, &dpObject, &io ) )
	{ sd->sdIsObjectSelection= 1; }
    }

    return;
    }

void docInitSelectionDescription(	SelectionDescription *	sd )
    {
    sd->sdDocumentId= 0;

    sd->sdIsSet= 0;
    sd->sdDocumentReadonly= 0;
    sd->sdIsIBarSelection= 0;
    sd->sdIsSingleParagraph= 0;
    sd->sdIsSingleCell= 0;
    sd->sdIsSingleFrame= 0;
    sd->sdBeginInFrame= 0;
    sd->sdBeginInTable= 0;
    sd->sdEndInTable= 0;
    sd->sdBeginInTableHeader= 0;
    sd->sdBeginInMultiColumnSection= 0;
    sd->sdIsColSlice= 0;
    sd->sdIsRowSlice= 0;
    sd->sdIsTableSlice= 0;
    sd->sdIsTableRectangle= 0;
    sd->sdIsObjectSelection= 0;

    sd->sdStartPage= -1;
    sd->sdEndPage= -1;
    sd->sdDocumentPages= 0;

    sd->sdStartSection= -1;
    sd->sdEndSection= -1;
    sd->sdDocumentSections= 0;

    sd->sdCanReplace= 0;
    sd->sdInExternalItem= 0;
    sd->sdInDocumentBody= 0;
    sd->sdInHeaderFooter= 0;

    sd->sdBeginInField= 0;
    sd->sdBeginInHyperlink= 0;
    sd->sdBeginInBookmark= 0;

    sd->sdIsListBullet= 0;

    sd->sdHasLists= 0;
    sd->sdFirstListParaNr= 0;
    sd->sdListOverride= 0;
    sd->sdListLevel= 0;
    sd->sdMultiList= 0;
    sd->sdMultiLevel= 0;

    docInitTableRectangle( &(sd->sdTableRectangle) );

    utilInitTextAttribute( &(sd->sdTextAttribute) );
    utilPropMaskClear( &(sd->sdTextAttributeMask) );

    return;
    }
