/************************************************************************/
/*									*/
/*  Section Properties.							*/
/*									*/
/************************************************************************/

#   ifndef	DOC_SECT_PROP_H
#   define	DOC_SECT_PROP_H

#   include	<utilDocumentGeometry.h>
#   include	"docNotesProperties.h"

typedef enum PageNumberStyle
    {
    DOCpgnDEC= 0,
    DOCpgnUCRM,
    DOCpgnLCRM,
    DOCpgnUCLTR,
    DOCpgnLCLTR,

    DOCpgn_COUNT
    } PageNumberStyle;

typedef enum PageNumberHyphen
    {
    DOCpgnhPGNHNSH,
    DOCpgnhPGNHNSP,
    DOCpgnhPGNHNSC,
    DOCpgnhPGNHNSM,
    DOCpgnhPGNHNSN,

    DOCpgnh_COUNT
    } PageNumberHyphen;

typedef struct SectionColumn
    {
    int		scColumnWidthTwips;
    int		scSpaceToRightTwips;
    } SectionColumn;

typedef struct SectionProperties
    {
    DocumentGeometry	spDocumentGeometry;

    int			spStyle;

    int			spColumnSpacingTwips;
    unsigned char	spLineBetweenColumns;

    unsigned char	spHasTitlePage;
    unsigned char	spBreakKind;
    unsigned char	spPageNumberStyle;
    unsigned char	spPageNumberHyphen;
    unsigned char	spRestartPageNumbers;

    int			spStartPageNumber;

    int			spColumnCount;
    SectionColumn *	spColumns;

    NotesProperties	spFootnoteProperties;
    NotesProperties	spEndnoteProperties;
    } SectionProperties;

# define DOC_SECTpropsBELOW_PREVIOUS( sp ) \
				( (sp)->spBreakKind == DOCibkNONE )

typedef enum SectionProperty
    {
    SPprop_NONE= -1,

    /* document geometry */

    SPpropSTYLE= DGprop_COUNT,
    SPpropTITLEPG,
    SPpropBREAK_KIND,
    SPpropNUMBER_STYLE,
    SPpropNUMBER_HYPHEN,
    SPpropPAGE_RESTART,
    SPpropSTART_PAGE,
    SPpropCOLUMN_COUNT,
    SPpropCOLUMN_SPACING,
    SPpropLINEBETCOL,
    SPpropCOLUMNS,

    SPpropFOOTNOTE_STARTNR,
    SPpropFOOTNOTE_POSITION,
    SPpropFOOTNOTE_RESTART,
    SPpropFOOTNOTE_STYLE,

    SPpropENDNOTE_STARTNR,
    SPpropENDNOTE_POSITION,
    SPpropENDNOTE_RESTART,
    SPpropENDNOTE_STYLE,

    SPprop_COUNT,

		    /****************************************************/
		    /*  Used by RTF parser:				*/
		    /****************************************************/
    SPprop_COLUMN_NUMBER,
    SPprop_COLUMN_WIDTH,
    SPprop_COLUMN_RIGHT,

    SPprop_FULL_COUNT
    } SectionProperty;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitSectionProperties(	SectionProperties *	sp );
extern void docCleanSectionProperties(	SectionProperties *	sp );

extern int docCopySectionProperties(	SectionProperties *		to,
					const SectionProperties *	from );

extern int docSectionPropertiesSetColumnCount(
					SectionProperties *	sp,
					int			count );

extern void docSectPropertyDifference(
				PropertyMask *			pChgMask,
				const SectionProperties *	sp1,
				const SectionProperties *	sp2,
				const PropertyMask *		updMask );

extern int docUpdSectProperties( PropertyMask *			pSpChgMask,
				SectionProperties *		to,
				const PropertyMask *		spUpdMask,
				const SectionProperties *	from );

extern int docSectGetEqualColumnWidth(	const SectionProperties *	sp );
extern int docSectSetEqualColumnWidth(	SectionProperties *		sp );
extern void docSectSetExplicitColumnWidth( SectionProperties *		sp );

extern void docSectGetColumnX(	int *				pXLine,
				int *				pX0,
				int *				pX1,
				const SectionProperties *	sp,
				const DocumentGeometry *	dgPage,
				int				column );

extern int docSetSectionProperty(	SectionProperties *	sp,
					int			prop,
					int			arg );

extern int docGetSectionProperty(	SectionProperties *	sp,
					int			prop );

#   endif	/*  DOC_SECT_PROP_H  */
