/************************************************************************/
/*									*/
/*  Read the various document tables of an RTF text file into a		*/
/*  BufferDocument.							*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docRtf.h"

/************************************************************************/
/*                                                                      */
/*  Consume the 'revision table' of a document                          */
/*  added by davina 6-2-00						*/
/*                                                                      */
/************************************************************************/

static int docRtfSaveRevisionTable(	RtfReadingContext *	rrc,
					const char *		text,
					int			len )
    {
    char **			newAuthorArray;
    char *			newAuthor= (char *)0;
    DocumentProperties *	dp= &(rrc->rrcBd->bdProperties);

    int				size;
    const int			removeSemicolon= 0;

    newAuthorArray = (char**)realloc( dp->dpAuthors, 
				   (dp->dpAuthorCount+1) * sizeof(char *));
    if  ( ! newAuthorArray )
	{ XDEB(newAuthorArray); return -1;	}
    dp->dpAuthors= newAuthorArray;

    if  ( docRtfSaveDocEncodedText( rrc, text, len ) )
	{ LDEB(len); return -1;	}

    if  ( docRtfStoreSavedText( &newAuthor, &size, rrc, removeSemicolon ) )
	{ LDEB(len); return -1;	}

    dp->dpAuthors[dp->dpAuthorCount++]= newAuthor;

    return 0;
    }

int docRtfRevisionTable(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    if  ( docRtfReadGroup( rcw, 0, 0, rrc,
                          docRtfDocumentGroups,
                          docRtfSaveRevisionTable, (RtfCommitGroup)0 ) )
	{ SLDEB(rcw->rcwWord, arg); return -1; }

    return 0;
    }

/************************************************************************/
/*									*/
/*  Read the info group.						*/
/*									*/
/************************************************************************/

int docRtfCommitGeneratorText(	const RtfControlWord *	rcw,
				RtfReadingContext *	rrc )
    {
    const int	removeSemicolon= 0;
    int		size;

    return docRtfStoreSavedText( &(rrc->rrcBd->bdProperties.dpGeneratorRead),
						&size, rrc, removeSemicolon );
    }

int docRtfCommitTitleText(	const RtfControlWord *	rcw,
				RtfReadingContext *	rrc )
    {
    const int	removeSemicolon= 0;
    int		size;

    return docRtfStoreSavedText( &(rrc->rrcBd->bdProperties.dpTitle),
						&size, rrc, removeSemicolon );
    }

int docRtfCommitAuthorText(	const RtfControlWord *	rcw,
				RtfReadingContext *	rrc )
    {
    const int	removeSemicolon= 0;
    int		size;

    return docRtfStoreSavedText( &(rrc->rrcBd->bdProperties.dpAuthor),
						&size, rrc, removeSemicolon );
    }

int docRtfCommitCompanyText(	const RtfControlWord *	rcw,
				RtfReadingContext *	rrc )
    {
    const int	removeSemicolon= 0;
    int		size;

    return docRtfStoreSavedText( &(rrc->rrcBd->bdProperties.dpCompany),
						&size, rrc, removeSemicolon );
    }

int docRtfCommitSubjectText(	const RtfControlWord *	rcw,
				RtfReadingContext *	rrc )
    {
    const int	removeSemicolon= 0;
    int		size;

    return docRtfStoreSavedText( &(rrc->rrcBd->bdProperties.dpSubject),
						&size, rrc, removeSemicolon );
    }

int docRtfCommitKeywordsText(	const RtfControlWord *	rcw,
				RtfReadingContext *	rrc )
    {
    const int	removeSemicolon= 0;
    int		size;

    return docRtfStoreSavedText( &(rrc->rrcBd->bdProperties.dpKeywords),
						&size, rrc, removeSemicolon );
    }

int docRtfCommitDoccommText(	const RtfControlWord *	rcw,
				RtfReadingContext *	rrc )
    {
    const int	removeSemicolon= 0;
    int		size;

    return docRtfStoreSavedText( &(rrc->rrcBd->bdProperties.dpDoccomm),
						&size, rrc, removeSemicolon );
    }

int docRtfCommitHlinkbaseText(	const RtfControlWord *	rcw,
				RtfReadingContext *	rrc )
    {
    const int	removeSemicolon= 0;
    int		size;

    return docRtfStoreSavedText( &(rrc->rrcBd->bdProperties.dpHlinkbase),
						&size, rrc, removeSemicolon );
    }

int docRtfDocTimeGroup(	const RtfControlWord *	rcw,
			int			arg,
			RtfReadingContext *	rrc )
    {
    appInvalidateTime( &(rrc->rrcTm) );

    if  ( docRtfReadGroup( rcw, 0, 0, rrc,
		    (RtfControlWord *)0, docRtfRefuseText, (RtfCommitGroup)0 ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    switch( rcw->rcwID )
	{
	case DPpropCREATIM:
	    rrc->rrcBd->bdProperties.dpCreatim= rrc->rrcTm;
	    break;

	case DPpropREVTIM:
	    rrc->rrcBd->bdProperties.dpRevtim= rrc->rrcTm;
	    break;

	case DPpropPRINTIM:
	    rrc->rrcBd->bdProperties.dpPrintim= rrc->rrcTm;
	    break;

	default:
	    SDEB(rcw->rcwWord); return -1;
	}

    return 0;
    }

int docRtfReadInfo(		const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    int		res;

    res= docRtfReadGroup( rcw, 0, 0, rrc,
		    (RtfControlWord *)0, docRtfIgnoreText, (RtfCommitGroup)0 );
    if  ( res )
	{ SLDEB(rcw->rcwWord,res);	}

    return res;
    }

