/************************************************************************/
/*									*/
/*  Read/Write shadings to/from rtf.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Save border definition.						*/
/*									*/
/************************************************************************/

void docRtfSaveShading(		RtfWritingContext *		rwc,
				const ItemShading *		is,
				const char ** const 		patTags,
				const char *			foreTag,
				const char *			backTag,
				const char *			levelTag )
    {
    if  ( is->isPattern != DOCspSOLID )
	{
	if  ( is->isPattern >= DOCsp_COUNT )
	    { LLDEB(is->isPattern,DOCsp_COUNT);			}
	else{ docRtfWriteTag( rwc, patTags[is->isPattern] );	}
	}

    if  ( is->isForeColor > 0 )
	{ docRtfWriteArgTag( rwc, foreTag, is->isForeColor );	}
    if  ( is->isBackColor > 0 )
	{ docRtfWriteArgTag( rwc, backTag, is->isBackColor );	}
    if  ( is->isLevel > 0 )
	{ docRtfWriteArgTag( rwc, levelTag, is->isLevel );	}

    return;
    }

void docRtfSaveShadingByNumber(	RtfWritingContext *		rwc,
				int				num,
				const char ** const 		patTags,
				const char *			foreTag,
				const char *			backTag,
				const char *			levelTag )
    {
    const BufferDocument *		bd= rwc->rwcBd;
    const NumberedPropertiesList *	isl= &(bd->bdItemShadingList);

    ItemShading				is;

    docGetItemShadingByNumber( &is, isl, num );

    docRtfSaveShading( rwc, &is, patTags, foreTag, backTag, levelTag );

    return;
    }
